/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.blue_skies.registries;

import com.legacy.blue_skies.BlueSkies;
import com.legacy.blue_skies.registries.SkiesFeatures;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.registry.Registry;
import net.minecraft.util.registry.WorldGenRegistries;
import net.minecraft.world.biome.BiomeGenerationSettings;
import net.minecraft.world.gen.GenerationStage;
import net.minecraft.world.gen.carver.ConfiguredCarver;
import net.minecraft.world.gen.carver.EmptyCarverConfig;
import net.minecraft.world.gen.carver.ICarverConfig;
import net.minecraft.world.gen.feature.ProbabilityConfig;

public class SkiesConfiguredCarvers {
    public static final ConfiguredCarver<?> SKY_NOISE_CARVER = SkiesConfiguredCarvers.register("sky_noise_carver", SkiesFeatures.Carvers.SKY_NOISE_CARVER.func_242761_a((ICarverConfig)EmptyCarverConfig.field_236238_c_));
    public static final ConfiguredCarver<?> SKY_CAVE_CARVER = SkiesConfiguredCarvers.register("sky_cave_carver", SkiesFeatures.Carvers.SKY_CAVE_CARVER.func_242761_a((ICarverConfig)new ProbabilityConfig(0.14285715f)));
    public static final ConfiguredCarver<?> SKY_CANYON_CARVER = SkiesConfiguredCarvers.register("sky_canyon_carver", SkiesFeatures.Carvers.SKY_CANYON_CARVER.func_242761_a((ICarverConfig)new ProbabilityConfig(0.02f)));
    public static final ConfiguredCarver<?> UNDERWATER_SKY_CAVE_CARVER = SkiesConfiguredCarvers.register("underwater_sky_cave_carver", SkiesFeatures.Carvers.UNDERWATER_SKY_CAVE_CARVER.func_242761_a((ICarverConfig)new ProbabilityConfig(0.02f)));
    public static final ConfiguredCarver<?> UNDERWATER_SKY_CANYON_CARVER = SkiesConfiguredCarvers.register("underwater_canyon_cave_carver", SkiesFeatures.Carvers.UNDERWATER_SKY_CANYON_CARVER.func_242761_a((ICarverConfig)new ProbabilityConfig(0.06666667f)));
    public static final ConfiguredCarver<?> EVERBRIGHT_NOISE_CARVER = SkiesConfiguredCarvers.register("everbright_noise_carver", SkiesFeatures.Carvers.EVERBRIGHT_NOISE_CARVER.func_242761_a((ICarverConfig)EmptyCarverConfig.field_236238_c_));
    public static final ConfiguredCarver<?> EVERBRIGHT_CAVE_CARVER = SkiesConfiguredCarvers.register("everbright_cave_carver", SkiesFeatures.Carvers.EVERBRIGHT_CAVE_CARVER.func_242761_a((ICarverConfig)new ProbabilityConfig(0.14285715f)));
    public static final ConfiguredCarver<?> EVERBRIGHT_CANYON_CARVER = SkiesConfiguredCarvers.register("everbright_canyon_carver", SkiesFeatures.Carvers.EVERBRIGHT_CANYON_CARVER.func_242761_a((ICarverConfig)new ProbabilityConfig(0.02f)));

    private static <C extends ICarverConfig> ConfiguredCarver<C> register(String name, ConfiguredCarver<C> carver) {
        return (ConfiguredCarver)Registry.func_218322_a((Registry)WorldGenRegistries.field_243652_d, (ResourceLocation)BlueSkies.locate(name), carver);
    }

    public static void init() {
    }

    public static void addDawnCarvers(BiomeGenerationSettings.Builder builder) {
        builder.func_242512_a(GenerationStage.Carving.AIR, SKY_CAVE_CARVER);
        builder.func_242512_a(GenerationStage.Carving.AIR, SKY_CANYON_CARVER);
        builder.func_242512_a(GenerationStage.Carving.AIR, SKY_NOISE_CARVER);
    }

    public static void addOceanCarvers(BiomeGenerationSettings.Builder builder) {
        builder.func_242512_a(GenerationStage.Carving.LIQUID, UNDERWATER_SKY_CAVE_CARVER);
        builder.func_242512_a(GenerationStage.Carving.LIQUID, UNDERWATER_SKY_CANYON_CARVER);
    }

    public static void addBrightCarvers(BiomeGenerationSettings.Builder builder) {
        builder.func_242512_a(GenerationStage.Carving.AIR, EVERBRIGHT_CAVE_CARVER);
        builder.func_242512_a(GenerationStage.Carving.AIR, EVERBRIGHT_CANYON_CARVER);
        builder.func_242512_a(GenerationStage.Carving.AIR, EVERBRIGHT_NOISE_CARVER);
    }
}

