/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.blue_skies.network.s_to_c;

import com.legacy.blue_skies.BlueSkies;
import com.legacy.blue_skies.client.gui.screen.journal.BlueJournalScreen;
import com.legacy.blue_skies.data.BlueSkiesData;
import com.legacy.blue_skies.data.managers.SkiesSyncedDataManager;
import java.util.function.Supplier;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.network.NetworkEvent;

public class SyncDataRegistryPacket {
    private final byte id;
    private final SkiesSyncedDataManager<?, ?, ?> manager;

    public SyncDataRegistryPacket(int id, SkiesSyncedDataManager<?, ?, ?> manager) {
        this.id = (byte)id;
        this.manager = manager;
    }

    public static void encoder(SyncDataRegistryPacket packet, PacketBuffer buff) {
        buff.writeByte((int)packet.id);
        buff.func_150786_a(packet.manager.toNBT());
    }

    public static SyncDataRegistryPacket decoder(PacketBuffer buff) {
        byte id = buff.readByte();
        CompoundNBT data = buff.func_150793_b();
        return new SyncDataRegistryPacket(id, (SkiesSyncedDataManager<?, ?, ?>)((Object)BlueSkiesData.getSyncedManager(id).fromNBT(data)));
    }

    public static void handler(SyncDataRegistryPacket packet, Supplier<NetworkEvent.Context> context) {
        context.get().enqueueWork(() -> DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> () -> {
            BlueJournalScreen.savedScreen = null;
            BlueSkiesData.getSyncedManager(packet.id).setData(packet.manager);
            BlueSkies.LOGGER.info("Recieved {} from the server", (Object)packet.manager.func_225594_i_());
        }));
        context.get().setPacketHandled(true);
    }
}

