/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.blue_skies.network.s_to_c;

import com.legacy.blue_skies.capability.SkiesPlayer;
import com.legacy.blue_skies.entities.util.SkiesDungeonType;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.network.NetworkEvent;

public class DungeonMusicPacket {
    private byte type;

    public DungeonMusicPacket(byte typeIn) {
        this.type = typeIn;
    }

    public static void encoder(DungeonMusicPacket packet, PacketBuffer buff) {
        buff.writeByte((int)packet.type);
    }

    public static DungeonMusicPacket decoder(PacketBuffer buff) {
        return new DungeonMusicPacket(buff.readByte());
    }

    public static void handler(DungeonMusicPacket packet, Supplier<NetworkEvent.Context> context) {
        context.get().enqueueWork(() -> DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> () -> DungeonMusicPacket.handlePacket(packet)));
        context.get().setPacketHandled(true);
    }

    @OnlyIn(value=Dist.CLIENT)
    private static void handlePacket(DungeonMusicPacket packet) {
        ClientPlayerEntity player = Minecraft.func_71410_x().field_71439_g;
        SkiesPlayer.ifPresent(player, skyPlayer -> skyPlayer.setDungeonMusicId(SkiesDungeonType.getFromId(packet.type)));
    }
}

