/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.blue_skies.network.c_to_s;

import com.legacy.blue_skies.capability.SkiesPlayer;
import java.util.function.Supplier;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.fml.network.NetworkEvent;

public class GetClientMotionPacket {
    private double motionX;
    private double motionZ;

    public GetClientMotionPacket(double motionXIn, double motionZIn) {
        this.motionX = motionXIn;
        this.motionZ = motionZIn;
    }

    public static void encoder(GetClientMotionPacket packet, PacketBuffer buff) {
        buff.writeDouble(packet.motionX);
        buff.writeDouble(packet.motionZ);
    }

    public static GetClientMotionPacket decoder(PacketBuffer buff) {
        return new GetClientMotionPacket(buff.readDouble(), buff.readDouble());
    }

    public static void handler(GetClientMotionPacket packet, Supplier<NetworkEvent.Context> context) {
        context.get().enqueueWork(() -> GetClientMotionPacket.handlePacket(packet, (PlayerEntity)((NetworkEvent.Context)context.get()).getSender()));
        context.get().setPacketHandled(true);
    }

    private static void handlePacket(GetClientMotionPacket packet, PlayerEntity player) {
        SkiesPlayer.ifPresent(player, skyPlayer -> skyPlayer.setSavedClientMotion(packet.motionX, 0.0, packet.motionZ));
    }
}

