/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.blue_skies.mixin;

import com.legacy.blue_skies.capability.SkiesPlayer;
import com.legacy.blue_skies.entities.hostile.boss.ArachnarchEntity;
import com.legacy.blue_skies.items.SkyArmorItem;
import com.legacy.blue_skies.items.util.IFalsiteItem;
import com.legacy.blue_skies.registries.SkiesDimensions;
import com.legacy.blue_skies.registries.SkiesSounds;
import com.legacy.blue_skies.util.EntityUtil;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ArmorItem;
import net.minecraft.item.ArmorMaterial;
import net.minecraft.item.IArmorMaterial;
import net.minecraft.item.ItemStack;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3d;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={LivingEntity.class})
public class LivingEntityMixin {
    @Inject(at={@At(value="RETURN")}, method={"getArmorValue()I"}, cancellable=true)
    private void getArmorValue(CallbackInfoReturnable<Integer> callback) {
        if ((LivingEntity)this instanceof PlayerEntity && SkiesDimensions.inSkyDimension((Entity)((LivingEntity)this))) {
            PlayerEntity player = (PlayerEntity)((LivingEntity)this);
            SkiesPlayer.ifPresent(player, skyPlayer -> {
                if (!EntityUtil.hasPlayerCompletedProgression(skyPlayer)) {
                    int value = (Integer)callback.getReturnValue();
                    int i = 0;
                    for (ItemStack stack : player.func_184193_aE()) {
                        IArmorMaterial material;
                        if (stack.func_77973_b() instanceof SkyArmorItem || !(stack.func_77973_b() instanceof ArmorItem) || (material = ((ArmorItem)stack.func_77973_b()).func_200880_d()) == ArmorMaterial.LEATHER || material == ArmorMaterial.CHAIN || material == ArmorMaterial.TURTLE) continue;
                        i += Math.max(2, Math.min(4, ((ArmorItem)stack.func_77973_b()).func_200880_d().func_200902_b(((ArmorItem)stack.func_77973_b()).func_185083_B_()) / 2));
                    }
                    if (value > 1 && i < value) {
                        callback.setReturnValue((Object)(value - i));
                    }
                }
            });
        }
    }

    @Inject(at={@At(value="HEAD")}, method={"dismountVehicle(Lnet/minecraft/entity/Entity;)V"}, cancellable=true)
    private void dismountVehicle(Entity mount, CallbackInfo callback) {
        if (mount instanceof ArachnarchEntity) {
            ArachnarchEntity boss = (ArachnarchEntity)mount;
            LivingEntity living = (LivingEntity)this;
            Vector3d vec3d = boss.func_70676_i(1.0f);
            living.func_70634_a(boss.func_226277_ct_() + vec3d.field_72450_a * 3.0, boss.func_226278_cu_() + living.func_70033_W() + (double)(boss.isCeilingLocked() ? -MathHelper.func_76134_b((float)((float)boss.field_70173_aa * 0.1f)) : MathHelper.func_76134_b((float)((float)boss.field_70173_aa * 0.1f))) * 0.05 + (boss.isCeilingLocked() ? (double)-1.2f : 1.4), boss.func_226281_cx_() + vec3d.field_72449_c * 3.0);
            callback.cancel();
        }
    }

    @Redirect(at=@At(value="FIELD", target="Lnet/minecraft/util/SoundEvents;ITEM_BREAK:Lnet/minecraft/util/SoundEvent;", opcode=178), method={"breakItem(Lnet/minecraft/item/ItemStack;)V"})
    private SoundEvent blue_skies$breakSoundModifier(ItemStack stack) {
        System.out.println("falsite burger");
        if (stack.func_77973_b() instanceof IFalsiteItem && IFalsiteItem.getFalsiteUses(stack) > 0) {
            return SkiesSounds.ITEM_FALSITE_BREAK;
        }
        return SoundEvents.field_187635_cQ;
    }
}

