/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.blue_skies.mixin;

import com.legacy.blue_skies.BlueSkiesConfig;
import com.legacy.blue_skies.world.SkiesNoiseChunkGenerator;
import com.legacy.blue_skies.world.general_features.AbstractSkyTreeFeature;
import com.legacy.blue_skies.world.util.IFeatureStopper;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.ISeedReader;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.feature.ConfiguredFeature;
import net.minecraft.world.gen.feature.DecoratedFeatureConfig;
import net.minecraft.world.gen.feature.Feature;
import net.minecraft.world.gen.feature.IFeatureConfig;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={ConfiguredFeature.class})
public class ConfiguredFeatureMixin
implements IFeatureStopper {
    @Shadow
    @Final
    public Feature<?> field_222737_a;
    @Shadow
    @Final
    public IFeatureConfig field_222738_b;
    @Nullable
    public Boolean allowedInBlueSkies = null;

    @Inject(at={@At(value="HEAD")}, method={"place(Lnet/minecraft/world/ISeedReader;Lnet/minecraft/world/gen/ChunkGenerator;Ljava/util/Random;Lnet/minecraft/util/math/BlockPos;)Z"}, cancellable=true)
    private void placeHook(ISeedReader world, ChunkGenerator chunkGen, Random rand, BlockPos pos, CallbackInfoReturnable<Boolean> callback) {
        if (chunkGen instanceof SkiesNoiseChunkGenerator && !this.isAllowedInBlueSkies().booleanValue()) {
            callback.setReturnValue((Object)false);
        }
    }

    @Override
    public Boolean isAllowedInBlueSkies() {
        if (this.allowedInBlueSkies == null) {
            Feature<?> feature = this.field_222737_a;
            if (this.field_222738_b instanceof DecoratedFeatureConfig) {
                feature = IFeatureStopper.diveIntoDecorated((DecoratedFeatureConfig)this.field_222738_b);
            }
            if (feature != null) {
                if (feature instanceof AbstractSkyTreeFeature) {
                    this.allowedInBlueSkies = true;
                    return this.allowedInBlueSkies;
                }
                ResourceLocation registryName = feature.getRegistryName();
                if (registryName != null) {
                    String mod = registryName.func_110624_b();
                    this.allowedInBlueSkies = (mod.equals("blue_skies") || mod.equals("minecraft") || BlueSkiesConfig.COMMON.isModAllowedForFeatureGen(mod)) && feature != Feature.field_236291_c_;
                    return this.allowedInBlueSkies;
                }
            }
            this.allowedInBlueSkies = false;
        }
        return this.allowedInBlueSkies;
    }
}

