/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.blue_skies.items.util;

import com.legacy.blue_skies.items.util.SkiesArmorMaterial;
import com.legacy.blue_skies.items.util.SkiesItemTier;
import java.util.function.Consumer;
import net.minecraft.entity.LivingEntity;
import net.minecraft.item.ArmorItem;
import net.minecraft.item.IArmorMaterial;
import net.minecraft.item.IItemTier;
import net.minecraft.item.ItemStack;
import net.minecraft.item.TieredItem;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.common.extensions.IForgeItem;

public interface IFalsiteItem
extends IForgeItem {
    public static final String FALSITE_KEY = "Falsite";

    default public <T extends LivingEntity> int damageItemFalsite(ItemStack stack, int amount, T entity, Consumer<T> onBroken) {
        int falsiteUses = IFalsiteItem.getFalsiteUses(stack);
        if (falsiteUses > 0) {
            IFalsiteItem.setFalsiteUses(stack, falsiteUses -= amount);
            if (falsiteUses <= 0) {
                onBroken.accept(entity);
                return Math.abs(falsiteUses);
            }
            return 0;
        }
        return amount;
    }

    public static ItemStack applyFalsite(ItemStack stack) {
        stack.func_196082_o().func_74768_a(FALSITE_KEY, IFalsiteItem.getMaxFalsiteUses(stack));
        return stack;
    }

    public static int getMaxFalsiteUses(ItemStack stack) {
        return Math.max(Math.floorDiv(stack.func_77958_k(), 5), 30);
    }

    public static void setFalsiteUses(ItemStack stack, int value) {
        stack.func_196082_o().func_74768_a(FALSITE_KEY, Math.max(value, 0));
    }

    public static int getFalsiteUses(ItemStack stack) {
        CompoundNBT tag = stack.func_77978_p();
        if (tag != null) {
            return tag.func_74762_e(FALSITE_KEY);
        }
        return 0;
    }

    public static boolean hasUses(ItemStack stack) {
        return IFalsiteItem.getFalsiteUses(stack) > 0;
    }

    default public boolean isFalsiteCompatible(ItemStack stack) {
        if (stack.func_77973_b() instanceof TieredItem) {
            IItemTier tier = ((TieredItem)stack.func_77973_b()).func_200891_e();
            if (tier instanceof SkiesItemTier) {
                return ((SkiesItemTier)tier).isCompatWithFalsite();
            }
            return false;
        }
        if (stack.func_77973_b() instanceof ArmorItem) {
            IArmorMaterial material = ((ArmorItem)stack.func_77973_b()).func_200880_d();
            if (material instanceof SkiesArmorMaterial) {
                return ((SkiesArmorMaterial)material).isCompatWithFalsite();
            }
            return false;
        }
        return false;
    }

    default public <T extends LivingEntity> int damageItem(ItemStack stack, int amount, T entity, Consumer<T> onBroken) {
        return this.isFalsiteCompatible(stack) ? this.damageItemFalsite(stack, amount, entity, onBroken) : amount;
    }

    default public int getRGBDurabilityForDisplay(ItemStack stack) {
        return IFalsiteItem.hasUses(stack) ? MathHelper.func_181758_c((float)0.5f, (float)1.0f, (float)1.0f) : MathHelper.func_181758_c((float)(Math.max(0.0f, (float)(1.0 - this.getDurabilityForDisplay(stack))) / 3.0f), (float)1.0f, (float)1.0f);
    }

    default public boolean showDurabilityBar(ItemStack stack) {
        return IFalsiteItem.hasUses(stack) ? true : stack.func_77951_h();
    }

    default public double getDurabilityForDisplay(ItemStack stack) {
        double falsiteDur = ((double)IFalsiteItem.getMaxFalsiteUses(stack) - (double)IFalsiteItem.getFalsiteUses(stack)) / (double)IFalsiteItem.getMaxFalsiteUses(stack);
        double normalDur = (double)stack.func_77952_i() / (double)stack.func_77958_k();
        return IFalsiteItem.hasUses(stack) ? falsiteDur : normalDur;
    }
}

