/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.blue_skies.items.tools.weapons;

import com.legacy.blue_skies.entities.hostile.boss.summons.ArtificialGolemEntity;
import com.legacy.blue_skies.entities.projectile.FluctuantSphereEntity;
import com.legacy.blue_skies.registries.SkiesSounds;
import com.legacy.blue_skies.util.StringUtil;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.UseAction;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.util.ActionResult;
import net.minecraft.util.Hand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.IServerWorld;
import net.minecraft.world.World;
import net.minecraft.world.gen.Heightmap;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class SummoningTomeItem
extends Item {
    public SummoningTomeItem(Item.Properties properties) {
        super(properties);
    }

    public int func_77626_a(ItemStack stack) {
        return 72000;
    }

    public UseAction func_77661_b(ItemStack stack) {
        return UseAction.BOW;
    }

    public ActionResult<ItemStack> func_77659_a(World world, PlayerEntity player, Hand hand) {
        ItemStack useStack = player.func_184586_b(hand);
        player.func_184598_c(hand);
        if (useStack.func_77973_b() == this && player.func_184600_cs() == hand) {
            List golems;
            if (SummoningTomeItem.canSummonGolems(useStack) && !(golems = world.func_175647_a(ArtificialGolemEntity.class, player.func_174813_aQ().func_186662_g(20.0), golem -> golem.playerSpawned() && golem.getCaster().equals((Object)player))).isEmpty()) {
                player.func_146105_b((ITextComponent)new TranslationTextComponent("gui.blue_skies.tooltip.too_many_golems"), true);
                player.func_184602_cy();
                return ActionResult.func_226251_d_((Object)useStack);
            }
            player.field_70170_p.func_217384_a(null, (Entity)player, SummoningTomeItem.canSummonGolems(useStack) ? SkiesSounds.ENTITY_PLAYER_PREPARE_SUMMONING : SkiesSounds.ENTITY_PLAYER_PREPARE_FLUCTUANT_SPHERE, SoundCategory.PLAYERS, 1.0f, 1.0f);
        }
        return ActionResult.func_226250_c_((Object)useStack);
    }

    public void func_77615_a(ItemStack stack, World worldIn, LivingEntity entityIn, int timeLeft) {
        int i = this.func_77626_a(stack) - timeLeft;
        boolean summonsGolems = SummoningTomeItem.canSummonGolems(stack);
        if (entityIn instanceof PlayerEntity && i > (summonsGolems ? 20 : 10)) {
            PlayerEntity player = (PlayerEntity)entityIn;
            ItemStack itemstack = player.func_184586_b(player.func_184600_cs());
            itemstack.func_222118_a(1, (LivingEntity)player, entity -> entity.func_213334_d(player.func_184600_cs()));
            if (!worldIn.func_201670_d()) {
                if (summonsGolems) {
                    BlockPos pos = player.func_233580_cy_();
                    BlockPos spawnPos = new BlockPos(pos.func_177958_n() + (worldIn.field_73012_v.nextInt(6) - 3), pos.func_177956_o(), pos.func_177952_p() + (worldIn.field_73012_v.nextInt(6) - 3));
                    if (worldIn instanceof IServerWorld) {
                        ArtificialGolemEntity golem = new ArtificialGolemEntity(worldIn, (LivingEntity)player);
                        golem.func_174828_a(spawnPos, 0.0f, 0.0f);
                        golem.func_213386_a((IServerWorld)worldIn, worldIn.func_175649_E(new BlockPos(spawnPos.func_177958_n(), worldIn.func_201676_a(Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, spawnPos.func_177958_n(), spawnPos.func_177952_p()), spawnPos.func_177952_p())), SpawnReason.MOB_SUMMONED, null, null);
                        golem.func_110148_a(Attributes.field_233818_a_).func_111128_a(20.0);
                        golem.func_70606_j(golem.func_110138_aP());
                        if (worldIn.field_73012_v.nextFloat() < 0.3f) {
                            golem.setRanged(true);
                        }
                        worldIn.func_217376_c((Entity)golem);
                        player.func_184811_cZ().func_185145_a((Item)this, 1200);
                        if (worldIn instanceof ServerWorld) {
                            for (int h = 0; h < 20; ++h) {
                                double dx = worldIn.field_73012_v.nextGaussian() * 0.02;
                                double dy = worldIn.field_73012_v.nextGaussian() * 0.02;
                                double dz = worldIn.field_73012_v.nextGaussian() * 0.02;
                                ((ServerWorld)worldIn).func_195598_a((IParticleData)ParticleTypes.field_197598_I, golem.func_226277_ct_() + (double)(worldIn.field_73012_v.nextFloat() * golem.func_213311_cf() * 2.0f) - (double)golem.func_213311_cf(), golem.func_226278_cu_() + (double)(worldIn.field_73012_v.nextFloat() * golem.func_213302_cg()), golem.func_226281_cx_() + (double)(worldIn.field_73012_v.nextFloat() * golem.func_213311_cf() * 2.0f) - (double)golem.func_213311_cf(), 1, dx, dy, dz, 0.0);
                            }
                        }
                        if (player instanceof ServerPlayerEntity) {
                            CriteriaTriggers.field_192133_m.func_192229_a((ServerPlayerEntity)player, (Entity)golem);
                        }
                    }
                } else {
                    Vector3d lookVector = player.func_70676_i(1.0f);
                    FluctuantSphereEntity projectile = new FluctuantSphereEntity(worldIn, (LivingEntity)player, lookVector.field_72450_a * 1.0, lookVector.field_72448_b * 1.0, lookVector.field_72449_c * 1.0);
                    projectile.func_70107_b(player.func_226277_ct_() + lookVector.field_72450_a * 1.0, player.func_226278_cu_() + (double)(player.func_213302_cg() / 2.0f) + (double)0.2f, player.func_226281_cx_() + lookVector.field_72449_c * 1.0);
                    projectile.field_70177_z = player.field_70759_as;
                    player.field_70170_p.func_217376_c((Entity)projectile);
                    player.func_184811_cZ().func_185145_a((Item)this, 80);
                }
            }
            player.func_184185_a(SkiesSounds.ENTITY_PLAYER_CAST_SPELL, 1.0f, 1.0f);
        }
    }

    public static boolean canSummonGolems(ItemStack stack) {
        CompoundNBT compoundnbt = stack.func_77978_p();
        return compoundnbt.func_74767_n("SummonsGolems");
    }

    public static ItemStack setSummonsGolems(ItemStack stack, boolean canSummon) {
        CompoundNBT compoundnbt = stack.func_196082_o();
        compoundnbt.func_74757_a("SummonsGolems", canSummon);
        return stack;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<ITextComponent> lore, ITooltipFlag flagIn) {
        lore.add((ITextComponent)new StringTextComponent(StringUtil.getAbilityText("gui.blue_skies.item.ability.summoning_tome." + (SummoningTomeItem.canSummonGolems(stack) ? "artificial_golem" : "fluctuant_sphere"))));
    }
}

