/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.blue_skies.items.tools.weapons;

import com.legacy.blue_skies.blocks.dungeon.SkyDecayingSpikeBlock;
import com.legacy.blue_skies.entities.hostile.boss.summons.DecayingSpikeEntity;
import com.legacy.blue_skies.registries.SkiesBlocks;
import com.legacy.blue_skies.registries.SkiesSounds;
import com.legacy.blue_skies.util.StringUtil;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.UseAction;
import net.minecraft.particles.BlockParticleData;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.state.Property;
import net.minecraft.stats.Stats;
import net.minecraft.util.ActionResult;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class AlchemyScrollItem
extends Item {
    public AlchemyScrollItem(Item.Properties properties) {
        super(properties);
    }

    public int func_77626_a(ItemStack stack) {
        return 72000;
    }

    public UseAction func_77661_b(ItemStack stack) {
        return UseAction.BOW;
    }

    public ActionResult<ItemStack> func_77659_a(World world, PlayerEntity player, Hand hand) {
        ItemStack useStack = player.func_184586_b(hand);
        player.func_184598_c(hand);
        if (useStack.func_77973_b() == this && player.func_184600_cs() == hand) {
            player.field_70170_p.func_217384_a(null, (Entity)player, SkiesSounds.ENTITY_PLAYER_PREPARE_ROCKS, SoundCategory.PLAYERS, 1.0f, 1.0f);
            AlchemyScrollItem.beginSpikeSpawning(player, false);
        }
        return ActionResult.func_226250_c_((Object)useStack);
    }

    public void func_77615_a(ItemStack stack, World worldIn, LivingEntity entityIn, int timeLeft) {
        int i = this.func_77626_a(stack) - timeLeft;
        if (entityIn instanceof PlayerEntity && i > 20) {
            PlayerEntity player = (PlayerEntity)entityIn;
            player.func_184811_cZ().func_185145_a((Item)this, 80);
            ItemStack itemstack = entityIn.func_184586_b(player.func_184600_cs());
            itemstack.func_222118_a(1, (LivingEntity)player, entity -> entity.func_213334_d(player.func_184600_cs()));
            AlchemyScrollItem.beginSpikeSpawning(player, true);
            player.func_71029_a(Stats.field_75929_E.func_199076_b((Object)this));
            player.field_70170_p.func_217384_a(null, (Entity)player, SkiesSounds.ENTITY_PLAYER_CAST_SPELL, SoundCategory.PLAYERS, 1.0f, 1.0f);
        }
    }

    private static void spawnSpikeLine(PlayerEntity playerIn, double posX, double posZ, double maxY, double posY) {
        BlockPos blockpos = new BlockPos(posX, posY, posZ);
        boolean flag = playerIn.field_70170_p.func_175623_d(blockpos);
        double d0 = 0.0;
        if (flag) {
            BlockPos blockpos2 = new BlockPos(posX, (double)blockpos.func_177956_o() + d0 + 5.0, posZ);
            DecayingSpikeEntity block = new DecayingSpikeEntity(playerIn.field_70170_p, blockpos2, SkiesBlocks.decaying_spike.func_176223_P(), (LivingEntity)playerIn);
            block.setDownwards(true);
            block.field_145812_b = 200;
            block.field_145813_c = false;
            playerIn.field_70170_p.func_217376_c((Entity)block);
        }
    }

    private static void spawnSpikeCircle(PlayerEntity playerIn, double posX, double posZ, double maxY, double posY) {
        BlockPos blockpos = new BlockPos(posX, posY, posZ);
        boolean flag = false;
        double d0 = 0.0;
        do {
            BlockState iblockstate;
            VoxelShape voxelshape;
            if (!playerIn.field_70170_p.func_175623_d(blockpos) || playerIn.field_70170_p.func_175623_d(blockpos.func_177977_b())) continue;
            if (!playerIn.field_70170_p.func_175623_d(blockpos) && (voxelshape = (iblockstate = playerIn.field_70170_p.func_180495_p(blockpos)).func_196952_d((IBlockReader)playerIn.field_70170_p, blockpos)) != null) {
                d0 = voxelshape.func_197758_c(Direction.Axis.Y);
            }
            flag = true;
            break;
        } while ((blockpos = blockpos.func_177977_b()).func_177956_o() >= MathHelper.func_76128_c((double)maxY) - 1);
        if (flag) {
            BlockPos blockpos2 = new BlockPos((double)blockpos.func_177958_n() + d0, (double)blockpos.func_177956_o() + d0, (double)blockpos.func_177952_p() + d0);
            DecayingSpikeEntity block = new DecayingSpikeEntity(playerIn.field_70170_p, blockpos2, (BlockState)SkiesBlocks.decaying_spike.func_176223_P().func_206870_a((Property)SkyDecayingSpikeBlock.DOWNWARD, (Comparable)Boolean.valueOf(false)), (LivingEntity)playerIn);
            block.setDownwards(false);
            block.func_70107_b((double)blockpos2.func_177958_n() + 0.5, blockpos2.func_177956_o(), (double)blockpos2.func_177952_p() + 0.5);
            block.field_145812_b = 200;
            block.func_213293_j(0.0, 0.7, 0.0);
            block.field_145813_c = false;
            playerIn.field_70170_p.func_217376_c((Entity)block);
        }
    }

    private static void playSpikeParticles(PlayerEntity playerIn, double posX, double posY, double posZ, double offsetX, double offsetY, double offsetZ) {
        int count = 20;
        if (playerIn.field_70170_p instanceof ServerWorld) {
            ((ServerWorld)playerIn.field_70170_p).func_195598_a((IParticleData)new BlockParticleData(ParticleTypes.field_197611_d, SkiesBlocks.decaying_spike.func_176223_P()), posX, posY, posZ, count, offsetX, offsetY, offsetZ, 0.05);
        }
    }

    public static void beginSpikeSpawning(PlayerEntity playerIn, boolean spawnSpikes) {
        AlchemyScrollItem.beginSpikeSpawning(playerIn, spawnSpikes, 8);
    }

    public static void beginSpikeSpawning(PlayerEntity playerIn, boolean spawnSpikes, int particleAmount) {
        Vector3d look = playerIn.func_70676_i(1.0f);
        double targetX = playerIn.func_226277_ct_() + look.func_82615_a() * 3.0;
        double targetZ = playerIn.func_226281_cx_() + look.func_82616_c() * 3.0;
        double d0 = playerIn.func_226278_cu_();
        double d1 = playerIn.func_226278_cu_() + 1.0;
        float f = (float)MathHelper.func_181159_b((double)(targetZ - playerIn.func_226281_cx_()), (double)(targetX - playerIn.func_226277_ct_()));
        if (playerIn.func_225608_bj_()) {
            for (int k = 0; k < particleAmount; ++k) {
                float f2 = f + (float)k * (float)Math.PI * 2.0f / 8.0f + 1.2566371f;
                AlchemyScrollItem.playSpikeParticles(playerIn, playerIn.func_226277_ct_() + (double)MathHelper.func_76134_b((float)f2) * 2.0, playerIn.func_226278_cu_() + 0.2, playerIn.func_226281_cx_() + (double)MathHelper.func_76126_a((float)f2) * 2.0, playerIn.func_213311_cf() / 4.0f, playerIn.func_213302_cg() / 4.0f, playerIn.func_213311_cf() / 4.0f);
                if (!spawnSpikes) continue;
                AlchemyScrollItem.spawnSpikeCircle(playerIn, playerIn.func_226277_ct_() + (double)MathHelper.func_76134_b((float)f2) * 2.0, playerIn.func_226281_cx_() + (double)MathHelper.func_76126_a((float)f2) * 2.0, d0, d1);
            }
        } else {
            for (int l = 0; l < particleAmount; ++l) {
                double d2 = 1.25 * (double)(l + 1);
                AlchemyScrollItem.playSpikeParticles(playerIn, playerIn.func_226277_ct_() + (double)MathHelper.func_76134_b((float)f) * d2, playerIn.func_226278_cu_() + 5.0, playerIn.func_226281_cx_() + (double)MathHelper.func_76126_a((float)f) * d2, playerIn.func_213311_cf() / 4.0f, playerIn.func_213302_cg() / 4.0f, playerIn.func_213311_cf() / 4.0f);
                if (!spawnSpikes) continue;
                AlchemyScrollItem.spawnSpikeLine(playerIn, playerIn.func_226277_ct_() + (double)MathHelper.func_76134_b((float)f) * d2, playerIn.func_226281_cx_() + (double)MathHelper.func_76126_a((float)f) * d2, d0, d1);
            }
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<ITextComponent> lore, ITooltipFlag flagIn) {
        lore.add((ITextComponent)new StringTextComponent(StringUtil.getAbilityText("gui.blue_skies.item.ability.alchemy_scroll")));
    }
}

