/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.blue_skies.items.tools;

import com.legacy.blue_skies.blocks.SkyPortalBlock;
import com.legacy.blue_skies.blocks.misc.SkyFireBlock;
import com.legacy.blue_skies.registries.SkiesBlocks;
import com.legacy.blue_skies.registries.SkiesDimensions;
import com.legacy.structure_gel.blocks.GelPortalBlock;
import com.legacy.structure_gel.util.GelPortalSize;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.block.AbstractFireBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.CampfireBlock;
import net.minecraft.block.PortalSize;
import net.minecraft.block.SoulFireBlock;
import net.minecraft.block.material.Material;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.FlintAndSteelItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemUseContext;
import net.minecraft.state.Property;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;

public class ZealLighterItem
extends FlintAndSteelItem {
    public ZealLighterItem(Item.Properties builder) {
        super(builder);
    }

    public ActionResultType func_195939_a(ItemUseContext context) {
        BlockPos pos;
        PlayerEntity player = context.func_195999_j();
        World world = context.func_195991_k();
        BlockState placePos = world.func_180495_p(pos = context.func_195995_a());
        if (CampfireBlock.func_241470_h_((BlockState)placePos)) {
            world.func_184133_a(player, pos, SoundEvents.field_187649_bu, SoundCategory.BLOCKS, 1.0f, field_77697_d.nextFloat() * 0.4f + 0.8f);
            world.func_180501_a(pos, (BlockState)placePos.func_206870_a((Property)BlockStateProperties.field_208190_q, (Comparable)Boolean.valueOf(true)), 11);
            if (player != null) {
                context.func_195996_i().func_222118_a(1, (LivingEntity)player, p -> p.func_213334_d(context.func_221531_n()));
            }
            return ActionResultType.func_233537_a_((boolean)world.func_201670_d());
        }
        BlockPos offsetPos = pos.func_177972_a(context.func_196000_l());
        if (ZealLighterItem.canLightBlock(world, offsetPos, context.func_195992_f())) {
            world.func_184133_a(player, offsetPos, SoundEvents.field_187649_bu, SoundCategory.BLOCKS, 1.0f, field_77697_d.nextFloat() * 0.4f + 0.8f);
            BlockState fireState = ZealLighterItem.getFire(world, offsetPos).func_177230_c().func_196258_a(new BlockItemUseContext(context));
            world.func_180501_a(offsetPos, fireState, 11);
            ItemStack stack = context.func_195996_i();
            if (player instanceof ServerPlayerEntity) {
                CriteriaTriggers.field_193137_x.func_193173_a((ServerPlayerEntity)player, offsetPos, stack);
                stack.func_222118_a(1, (LivingEntity)player, p -> p.func_213334_d(context.func_221531_n()));
            }
            return ActionResultType.func_233537_a_((boolean)world.func_201670_d());
        }
        return ActionResultType.FAIL;
    }

    public static boolean canLightBlock(World world, BlockPos pos, Direction facing) {
        BlockState state = world.func_180495_p(pos);
        if (state.func_185904_a() != Material.field_151579_a) {
            return false;
        }
        BlockState fire = ZealLighterItem.getFire(world, pos);
        return fire.func_196955_c((IWorldReader)world, pos) || ZealLighterItem.shouldLightNetherPortal(world, pos, facing) || fire.func_177230_c() instanceof SkyFireBlock && GelPortalSize.isPortal((World)world, (BlockPos)pos, (GelPortalBlock)((SkyFireBlock)fire.func_177230_c()).portalBlock.get(), SkyPortalBlock.ALLOWED_INSIDE_BLOCKS);
    }

    public static BlockState getFire(World world, BlockPos pos) {
        RegistryKey type = world.func_234923_W_();
        if (SoulFireBlock.func_235577_c_((Block)world.func_180495_p(pos.func_177977_b()).func_177230_c())) {
            return Blocks.field_235335_bO_.func_176223_P();
        }
        if (type == SkiesDimensions.EVERBRIGHT || type == World.field_234918_g_ && GelPortalSize.isPortal((World)world, (BlockPos)pos, (GelPortalBlock)SkiesBlocks.everbright_portal, SkyPortalBlock.ALLOWED_INSIDE_BLOCKS)) {
            return SkiesBlocks.blue_fire.func_176223_P();
        }
        if (type == SkiesDimensions.EVERDAWN || type == World.field_234918_g_ && GelPortalSize.isPortal((World)world, (BlockPos)pos, (GelPortalBlock)SkiesBlocks.everdawn_portal, SkyPortalBlock.ALLOWED_INSIDE_BLOCKS)) {
            return SkiesBlocks.black_fire.func_176223_P();
        }
        return AbstractFireBlock.func_235326_a_((IBlockReader)world, (BlockPos)pos);
    }

    private static boolean shouldLightNetherPortal(World world, BlockPos pos, Direction facing) {
        if (world.func_234923_W_() != World.field_234918_g_ && world.func_234923_W_() != World.field_234919_h_) {
            return false;
        }
        BlockPos.Mutable mutablePos = pos.func_239590_i_();
        boolean flag = false;
        for (Direction direction : Direction.values()) {
            if (!world.func_180495_p((BlockPos)mutablePos.func_189533_g((Vector3i)pos).func_189536_c(direction)).func_203425_a(Blocks.field_150343_Z)) continue;
            flag = true;
            break;
        }
        return flag && PortalSize.func_242964_a((IWorld)world, (BlockPos)pos, (Direction.Axis)facing.func_176735_f().func_176740_k()).isPresent();
    }
}

