/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.blue_skies.entities.villager.tasks;

import com.google.common.collect.ImmutableMap;
import com.legacy.blue_skies.entities.villager.GatekeeperEntity;
import java.util.Map;
import java.util.Optional;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.ai.RandomPositionGenerator;
import net.minecraft.entity.ai.brain.Brain;
import net.minecraft.entity.ai.brain.memory.MemoryModuleStatus;
import net.minecraft.entity.ai.brain.memory.MemoryModuleType;
import net.minecraft.entity.ai.brain.memory.WalkTarget;
import net.minecraft.entity.ai.brain.task.Task;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.GlobalPos;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.server.ServerWorld;

public class GatekeeperStayNearPointTask
extends Task<GatekeeperEntity> {
    private final MemoryModuleType<GlobalPos> memoryType;
    private final float speedModifier;
    private final int closeEnoughDist;
    private final int tooFarDistance;
    private final int tooLongUnreachableDuration;

    public GatekeeperStayNearPointTask(MemoryModuleType<GlobalPos> p_i51501_1_, float p_i51501_2_, int p_i51501_3_, int p_i51501_4_, int p_i51501_5_) {
        super((Map)ImmutableMap.of((Object)MemoryModuleType.field_223021_x, (Object)MemoryModuleStatus.REGISTERED, (Object)MemoryModuleType.field_220950_k, (Object)MemoryModuleStatus.VALUE_ABSENT, p_i51501_1_, (Object)MemoryModuleStatus.VALUE_PRESENT));
        this.memoryType = p_i51501_1_;
        this.speedModifier = p_i51501_2_;
        this.closeEnoughDist = p_i51501_3_;
        this.tooFarDistance = p_i51501_4_;
        this.tooLongUnreachableDuration = p_i51501_5_;
    }

    private void dropPOI(GatekeeperEntity p_225457_1_, long p_225457_2_) {
        Brain<GatekeeperEntity> brain = p_225457_1_.func_213375_cj();
        p_225457_1_.removePOI(this.memoryType);
        brain.func_218189_b(this.memoryType);
        brain.func_218205_a(MemoryModuleType.field_223021_x, (Object)p_225457_2_);
    }

    protected void start(ServerWorld worldIn, GatekeeperEntity entityIn, long gameTimeIn) {
        Brain<GatekeeperEntity> brain = entityIn.func_213375_cj();
        brain.func_218207_c(this.memoryType).ifPresent(p_220545_6_ -> {
            if (this.tiredOfTryingToFindTarget(worldIn, entityIn)) {
                this.dropPOI(entityIn, gameTimeIn);
            } else if (this.func_220546_a(worldIn, entityIn, (GlobalPos)p_220545_6_)) {
                int i;
                Vector3d vec3d = null;
                int j = 1000;
                for (i = 0; i < 1000 && (vec3d == null || this.func_220546_a(worldIn, entityIn, GlobalPos.func_239648_a_((RegistryKey)entityIn.field_70170_p.func_234923_W_(), (BlockPos)new BlockPos(vec3d)))); ++i) {
                    vec3d = RandomPositionGenerator.func_75464_a((CreatureEntity)entityIn, (int)15, (int)7, (Vector3d)Vector3d.func_237492_c_((Vector3i)p_220545_6_.func_218180_b()));
                }
                if (i == 1000) {
                    this.dropPOI(entityIn, gameTimeIn);
                    return;
                }
                brain.func_218205_a(MemoryModuleType.field_220950_k, (Object)new WalkTarget(vec3d, this.speedModifier, this.closeEnoughDist));
            } else if (!this.closeEnough(worldIn, entityIn, (GlobalPos)p_220545_6_)) {
                brain.func_218205_a(MemoryModuleType.field_220950_k, (Object)new WalkTarget(p_220545_6_.func_218180_b(), this.speedModifier, this.closeEnoughDist));
            }
        });
    }

    private boolean tiredOfTryingToFindTarget(ServerWorld p_223017_1_, GatekeeperEntity p_223017_2_) {
        Optional optional = p_223017_2_.func_213375_cj().func_218207_c(MemoryModuleType.field_223021_x);
        if (optional.isPresent()) {
            return p_223017_1_.func_82737_E() - (Long)optional.get() > (long)this.tooLongUnreachableDuration;
        }
        return false;
    }

    private boolean func_220546_a(ServerWorld p_220546_1_, GatekeeperEntity p_220546_2_, GlobalPos p_220546_3_) {
        return p_220546_3_.func_239646_a_() != p_220546_1_.func_234923_W_() || p_220546_3_.func_218180_b().func_218139_n((Vector3i)p_220546_2_.func_233580_cy_()) > this.tooFarDistance;
    }

    private boolean closeEnough(ServerWorld p_220547_1_, GatekeeperEntity p_220547_2_, GlobalPos p_220547_3_) {
        return p_220547_3_.func_239646_a_() == p_220547_1_.func_234923_W_() && p_220547_3_.func_218180_b().func_218139_n((Vector3i)p_220547_2_.func_233580_cy_()) <= this.closeEnoughDist;
    }
}

