/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.blue_skies.entities.projectile;

import com.legacy.blue_skies.registries.SkiesEntityTypes;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.monster.MonsterEntity;
import net.minecraft.entity.projectile.LlamaSpitEntity;
import net.minecraft.network.IPacket;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.EntityRayTraceResult;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.network.FMLPlayMessages;
import net.minecraftforge.fml.network.NetworkHooks;

public class SeedBombEntity
extends LlamaSpitEntity {
    public SeedBombEntity(EntityType<? extends SeedBombEntity> type, World world) {
        super(type, world);
    }

    public SeedBombEntity(World worldIn, MonsterEntity shooter) {
        this(SkiesEntityTypes.SEED_BOMB, worldIn);
        super.func_212361_a((Entity)shooter);
        this.func_70107_b(shooter.func_226277_ct_(), shooter.func_226278_cu_() + (double)shooter.func_70047_e() - (double)0.1f, shooter.func_226281_cx_());
    }

    @OnlyIn(value=Dist.CLIENT)
    public SeedBombEntity(World worldIn, double x, double y, double z, double xDir, double yDir, double zDir) {
        this(SkiesEntityTypes.SEED_BOMB, worldIn);
        this.func_70107_b(x, y, z);
        for (int i = 0; i < 7; ++i) {
            double d0 = 0.4 + 0.1 * (double)i;
            worldIn.func_195594_a((IParticleData)ParticleTypes.field_197602_M, x, y, z, xDir * d0, yDir, zDir * d0);
        }
        this.func_213293_j(xDir, yDir, zDir);
    }

    public SeedBombEntity(FMLPlayMessages.SpawnEntity spawnEntity, World world) {
        this(SkiesEntityTypes.SEED_BOMB, world);
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        if (this.field_70170_p.field_72995_K) {
            this.spawnParticles();
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    private void spawnParticles() {
        float dx = (this.field_70146_Z.nextFloat() - 0.5f) / 7.0f;
        float dy = this.field_70146_Z.nextFloat() / 10.0f;
        float dz = (this.field_70146_Z.nextFloat() - 0.5f) / 7.0f;
        this.field_70170_p.func_195594_a((IParticleData)ParticleTypes.field_218421_R, (double)this.func_233580_cy_().func_177958_n() + 0.5, (double)((float)this.func_233580_cy_().func_177956_o() + 0.5f), (double)this.func_233580_cy_().func_177952_p() + 0.5, (double)dx, (double)dy, (double)dz);
    }

    public void func_70186_c(double x, double y, double z, float velocity, float inaccuracy) {
        Vector3d vec3d = new Vector3d(x, y, z).func_72432_b().func_72441_c(this.field_70146_Z.nextGaussian() * (double)0.0075f * (double)inaccuracy, this.field_70146_Z.nextGaussian() * (double)0.0075f * (double)inaccuracy, this.field_70146_Z.nextGaussian() * (double)0.0075f * (double)inaccuracy).func_186678_a((double)velocity);
        this.func_213317_d(vec3d);
        float f = MathHelper.func_76133_a((double)SeedBombEntity.func_213296_b((Vector3d)vec3d));
        this.field_70177_z = (float)(MathHelper.func_181159_b((double)vec3d.field_72450_a, (double)z) * 57.2957763671875);
        this.field_70125_A = (float)(MathHelper.func_181159_b((double)vec3d.field_72448_b, (double)f) * 57.2957763671875);
        this.field_70126_B = this.field_70177_z;
        this.field_70127_C = this.field_70125_A;
    }

    protected void func_213868_a(EntityRayTraceResult result) {
        Entity entity = this.func_234616_v_();
        if (entity != null && result.func_216348_a() != null && !entity.func_184191_r(result.func_216348_a())) {
            this.causeSeedExplosion(this.func_233580_cy_());
            super.func_213868_a(result);
            if (!this.field_70170_p.field_72995_K) {
                this.func_70106_y();
            }
        }
    }

    protected void func_230299_a_(BlockRayTraceResult result) {
        super.func_230299_a_(result);
        this.causeSeedExplosion(result.func_216350_a().func_177981_b(1));
    }

    public void causeSeedExplosion(BlockPos pos) {
        this.func_184185_a(SoundEvents.field_211414_dn, 0.7f, 1.0f);
        this.func_184185_a(SoundEvents.field_187638_cR, 0.3f, 0.7f);
        double d0 = (double)pos.func_177958_n() + 0.5;
        double d13 = (double)pos.func_177956_o() + 0.5;
        double d18 = (double)pos.func_177952_p() + 0.5;
        for (double d24 = 0.0; d24 < Math.PI * 2; d24 += 0.1) {
            double motion = 0.1f;
            this.field_70170_p.func_195594_a((IParticleData)ParticleTypes.field_197601_L, d0 + Math.cos(d24) * motion, d13 - 0.4, d18 + Math.sin(d24) * motion, Math.cos(d24) * -motion, 0.0, Math.sin(d24) * -motion);
        }
    }

    public IPacket<?> func_213297_N() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }
}

