/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.blue_skies.entities.projectile;

import com.google.common.collect.Lists;
import com.legacy.blue_skies.entities.hostile.boss.SummonerEntity;
import com.legacy.blue_skies.entities.util.interfaces.ISkyBoss;
import com.legacy.blue_skies.registries.SkiesEntityTypes;
import com.legacy.blue_skies.registries.SkiesParticles;
import com.legacy.blue_skies.registries.SkiesSounds;
import com.legacy.blue_skies.util.EntityUtil;
import com.legacy.blue_skies.util.GeometryHelper;
import java.util.ArrayList;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.entity.projectile.DamagingProjectileEntity;
import net.minecraft.entity.projectile.ProjectileHelper;
import net.minecraft.network.IPacket;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.util.DamageSource;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.fml.network.FMLPlayMessages;
import net.minecraftforge.fml.network.NetworkHooks;

public class FluctuantSphereEntity
extends DamagingProjectileEntity {
    public FluctuantSphereEntity(EntityType<? extends FluctuantSphereEntity> type, World world) {
        super(type, world);
    }

    public FluctuantSphereEntity(World worldIn, SummonerEntity summoner) {
        this(SkiesEntityTypes.FLUCTUANT_SPHERE, worldIn);
        this.func_212361_a((Entity)summoner);
        this.func_70107_b(summoner.func_226277_ct_() - (double)(summoner.func_213311_cf() + 1.0f) * 0.5 * (double)MathHelper.func_76126_a((float)(summoner.field_70761_aq * ((float)Math.PI / 180))), summoner.func_226278_cu_() + (double)summoner.func_70047_e() - (double)0.1f, summoner.func_226281_cx_() + (double)(summoner.func_213311_cf() + 1.0f) * 0.5 * (double)MathHelper.func_76134_b((float)(summoner.field_70761_aq * ((float)Math.PI / 180))));
    }

    public FluctuantSphereEntity(FMLPlayMessages.SpawnEntity spawnEntity, World world) {
        this(SkiesEntityTypes.FLUCTUANT_SPHERE, world);
    }

    @OnlyIn(value=Dist.CLIENT)
    public FluctuantSphereEntity(World worldIn, double x, double y, double z, double accelX, double accelY, double accelZ) {
        super(SkiesEntityTypes.FLUCTUANT_SPHERE, x, y, z, accelX, accelY, accelZ, worldIn);
    }

    public FluctuantSphereEntity(World worldIn, LivingEntity shooter, double accelX, double accelY, double accelZ) {
        super(SkiesEntityTypes.FLUCTUANT_SPHERE, shooter, accelX, accelY, accelZ, worldIn);
    }

    protected void func_70227_a(RayTraceResult result) {
        RayTraceResult.Type raytraceresult$type = result.func_216346_c();
        if (raytraceresult$type == RayTraceResult.Type.BLOCK && !this.field_70170_p.field_72995_K && this.field_70173_aa > 20 || this.field_70173_aa >= 100) {
            this.vanish();
        }
    }

    public boolean func_70067_L() {
        return false;
    }

    public void func_70071_h_() {
        Entity entity = this.func_234616_v_();
        if (this.field_70170_p.field_72995_K || (entity == null || entity.func_70089_S()) && this.field_70170_p.func_195588_v(this.func_233580_cy_())) {
            RayTraceResult raytraceresult;
            super.func_70071_h_();
            if (this.func_184564_k()) {
                this.func_70015_d(1);
            }
            if ((raytraceresult = ProjectileHelper.func_234618_a_((Entity)this, arg_0 -> ((FluctuantSphereEntity)this).func_230298_a_(arg_0))).func_216346_c() != RayTraceResult.Type.MISS && !ForgeEventFactory.onProjectileImpact((DamagingProjectileEntity)this, (RayTraceResult)raytraceresult)) {
                this.func_70227_a(raytraceresult);
            }
            this.func_145775_I();
            Vector3d vector3d = this.func_213322_ci();
            double x = this.func_226277_ct_() + vector3d.field_72450_a;
            double y = this.func_226278_cu_() + vector3d.field_72448_b;
            double z = this.func_226281_cx_() + vector3d.field_72449_c;
            ProjectileHelper.func_188803_a((Entity)this, (float)0.2f);
            float inirtia = this.func_82341_c();
            if (this.func_70090_H()) {
                for (int i = 0; i < 4; ++i) {
                    this.field_70170_p.func_195594_a((IParticleData)ParticleTypes.field_197612_e, x - vector3d.field_72450_a * 0.25, y - vector3d.field_72448_b * 0.25, z - vector3d.field_72449_c * 0.25, vector3d.field_72450_a, vector3d.field_72448_b, vector3d.field_72449_c);
                }
                inirtia = 0.8f;
            }
            this.func_213317_d(vector3d.func_72441_c(this.field_70232_b, this.field_70233_c, this.field_70230_d).func_186678_a((double)inirtia));
            this.func_70107_b(x, y, z);
        } else {
            this.func_70106_y();
        }
        if (this.field_70170_p instanceof ServerWorld) {
            ServerWorld world = (ServerWorld)this.field_70170_p;
            for (ServerPlayerEntity p : world.func_217369_A()) {
                world.func_195600_a(p, this.func_195057_f(), true, this.func_226277_ct_(), this.func_226278_cu_() + 0.4, this.func_226281_cx_(), 1, 0.0, 0.0, 0.0, 0.0);
            }
        }
        int timeUntilHit = 8;
        if (this.func_234616_v_() instanceof SummonerEntity) {
            SummonerEntity summoner = (SummonerEntity)this.func_234616_v_();
            timeUntilHit = summoner.getDifficultyID() == ISkyBoss.Level.SILVER.getId() ? 8 : (summoner.getDifficultyID() == ISkyBoss.Level.GOLD.getId() ? 10 : (summoner.getDifficultyID() >= ISkyBoss.Level.PLATINUM.getId() ? 14 : 0));
        }
        ArrayList list = Lists.newArrayList((Iterable)this.field_70170_p.func_72839_b((Entity)this, this.func_174813_aQ().func_186662_g(1.5)));
        for (Entity e : list) {
            if (e == null || !(e instanceof LivingEntity) || ((LivingEntity)e).field_70172_ad > timeUntilHit || this.func_234616_v_() == null || e == this.func_234616_v_() || e.func_184191_r(this.func_234616_v_())) continue;
            this.causeDamage(e, Math.max(1.0f, 3.0f / ((float)list.size() * 0.5f)));
        }
        if (!this.field_70170_p.field_72995_K && this.field_70173_aa > 120) {
            this.vanish();
        }
    }

    public void causeDamage(Entity entity, float amount) {
        boolean flag = entity.func_70097_a(EntityUtil.DamageSources.causeShockDamage(this.func_234616_v_()), amount);
        if (entity instanceof LivingEntity && flag && this.field_70170_p instanceof ServerWorld) {
            GeometryHelper.drawParticleLine((ServerWorld)this.field_70170_p, (IParticleData)SkiesParticles.FLUCTUANT_SPHERE_BEAM, this.func_213303_ch().func_72441_c(0.0, 0.5, 0.0), new Vector3d(entity.func_226277_ct_(), entity.func_226278_cu_() + (double)(entity.func_213302_cg() / 2.0f), entity.func_226281_cx_()), 0.2, 0.0, true);
        }
    }

    public void vanish() {
        if (this.field_70170_p instanceof ServerWorld) {
            double d0 = this.field_70146_Z.nextGaussian() * 0.02;
            double d1 = this.field_70146_Z.nextGaussian() * 0.02;
            double d2 = this.field_70146_Z.nextGaussian() * 0.02;
            double d3 = 10.0;
            ((ServerWorld)this.field_70170_p).func_195598_a((IParticleData)ParticleTypes.field_197598_I, this.func_226277_ct_() + (double)(this.field_70146_Z.nextFloat() * this.func_213311_cf() * 2.0f) - (double)this.func_213311_cf() - d0 * d3, this.func_226278_cu_() + (double)(this.field_70146_Z.nextFloat() * this.func_213302_cg()) - d1 * d3, this.func_226281_cx_() + (double)(this.field_70146_Z.nextFloat() * this.func_213311_cf() * 2.0f) - (double)this.func_213311_cf() - d2 * d3, 20, d0, d1, d2, 0.1);
        }
        this.func_70106_y();
        this.field_70170_p.func_184133_a((PlayerEntity)null, this.func_233580_cy_(), SkiesSounds.ENTITY_FLUCTUANT_SPHERE_DISAPPEAR, SoundCategory.HOSTILE, 1.0f, 2.0f);
    }

    protected IParticleData func_195057_f() {
        return SkiesParticles.FLUCTUANT_SPHERE;
    }

    public boolean func_70097_a(DamageSource source, float amount) {
        return false;
    }

    protected boolean func_184564_k() {
        return false;
    }

    protected float func_82341_c() {
        return 0.7f;
    }

    public IPacket<?> func_213297_N() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }
}

