/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.blue_skies.entities.passive.fish;

import com.legacy.blue_skies.BlueSkies;
import com.legacy.blue_skies.entities.util.interfaces.IVentiumCatchable;
import com.legacy.blue_skies.registries.SkiesItems;
import com.legacy.blue_skies.registries.SkiesSounds;
import com.legacy.blue_skies.util.StringUtil;
import java.util.Random;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.block.Blocks;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.ILivingEntityData;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.ai.attributes.AttributeModifierMap;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.ai.controller.MovementController;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.RandomSwimmingGoal;
import net.minecraft.entity.passive.WaterMobEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.pathfinding.PathNavigator;
import net.minecraft.pathfinding.SwimmerPathNavigator;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.ITag;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.IServerWorld;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;

public class JellyDrifterEntity
extends WaterMobEntity
implements IVentiumCatchable {
    private static final DataParameter<Byte> COLOR = EntityDataManager.func_187226_a(JellyDrifterEntity.class, (IDataSerializer)DataSerializers.field_187191_a);
    private static final DataParameter<Boolean> FROM_BUCKET = EntityDataManager.func_187226_a(JellyDrifterEntity.class, (IDataSerializer)DataSerializers.field_187198_h);
    public float jellyPitch;
    public float prevJellyPitch;
    public float jellyYaw;
    public float prevJellyYaw;

    public JellyDrifterEntity(EntityType<? extends JellyDrifterEntity> type, World world) {
        super(type, world);
        this.field_70765_h = new MoveHelperController(this);
    }

    protected void func_184651_r() {
        super.func_184651_r();
        this.field_70714_bg.func_75776_a(4, (Goal)new RandomSwimmingGoal((CreatureEntity)this, 1.0, 80));
    }

    public static AttributeModifierMap.MutableAttribute registerAttributes() {
        return MobEntity.func_233666_p_().func_233815_a_(Attributes.field_233818_a_, 6.0);
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(COLOR, (Object)0);
        this.field_70180_af.func_187214_a(FROM_BUCKET, (Object)false);
    }

    public boolean func_213392_I() {
        return this.isFromBucket();
    }

    public boolean func_213397_c(double distanceToClosestPlayer) {
        return !this.isFromBucket() && !this.func_145818_k_();
    }

    public void func_70636_d() {
        super.func_70636_d();
        this.prevJellyPitch = this.jellyPitch;
        this.prevJellyYaw = this.jellyYaw;
        if (this.func_203005_aq()) {
            Vector3d vector3d = this.func_213322_ci();
            float f1 = MathHelper.func_76133_a((double)JellyDrifterEntity.func_213296_b((Vector3d)vector3d));
            this.field_70761_aq += (-((float)MathHelper.func_181159_b((double)vector3d.field_72450_a, (double)vector3d.field_72449_c)) * 57.295776f - this.field_70761_aq) * 0.1f;
            this.field_70177_z = this.field_70761_aq;
            this.jellyYaw = (float)((double)this.jellyYaw + 2.356194490192345);
            this.jellyPitch += (-((float)MathHelper.func_181159_b((double)f1, (double)vector3d.field_72448_b)) * 57.295776f - this.jellyPitch) * 0.1f;
        } else {
            this.jellyPitch = 0.0f;
        }
    }

    public ILivingEntityData func_213386_a(IServerWorld worldIn, DifficultyInstance difficultyIn, SpawnReason reason, ILivingEntityData spawnDataIn, CompoundNBT dataTag) {
        spawnDataIn = super.func_213386_a(worldIn, difficultyIn, reason, spawnDataIn, dataTag);
        if (dataTag != null && dataTag.func_150297_b("Color", 99)) {
            this.setColor(dataTag.func_74771_c("Color"));
        } else {
            this.setColor(Colors.getRandom(this.field_70146_Z).getId());
        }
        return spawnDataIn;
    }

    public void func_213281_b(CompoundNBT compound) {
        super.func_213281_b(compound);
        compound.func_74774_a("Color", this.getColor());
        compound.func_74757_a("FromBucket", this.isFromBucket());
    }

    public void func_70020_e(CompoundNBT compound) {
        super.func_70020_e(compound);
        this.setColor(compound.func_74771_c("Color"));
        this.setFromVentiumBucket(compound.func_74767_n("FromBucket"));
    }

    public void setColor(byte color) {
        this.field_70180_af.func_187227_b(COLOR, (Object)color);
    }

    public byte getColor() {
        return (Byte)this.field_70180_af.func_187225_a(COLOR);
    }

    public boolean isFromBucket() {
        return (Boolean)this.field_70180_af.func_187225_a(FROM_BUCKET);
    }

    @Override
    public void setFromVentiumBucket(boolean fromBucket) {
        this.field_70180_af.func_187227_b(FROM_BUCKET, (Object)fromBucket);
    }

    protected PathNavigator func_175447_b(World worldIn) {
        return new SwimmerPathNavigator((MobEntity)this, worldIn);
    }

    protected SoundEvent func_184639_G() {
        return SkiesSounds.ENTITY_JELLY_DRIFTER_IDLE;
    }

    protected SoundEvent func_184601_bQ(DamageSource source) {
        return SkiesSounds.ENTITY_JELLY_DRIFTER_HURT;
    }

    protected SoundEvent func_184615_bR() {
        return SkiesSounds.ENTITY_JELLY_DRIFTER_DEATH;
    }

    protected float func_70599_aP() {
        return 0.7f;
    }

    @Override
    public ItemStack getVentiumBucket() {
        return new ItemStack((IItemProvider)SkiesItems.ventium_drifter_bucket);
    }

    protected void func_82167_n(Entity entityIn) {
        super.func_82167_n(entityIn);
        if (entityIn instanceof LivingEntity && !(entityIn instanceof JellyDrifterEntity) && !((LivingEntity)entityIn).func_70644_a(Effects.field_76436_u) && !entityIn.func_190530_aW()) {
            if (entityIn instanceof PlayerEntity && ((PlayerEntity)entityIn).func_184812_l_()) {
                return;
            }
            if (!this.field_70170_p.field_72995_K) {
                ((LivingEntity)entityIn).func_195064_c(new EffectInstance(Effects.field_76436_u, 60));
                this.func_184185_a(SkiesSounds.ENTITY_JELLY_DRIFTER_POISON, 1.0f, this.func_70647_i());
            }
        }
    }

    protected ActionResultType func_230254_b_(PlayerEntity player, Hand hand) {
        ItemStack waterBucket = player.func_184586_b(hand);
        if (waterBucket.func_77973_b() == SkiesItems.ventium_water_bucket && this.func_70089_S()) {
            this.func_184185_a(SoundEvents.field_203814_aa, 1.0f, 1.0f);
            waterBucket.func_190918_g(1);
            ItemStack bucket = this.getVentiumBucket();
            this.setBucketData(bucket);
            if (!this.field_70170_p.field_72995_K) {
                CriteriaTriggers.field_204813_j.func_204817_a((ServerPlayerEntity)player, bucket);
            }
            if (waterBucket.func_190926_b()) {
                player.func_184611_a(hand, bucket);
            } else if (!player.field_71071_by.func_70441_a(bucket)) {
                player.func_71019_a(bucket, false);
            }
            this.func_70106_y();
            return ActionResultType.SUCCESS;
        }
        return super.func_230254_b_(player, hand);
    }

    protected void setBucketData(ItemStack bucket) {
        if (this.func_145818_k_()) {
            bucket.func_200302_a(this.func_200201_e());
        }
        CompoundNBT compoundnbt = bucket.func_196082_o();
        compoundnbt.func_74774_a("Color", this.getColor());
    }

    public static boolean spawnConditions(EntityType<? extends JellyDrifterEntity> type, IWorld worldIn, SpawnReason reason, BlockPos p_223363_3_, Random randomIn) {
        return worldIn.func_180495_p(p_223363_3_).func_177230_c() == Blocks.field_150355_j && worldIn.func_180495_p(p_223363_3_.func_177984_a()).func_177230_c() == Blocks.field_150355_j;
    }

    public static enum Colors {
        SNOW,
        ICY,
        ROSE,
        TEAL,
        AMBER,
        CRIMSON;

        private final ResourceLocation texture = BlueSkies.locate(String.format("textures/entity/jelly_drifter/jelly_drifter_%s.png", StringUtil.toLower(this.name())));

        public byte getId() {
            return (byte)this.ordinal();
        }

        public ResourceLocation getTexture() {
            return this.texture;
        }

        public static Colors getRandom(Random rand) {
            return rand.nextFloat() < 0.002f ? CRIMSON : Colors.values()[rand.nextInt(Colors.values().length - 1)];
        }

        public static Colors byId(int id) {
            if (id < 0 || id >= Colors.values().length) {
                id = 0;
            }
            return Colors.values()[id];
        }
    }

    static class MoveHelperController
    extends MovementController {
        private final JellyDrifterEntity jellyfish;

        MoveHelperController(JellyDrifterEntity fish) {
            super((MobEntity)fish);
            this.jellyfish = fish;
        }

        public void func_75641_c() {
            if (this.jellyfish.func_208600_a((ITag)FluidTags.field_206959_a)) {
                this.jellyfish.func_213317_d(this.jellyfish.func_213322_ci().func_72441_c(0.0, 0.005, 0.0));
            }
            if (this.field_188491_h == MovementController.Action.MOVE_TO && !this.jellyfish.func_70661_as().func_75500_f()) {
                double d0 = this.field_75646_b - this.jellyfish.func_226277_ct_();
                double d1 = this.field_75647_c - this.jellyfish.func_226278_cu_();
                double d2 = this.field_75644_d - this.jellyfish.func_226281_cx_();
                double d3 = MathHelper.func_76133_a((double)(d0 * d0 + d1 * d1 + d2 * d2));
                float f = (float)(MathHelper.func_181159_b((double)d2, (double)d0) * 57.2957763671875) - 90.0f;
                this.jellyfish.field_70761_aq = this.jellyfish.field_70177_z = this.func_75639_a(this.jellyfish.field_70177_z, f, 90.0f);
                float f1 = (float)(this.field_75645_e * this.jellyfish.func_110148_a(Attributes.field_233821_d_).func_111126_e());
                this.jellyfish.func_70659_e(MathHelper.func_219799_g((float)0.125f, (float)this.jellyfish.func_70689_ay(), (float)f1));
                this.jellyfish.func_213317_d(this.jellyfish.func_213322_ci().func_72441_c(0.0, (double)this.jellyfish.func_70689_ay() * (d1 /= d3) * 0.1, 0.0));
            } else {
                this.jellyfish.func_70659_e(0.0f);
            }
        }
    }
}

