/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.blue_skies.entities.hostile.boss;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.legacy.blue_skies.blocks.dungeon.SpiderNestBlock;
import com.legacy.blue_skies.blocks.misc.TrophyBlock;
import com.legacy.blue_skies.capability.SkiesPlayer;
import com.legacy.blue_skies.client.particle.data.PoisonData;
import com.legacy.blue_skies.data.objects.SkiesEntityTags;
import com.legacy.blue_skies.entities.hostile.boss.summons.NestedSpiderEntity;
import com.legacy.blue_skies.entities.projectile.VenomBombEntity;
import com.legacy.blue_skies.entities.projectile.VenomSpitEntity;
import com.legacy.blue_skies.entities.util.SkiesDungeonType;
import com.legacy.blue_skies.entities.util.StunnableLookController;
import com.legacy.blue_skies.entities.util.StunnedEntitySound;
import com.legacy.blue_skies.entities.util.base.SkiesBossEntity;
import com.legacy.blue_skies.entities.util.interfaces.ISkyBoss;
import com.legacy.blue_skies.entities.util.interfaces.IStunnableMob;
import com.legacy.blue_skies.items.LootBagItem;
import com.legacy.blue_skies.network.PacketHandler;
import com.legacy.blue_skies.network.c_to_s.GetClientMotionPacket;
import com.legacy.blue_skies.registries.SkiesBlocks;
import com.legacy.blue_skies.registries.SkiesEffects;
import com.legacy.blue_skies.registries.SkiesEntityTypes;
import com.legacy.blue_skies.registries.SkiesItems;
import com.legacy.blue_skies.registries.SkiesPointsOfInterest;
import com.legacy.blue_skies.registries.SkiesSounds;
import java.util.List;
import java.util.Set;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.client.Minecraft;
import net.minecraft.client.audio.ISound;
import net.minecraft.client.audio.SoundHandler;
import net.minecraft.command.arguments.EntityAnchorArgument;
import net.minecraft.entity.CreatureAttribute;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntitySize;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.ILivingEntityData;
import net.minecraft.entity.IRangedAttackMob;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.MoverType;
import net.minecraft.entity.Pose;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.ai.attributes.AttributeModifierMap;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.HurtByTargetGoal;
import net.minecraft.entity.ai.goal.LookAtGoal;
import net.minecraft.entity.ai.goal.LookRandomlyGoal;
import net.minecraft.entity.ai.goal.NearestAttackableTargetGoal;
import net.minecraft.entity.ai.goal.RangedAttackGoal;
import net.minecraft.entity.ai.goal.SwimGoal;
import net.minecraft.entity.ai.goal.WaterAvoidingRandomWalkingGoal;
import net.minecraft.entity.item.ExperienceOrbEntity;
import net.minecraft.entity.monster.MonsterEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.particles.BlockParticleData;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.potion.Effect;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.util.DamageSource;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.village.PointOfInterestManager;
import net.minecraft.world.BossInfo;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.GameRules;
import net.minecraft.world.IServerWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.LightType;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class ArachnarchEntity
extends SkiesBossEntity
implements IRangedAttackMob,
IStunnableMob {
    protected static final DataParameter<Byte> CLIMBING = EntityDataManager.func_187226_a(ArachnarchEntity.class, (IDataSerializer)DataSerializers.field_187191_a);
    protected static final DataParameter<Boolean> CEILING_LOCKED = EntityDataManager.func_187226_a(ArachnarchEntity.class, (IDataSerializer)DataSerializers.field_187198_h);
    protected static final DataParameter<Boolean> CHARGING = EntityDataManager.func_187226_a(ArachnarchEntity.class, (IDataSerializer)DataSerializers.field_187198_h);
    protected static final DataParameter<Boolean> STUNNED = EntityDataManager.func_187226_a(ArachnarchEntity.class, (IDataSerializer)DataSerializers.field_187198_h);
    protected static final DataParameter<Integer> TIME_ON_CEILING = EntityDataManager.func_187226_a(ArachnarchEntity.class, (IDataSerializer)DataSerializers.field_187192_b);
    protected static final DataParameter<Integer> TIME_SINCE_LOCKED = EntityDataManager.func_187226_a(ArachnarchEntity.class, (IDataSerializer)DataSerializers.field_187192_b);
    protected static final DataParameter<Integer> TIME_STUNNED = EntityDataManager.func_187226_a(ArachnarchEntity.class, (IDataSerializer)DataSerializers.field_187192_b);
    protected static final DataParameter<Integer> TICKS_UNTIL_NEXT_SCREECH = EntityDataManager.func_187226_a(ArachnarchEntity.class, (IDataSerializer)DataSerializers.field_187192_b);
    private static final Set<Effect> IMMUNE_EFFECTS = ImmutableSet.of((Object)Effects.field_76421_d, (Object)Effects.field_76436_u, (Object)SkiesEffects.DEADLY_VENOM, (Object)Effects.field_204839_B, (Object)Effects.field_188424_y);
    public static Set<Item> SHIELDS = ImmutableSet.of((Object)SkiesItems.moonstone_shield, (Object)SkiesItems.spike_shield);
    public int deathTicks;
    public int holdingTime = 1;
    public int clientScreechTime = 0;
    public float damageSinceGrabbed = 0.0f;
    @OnlyIn(value=Dist.CLIENT)
    private ISound stunSound;

    public ArachnarchEntity(EntityType<? extends ArachnarchEntity> type, World worldIn) {
        super((EntityType<? extends SkiesBossEntity>)type, worldIn);
        this.field_70728_aV = 40;
        this.field_70749_g = new StunnableLookController((MobEntity)this);
        this.field_70138_W = 2.0f;
    }

    @Override
    public void func_213315_a(MoverType type, Vector3d vec) {
        if (this.getInvulTime() <= 0 && !this.isStunned()) {
            super.func_213315_a(type, vec);
        } else {
            super.func_213315_a(type, new Vector3d(0.0, vec.field_72448_b, 0.0));
        }
    }

    @Override
    protected void func_184651_r() {
        super.func_184651_r();
        this.field_70714_bg.func_75776_a(1, (Goal)new SwimGoal((MobEntity)this));
        this.field_70714_bg.func_75776_a(5, (Goal)new WaterAvoidingRandomWalkingGoal((CreatureEntity)this, 0.8){

            public boolean func_75253_b() {
                if (((ArachnarchEntity)this.field_75457_a).isCeilingLocked() || this.field_75457_a.func_70638_az() != null) {
                    return false;
                }
                return !((ArachnarchEntity)this.field_75457_a).isDungeonSpawned() && super.func_75253_b();
            }

            public boolean func_75250_a() {
                if (((ArachnarchEntity)this.field_75457_a).isCeilingLocked() || this.field_75457_a.func_70638_az() != null) {
                    return false;
                }
                return !((ArachnarchEntity)this.field_75457_a).isDungeonSpawned() && super.func_75250_a();
            }
        });
        this.field_70714_bg.func_75776_a(6, (Goal)new LookAtGoal((MobEntity)this, PlayerEntity.class, 15.0f));
        this.field_70714_bg.func_75776_a(6, (Goal)new LookRandomlyGoal((MobEntity)this));
        this.field_70715_bh.func_75776_a(1, (Goal)new HurtByTargetGoal((CreatureEntity)this, new Class[0]));
        this.field_70714_bg.func_75776_a(2, (Goal)new NearestAttackableTargetGoal((MobEntity)this, PlayerEntity.class, false));
        this.field_70714_bg.func_75776_a(3, (Goal)new VenomAttackGoal(this, 1.25, 20, 40.0f));
        this.field_70714_bg.func_75776_a(3, (Goal)new VenomWalkingAttackGoal(this, 1.25, 60, 40.0f));
        this.field_70714_bg.func_75776_a(3, (Goal)new LungeAtTargetGoal());
        this.field_70714_bg.func_75776_a(3, (Goal)new WalkAndDropGoal());
        this.field_70714_bg.func_75776_a(3, (Goal)new ScreechAttackGoal());
    }

    @Override
    public ILivingEntityData func_213386_a(IServerWorld worldIn, DifficultyInstance difficultyIn, SpawnReason reason, @Nullable ILivingEntityData spawnDataIn, @Nullable CompoundNBT dataTag) {
        ILivingEntityData flag = super.func_213386_a(worldIn, difficultyIn, reason, spawnDataIn, dataTag);
        if (!this.field_70170_p.field_72995_K) {
            if (this.getDifficultyID() >= ISkyBoss.Level.GOLD.getId()) {
                if (this.getDifficultyID() >= ISkyBoss.Level.PLATINUM.getId()) {
                    this.func_110148_a(Attributes.field_233826_i_).func_111128_a(7.5);
                }
                this.func_110148_a(Attributes.field_233827_j_).func_111128_a(this.getDifficultyID() >= ISkyBoss.Level.PLATINUM.getId() ? 6.0 : 4.0);
            }
            this.func_110148_a(Attributes.field_233823_f_).func_111128_a(10.0 + Math.min(8.0, (double)this.getExtraPlayers() * 1.5));
        }
        return flag;
    }

    public static AttributeModifierMap.MutableAttribute registerAttributes() {
        return MonsterEntity.func_234295_eP_().func_233815_a_(Attributes.field_233818_a_, 500.0).func_233815_a_(Attributes.field_233819_b_, 40.0).func_233815_a_(Attributes.field_233821_d_, (double)0.36f).func_233815_a_(Attributes.field_233823_f_, 14.0).func_233815_a_(Attributes.field_233820_c_, 100.0).func_233815_a_(Attributes.field_233826_i_, 6.0).func_233815_a_(Attributes.field_233824_g_, 4.0);
    }

    @Override
    public double getBossHealth() {
        return 500.0 + (double)this.getExtraPlayers() * 200.0;
    }

    @Override
    public float getHealAmount() {
        return 50.0f;
    }

    @Override
    public LootBagItem getLootBag() {
        return SkiesItems.loot_bag_arachnarch;
    }

    @Override
    public TrophyBlock getTrophy() {
        return SkiesBlocks.arachnarch_trophy;
    }

    @Override
    public float getMaxReach() {
        return 5.08f;
    }

    @Override
    public int getDamageCap() {
        return 15;
    }

    @Override
    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(CLIMBING, (Object)0);
        this.field_70180_af.func_187214_a(CEILING_LOCKED, (Object)false);
        this.field_70180_af.func_187214_a(CHARGING, (Object)false);
        this.field_70180_af.func_187214_a(STUNNED, (Object)false);
        this.field_70180_af.func_187214_a(TIME_ON_CEILING, (Object)0);
        this.field_70180_af.func_187214_a(TIME_SINCE_LOCKED, (Object)0);
        this.field_70180_af.func_187214_a(TIME_STUNNED, (Object)0);
        this.field_70180_af.func_187214_a(TICKS_UNTIL_NEXT_SCREECH, (Object)0);
    }

    @Override
    public void func_70071_h_() {
        super.func_70071_h_();
        if (this.deathTicks > 0 || this.func_175446_cd()) {
            return;
        }
        if (this.clientScreechTime > 0) {
            --this.clientScreechTime;
        }
        if (!this.field_70170_p.field_72995_K) {
            if (this.getPlayersInDungeonArea().isEmpty() && !this.getSpidersInDungeonArea(20.0).isEmpty()) {
                this.getSpidersInDungeonArea(20.0).forEach(spider -> {
                    spider.func_70106_y();
                    spider.func_70656_aK();
                });
            }
            this.setBesideClimbableBlock(this.field_70123_F);
            if (!this.isStunned()) {
                if (this.getSpidersInDungeonArea(15.0).isEmpty() && this.getTicksUntilNextScreech() > 0) {
                    this.setTicksUntilNextScreech(this.getTicksUntilNextScreech() - 1);
                }
                if (!this.func_184188_bt().isEmpty() && this.func_184188_bt().get(0) instanceof LivingEntity) {
                    double yLook;
                    if (this.holdingTime > 0) {
                        --this.holdingTime;
                    }
                    if (this.holdingTime <= 70 && !this.isCeilingLocked() && this.getDifficultyID() >= ISkyBoss.Level.PLATINUM.getId()) {
                        if (this.func_70092_e(this.getHome().func_177958_n(), this.getHome().func_177956_o(), this.getHome().func_177952_p()) > 60.0) {
                            this.func_70605_aq().func_75642_a((double)this.getHome().func_177958_n(), (double)this.getHome().func_177956_o(), (double)this.getHome().func_177952_p(), 1.0);
                        } else {
                            this.slingToCeiling();
                        }
                    }
                    if (this.isCharging()) {
                        this.setCharging(false);
                    }
                    LivingEntity rider = (LivingEntity)this.func_184188_bt().get(0);
                    rider.func_195064_c(new EffectInstance(Effects.field_76436_u, 60, 1));
                    this.field_70177_z = this.field_70759_as;
                    double d = yLook = this.isCeilingLocked() ? this.func_226278_cu_() + (double)this.func_70047_e() : (double)this.getHome().func_177956_o();
                    if (this.func_70092_e(this.getHome().func_177958_n(), this.getHome().func_177956_o(), this.getHome().func_177952_p()) > 20.0) {
                        this.func_200602_a(EntityAnchorArgument.Type.EYES, new Vector3d((double)this.getHome().func_177958_n(), yLook, (double)this.getHome().func_177952_p()));
                    }
                }
                if (!this.isCeilingLocked()) {
                    BlockPos pos = this.func_233580_cy_();
                    if (!this.field_70170_p.func_175623_d(pos.func_177981_b(2)) && this.isBesideClimbableBlock() && this.func_70638_az() == null) {
                        this.setCeilingLocked(true);
                    }
                    if (this.func_70638_az() != null) {
                        boolean canSling;
                        boolean bl = canSling = !this.field_70170_p.func_226660_f_(this.func_233580_cy_()) && this.field_70170_p.func_226658_a_(LightType.SKY, this.func_233580_cy_()) < 5 && this.getInvulTime() <= 0;
                        if (this.getTimeSinceLocked() < 260 && canSling && this.func_184188_bt().isEmpty()) {
                            this.setTimeSinceLocked(this.getTimeSinceLocked() + 1);
                        }
                        if (this.getTimeSinceLocked() >= 240 && canSling) {
                            if (this.func_70092_e(this.getHome().func_177958_n(), this.getHome().func_177956_o(), this.getHome().func_177952_p()) > 60.0) {
                                this.func_70605_aq().func_75642_a((double)this.getHome().func_177958_n(), (double)this.getHome().func_177956_o(), (double)this.getHome().func_177952_p(), 1.0);
                            } else {
                                this.slingToCeiling();
                            }
                        }
                    }
                    if (this.isCharging() && this.func_70092_e(this.getHome().func_177958_n(), this.getHome().func_177956_o(), this.getHome().func_177952_p()) > 60.0) {
                        this.func_70605_aq().func_75642_a((double)this.getHome().func_177958_n(), (double)this.getHome().func_177956_o(), (double)this.getHome().func_177952_p(), 1.0);
                    }
                } else if (this.getTimeOnCeiling() > 0) {
                    boolean canScreech;
                    boolean bl = canScreech = this.getTicksUntilNextScreech() <= 0 && this.getTimeOnCeiling() > 600;
                    if (!this.isSecondPhase() || this.isSecondPhase() && this.getSpidersInDungeonArea(15.0).isEmpty() && !canScreech && this.func_184188_bt().isEmpty()) {
                        this.setTimeOnCeiling(this.getTimeOnCeiling() - 1);
                    }
                    PlayerEntity closestPlayer = this.field_70170_p.func_217362_a((Entity)this, 30.0);
                    if (!this.getSpidersInDungeonArea(15.0).isEmpty() && closestPlayer != null) {
                        this.func_70671_ap().func_75651_a((Entity)closestPlayer, 30.0f, 30.0f);
                    }
                    if (this.field_70173_aa % 8 == 0 && this.field_191988_bg != 0.0f) {
                        this.func_180429_a(this.func_233580_cy_(), SkiesBlocks.poison_stonebrick.func_176223_P());
                    }
                    if (!this.func_189652_ae()) {
                        this.func_189654_d(true);
                    }
                    if (this.func_70092_e(this.getHome().func_177958_n(), this.func_226278_cu_(), this.getHome().func_177952_p()) >= 2.0 && this.func_184188_bt().isEmpty()) {
                        this.func_70605_aq().func_75642_a((double)this.getHome().func_177958_n(), this.func_226278_cu_(), (double)this.getHome().func_177952_p(), 2.0);
                    }
                } else {
                    this.setCeilingLocked(false);
                }
            } else {
                if (!this.func_184188_bt().isEmpty()) {
                    ((Entity)this.func_184188_bt().get(0)).func_184210_p();
                }
                if (this.getStunTime() > 0) {
                    this.setStunTime(this.getStunTime() - 1);
                } else {
                    this.setStunned(false);
                }
            }
            if ((this.func_70638_az() == null || this.isCeilingLocked()) && this.isCharging()) {
                this.setCharging(false);
            }
            if (this.getTimeOnCeiling() == 320 && this.field_70146_Z.nextBoolean()) {
                this.setTimeOnCeiling(0);
            }
            if (this.func_184207_aI()) {
                ((Entity)this.func_184188_bt().get(0)).func_226284_e_(false);
            }
        } else {
            int t;
            if (this.isCharging()) {
                for (t = 0; t < 4; ++t) {
                    this.spawnParticles((IParticleData)ParticleTypes.field_197594_E);
                    int i = MathHelper.func_76128_c((double)this.func_226277_ct_());
                    int j = MathHelper.func_76128_c((double)(this.func_226278_cu_() - (double)0.2f));
                    int k = MathHelper.func_76128_c((double)this.func_226281_cx_());
                    BlockPos blockPos = new BlockPos(i, j, k);
                    BlockState blockstate = this.field_70170_p.func_180495_p(blockPos);
                    if (this.field_70170_p.func_175623_d(blockPos)) continue;
                    this.field_70170_p.func_195594_a((IParticleData)new BlockParticleData(ParticleTypes.field_197611_d, blockstate).setPos(new BlockPos(i, j, k)), this.func_226277_ct_() + ((double)this.field_70146_Z.nextFloat() - 0.5) * (double)this.func_213311_cf(), this.func_174813_aQ().field_72338_b + 0.1, this.func_226281_cx_() + ((double)this.field_70146_Z.nextFloat() - 0.5) * (double)this.func_213311_cf(), 4.0 * ((double)this.field_70146_Z.nextFloat() - 0.5), 0.5, ((double)this.field_70146_Z.nextFloat() - 0.5) * 4.0);
                }
            }
            if (this.isStunned()) {
                for (t = 0; t < 4; ++t) {
                    this.spawnParticles((IParticleData)ParticleTypes.field_197608_a);
                }
            }
            if (this.isCeilingLocked()) {
                for (PlayerEntity players : this.getPlayersInDungeonArea(25.0, false)) {
                    if (players == null || this.field_70173_aa % 10 != 0 || !this.field_70170_p.func_201670_d()) {
                        return;
                    }
                    PacketHandler.sendToServer(new GetClientMotionPacket(players.func_213322_ci().func_82615_a(), players.func_213322_ci().func_82616_c()));
                }
            }
        }
    }

    @Override
    public void invulnerableTick() {
        super.invulnerableTick();
        if (this.field_70170_p.field_72995_K) {
            for (int t = 0; t < 4; ++t) {
                this.spawnParticles(new PoisonData(false));
                this.spawnParticles((IParticleData)ParticleTypes.field_197608_a);
            }
        }
    }

    @Override
    public void func_70020_e(CompoundNBT compound) {
        super.func_70020_e(compound);
        this.setCeilingLocked(compound.func_74767_n("CelingLocked"));
        this.setCharging(compound.func_74767_n("Charging"));
        this.setStunned(compound.func_74767_n("Stunned"));
        this.setTimeOnCeiling(compound.func_74762_e("TimeOnCeiling"));
        this.setTimeSinceLocked(compound.func_74762_e("TimeSinceCeilingLocked"));
        this.setStunTime(compound.func_74762_e("TimeStunned"));
        this.setTicksUntilNextScreech(compound.func_74762_e("TicksUntilNextScreech"));
    }

    @Override
    public void func_213281_b(CompoundNBT compound) {
        super.func_213281_b(compound);
        compound.func_74757_a("CelingLocked", this.isCeilingLocked());
        compound.func_74757_a("Charging", this.isCharging());
        compound.func_74757_a("Stunned", this.isStunned());
        compound.func_74768_a("TimeOnCeiling", this.getTimeOnCeiling());
        compound.func_74768_a("TimeSinceCeilingLocked", this.getTimeSinceLocked());
        compound.func_74768_a("TimeStunned", this.getStunTime());
        compound.func_74768_a("TicksUntilNextScreech", this.getTicksUntilNextScreech());
    }

    public boolean func_70652_k(Entity entityIn) {
        if (this.func_184191_r(entityIn)) {
            return false;
        }
        if (entityIn instanceof PlayerEntity) {
            ItemStack playerItem;
            PlayerEntity player = (PlayerEntity)entityIn;
            ItemStack itemStack = playerItem = player.func_184587_cr() ? player.func_184607_cu() : ItemStack.field_190927_a;
            if (!playerItem.func_190926_b() && !this.field_70170_p.field_72995_K) {
                if (SHIELDS.contains(playerItem.func_77973_b())) {
                    this.field_70170_p.func_72960_a((Entity)this, (byte)4);
                    this.setStunned(true);
                    this.field_70170_p.func_72960_a((Entity)player, (byte)29);
                    this.field_70170_p.func_72960_a((Entity)player, (byte)30);
                    player.func_190777_m(true);
                    SHIELDS.forEach(item -> player.func_184811_cZ().func_185145_a(item.getItem(), 300));
                    if (player.func_184600_cs() != null) {
                        playerItem.func_222118_a(1, (LivingEntity)player, e -> e.func_213334_d(player.func_184600_cs()));
                    }
                    return false;
                }
                if (playerItem.isShield((LivingEntity)player)) {
                    player.func_146105_b((ITextComponent)new TranslationTextComponent("gui.blue_skies.tooltip.arachnarch_incorrect_shield"), true);
                    player.func_190777_m(true);
                    this.field_70170_p.func_72960_a((Entity)player, (byte)30);
                    player.func_184811_cZ().func_185145_a(playerItem.func_77973_b(), 800);
                    return super.func_70652_k(entityIn);
                }
            }
        }
        return super.func_70652_k(entityIn);
    }

    @Override
    public boolean func_70097_a(DamageSource source, float amount) {
        if (!this.func_184188_bt().isEmpty()) {
            this.damageSinceGrabbed += amount;
        }
        if (source.func_180136_u()) {
            return super.func_70097_a(source, amount);
        }
        if (this.isCeilingLocked() && this.func_184188_bt().isEmpty()) {
            return super.func_70097_a(source, Math.min(1.0f, amount));
        }
        return super.func_70097_a(source, amount);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_70103_a(byte id) {
        switch (id) {
            case 4: {
                this.setStunned(true);
                break;
            }
            case 5: {
                this.spawnParticles((IParticleData)ParticleTypes.field_197598_I);
                break;
            }
            case 6: {
                this.clientScreechTime = 50;
                break;
            }
            default: {
                super.func_70103_a(id);
            }
        }
    }

    public void func_184232_k(Entity passenger) {
        if (this.func_184196_w(passenger)) {
            Vector3d vec3d = this.func_70676_i(1.0f);
            passenger.func_70107_b(this.func_226277_ct_() + vec3d.field_72450_a * 3.0, this.func_226278_cu_() + passenger.func_70033_W() + (double)(this.isCeilingLocked() ? -MathHelper.func_76134_b((float)((float)this.field_70173_aa * 0.1f)) : MathHelper.func_76134_b((float)((float)this.field_70173_aa * 0.1f))) * 0.05 + (this.isCeilingLocked() ? (double)-1.2f : 1.4), this.func_226281_cx_() + vec3d.field_72449_c * 3.0);
            if (this.isStunned() || this.holdingTime <= 0 || !this.field_70170_p.field_72995_K && this.damageSinceGrabbed > 15.0f || !this.func_70089_S()) {
                this.damageSinceGrabbed = 0.0f;
                passenger.func_184210_p();
                this.func_184185_a(SkiesSounds.ENTITY_ARACHNARCH_THROW, this.func_70599_aP(), 2.0f);
                passenger.field_70133_I = true;
                passenger.func_213293_j(vec3d.func_82615_a() * 1.0, 0.5, vec3d.func_82616_c() * 1.0);
            }
            if (this.damageSinceGrabbed > 15.0f) {
                passenger.func_213293_j(vec3d.func_82615_a() * 1.0, 0.5, vec3d.func_82616_c() * 1.0);
                if (passenger instanceof PlayerEntity) {
                    ((PlayerEntity)passenger).field_70133_I = true;
                }
            }
        }
    }

    public void func_233627_a_(float strength, double x, double z) {
    }

    public void func_70024_g(double x, double y, double z) {
    }

    public boolean func_70687_e(EffectInstance potioneffectIn) {
        return IMMUNE_EFFECTS.contains(potioneffectIn.func_188419_a()) ? false : super.func_70687_e(potioneffectIn);
    }

    protected float func_213348_b(Pose poseIn, EntitySize sizeIn) {
        return 0.8f;
    }

    public boolean canRiderInteract() {
        return true;
    }

    public boolean shouldRiderSit() {
        return false;
    }

    @Override
    public BossInfo.Color getBossBarColor() {
        return BossInfo.Color.PINK;
    }

    @Override
    public SkiesDungeonType getBossType() {
        return SkiesDungeonType.POISON;
    }

    @Override
    public int getProgression() {
        return 2;
    }

    @Override
    public boolean isEverbrightBoss() {
        return false;
    }

    public boolean isCeilingLocked() {
        return (Boolean)this.field_70180_af.func_187225_a(CEILING_LOCKED);
    }

    public void setCeilingLocked(boolean locked) {
        this.field_70180_af.func_187227_b(CEILING_LOCKED, (Object)locked);
        this.func_70661_as().func_75499_g();
        if (locked) {
            this.setTimeOnCeiling(this.getTicksUntilNextScreech() == 0 && this.isSecondPhase() ? 610 : (this.field_70146_Z.nextInt(5) == 0 ? 300 : 600));
        } else {
            this.func_184185_a(SkiesSounds.ENTITY_ARACHNARCH_FLIP, this.func_70599_aP(), this.func_70647_i());
            this.func_189654_d(false);
            this.setTimeSinceLocked(0);
        }
    }

    public int getTimeOnCeiling() {
        return (Integer)this.field_70180_af.func_187225_a(TIME_ON_CEILING);
    }

    public void setTimeOnCeiling(int time) {
        this.field_70180_af.func_187227_b(TIME_ON_CEILING, (Object)time);
    }

    public int getTimeSinceLocked() {
        return (Integer)this.field_70180_af.func_187225_a(TIME_SINCE_LOCKED);
    }

    public void setTimeSinceLocked(int time) {
        this.field_70180_af.func_187227_b(TIME_SINCE_LOCKED, (Object)time);
    }

    public int getStunTime() {
        return (Integer)this.field_70180_af.func_187225_a(TIME_STUNNED);
    }

    public void setStunTime(int time) {
        this.field_70180_af.func_187227_b(TIME_STUNNED, (Object)time);
    }

    public int getTicksUntilNextScreech() {
        return (Integer)this.field_70180_af.func_187225_a(TICKS_UNTIL_NEXT_SCREECH);
    }

    public void setTicksUntilNextScreech(int time) {
        this.field_70180_af.func_187227_b(TICKS_UNTIL_NEXT_SCREECH, (Object)time);
    }

    @Override
    public boolean isStunned() {
        return (Boolean)this.field_70180_af.func_187225_a(STUNNED);
    }

    public void setStunned(boolean stunned) {
        this.field_70180_af.func_187227_b(STUNNED, (Object)stunned);
        if (stunned) {
            if (this.field_70170_p.field_72995_K) {
                this.playStunSound();
                return;
            }
            this.setStunTime(Math.max(20, 60 - this.getExtraPlayers() * 10));
        } else {
            this.setStunTime(0);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    private void playStunSound() {
        if (!this.func_174814_R() && this.field_70170_p.field_72995_K) {
            SoundHandler soundHandler = Minecraft.func_71410_x().func_147118_V();
            if (this.stunSound == null || !soundHandler.func_215294_c(this.stunSound)) {
                this.stunSound = new StunnedEntitySound((LivingEntity)this, SkiesSounds.ENTITY_ARACHNARCH_STUNNED, this.func_70599_aP());
                soundHandler.func_147682_a(this.stunSound);
            }
        }
    }

    public boolean isCharging() {
        return (Boolean)this.field_70180_af.func_187225_a(CHARGING);
    }

    public void setCharging(boolean charge) {
        this.field_70180_af.func_187227_b(CHARGING, (Object)charge);
    }

    public void setHolding(LivingEntity entity) {
        this.holdingTime = 100;
        if (!this.field_70170_p.field_72995_K) {
            entity.func_184220_m((Entity)this);
            this.damageSinceGrabbed = 0.0f;
        }
    }

    public CreatureAttribute func_70668_bt() {
        return CreatureAttribute.field_223224_c_;
    }

    protected SoundEvent func_184639_G() {
        return this.isStunned() ? null : SkiesSounds.ENTITY_ARACHNARCH_IDLE;
    }

    protected SoundEvent func_184601_bQ(DamageSource damageSourceIn) {
        return SkiesSounds.ENTITY_ARACHNARCH_HURT;
    }

    protected SoundEvent func_184615_bR() {
        this.func_184185_a(SkiesSounds.ENTITY_ARACHNARCH_DEATH, this.func_70599_aP(), 1.0f);
        return super.func_184615_bR();
    }

    protected void func_180429_a(BlockPos pos, BlockState blockIn) {
        this.func_184185_a(SoundEvents.field_187823_fN, 0.15f, 0.5f);
    }

    protected float func_70647_i() {
        return super.func_70647_i();
    }

    @Override
    protected float func_70599_aP() {
        return 2.0f;
    }

    public boolean func_70617_f_() {
        return this.isBesideClimbableBlock();
    }

    public boolean isBesideClimbableBlock() {
        return ((Byte)this.field_70180_af.func_187225_a(CLIMBING) & 1) != 0;
    }

    public void setBesideClimbableBlock(boolean climbing) {
        byte b0 = (Byte)this.field_70180_af.func_187225_a(CLIMBING);
        b0 = climbing ? (byte)(b0 | 1) : (byte)(b0 & 0xFFFFFFFE);
        this.field_70180_af.func_187227_b(CLIMBING, (Object)b0);
    }

    public void func_213295_a(BlockState state, Vector3d motionVec) {
        if (state.func_177230_c() != Blocks.field_196553_aF && state.func_177230_c() != SkiesBlocks.spider_webbing) {
            super.func_213295_a(state, motionVec);
        }
    }

    public boolean func_225503_b_(float distance, float damageMultiplier) {
        return false;
    }

    public void func_82196_d(LivingEntity target, float distanceFactor) {
        if (!(target instanceof PlayerEntity)) {
            this.spit(target);
        }
        for (PlayerEntity players : this.getPlayersInDungeonArea()) {
            this.spit((LivingEntity)players);
        }
    }

    private void spit(LivingEntity target) {
        this.field_70177_z = this.field_70759_as;
        if (this.getDifficultyID() == ISkyBoss.Level.PLATINUM.getId() && this.isSecondPhase() && this.func_70092_e(this.getHome().func_177958_n(), this.func_226278_cu_(), this.getHome().func_177952_p()) > 2.0) {
            VenomSpitEntity venomSpit = new VenomSpitEntity(this.field_70170_p, (LivingEntity)this);
            double d0 = target.func_226277_ct_() - this.func_226277_ct_();
            double d1 = target.func_174813_aQ().field_72338_b + (double)(target.func_213302_cg() / 3.0f) - venomSpit.func_226278_cu_();
            double d2 = target.func_226281_cx_() - this.func_226281_cx_();
            float f = MathHelper.func_76133_a((double)(d0 * d0 + d2 * d2)) * 0.2f;
            venomSpit.func_70186_c(d0, d1 + (double)f, d2, 1.5f, 0.0f);
            this.field_70170_p.func_217376_c((Entity)venomSpit);
            this.func_184185_a(SkiesSounds.ENTITY_ARACHNARCH_SPIT, this.func_70599_aP(), 1.0f + (this.field_70146_Z.nextFloat() - this.field_70146_Z.nextFloat()) * 0.2f);
        } else if (this.func_70032_d((Entity)target) > 8.0f) {
            BlockPos targetPos = target.func_233580_cy_();
            BlockPos predictedPosition = targetPos.func_177963_a(0.5, 0.0, 0.5);
            if (target instanceof PlayerEntity && this.getDifficultyID() != ISkyBoss.Level.BRONZE.getId()) {
                float extraSpacing = 20.0f;
                predictedPosition = SkiesPlayer.getIfPresent((PlayerEntity)target, skyPlayer -> {
                    if (skyPlayer.getSavedClientMotion() != null) {
                        return targetPos.func_177963_a((double)extraSpacing * skyPlayer.getSavedClientMotion().func_82615_a(), 0.0, (double)extraSpacing * skyPlayer.getSavedClientMotion().func_82616_c());
                    }
                    return targetPos.func_177963_a(0.5, 0.0, 0.5);
                });
            }
            VenomSpitEntity venomSpit = new VenomSpitEntity(this.field_70170_p, (LivingEntity)this);
            double d0 = (double)((float)predictedPosition.func_177958_n() + 0.5f) - this.func_226277_ct_();
            double d1 = target.func_174813_aQ().field_72338_b + (double)(target.func_70047_e() / 3.0f) - venomSpit.func_226278_cu_();
            double d2 = (double)((float)predictedPosition.func_177952_p() + 0.5f) - this.func_226281_cx_();
            float f = MathHelper.func_76133_a((double)(d0 * d0 + d2 * d2)) * ((double)this.func_70032_d((Entity)target) < 9.0 ? 0.0f : this.func_70032_d((Entity)target) * 0.01f);
            venomSpit.func_70186_c(d0, d1 + (double)f, d2, 1.5f, 0.0f);
            venomSpit.setDeadly(true);
            this.field_70170_p.func_217376_c((Entity)venomSpit);
            this.func_184185_a(SkiesSounds.ENTITY_ARACHNARCH_SPIT, this.func_70599_aP(), 1.0f + (this.field_70146_Z.nextFloat() - this.field_70146_Z.nextFloat()) * 0.2f);
        } else {
            VenomBombEntity venomBomb = new VenomBombEntity(this.field_70170_p, (LivingEntity)this);
            venomBomb.effect = new EffectInstance(SkiesEffects.DEADLY_VENOM, 100, (int)this.getDifficultyID());
            venomBomb.field_70125_A -= -20.0f;
            venomBomb.func_70107_b(this.func_226277_ct_(), this.func_226278_cu_() - 1.0, this.func_226281_cx_());
            Vector3d look = this.func_70676_i(1.0f);
            venomBomb.func_70186_c(look.func_82615_a() * (double)0.1f, 0.0, look.func_82616_c() * (double)0.1f, 0.15f, 10.0f);
            this.field_70170_p.func_217376_c((Entity)venomBomb);
            this.func_184185_a(SkiesSounds.ENTITY_ARACHNARCH_VENOM_DROP, this.func_70599_aP(), 1.0f);
        }
    }

    public List<NestedSpiderEntity> getSpidersInDungeonArea(double distance) {
        if (this.getHome() != null && this.getHome() != BlockPos.field_177992_a) {
            return this.field_70170_p.func_217357_a(NestedSpiderEntity.class, new AxisAlignedBB((double)this.getHome().func_177958_n() - distance, (double)this.getHome().func_177956_o() - 1.0, (double)this.getHome().func_177952_p() - distance, (double)this.getHome().func_177958_n() + distance, (double)this.getHome().func_177956_o() + 10.0, (double)this.getHome().func_177952_p() + distance));
        }
        return ImmutableList.of();
    }

    public void slingToCeiling() {
        this.setCeilingLocked(true);
        this.func_213293_j(0.0, 3.0, 0.0);
        this.func_184185_a(SkiesSounds.ENTITY_ARACHNARCH_SLING, this.func_70599_aP(), this.func_70647_i());
    }

    protected void func_70609_aI() {
        boolean flag = this.field_70170_p.func_82736_K().func_223586_b(GameRules.field_223602_e);
        if (this.isCeilingLocked()) {
            this.setCeilingLocked(false);
        }
        ++this.deathTicks;
        if (this.deathTicks < 20) {
            super.func_70609_aI();
        }
        this.field_70761_aq += 0.0f;
        this.field_70759_as += 0.0f;
        this.field_70125_A += 0.0f;
        float money = 40.0f;
        if (this.deathTicks > 30 && this.deathTicks % 5 == 0 && flag) {
            this.dropExperience(MathHelper.func_76141_d((float)(money * 0.08f)));
        }
        if (this.deathTicks >= 100 && !this.field_70170_p.field_72995_K && !this.field_70170_p.field_72995_K) {
            if (this.deathTicks >= 120) {
                this.func_70106_y();
            }
            if (this.deathTicks % 2 == 0) {
                for (int i = 0; i < 20; ++i) {
                    this.field_70170_p.func_72960_a((Entity)this, (byte)5);
                }
            }
        }
        if (this.isCharging()) {
            this.setCharging(false);
        }
    }

    private void dropExperience(int amount) {
        while (amount > 0) {
            int i = ExperienceOrbEntity.func_70527_a((int)amount);
            amount -= i;
            this.field_70170_p.func_217376_c((Entity)new ExperienceOrbEntity(this.field_70170_p, this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_(), i));
        }
    }

    public void func_174812_G() {
        this.func_70106_y();
    }

    public boolean func_184191_r(Entity entityIn) {
        if (entityIn.func_200600_R().func_220341_a(SkiesEntityTags.POISON_ALLIES)) {
            return this.func_96124_cp() == null && entityIn.func_96124_cp() == null;
        }
        return super.func_184191_r(entityIn) && entityIn != null && entityIn != this;
    }

    class ScreechAttackGoal
    extends Goal {
        private final ArachnarchEntity boss;
        private int screechTime;

        public ScreechAttackGoal() {
            this.boss = ArachnarchEntity.this;
        }

        public boolean func_75250_a() {
            boolean closeToHome = this.boss.func_70092_e(this.boss.getHome().func_177958_n(), this.boss.func_226278_cu_(), this.boss.getHome().func_177952_p()) <= 2.0;
            return this.boss.isCeilingLocked() && this.boss.func_70638_az() != null && !this.boss.isStunned() && this.boss.getInvulTime() == 0 && this.boss.func_184188_bt().isEmpty() && this.boss.isSecondPhase() && this.boss.getTicksUntilNextScreech() <= 0 && this.boss.getTimeOnCeiling() > 600 && closeToHome;
        }

        public boolean func_75253_b() {
            return this.boss.isCeilingLocked() && this.boss.func_70638_az() != null && this.screechTime > 0 && !this.boss.isStunned() && this.boss.func_184188_bt().isEmpty();
        }

        public void func_75249_e() {
            this.screechTime = 80;
        }

        public void func_75246_d() {
            this.boss.func_70671_ap().func_75651_a((Entity)this.boss.func_70638_az(), 30.0f, 30.0f);
            if (this.screechTime > 0) {
                --this.screechTime;
            }
            if (this.screechTime == 75) {
                this.boss.field_70170_p.func_72960_a((Entity)this.boss, (byte)6);
                this.boss.func_184185_a(SkiesSounds.ENTITY_ARACHNARCH_SCREECH, this.boss.func_70599_aP(), this.boss.func_70647_i());
            }
            if (this.screechTime == 79 && !this.boss.field_70170_p.field_72995_K) {
                for (PlayerEntity players : this.boss.getPlayersInDungeonArea()) {
                    players.func_195064_c(new EffectInstance(Effects.field_76431_k, 120, 0, true, false));
                }
            }
            if (this.screechTime == 20) {
                BlockPos homePos = this.boss.getHome();
                int radius = 15;
                if (this.boss.field_70170_p instanceof ServerWorld) {
                    ServerWorld world = (ServerWorld)this.boss.field_70170_p;
                    PointOfInterestManager pointofinterestmanager = world.func_217443_B();
                    pointofinterestmanager.func_226347_a_((IWorldReader)this.boss.field_70170_p, homePos, radius);
                    Stream optional = world.func_217443_B().func_226353_b_(poiType -> poiType == SkiesPointsOfInterest.SPIDER_NEST, homePos, radius, PointOfInterestManager.Status.ANY);
                    optional.forEach(poi -> {
                        BlockPos pos = poi.func_218261_f();
                        BlockState funny = this.boss.field_70170_p.func_180495_p(pos);
                        if (funny.func_177230_c() instanceof SpiderNestBlock && this.boss.field_70170_p.field_73012_v.nextFloat() < 0.7f) {
                            SpiderNestBlock.spawnSpiders(funny, this.boss.field_70170_p, pos, SkiesEntityTypes.NESTED_SPIDER);
                        }
                    });
                }
            }
            if (this.screechTime <= 1) {
                this.boss.setTicksUntilNextScreech(1200);
            }
        }
    }

    class WalkAndDropGoal
    extends Goal {
        private final ArachnarchEntity boss;
        private int walkTime;

        public WalkAndDropGoal() {
            this.boss = ArachnarchEntity.this;
        }

        public boolean func_75250_a() {
            if (!this.boss.func_184188_bt().isEmpty()) {
                return false;
            }
            return this.boss.isCeilingLocked() && this.boss.func_70638_az() != null && this.boss.getTimeOnCeiling() < 300;
        }

        public boolean func_75253_b() {
            if (!this.boss.func_184188_bt().isEmpty()) {
                return false;
            }
            return this.boss.isCeilingLocked() && this.boss.func_70638_az() != null && this.walkTime > 0;
        }

        public void func_75249_e() {
            this.walkTime = 300;
        }

        public void func_75246_d() {
            World world = this.boss.field_70170_p;
            this.boss.func_70671_ap().func_75651_a((Entity)this.boss.func_70638_az(), 30.0f, 30.0f);
            if (this.walkTime > 0) {
                --this.walkTime;
                if (this.boss.func_70032_d((Entity)this.boss.func_70638_az()) >= 2.0f) {
                    this.boss.func_70605_aq().func_75642_a(this.boss.func_70638_az().func_226277_ct_(), this.boss.func_226278_cu_(), this.boss.func_70638_az().func_226281_cx_(), 15.0);
                }
                if (this.boss.field_70173_aa % 10 == 0) {
                    Vector3d look = this.boss.func_70676_i(1.0f);
                    VenomBombEntity venomBomb = new VenomBombEntity(world, (LivingEntity)this.boss);
                    venomBomb.effect = new EffectInstance(SkiesEffects.DEADLY_VENOM, 50, (int)this.boss.getDifficultyID());
                    venomBomb.field_70125_A -= -20.0f;
                    venomBomb.func_70107_b(this.boss.func_226277_ct_() - look.func_82615_a() * 1.0, this.boss.func_226278_cu_() - 1.0, this.boss.func_226281_cx_() - look.func_82616_c() * 1.0);
                    venomBomb.func_70186_c(look.func_82615_a() * (double)0.1f, 0.0, look.func_82616_c() * (double)0.1f, 0.15f, 10.0f);
                    venomBomb.lingering = true;
                    world.func_217376_c((Entity)venomBomb);
                    this.boss.func_184185_a(SkiesSounds.ENTITY_ARACHNARCH_VENOM_DROP, 1.0f, 1.0f);
                }
            }
        }
    }

    class LungeAtTargetGoal
    extends Goal {
        private final ArachnarchEntity boss;
        private int chargeTime;

        public LungeAtTargetGoal() {
            this.boss = ArachnarchEntity.this;
        }

        public boolean func_75250_a() {
            if (this.boss.func_70638_az() == null) {
                return false;
            }
            return !this.boss.isCeilingLocked() && !this.boss.isStunned() && this.boss.getInvulTime() <= 0 && this.boss.func_184188_bt().isEmpty() && this.boss.getTimeSinceLocked() <= this.getTimeNeededForLunge();
        }

        public boolean func_75253_b() {
            return !this.boss.isCeilingLocked() && this.boss.func_70638_az() != null && this.chargeTime > 0 && !this.boss.isStunned() && this.boss.func_184188_bt().isEmpty();
        }

        public void func_75249_e() {
            List playersInDungeon = this.boss.getPlayersInDungeonArea();
            for (PlayerEntity players : playersInDungeon) {
                if (players == this.boss.func_70638_az() || !this.boss.field_70146_Z.nextBoolean() || playersInDungeon.size() <= 1) continue;
                this.boss.func_70624_b((LivingEntity)players);
            }
            this.chargeTime = 80;
            this.boss.setCharging(true);
            this.boss.func_184185_a(SkiesSounds.ENTITY_ARACHNARCH_CHARGE, this.boss.func_70599_aP(), this.boss.func_70647_i());
        }

        public void func_75246_d() {
            World world = this.boss.field_70170_p;
            this.boss.func_70671_ap().func_75651_a((Entity)this.boss.func_70638_az(), 30.0f, 30.0f);
            if (this.chargeTime > 0) {
                --this.chargeTime;
            }
            if (this.chargeTime == 20) {
                this.boss.setCharging(false);
                Vector3d vec3d = this.boss.func_213322_ci();
                Vector3d vec3d1 = new Vector3d(this.boss.func_70638_az().func_226277_ct_() - this.boss.func_226277_ct_(), 0.0, this.boss.func_70638_az().func_226281_cx_() - this.boss.func_226281_cx_());
                if (vec3d1.func_189985_c() > 1.0E-7) {
                    vec3d1 = vec3d1.func_72432_b().func_186678_a(3.0).func_178787_e(vec3d.func_186678_a(3.0));
                }
                this.boss.func_213293_j(vec3d1.field_72450_a, 0.4, vec3d1.field_72449_c);
                this.boss.func_184185_a(SkiesSounds.ENTITY_ARACHNARCH_LUNGE, this.boss.func_70599_aP(), this.boss.func_70647_i());
            }
            List list = world.func_72839_b((Entity)this.boss, this.boss.func_174813_aQ().func_186662_g(this.chargeTime <= 5 ? 0.5 : 0.0));
            for (Entity entity : list) {
                LivingEntity living;
                boolean attack;
                if (!(entity instanceof LivingEntity) || ((LivingEntity)entity).field_70737_aN > 0 || !(attack = this.boss.func_70652_k((Entity)(living = (LivingEntity)entity))) || !this.boss.func_184188_bt().isEmpty() || !this.boss.isCharging() && !(this.boss.func_110143_aJ() <= this.boss.func_110138_aP() / 2.0f)) continue;
                this.boss.func_184185_a(SkiesSounds.ENTITY_ARACHNARCH_ATTACK, this.boss.func_70599_aP(), this.boss.func_70647_i());
                if (living.func_110148_a(Attributes.field_233820_c_).func_111126_e() < 1.0) {
                    this.boss.setHolding(living);
                }
                return;
            }
        }

        private int getTimeNeededForLunge() {
            return 180;
        }
    }

    class VenomWalkingAttackGoal
    extends RangedAttackGoal {
        private final ArachnarchEntity boss;
        private boolean nestedSpidersDead;

        public VenomWalkingAttackGoal(IRangedAttackMob attacker, double movespeed, int maxAttackTime, float maxAttackDistanceIn) {
            super(attacker, movespeed, maxAttackTime, maxAttackTime, maxAttackDistanceIn);
            this.boss = ArachnarchEntity.this;
            this.nestedSpidersDead = this.boss.getSpidersInDungeonArea(15.0).isEmpty();
        }

        public boolean func_75250_a() {
            if (!(this.nestedSpidersDead && super.func_75250_a() && this.boss.func_184188_bt().isEmpty())) {
                return false;
            }
            return this.boss.getDifficultyID() == ISkyBoss.Level.PLATINUM.getId() && this.boss.isCeilingLocked() && this.boss.getTimeOnCeiling() <= 300 && this.boss.isSecondPhase();
        }

        public boolean func_75253_b() {
            if (!(this.nestedSpidersDead && super.func_75253_b() && this.boss.func_184188_bt().isEmpty())) {
                return false;
            }
            return this.boss.getDifficultyID() == ISkyBoss.Level.PLATINUM.getId() && this.boss.isCeilingLocked() && this.boss.getTimeOnCeiling() <= 300 && this.boss.isSecondPhase();
        }
    }

    class VenomAttackGoal
    extends RangedAttackGoal {
        private final ArachnarchEntity boss;
        private boolean nestedSpidersDead;

        public VenomAttackGoal(IRangedAttackMob attacker, double movespeed, int maxAttackTime, float maxAttackDistanceIn) {
            super(attacker, movespeed, maxAttackTime, maxAttackTime, maxAttackDistanceIn);
            this.boss = ArachnarchEntity.this;
            this.nestedSpidersDead = this.boss.getSpidersInDungeonArea(15.0).isEmpty();
        }

        public boolean func_75250_a() {
            if (!this.nestedSpidersDead || !super.func_75250_a()) {
                return false;
            }
            return this.boss.isCeilingLocked() && this.boss.func_70092_e(this.boss.getHome().func_177958_n(), this.boss.func_226278_cu_(), this.boss.getHome().func_177952_p()) <= 2.0 && this.boss.getTimeOnCeiling() > 300 && this.boss.getTimeOnCeiling() <= 600;
        }

        public boolean func_75253_b() {
            if (!this.nestedSpidersDead || !super.func_75253_b()) {
                return false;
            }
            return this.boss.isCeilingLocked() && this.boss.func_70092_e(this.boss.getHome().func_177958_n(), this.boss.func_226278_cu_(), this.boss.getHome().func_177952_p()) <= 2.0 && this.boss.getTimeOnCeiling() > 300 && this.boss.getTimeOnCeiling() <= 600;
        }
    }
}

