/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.blue_skies.entities;

import com.legacy.blue_skies.registries.SkiesEntityTypes;
import java.util.Optional;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.IPacket;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.management.PreYggdrasilConverter;
import net.minecraft.world.World;
import net.minecraftforge.fml.network.FMLPlayMessages;
import net.minecraftforge.fml.network.NetworkHooks;

public class BossItemEntity
extends ItemEntity {
    protected static final DataParameter<Optional<UUID>> VISIBLE_PLAYER_UNIQUE_ID = EntityDataManager.func_187226_a(BossItemEntity.class, (IDataSerializer)DataSerializers.field_187203_m);

    public BossItemEntity(EntityType<? extends ItemEntity> type, World world) {
        super(type, world);
    }

    public BossItemEntity(World worldIn, double x, double y, double z) {
        this(SkiesEntityTypes.BOSS_ITEM, worldIn);
        this.func_70107_b(x, y, z);
        this.field_70177_z = this.field_70146_Z.nextFloat() * 360.0f;
        this.func_213293_j(this.field_70146_Z.nextDouble() * 0.2 - 0.1, 0.2, this.field_70146_Z.nextDouble() * 0.2 - 0.1);
        this.func_184224_h(true);
    }

    public BossItemEntity(World worldIn, double x, double y, double z, ItemStack stack) {
        this(worldIn, x, y, z);
        this.func_92058_a(stack);
        this.lifespan = stack.func_77973_b() == null ? 6000 : stack.getEntityLifespan(worldIn);
    }

    public BossItemEntity(FMLPlayMessages.SpawnEntity spawnEntity, World world) {
        this(SkiesEntityTypes.BOSS_ITEM, world);
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(VISIBLE_PLAYER_UNIQUE_ID, Optional.empty());
    }

    public void func_213281_b(CompoundNBT compound) {
        super.func_213281_b(compound);
        if (this.getVisiblePlayerId() != null) {
            compound.func_186854_a("VisiblePlayerID", this.getVisiblePlayerId());
        }
    }

    public void func_70037_a(CompoundNBT compound) {
        UUID uuid;
        super.func_70037_a(compound);
        if (compound.func_186855_b("VisiblePlayerID")) {
            uuid = compound.func_186857_a("VisiblePlayerID");
        } else {
            String s = compound.func_74779_i("VisiblePlayerID");
            uuid = PreYggdrasilConverter.func_187473_a((MinecraftServer)this.func_184102_h(), (String)s);
        }
        if (uuid != null) {
            this.setVisiblePlayerId(uuid);
        }
    }

    public UUID getVisiblePlayerId() {
        return ((Optional)this.field_70180_af.func_187225_a(VISIBLE_PLAYER_UNIQUE_ID)).orElse(null);
    }

    public void setVisiblePlayerId(@Nullable UUID ownerId) {
        this.field_70180_af.func_187227_b(VISIBLE_PLAYER_UNIQUE_ID, Optional.ofNullable(ownerId));
    }

    public IPacket<?> func_213297_N() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    public void func_70100_b_(PlayerEntity entityIn) {
        if (this.getVisiblePlayerId() != null && !this.getVisiblePlayerId().equals(entityIn.func_110124_au())) {
            return;
        }
        super.func_70100_b_(entityIn);
    }
}

