/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.blue_skies.data.providers;

import com.google.common.collect.ImmutableList;
import com.legacy.blue_skies.BlueSkies;
import com.legacy.blue_skies.blocks.construction.BagOfSpoilsBlock;
import com.legacy.blue_skies.blocks.misc.SkyWebbingBlock;
import com.legacy.blue_skies.blocks.misc.TrophyBlock;
import com.legacy.blue_skies.blocks.natural.BrewberryBushBlock;
import com.legacy.blue_skies.blocks.natural.LargeLilyPadBlock;
import com.legacy.blue_skies.blocks.natural.SkyCropBlock;
import com.legacy.blue_skies.blocks.natural.SkyDoubleCropBlock;
import com.legacy.blue_skies.data.BlueSkiesData;
import com.legacy.blue_skies.data.loot_functions.SetArcRarity;
import com.legacy.blue_skies.data.objects.SkiesItemTags;
import com.legacy.blue_skies.items.arcs.DuskArcItem;
import com.legacy.blue_skies.items.arcs.EtherealArcItem;
import com.legacy.blue_skies.items.arcs.NatureArcItem;
import com.legacy.blue_skies.items.arcs.PoisonArcItem;
import com.legacy.blue_skies.items.util.IRarityItem;
import com.legacy.blue_skies.registries.SkiesBlocks;
import com.legacy.blue_skies.registries.SkiesEntityTypes;
import com.legacy.blue_skies.registries.SkiesItems;
import com.legacy.blue_skies.world.general_features.structures.villages.SkiesVillageBiomes;
import com.legacy.blue_skies.world.general_features.structures.villages.SkiesVillageProfessions;
import com.mojang.datafixers.util.Pair;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.advancements.criterion.EnchantmentPredicate;
import net.minecraft.advancements.criterion.EntityPredicate;
import net.minecraft.advancements.criterion.ItemPredicate;
import net.minecraft.advancements.criterion.MinMaxBounds;
import net.minecraft.advancements.criterion.StatePropertiesPredicate;
import net.minecraft.block.Block;
import net.minecraft.block.Blocks;
import net.minecraft.block.ChestBlock;
import net.minecraft.block.DoorBlock;
import net.minecraft.block.DoublePlantBlock;
import net.minecraft.block.FlowerPotBlock;
import net.minecraft.block.SlabBlock;
import net.minecraft.block.VineBlock;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.LootTableProvider;
import net.minecraft.data.loot.BlockLootTables;
import net.minecraft.data.loot.EntityLootTables;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.Enchantments;
import net.minecraft.entity.EntityType;
import net.minecraft.item.DyeColor;
import net.minecraft.item.Item;
import net.minecraft.item.Items;
import net.minecraft.loot.ConstantRange;
import net.minecraft.loot.ILootConditionConsumer;
import net.minecraft.loot.ILootFunctionConsumer;
import net.minecraft.loot.IRandomRange;
import net.minecraft.loot.ItemLootEntry;
import net.minecraft.loot.LootContext;
import net.minecraft.loot.LootEntry;
import net.minecraft.loot.LootFunction;
import net.minecraft.loot.LootParameterSet;
import net.minecraft.loot.LootParameterSets;
import net.minecraft.loot.LootPool;
import net.minecraft.loot.LootTable;
import net.minecraft.loot.LootTableManager;
import net.minecraft.loot.LootTables;
import net.minecraft.loot.RandomValueRange;
import net.minecraft.loot.StandaloneLootEntry;
import net.minecraft.loot.TableLootEntry;
import net.minecraft.loot.TagLootEntry;
import net.minecraft.loot.ValidationTracker;
import net.minecraft.loot.conditions.BlockStateProperty;
import net.minecraft.loot.conditions.EntityHasProperty;
import net.minecraft.loot.conditions.ILootCondition;
import net.minecraft.loot.conditions.KilledByPlayer;
import net.minecraft.loot.conditions.MatchTool;
import net.minecraft.loot.conditions.RandomChance;
import net.minecraft.loot.conditions.TableBonus;
import net.minecraft.loot.functions.ApplyBonus;
import net.minecraft.loot.functions.CopyBlockState;
import net.minecraft.loot.functions.CopyNbt;
import net.minecraft.loot.functions.EnchantRandomly;
import net.minecraft.loot.functions.EnchantWithLevels;
import net.minecraft.loot.functions.ILootFunction;
import net.minecraft.loot.functions.LootingEnchantBonus;
import net.minecraft.loot.functions.SetCount;
import net.minecraft.loot.functions.SetDamage;
import net.minecraft.loot.functions.SetNBT;
import net.minecraft.loot.functions.Smelt;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.potion.Potions;
import net.minecraft.state.Property;
import net.minecraft.state.properties.DoubleBlockHalf;
import net.minecraft.tags.ITag;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Util;
import net.minecraftforge.registries.ForgeRegistries;

public class SkiesLootProv
extends LootTableProvider {
    public static final ResourceLocation BUNKER = BlueSkies.locate("chests/bunker/common");
    public static final ResourceLocation BUNKER_RARE = BlueSkies.locate("chests/bunker/rare");
    public static final ResourceLocation BLINDING_STUDY = BlueSkies.locate("chests/blinding_dungeon/study_chest");
    public static final ResourceLocation BLINDING_LIBRARY = BlueSkies.locate("chests/blinding_dungeon/library_chest");
    public static final ResourceLocation BLINDING_LIBRARY_KEY = BlueSkies.locate("chests/blinding_dungeon/library_chest_key");
    public static final ResourceLocation BLINDING_PRISON_EVERBRIGHT = BlueSkies.locate("chests/blinding_dungeon/prison_chest_everbright");
    public static final ResourceLocation BLINDING_PRISON_EVERDAWN = BlueSkies.locate("chests/blinding_dungeon/prison_chest_everdawn");
    public static final ResourceLocation NATURE_CHEST = BlueSkies.locate("chests/nature_dungeon/chest");
    public static final ResourceLocation NATURE_CHEST_KEY = BlueSkies.locate("chests/nature_dungeon/chest_key");
    public static final ResourceLocation POISON_CHEST = BlueSkies.locate("chests/poison_dungeon/chest");
    public static final ResourceLocation POISON_CHEST_KEY = BlueSkies.locate("chests/poison_dungeon/chest_key");
    public static final EnumMap<SkiesVillageBiomes, ResourceLocation> VILLAGE_BIOME_CHESTS = (EnumMap)Util.func_200696_a(new EnumMap(SkiesVillageBiomes.class), map -> {
        for (SkiesVillageBiomes name : SkiesVillageBiomes.values()) {
            map.put(name, BlueSkies.locate("chests/village/" + name.toString()));
        }
    });
    public static final EnumMap<SkiesVillageProfessions, ResourceLocation> VILLAGE_EVERBRIGHT_PROFESSIONS = (EnumMap)Util.func_200696_a(new EnumMap(SkiesVillageProfessions.class), map -> {
        for (SkiesVillageProfessions name : SkiesVillageProfessions.values()) {
            map.put(name, BlueSkies.locate("chests/village/profession/everbright/" + name.toString()));
        }
    });
    public static final EnumMap<SkiesVillageProfessions, ResourceLocation> VILLAGE_EVERDAWN_PROFESSIONS = (EnumMap)Util.func_200696_a(new EnumMap(SkiesVillageProfessions.class), map -> {
        for (SkiesVillageProfessions name : SkiesVillageProfessions.values()) {
            map.put(name, BlueSkies.locate("chests/village/profession/everdawn/" + name.toString()));
        }
    });
    public static final ResourceLocation EVERBRIGHT_CAVE_SPAWNER = BlueSkies.locate("chests/cave_spawner/chest_everbright");
    public static final ResourceLocation EVERDAWN_CAVE_SPAWNER = BlueSkies.locate("chests/cave_spawner/chest_everdawn");
    public static final ResourceLocation STARGAZER_GIFTS = BlueSkies.locate("gameplay/hero_of_the_village/stargazer_gift");
    public static final ResourceLocation WRANGLER_GIFTS = BlueSkies.locate("gameplay/hero_of_the_village/wrangler_gift");
    public static final ResourceLocation SHOVELER_GIFTS = BlueSkies.locate("gameplay/hero_of_the_village/shoveler_gift");
    public static final ResourceLocation SUMMONER_GIFTS = BlueSkies.locate("gameplay/hero_of_the_village/summoner_gift");
    public static final ResourceLocation ALCHEMIST_GIFTS = BlueSkies.locate("gameplay/hero_of_the_village/alchemist_gift");
    public static final ResourceLocation SUMMONER_BAG_COMMON = BlueSkies.locate("loot_bags/summoner/common");
    public static final ResourceLocation SUMMONER_BAG_UNCOMMON = BlueSkies.locate("loot_bags/summoner/uncommon");
    public static final ResourceLocation SUMMONER_BAG_RARE = BlueSkies.locate("loot_bags/summoner/rare");
    public static final ResourceLocation ALCHEMIST_BAG_COMMON = BlueSkies.locate("loot_bags/alchemist/common");
    public static final ResourceLocation ALCHEMIST_BAG_UNCOMMON = BlueSkies.locate("loot_bags/alchemist/uncommon");
    public static final ResourceLocation ALCHEMIST_BAG_RARE = BlueSkies.locate("loot_bags/alchemist/rare");
    public static final ResourceLocation STARLIT_CRUSHER_BAG_COMMON = BlueSkies.locate("loot_bags/starlit_crusher/common");
    public static final ResourceLocation STARLIT_CRUSHER_BAG_UNCOMMON = BlueSkies.locate("loot_bags/starlit_crusher/uncommon");
    public static final ResourceLocation STARLIT_CRUSHER_BAG_RARE = BlueSkies.locate("loot_bags/starlit_crusher/rare");
    public static final ResourceLocation ARACHNARCH_BAG_COMMON = BlueSkies.locate("loot_bags/arachnarch/common");
    public static final ResourceLocation ARACHNARCH_BAG_UNCOMMON = BlueSkies.locate("loot_bags/arachnarch/uncommon");
    public static final ResourceLocation ARACHNARCH_BAG_RARE = BlueSkies.locate("loot_bags/arachnarch/rare");

    public SkiesLootProv(DataGenerator dataGeneratorIn) {
        super(dataGeneratorIn);
    }

    protected List<Pair<Supplier<Consumer<BiConsumer<ResourceLocation, LootTable.Builder>>>, LootParameterSet>> getTables() {
        return ImmutableList.of((Object)Pair.of(() -> new BlockLoot(), (Object)LootParameterSets.field_216267_h), (Object)Pair.of(() -> new EntityLoot(), (Object)LootParameterSets.field_216263_d), (Object)Pair.of(() -> new ChestLoot(), (Object)LootParameterSets.field_216261_b), (Object)Pair.of(LootBagLoot::new, (Object)LootParameterSets.field_216261_b), (Object)Pair.of(GiftLoot::new, (Object)LootParameterSets.field_216264_e));
    }

    protected void validate(Map<ResourceLocation, LootTable> map, ValidationTracker validationtracker) {
        map.forEach((location, table) -> LootTableManager.func_227508_a_((ValidationTracker)validationtracker, (ResourceLocation)location, (LootTable)table));
    }

    public String func_200397_b() {
        return "Blue Skies Loot Tables";
    }

    public static interface LootPoolUtil {
        default public LootTable.Builder tableOf(List<LootPool.Builder> pools) {
            LootTable.Builder table = LootTable.func_216119_b();
            pools.forEach(pool -> table.func_216040_a(pool));
            return table;
        }

        default public LootTable.Builder tableOf(LootPool.Builder pool) {
            return LootTable.func_216119_b().func_216040_a(pool);
        }

        default public LootPool.Builder basicPool(IItemProvider item, int min, int max) {
            return LootPool.func_216096_a().func_216045_a(this.basicEntry(item, min, max));
        }

        default public LootPool.Builder basicPool(IItemProvider item) {
            return LootPool.func_216096_a().func_216045_a(this.basicEntry(item));
        }

        default public LootPool.Builder randItemPool(List<IItemProvider> items) {
            return this.poolOf(items.stream().map(i -> this.basicEntry((IItemProvider)i)).collect(Collectors.toList()));
        }

        default public LootPool.Builder poolOf(List<LootEntry.Builder<?>> lootEntries) {
            LootPool.Builder pool = LootPool.func_216096_a();
            lootEntries.forEach(entry -> pool.func_216045_a(entry));
            return pool;
        }

        default public StandaloneLootEntry.Builder<?> basicEntry(IItemProvider item, int min, int max) {
            return this.basicEntry(item).func_212841_b_((ILootFunction.IBuilder)SetCount.func_215932_a((IRandomRange)RandomValueRange.func_215837_a((float)min, (float)max)));
        }

        default public StandaloneLootEntry.Builder<?> basicEntry(IItemProvider item) {
            return ItemLootEntry.func_216168_a((IItemProvider)item);
        }

        default public LootFunction.Builder<?> setStick(Item stick) {
            return this.setNbt(nbt -> nbt.func_74778_a("Stick", BlueSkiesData.TOOL_HANDLE_TYPES.getHandle(stick).getName()));
        }

        default public LootFunction.Builder<?> setDamage(int min, int max) {
            return SetDamage.func_215931_a((RandomValueRange)RandomValueRange.func_215837_a((float)((float)min / 100.0f), (float)((float)max / 100.0f)));
        }

        default public LootFunction.Builder<?> smeltItem(EntityPredicate.Builder predicate) {
            return Smelt.func_215953_b().func_212840_b_(EntityHasProperty.func_215999_a((LootContext.EntityTarget)LootContext.EntityTarget.THIS, (EntityPredicate.Builder)predicate));
        }

        default public LootFunction.Builder<?> enchant(int minLevel, int maxLevel) {
            return EnchantWithLevels.func_215895_a((IRandomRange)RandomValueRange.func_215837_a((float)minLevel, (float)maxLevel));
        }

        default public LootFunction.Builder<?> enchant(Enchantment ... enchantments) {
            EnchantRandomly.Builder func = new EnchantRandomly.Builder();
            for (Enchantment enchantment : enchantments) {
                func.func_237424_a_(enchantment);
            }
            return func;
        }

        default public LootFunction.Builder<?> setNbt(Consumer<CompoundNBT> nbt) {
            return SetNBT.func_215952_a((CompoundNBT)((CompoundNBT)Util.func_200696_a((Object)new CompoundNBT(), nbt)));
        }
    }

    public static class GiftLoot
    implements Consumer<BiConsumer<ResourceLocation, LootTable.Builder>>,
    LootPoolUtil {
        @Override
        public void accept(BiConsumer<ResourceLocation, LootTable.Builder> consumer) {
            consumer.accept(STARGAZER_GIFTS, this.tableOf((List<LootPool.Builder>)ImmutableList.of((Object)this.poolOf((List<LootEntry.Builder<?>>)ImmutableList.of((Object)this.basicEntry((IItemProvider)SkiesBlocks.star_flare, 1, 2).func_216086_a(3), (Object)this.basicEntry((IItemProvider)Blocks.field_150359_w, 1, 2).func_216086_a(3), (Object)this.basicEntry((IItemProvider)SkiesItems.falsite_ingot).func_216086_a(1))).func_216046_a((IRandomRange)ConstantRange.func_215835_a((int)1)))));
            consumer.accept(WRANGLER_GIFTS, this.tableOf((List<LootPool.Builder>)ImmutableList.of((Object)this.poolOf((List<LootEntry.Builder<?>>)ImmutableList.of((Object)this.basicEntry((IItemProvider)SkiesItems.brewberry, 3, 4).func_216086_a(2), (Object)this.basicEntry((IItemProvider)SkiesItems.crescent_fruit, 2, 3).func_216086_a(2), (Object)this.basicEntry((IItemProvider)SkiesItems.azulfo_horn, 1, 2).func_216086_a(2), (Object)this.basicEntry((IItemProvider)SkiesItems.fox_pelt, 1, 2).func_216086_a(2), (Object)this.basicEntry((IItemProvider)Items.field_151058_ca, 1, 3).func_216086_a(1))).func_216046_a((IRandomRange)ConstantRange.func_215835_a((int)1)))));
            consumer.accept(SHOVELER_GIFTS, this.tableOf((List<LootPool.Builder>)ImmutableList.of((Object)this.poolOf((List<LootEntry.Builder<?>>)ImmutableList.of((Object)this.basicEntry((IItemProvider)Items.field_151126_ay, 4, 6).func_216086_a(3), (Object)this.basicEntry((IItemProvider)SkiesItems.falsite_ingot, 1, 2).func_216086_a(2), (Object)this.basicEntry((IItemProvider)SkiesItems.aquite_shovel).func_212841_b_(this.setStick(SkiesItems.bluebright_stick)).func_216086_a(1))).func_216046_a((IRandomRange)ConstantRange.func_215835_a((int)1)))));
            consumer.accept(SUMMONER_GIFTS, this.tableOf((List<LootPool.Builder>)ImmutableList.of((Object)this.poolOf((List<LootEntry.Builder<?>>)ImmutableList.of((Object)this.basicEntry((IItemProvider)SkiesItems.soul_fragment, 2, 3).func_216086_a(3), (Object)this.basicEntry((IItemProvider)Items.field_151122_aG).func_216086_a(2))).func_216046_a((IRandomRange)ConstantRange.func_215835_a((int)1)))));
            consumer.accept(ALCHEMIST_GIFTS, this.tableOf((List<LootPool.Builder>)ImmutableList.of((Object)this.poolOf((List<LootEntry.Builder<?>>)ImmutableList.of((Object)this.basicEntry((IItemProvider)Items.field_151074_bl, 2, 4).func_216086_a(6), (Object)this.basicEntry((IItemProvider)Items.field_151065_br, 1, 2).func_216086_a(4), (Object)this.basicEntry((IItemProvider)Items.field_151043_k).func_216086_a(1))).func_216046_a((IRandomRange)ConstantRange.func_215835_a((int)1)))));
        }
    }

    public static class LootBagLoot
    implements Consumer<BiConsumer<ResourceLocation, LootTable.Builder>>,
    LootPoolUtil {
        @Override
        public void accept(BiConsumer<ResourceLocation, LootTable.Builder> consumer) {
            this.summoner(consumer);
            this.alchemist(consumer);
            this.starlitCrusher(consumer);
            this.arachnarch(consumer);
        }

        private void summoner(BiConsumer<ResourceLocation, LootTable.Builder> consumer) {
            EtherealArcItem arc = SkiesItems.ethereal_arc;
            Supplier<LootPool.Builder> common = () -> this.poolOf((List<LootEntry.Builder<?>>)ImmutableList.of(this.basicEntry((IItemProvider)Items.field_151166_bC, 1, 2), this.basicEntry((IItemProvider)SkiesItems.soul_fragment, 1, 2), this.basicEntry((IItemProvider)SkiesItems.moonstone_shard, 2, 4), this.basicEntry((IItemProvider)SkiesItems.aquite_gem, 1, 2)));
            Supplier<LootPool.Builder> uncommon = () -> this.poolOf((List<LootEntry.Builder<?>>)ImmutableList.of(this.basicEntry((IItemProvider)SkiesBlocks.summoning_table), this.basicEntry((IItemProvider)SkiesBlocks.star_flare, 1, 2), this.basicEntry((IItemProvider)SkiesItems.blinding_rage), (Object)this.basicEntry((IItemProvider)Items.field_151122_aG).func_212841_b_(this.enchant(15, 20))));
            Supplier<LootPool.Builder> rare = () -> this.poolOf((List<LootEntry.Builder<?>>)ImmutableList.of(this.basicEntry((IItemProvider)SkiesItems.summoning_tome), this.basicEntry((IItemProvider)SkiesItems.falsite_ingot, 1, 4), (Object)this.basicEntry((IItemProvider)Items.field_151122_aG).func_212841_b_(this.enchant(Enchantments.field_222194_I))));
            consumer.accept(SUMMONER_BAG_COMMON, this.makeBagTable(IRarityItem.SkiesRarity.COMMON, arc, common, uncommon, rare, new IItemProvider[]{SkiesItems.soulbound_spear}));
            consumer.accept(SUMMONER_BAG_UNCOMMON, this.makeBagTable(IRarityItem.SkiesRarity.UNCOMMON, arc, common, uncommon, rare, new IItemProvider[]{SkiesItems.soulbound_spear}));
            consumer.accept(SUMMONER_BAG_RARE, this.makeBagTable(IRarityItem.SkiesRarity.RARE, arc, common, uncommon, rare, new IItemProvider[]{SkiesItems.soulbound_spear}));
        }

        private void alchemist(BiConsumer<ResourceLocation, LootTable.Builder> consumer) {
            DuskArcItem arc = SkiesItems.dusk_arc;
            Supplier<LootPool.Builder> common = () -> this.poolOf((List<LootEntry.Builder<?>>)ImmutableList.of(this.basicEntry((IItemProvider)Items.field_151166_bC, 1, 2), this.basicEntry((IItemProvider)SkiesItems.ventium_ingot, 1, 2), this.basicEntry((IItemProvider)SkiesItems.moonstone_shard, 2, 4), this.basicEntry((IItemProvider)SkiesItems.aquite_gem, 1, 2)));
            Supplier<LootPool.Builder> uncommon = () -> this.poolOf((List<LootEntry.Builder<?>>)ImmutableList.of(this.basicEntry((IItemProvider)SkiesBlocks.alchemy_table), this.basicEntry((IItemProvider)SkiesBlocks.star_flare, 1, 2), this.basicEntry((IItemProvider)SkiesItems.blinding_rage), (Object)this.basicEntry((IItemProvider)Items.field_151122_aG).func_212841_b_(this.enchant(15, 20))));
            Supplier<LootPool.Builder> rare = () -> this.poolOf((List<LootEntry.Builder<?>>)ImmutableList.of(this.basicEntry((IItemProvider)SkiesItems.alchemy_scroll), this.basicEntry((IItemProvider)SkiesItems.horizonite_ingot, 1, 4), (Object)this.basicEntry((IItemProvider)Items.field_151122_aG).func_212841_b_(this.enchant(Enchantments.field_185302_k, Enchantments.field_185303_l, Enchantments.field_180312_n))));
            consumer.accept(ALCHEMIST_BAG_COMMON, this.makeBagTable(IRarityItem.SkiesRarity.COMMON, arc, common, uncommon, rare, new IItemProvider[]{SkiesItems.spike_shield}));
            consumer.accept(ALCHEMIST_BAG_UNCOMMON, this.makeBagTable(IRarityItem.SkiesRarity.UNCOMMON, arc, common, uncommon, rare, new IItemProvider[]{SkiesItems.spike_shield}));
            consumer.accept(ALCHEMIST_BAG_RARE, this.makeBagTable(IRarityItem.SkiesRarity.RARE, arc, common, uncommon, rare, new IItemProvider[]{SkiesItems.spike_shield}));
        }

        private void starlitCrusher(BiConsumer<ResourceLocation, LootTable.Builder> consumer) {
            NatureArcItem arc = SkiesItems.nature_arc;
            Supplier<LootPool.Builder> common = () -> this.poolOf((List<LootEntry.Builder<?>>)ImmutableList.of(this.basicEntry((IItemProvider)SkiesBlocks.starlit_log, 5, 10), this.basicEntry((IItemProvider)SkiesItems.winter_leaves, 2, 5), this.basicEntry((IItemProvider)SkiesBlocks.cherry_sapling, 2, 4), this.basicEntry((IItemProvider)SkiesItems.aquite_gem, 2, 4)));
            Supplier<LootPool.Builder> uncommon = () -> this.poolOf((List<LootEntry.Builder<?>>)ImmutableList.of(this.basicEntry((IItemProvider)SkiesItems.cryo_root, 1, 3), this.basicEntry((IItemProvider)SkiesItems.falsite_ingot, 2, 5), this.basicEntry((IItemProvider)SkiesItems.defying_starlight), (Object)this.basicEntry((IItemProvider)Items.field_151122_aG).func_212841_b_(this.enchant(20, 28))));
            Supplier<LootPool.Builder> rare = () -> this.poolOf((List<LootEntry.Builder<?>>)ImmutableList.of(this.basicEntry((IItemProvider)SkiesItems.crushing_hammer), this.basicEntry((IItemProvider)SkiesItems.diopside_gem, 2, 3), this.basicEntry((IItemProvider)Items.field_151141_av)));
            consumer.accept(STARLIT_CRUSHER_BAG_COMMON, this.makeBagTable(IRarityItem.SkiesRarity.COMMON, arc, common, uncommon, rare, new IItemProvider[0]));
            consumer.accept(STARLIT_CRUSHER_BAG_UNCOMMON, this.makeBagTable(IRarityItem.SkiesRarity.UNCOMMON, arc, common, uncommon, rare, new IItemProvider[0]));
            consumer.accept(STARLIT_CRUSHER_BAG_RARE, this.makeBagTable(IRarityItem.SkiesRarity.RARE, arc, common, uncommon, rare, new IItemProvider[0]));
        }

        private void arachnarch(BiConsumer<ResourceLocation, LootTable.Builder> consumer) {
            PoisonArcItem arc = SkiesItems.poison_arc;
            Supplier<LootPool.Builder> common = () -> this.poolOf((List<LootEntry.Builder<?>>)ImmutableList.of(this.basicEntry((IItemProvider)Items.field_151007_F, 5, 10), this.basicEntry((IItemProvider)SkiesBlocks.spider_webbing, 2, 5), this.basicEntry((IItemProvider)Items.field_151070_bp, 2, 4), this.basicEntry((IItemProvider)SkiesItems.aquite_gem, 2, 4)));
            Supplier<LootPool.Builder> uncommon = () -> this.poolOf((List<LootEntry.Builder<?>>)ImmutableList.of((Object)this.basicEntry((IItemProvider)Items.field_185155_bH).func_212841_b_(this.setNbt(nbt -> nbt.func_74778_a("Potion", Potions.field_185218_A.getRegistryName().toString()))), this.basicEntry((IItemProvider)SkiesItems.horizonite_ingot, 2, 3), this.basicEntry((IItemProvider)SkiesItems.venomous_encounter), (Object)this.basicEntry((IItemProvider)Items.field_151122_aG).func_212841_b_(this.enchant(20, 28))));
            Supplier<LootPool.Builder> rare = () -> this.poolOf((List<LootEntry.Builder<?>>)ImmutableList.of(this.basicEntry((IItemProvider)SkiesItems.venom_sac), this.basicEntry((IItemProvider)SkiesItems.diopside_gem, 2, 3), this.basicEntry((IItemProvider)SkiesItems.different_sword)));
            consumer.accept(ARACHNARCH_BAG_COMMON, this.makeBagTable(IRarityItem.SkiesRarity.COMMON, arc, common, uncommon, rare, new IItemProvider[0]));
            consumer.accept(ARACHNARCH_BAG_UNCOMMON, this.makeBagTable(IRarityItem.SkiesRarity.UNCOMMON, arc, common, uncommon, rare, new IItemProvider[0]));
            consumer.accept(ARACHNARCH_BAG_RARE, this.makeBagTable(IRarityItem.SkiesRarity.RARE, arc, common, uncommon, rare, new IItemProvider[0]));
        }

        private LootTable.Builder makeBagTable(IRarityItem.SkiesRarity rarity, Item arc, Supplier<LootPool.Builder> common, Supplier<LootPool.Builder> uncommon, Supplier<LootPool.Builder> rare, IItemProvider ... guaranteedItems) {
            float rareChance;
            float uncommonChance;
            int maxUncommonRolls;
            boolean minUncommonRolls;
            int maxCommonRolls;
            int minCommonRolls;
            switch (rarity) {
                case COMMON: {
                    minCommonRolls = 3;
                    maxCommonRolls = 6;
                    minUncommonRolls = false;
                    maxUncommonRolls = 2;
                    uncommonChance = 0.6f;
                    rareChance = 0.0f;
                    break;
                }
                case UNCOMMON: {
                    minCommonRolls = 2;
                    maxCommonRolls = 5;
                    minUncommonRolls = true;
                    maxUncommonRolls = 3;
                    uncommonChance = 0.85f;
                    rareChance = 0.25f;
                    break;
                }
                default: {
                    minCommonRolls = 1;
                    maxCommonRolls = 4;
                    minUncommonRolls = true;
                    maxUncommonRolls = 3;
                    uncommonChance = 1.0f;
                    rareChance = 0.5f;
                }
            }
            ArrayList<LootPool.Builder> pools = new ArrayList<LootPool.Builder>();
            pools.add(this.poolOf((List<LootEntry.Builder<?>>)ImmutableList.of((Object)this.basicEntry((IItemProvider)arc).func_212841_b_(SetArcRarity.setRarity(rarity)))));
            for (IItemProvider item : guaranteedItems) {
                pools.add(this.basicPool(item));
            }
            if (maxCommonRolls > 0) {
                pools.add(common.get().func_216046_a((IRandomRange)RandomValueRange.func_215837_a((float)minCommonRolls, (float)maxCommonRolls)));
            }
            if (maxUncommonRolls > 0) {
                pools.add(uncommon.get().func_216046_a((IRandomRange)RandomValueRange.func_215837_a((float)((float)minUncommonRolls), (float)maxUncommonRolls)).func_212840_b_(RandomChance.func_216004_a((float)uncommonChance)));
            }
            if (rareChance > 0.0f) {
                pools.add(rare.get().func_212840_b_(RandomChance.func_216004_a((float)rareChance)));
            }
            return this.tableOf(pools);
        }
    }

    private class BlockLoot
    extends BlockLootTables
    implements LootPoolUtil {
        private final ILootCondition.IBuilder SILK_TOUCH = MatchTool.func_216012_a((ItemPredicate.Builder)ItemPredicate.Builder.func_200309_a().func_218003_a(new EnchantmentPredicate(Enchantments.field_185306_r, MinMaxBounds.IntBound.func_211340_b((int)1))));
        private final ILootCondition.IBuilder SHEARS = MatchTool.func_216012_a((ItemPredicate.Builder)ItemPredicate.Builder.func_200309_a().func_200308_a((IItemProvider)Items.field_151097_aZ));
        private final ILootCondition.IBuilder SILK_TOUCH_OR_SHEARS = this.SHEARS.func_216297_a(this.SILK_TOUCH);
        private final ILootCondition.IBuilder NOT_SILK_TOUCH_OR_SHEARS = this.SILK_TOUCH_OR_SHEARS.func_216298_a();
        private float[] DEFAULT_SAPLING_DROP_RATES = new float[]{0.05f, 0.0625f, 0.083333336f, 0.1f};

        private BlockLoot() {
        }

        protected void addTables() {
            this.blocks().forEach(block -> {
                if (block == SkiesBlocks.turquoise_grass) {
                    this.droppingSeedTag((Block)block, (ITag.INamedTag<Item>)SkiesItemTags.TURQUOISE_GRASS_DROPS);
                } else if (block == SkiesBlocks.tall_turquoise_grass) {
                    this.func_218522_a((Block)block, b -> BlockLoot.func_218511_b((Block)SkiesBlocks.turquoise_grass, (LootEntry.Builder)((StandaloneLootEntry.Builder)((StandaloneLootEntry.Builder)BlockLoot.func_218560_a((IItemProvider)b, (ILootConditionConsumer)TagLootEntry.func_216176_b(SkiesItemTags.TURQUOISE_GRASS_DROPS))).func_212840_b_((ILootCondition.IBuilder)BlockStateProperty.func_215985_a((Block)b).func_227567_a_(StatePropertiesPredicate.Builder.func_227191_a_().func_227193_a_((Property)DoublePlantBlock.field_176492_b, (Comparable)DoubleBlockHalf.LOWER)))).func_212840_b_(RandomChance.func_216004_a((float)0.125f))));
                } else if (block == SkiesBlocks.lunar_grass) {
                    this.droppingSeedTag((Block)block, (ITag.INamedTag<Item>)SkiesItemTags.LUNAR_GRASS_DROPS);
                } else if (block == SkiesBlocks.tall_lunar_grass) {
                    this.func_218522_a((Block)block, b -> BlockLoot.func_218511_b((Block)SkiesBlocks.lunar_grass, (LootEntry.Builder)((StandaloneLootEntry.Builder)((StandaloneLootEntry.Builder)BlockLoot.func_218560_a((IItemProvider)b, (ILootConditionConsumer)TagLootEntry.func_216176_b(SkiesItemTags.LUNAR_GRASS_DROPS))).func_212840_b_((ILootCondition.IBuilder)BlockStateProperty.func_215985_a((Block)b).func_227567_a_(StatePropertiesPredicate.Builder.func_227191_a_().func_227193_a_((Property)DoublePlantBlock.field_176492_b, (Comparable)DoubleBlockHalf.LOWER)))).func_212840_b_(RandomChance.func_216004_a((float)0.125f))));
                } else if (block == SkiesBlocks.cherry_grass) {
                    this.droppingSeedTag((Block)block, (ITag.INamedTag<Item>)SkiesItemTags.CHERRY_GRASS_DROPS);
                } else if (block == SkiesBlocks.turquoise_grass_block || block == SkiesBlocks.turquoise_cherry_grass_block) {
                    this.silkOrElse((Block)block, (IItemProvider)SkiesBlocks.turquoise_dirt);
                } else if (block == SkiesBlocks.lunar_grass_block || block == SkiesBlocks.lunar_cherry_grass_block) {
                    this.silkOrElse((Block)block, (IItemProvider)SkiesBlocks.lunar_dirt);
                } else if (block == SkiesBlocks.turquoise_farmland) {
                    this.func_218493_a((Block)block, (IItemProvider)SkiesBlocks.turquoise_dirt);
                } else if (block == SkiesBlocks.lunar_farmland) {
                    this.func_218493_a((Block)block, (IItemProvider)SkiesBlocks.lunar_dirt);
                } else if (block == SkiesBlocks.turquoise_stone) {
                    this.silkOrElse((Block)block, (IItemProvider)SkiesBlocks.turquoise_cobblestone);
                } else if (block == SkiesBlocks.lunar_stone) {
                    this.silkOrElse((Block)block, (IItemProvider)SkiesBlocks.lunar_cobblestone);
                } else if (block instanceof VineBlock || block == SkiesBlocks.muckweed || block == SkiesBlocks.brittlebush || block == SkiesBlocks.chillweed || block == SkiesBlocks.sea_moss || block == SkiesBlocks.crystallized_grass) {
                    this.func_218522_a((Block)block, BlockLootTables::func_218486_d);
                } else if (block == SkiesBlocks.bluebright_leaves) {
                    this.func_218522_a((Block)block, b -> this.leaves((Block)b, (IItemProvider)SkiesBlocks.bluebright_sapling, (IItemProvider)SkiesItems.bluebright_stick));
                } else if (block == SkiesBlocks.starlit_leaves) {
                    this.func_218522_a((Block)block, b -> this.leaves((Block)b, (IItemProvider)SkiesBlocks.starlit_sapling, (IItemProvider)SkiesItems.starlit_stick));
                } else if (block == SkiesBlocks.frostbright_leaves) {
                    this.func_218522_a((Block)block, b -> this.leaves((Block)b, (IItemProvider)SkiesBlocks.frostbright_sapling, (IItemProvider)SkiesItems.frostbright_stick));
                } else if (block == SkiesBlocks.lunar_leaves) {
                    this.func_218522_a((Block)block, b -> this.leaves((Block)b, (IItemProvider)SkiesBlocks.lunar_sapling, (IItemProvider)SkiesItems.lunar_stick));
                } else if (block == SkiesBlocks.dusk_leaves) {
                    this.func_218522_a((Block)block, b -> this.leaves((Block)b, (IItemProvider)SkiesBlocks.dusk_sapling, (IItemProvider)SkiesItems.dusk_stick));
                } else if (block == SkiesBlocks.maple_leaves) {
                    this.func_218522_a((Block)block, b -> this.leaves((Block)b, (IItemProvider)SkiesBlocks.maple_sapling, (IItemProvider)SkiesItems.maple_stick));
                } else if (block == SkiesBlocks.cherry_leaves) {
                    this.func_218522_a((Block)block, b -> this.leavesFruit((Block)b, (IItemProvider)SkiesBlocks.cherry_sapling, (IItemProvider)SkiesItems.cherry_stick, (IItemProvider)SkiesItems.cherry));
                } else if (block == SkiesBlocks.crescent_fruit_leaves) {
                    this.func_218522_a((Block)block, b -> this.leaves((Block)SkiesBlocks.lunar_leaves, (IItemProvider)SkiesBlocks.crescent_fruit_sapling, (IItemProvider)SkiesItems.lunar_stick));
                } else if (block == SkiesBlocks.snowcap_mushroom) {
                    this.func_218522_a((Block)block, b -> BlockLoot.func_218562_a((Block)b, (Property)DoublePlantBlock.field_176492_b, (Comparable)DoubleBlockHalf.LOWER));
                } else if (block == SkiesBlocks.snowcap_mushroom_block) {
                    this.func_218522_a((Block)block, b -> BlockLoot.func_218530_a((Block)b, (IItemProvider)SkiesBlocks.snowcap_pinhead, (IRandomRange)RandomValueRange.func_215837_a((float)0.0f, (float)2.0f)));
                } else if (block == SkiesBlocks.snowcap_mushroom_stem) {
                    this.func_218522_a((Block)block, b -> BlockLoot.func_218530_a((Block)b, (IItemProvider)SkiesBlocks.snowcap_pinhead, (IRandomRange)RandomValueRange.func_215837_a((float)0.0f, (float)1.0f)));
                } else if (block == SkiesBlocks.brewberry_bush) {
                    this.func_218522_a((Block)block, b -> (LootTable.Builder)BlockLoot.func_218552_a((IItemProvider)b, (ILootFunctionConsumer)LootTable.func_216119_b().func_216040_a(LootPool.func_216096_a().func_212840_b_((ILootCondition.IBuilder)BlockStateProperty.func_215985_a((Block)SkiesBlocks.brewberry_bush).func_227567_a_(StatePropertiesPredicate.Builder.func_227191_a_().func_227195_a_((Property)BrewberryBushBlock.MATURE, true))).func_216045_a((LootEntry.Builder)ItemLootEntry.func_216168_a((IItemProvider)SkiesItems.brewberry).func_212841_b_((ILootFunction.IBuilder)SetCount.func_215932_a((IRandomRange)RandomValueRange.func_215837_a((float)1.0f, (float)2.0f))))).func_216040_a(LootPool.func_216096_a().func_216045_a((LootEntry.Builder)ItemLootEntry.func_216168_a((IItemProvider)SkiesBlocks.brewberry_bush)))));
                } else if (block instanceof SkyWebbingBlock) {
                    this.func_218522_a((Block)block, b -> BlockLoot.func_218535_c((Block)b, (LootEntry.Builder)((LootEntry.Builder)BlockLoot.func_218560_a((IItemProvider)b, (ILootConditionConsumer)ItemLootEntry.func_216168_a((IItemProvider)Items.field_151007_F)))));
                } else if (block instanceof ChestBlock) {
                    this.func_218522_a((Block)block, BlockLootTables::func_218481_e);
                } else if (block instanceof SlabBlock) {
                    this.func_218522_a((Block)block, BlockLootTables::func_218513_d);
                } else if (block == SkiesBlocks.crystal_glass || block == SkiesBlocks.midnight_glass || block == SkiesBlocks.crystal_glass_pane || block == SkiesBlocks.midnight_glass_pane || block == SkiesBlocks.crystallized_leaves) {
                    this.func_218466_b((Block)block);
                } else if (block == SkiesBlocks.everbright_moonstone_ore || block == SkiesBlocks.everdawn_moonstone_ore) {
                    this.func_218522_a((Block)block, b -> BlockLoot.func_218519_a((Block)b, (LootEntry.Builder)((LootEntry.Builder)BlockLoot.func_218552_a((IItemProvider)b, (ILootFunctionConsumer)ItemLootEntry.func_216168_a((IItemProvider)SkiesItems.moonstone_shard).func_212841_b_((ILootFunction.IBuilder)SetCount.func_215932_a((IRandomRange)RandomValueRange.func_215837_a((float)1.0f, (float)3.0f))).func_212841_b_((ILootFunction.IBuilder)ApplyBonus.func_215871_b((Enchantment)Enchantments.field_185308_t))))));
                } else if (block == SkiesBlocks.everbright_pyrope_ore || block == SkiesBlocks.everdawn_pyrope_ore) {
                    this.func_218522_a((Block)block, b -> BlockLoot.func_218476_a((Block)b, (Item)SkiesItems.pyrope_gem));
                } else if (block == SkiesBlocks.everbright_diopside_ore || block == SkiesBlocks.everdawn_diopside_ore) {
                    this.func_218522_a((Block)block, b -> BlockLoot.func_218476_a((Block)b, (Item)SkiesItems.diopside_gem));
                } else if (block == SkiesBlocks.everbright_emerald_ore || block == SkiesBlocks.everdawn_emerald_ore) {
                    this.func_218522_a((Block)block, b -> BlockLoot.func_218476_a((Block)b, (Item)Items.field_151166_bC));
                } else if (block == SkiesBlocks.decaying_spike) {
                    this.func_218493_a((Block)block, (IItemProvider)SkiesBlocks.lunar_cobblestone);
                } else if (block == SkiesBlocks.crescent_fruit) {
                    this.func_218493_a((Block)block, (IItemProvider)SkiesItems.crescent_fruit);
                } else if (block == SkiesBlocks.cherry_pie) {
                    this.func_218507_a((Block)block, BlockLoot.func_218482_a());
                } else if (block instanceof DoorBlock) {
                    this.func_218522_a((Block)block, b -> BlockLoot.func_218562_a((Block)b, (Property)DoorBlock.field_176523_O, (Comparable)DoubleBlockHalf.LOWER));
                } else if (ImmutableList.of((Object)SkiesBlocks.bluebright_bookshelf, (Object)SkiesBlocks.starlit_bookshelf, (Object)SkiesBlocks.frostbright_bookshelf, (Object)SkiesBlocks.lunar_bookshelf, (Object)SkiesBlocks.dusk_bookshelf, (Object)SkiesBlocks.maple_bookshelf, (Object)SkiesBlocks.cherry_bookshelf).contains(block)) {
                    this.func_218522_a((Block)block, b -> BlockLoot.func_218530_a((Block)b, (IItemProvider)Items.field_151122_aG, (IRandomRange)ConstantRange.func_215835_a((int)3)));
                } else if (block instanceof FlowerPotBlock) {
                    this.func_218547_a((Block)block);
                } else if (block instanceof SkyCropBlock) {
                    BlockStateProperty.Builder growthCondition = BlockStateProperty.func_215985_a((Block)block).func_227567_a_(StatePropertiesPredicate.Builder.func_227191_a_().func_227192_a_((Property)SkyCropBlock.AGE, ((SkyCropBlock)((Object)block)).func_185526_g()));
                    if (block == SkiesBlocks.solnuts) {
                        this.func_218522_a((Block)block, arg_0 -> this.lambda$null$21((ILootCondition.IBuilder)growthCondition, arg_0));
                    } else if (block == SkiesBlocks.cryo_roots) {
                        this.func_218522_a((Block)block, arg_0 -> this.lambda$null$22((ILootCondition.IBuilder)growthCondition, arg_0));
                    } else if (block == SkiesBlocks.winter_leaves) {
                        this.func_218522_a((Block)block, arg_0 -> this.lambda$null$23((ILootCondition.IBuilder)growthCondition, arg_0));
                    } else if (block == SkiesBlocks.fiery_beans) {
                        this.func_218522_a((Block)block, arg_0 -> this.lambda$null$24((ILootCondition.IBuilder)growthCondition, arg_0));
                    } else if (block == SkiesBlocks.scalefruits) {
                        this.func_218522_a((Block)block, arg_0 -> this.lambda$null$25((ILootCondition.IBuilder)growthCondition, arg_0));
                    } else if (block == SkiesBlocks.pine_fruits) {
                        this.func_218522_a((Block)block, arg_0 -> this.lambda$null$26((ILootCondition.IBuilder)growthCondition, arg_0));
                    }
                } else if (block == SkiesBlocks.spider_nest) {
                    this.func_218493_a((Block)block, (IItemProvider)SkiesBlocks.poison_stone);
                } else if (block == SkiesBlocks.moonlit_water_lily) {
                    this.func_218522_a((Block)block, b -> BlockLoot.func_218562_a((Block)b, LargeLilyPadBlock.CORNER, (Comparable)((Object)LargeLilyPadBlock.Corner.BOTTOM_L)));
                } else if (block instanceof TrophyBlock) {
                    this.func_218522_a((Block)block, b -> this.trophy((Block)b));
                } else if (block instanceof BagOfSpoilsBlock) {
                    this.func_218522_a((Block)block, b -> BlockLoot.func_218544_f((Block)b));
                } else {
                    this.func_218492_c((Block)block);
                }
            });
        }

        protected Iterable<Block> getKnownBlocks() {
            return this.blocks()::iterator;
        }

        private Stream<Block> blocks() {
            return ForgeRegistries.BLOCKS.getValues().stream().filter(b -> b.getRegistryName().func_110624_b().equals("blue_skies") && !b.func_220068_i().equals((Object)LootTables.field_186419_a));
        }

        private void droppingSeedTag(Block block, ITag.INamedTag<Item> tag) {
            this.func_218507_a(block, BlockLoot.func_218511_b((Block)block, (LootEntry.Builder)((LootEntry.Builder)BlockLoot.func_218552_a((IItemProvider)block, (ILootFunctionConsumer)((StandaloneLootEntry.Builder)TagLootEntry.func_216176_b(tag).func_212840_b_(RandomChance.func_216004_a((float)0.125f))).func_212841_b_((ILootFunction.IBuilder)ApplyBonus.func_215865_a((Enchantment)Enchantments.field_185308_t, (int)2))))));
        }

        private void silkOrElse(Block withSilk, IItemProvider without) {
            this.func_218522_a(withSilk, b -> BlockLoot.func_218515_b((Block)b, (IItemProvider)without));
        }

        private LootTable.Builder leaves(Block block, IItemProvider sapling, IItemProvider stick) {
            return BlockLoot.func_218535_c((Block)block, (LootEntry.Builder)((StandaloneLootEntry.Builder)BlockLoot.func_218560_a((IItemProvider)block, (ILootConditionConsumer)ItemLootEntry.func_216168_a((IItemProvider)sapling))).func_212840_b_(TableBonus.func_215955_a((Enchantment)Enchantments.field_185308_t, (float[])this.DEFAULT_SAPLING_DROP_RATES))).func_216040_a(LootPool.func_216096_a().func_216046_a((IRandomRange)ConstantRange.func_215835_a((int)1)).func_212840_b_(this.NOT_SILK_TOUCH_OR_SHEARS).func_216045_a(((StandaloneLootEntry.Builder)BlockLoot.func_218552_a((IItemProvider)block, (ILootFunctionConsumer)ItemLootEntry.func_216168_a((IItemProvider)stick).func_212841_b_((ILootFunction.IBuilder)SetCount.func_215932_a((IRandomRange)RandomValueRange.func_215837_a((float)1.0f, (float)2.0f))))).func_212840_b_(TableBonus.func_215955_a((Enchantment)Enchantments.field_185308_t, (float[])new float[]{0.02f, 0.022222223f, 0.025f, 0.033333335f, 0.1f}))));
        }

        private LootTable.Builder leavesFruit(Block block, IItemProvider sapling, IItemProvider stick, IItemProvider fruit) {
            float baseChance = 0.05f;
            float[] fortuneChances = new float[]{1.1111112f, 1.25f, 1.6666667f, 5.0f};
            return this.leaves(block, sapling, stick).func_216040_a(LootPool.func_216096_a().func_216046_a((IRandomRange)ConstantRange.func_215835_a((int)1)).func_212840_b_(this.NOT_SILK_TOUCH_OR_SHEARS).func_216045_a(((StandaloneLootEntry.Builder)BlockLoot.func_218560_a((IItemProvider)block, (ILootConditionConsumer)ItemLootEntry.func_216168_a((IItemProvider)fruit))).func_212840_b_(TableBonus.func_215955_a((Enchantment)Enchantments.field_185308_t, (float[])new float[]{baseChance, baseChance * fortuneChances[0], baseChance * fortuneChances[1], baseChance * fortuneChances[2], baseChance * fortuneChances[3]}))));
        }

        private LootTable.Builder crop(ILootCondition.IBuilder growthCondition, Block block, IItemProvider food) {
            return this.crop(growthCondition, block, food, food);
        }

        private LootTable.Builder crop(ILootCondition.IBuilder growthCondition, Block block, IItemProvider food, IItemProvider seed) {
            LootPool.Builder seedPool = LootPool.func_216096_a().func_216045_a((LootEntry.Builder)ItemLootEntry.func_216168_a((IItemProvider)seed).func_212841_b_((ILootFunction.IBuilder)ApplyBonus.func_215870_a((Enchantment)Enchantments.field_185308_t, (float)0.5714286f, (int)3).func_212840_b_(growthCondition)));
            LootPool.Builder foodPool = LootPool.func_216096_a().func_212840_b_(growthCondition).func_216045_a((LootEntry.Builder)ItemLootEntry.func_216168_a((IItemProvider)food).func_212841_b_((ILootFunction.IBuilder)ApplyBonus.func_215870_a((Enchantment)Enchantments.field_185308_t, (float)0.5714286f, (int)1)));
            return (LootTable.Builder)BlockLoot.func_218552_a((IItemProvider)block, (ILootFunctionConsumer)LootTable.func_216119_b().func_216040_a(seedPool).func_216040_a(foodPool));
        }

        private LootTable.Builder doubleCrop(ILootCondition.IBuilder growthCondition, Block block, IItemProvider food, IItemProvider seed) {
            BlockStateProperty.Builder topHalf = BlockStateProperty.func_215985_a((Block)block).func_227567_a_(StatePropertiesPredicate.Builder.func_227191_a_().func_227193_a_(SkyDoubleCropBlock.HALF, (Comparable)DoubleBlockHalf.UPPER));
            BlockStateProperty.Builder lowerHalf = BlockStateProperty.func_215985_a((Block)block).func_227567_a_(StatePropertiesPredicate.Builder.func_227191_a_().func_227193_a_(SkyDoubleCropBlock.HALF, (Comparable)DoubleBlockHalf.LOWER));
            LootPool.Builder seedPool = LootPool.func_216096_a().func_216045_a((LootEntry.Builder)ItemLootEntry.func_216168_a((IItemProvider)seed).func_212841_b_((ILootFunction.IBuilder)ApplyBonus.func_215870_a((Enchantment)Enchantments.field_185308_t, (float)0.2f, (int)2).func_212840_b_(growthCondition)));
            LootPool.Builder topPool = LootPool.func_216096_a().func_212840_b_(growthCondition).func_212840_b_((ILootCondition.IBuilder)topHalf).func_216045_a((LootEntry.Builder)ItemLootEntry.func_216168_a((IItemProvider)food).func_212841_b_((ILootFunction.IBuilder)ApplyBonus.func_215870_a((Enchantment)Enchantments.field_185308_t, (float)0.4f, (int)1)));
            LootPool.Builder lowerPool = LootPool.func_216096_a().func_212840_b_(growthCondition).func_212840_b_((ILootCondition.IBuilder)lowerHalf).func_216045_a((LootEntry.Builder)ItemLootEntry.func_216168_a((IItemProvider)food).func_212841_b_((ILootFunction.IBuilder)ApplyBonus.func_215870_a((Enchantment)Enchantments.field_185308_t, (float)0.2f, (int)1)));
            return (LootTable.Builder)BlockLoot.func_218552_a((IItemProvider)block, (ILootFunctionConsumer)LootTable.func_216119_b().func_216040_a(seedPool).func_216040_a(topPool).func_216040_a(lowerPool));
        }

        private LootTable.Builder trophy(Block block) {
            return LootTable.func_216119_b().func_216040_a(LootPool.func_216096_a().func_216045_a((LootEntry.Builder)ItemLootEntry.func_216168_a((IItemProvider)block).func_212841_b_((ILootFunction.IBuilder)CopyBlockState.func_227545_a_((Block)block).func_227552_a_(TrophyBlock.TIER)).func_212841_b_((ILootFunction.IBuilder)CopyNbt.func_215881_a((CopyNbt.Source)CopyNbt.Source.BLOCK_ENTITY).func_216056_a("Label", "display.Name"))));
        }

        private /* synthetic */ LootTable.Builder lambda$null$26(ILootCondition.IBuilder growthCondition, Block b) {
            return this.doubleCrop(growthCondition, b, (IItemProvider)SkiesItems.pine_fruit, (IItemProvider)SkiesItems.pine_fruit_seeds);
        }

        private /* synthetic */ LootTable.Builder lambda$null$25(ILootCondition.IBuilder growthCondition, Block b) {
            return this.doubleCrop(growthCondition, b, (IItemProvider)SkiesItems.scalefruit, (IItemProvider)SkiesItems.scalefruit_seeds);
        }

        private /* synthetic */ LootTable.Builder lambda$null$24(ILootCondition.IBuilder growthCondition, Block b) {
            return this.crop(growthCondition, b, (IItemProvider)SkiesItems.fiery_beans, (IItemProvider)SkiesItems.fiery_bean_seeds);
        }

        private /* synthetic */ LootTable.Builder lambda$null$23(ILootCondition.IBuilder growthCondition, Block b) {
            return this.crop(growthCondition, b, (IItemProvider)SkiesItems.winter_leaves, (IItemProvider)SkiesItems.winter_leaf_seeds);
        }

        private /* synthetic */ LootTable.Builder lambda$null$22(ILootCondition.IBuilder growthCondition, Block b) {
            return this.crop(growthCondition, b, (IItemProvider)SkiesItems.cryo_root);
        }

        private /* synthetic */ LootTable.Builder lambda$null$21(ILootCondition.IBuilder growthCondition, Block b) {
            return this.crop(growthCondition, b, (IItemProvider)SkiesItems.solnut);
        }
    }

    private class EntityLoot
    extends EntityLootTables
    implements LootPoolUtil {
        private EntityLoot() {
        }

        protected void addTables() {
            this.func_218582_a(SkiesEntityTypes.GATEKEEPER, LootTable.func_216119_b());
            this.func_218582_a(SkiesEntityTypes.SUMMONER, LootTable.func_216119_b());
            this.func_218582_a(SkiesEntityTypes.ALCHEMIST, LootTable.func_216119_b());
            this.func_218582_a(SkiesEntityTypes.ARACHNARCH, LootTable.func_216119_b());
            this.func_218582_a(SkiesEntityTypes.STARLIT_CRUSHER, LootTable.func_216119_b());
            LootPool.Builder azulfoBeef = this.lootingPool((IItemProvider)SkiesItems.carabeef, 2, 4, 0, 1).func_212841_b_((ILootFunction.IBuilder)this.smeltItem(field_218586_a));
            LootPool.Builder auzlfoHorn = this.lootingPool((IItemProvider)SkiesItems.azulfo_horn, 0, 1, 0, 1).func_212840_b_(KilledByPlayer.func_215994_b());
            this.func_218582_a(SkiesEntityTypes.AZULFO, this.tableOf((List)ImmutableList.of((Object)azulfoBeef, (Object)auzlfoHorn)));
            LootPool.Builder rawVenison = this.lootingPool((IItemProvider)SkiesItems.venison, 1, 2, 0, 1).func_212841_b_((ILootFunction.IBuilder)this.smeltItem(field_218586_a));
            this.func_218582_a(SkiesEntityTypes.REINDEER, this.tableOf(rawVenison));
            LootPool.Builder mutton = this.lootingPool((IItemProvider)Items.field_179561_bm, 1, 2, 0, 1).func_212841_b_((ILootFunction.IBuilder)this.smeltItem(field_218586_a));
            this.func_218582_a(SkiesEntityTypes.STARDUST_RAM, this.tableOf(mutton));
            Arrays.asList(DyeColor.values()).forEach(c -> this.func_218585_a(BlueSkies.locate("entities/" + this.entityName(SkiesEntityTypes.STARDUST_RAM) + "/" + c), this.ramLootTable((IItemProvider)ForgeRegistries.BLOCKS.getValue(new ResourceLocation(c + "_wool")))));
            LootPool.Builder starFlare = this.lootingPool((IItemProvider)SkiesBlocks.star_flare, 0, 2, 0, 1).func_212840_b_(KilledByPlayer.func_215994_b());
            LootPool.Builder soulFragment = this.lootingPool((IItemProvider)SkiesItems.soul_fragment, 0, 2, 0, 1).func_212840_b_(KilledByPlayer.func_215994_b());
            this.func_218582_a(SkiesEntityTypes.FROST_SPIRIT, this.tableOf((List)ImmutableList.of((Object)starFlare, (Object)soulFragment)));
            LootPool.Builder ice = this.lootingPool((IItemProvider)Items.field_221770_cu, 0, 2, 0, 1);
            LootPool.Builder packedIce = this.lootingPool((IItemProvider)Items.field_221898_fg, 0, 2, 0, 1);
            this.func_218582_a(SkiesEntityTypes.ARMORED_FROST_SPIRIT, this.tableOf(ice));
            this.func_218585_a(BlueSkies.locate("entities/" + this.entityName(SkiesEntityTypes.ARMORED_FROST_SPIRIT) + "_packed"), this.tableOf(packedIce));
            this.func_218582_a(SkiesEntityTypes.CRYNOCEROUS, this.tableOf(ice.func_216046_a((IRandomRange)RandomValueRange.func_215837_a((float)1.0f, (float)2.0f))));
            this.func_218585_a(BlueSkies.locate("entities/" + this.entityName(SkiesEntityTypes.CRYNOCEROUS) + "_packed"), this.tableOf(packedIce.func_216046_a((IRandomRange)RandomValueRange.func_215837_a((float)1.0f, (float)2.0f))));
            this.func_218582_a(SkiesEntityTypes.JELLY_DRIFTER, LootTable.func_216119_b());
            LootPool.Builder feather = this.lootingPool((IItemProvider)Items.field_151008_G, 1, 2, 0, 1);
            this.func_218582_a(SkiesEntityTypes.SNOW_OWL, this.tableOf(feather));
            this.func_218582_a(SkiesEntityTypes.POLARGEIST, this.tableOf(soulFragment));
            LootPool.Builder glowstoneDust = this.lootingPool((IItemProvider)Items.field_151114_aO, 0, 1, 0, 1);
            this.func_218582_a(SkiesEntityTypes.FIREFLY, this.tableOf(glowstoneDust));
            LootPool.Builder bugGuts = this.lootingPool((IItemProvider)SkiesItems.bug_guts, 0, 2, 0, 1);
            LootPool.Builder slimeBall = this.lootingPool((IItemProvider)Items.field_151123_aH, 0, 1, 0, 1);
            this.func_218582_a(SkiesEntityTypes.NYCTOFLY, this.tableOf((List)ImmutableList.of((Object)bugGuts, (Object)slimeBall)));
            LootPool.Builder string = this.lootingPool((IItemProvider)Items.field_151007_F, 0, 2, 0, 1);
            LootPool.Builder spiderEye = this.lootingPool((IItemProvider)Items.field_151070_bp, -1, 1, 0, 1).func_212840_b_(KilledByPlayer.func_215994_b());
            this.func_218582_a(SkiesEntityTypes.VENOM_SPIDER, this.tableOf((List)ImmutableList.of((Object)string, (Object)spiderEye, (Object)bugGuts)));
            LootPool.Builder fur = this.lootingPool((IItemProvider)SkiesItems.fox_pelt, 1, 2, 0, 1);
            LootPool.Builder salmon = this.lootingPool((IItemProvider)Items.field_196087_aX, -1, 1, 0, 1).func_212841_b_((ILootFunction.IBuilder)this.smeltItem(field_218586_a));
            this.func_218582_a(SkiesEntityTypes.COSMIC_FOX, this.tableOf((List)ImmutableList.of((Object)fur, (Object)salmon)));
            LootPool.Builder rawMoonstone = this.lootingPool((IItemProvider)SkiesBlocks.raw_moonstone, 0, 2, 0, 1);
            LootPool.Builder bone = this.lootingPool((IItemProvider)Items.field_151103_aS, -1, 1, 0, 1).func_212840_b_(KilledByPlayer.func_215994_b());
            this.func_218582_a(SkiesEntityTypes.CRYSTAL_CAMEL, this.tableOf((List)ImmutableList.of((Object)rawMoonstone, (Object)bone)));
            this.func_218582_a(SkiesEntityTypes.EMBERBACK, this.tableOf(bugGuts));
            LootPool.Builder monitorTail = this.lootingPool((IItemProvider)SkiesItems.monitor_tail, 1, 1, 0, 0).func_212841_b_((ILootFunction.IBuilder)this.smeltItem(field_218586_a));
            this.func_218582_a(SkiesEntityTypes.SHADE_MONITOR, this.tableOf(monitorTail));
            this.func_218582_a(SkiesEntityTypes.SLIV, LootTable.func_216119_b());
            this.func_218582_a(SkiesEntityTypes.ARTIFICIAL_GOLEM, LootTable.func_216119_b().func_216040_a(LootPool.func_216096_a().func_216045_a((LootEntry.Builder)TagLootEntry.func_216176_b(SkiesItemTags.BLINDING_STONES)).func_212841_b_((ILootFunction.IBuilder)SetCount.func_215932_a((IRandomRange)RandomValueRange.func_215837_a((float)0.0f, (float)1.0f))).func_212841_b_((ILootFunction.IBuilder)LootingEnchantBonus.func_215915_a((RandomValueRange)RandomValueRange.func_215837_a((float)0.0f, (float)1.0f)))));
            this.func_218582_a(SkiesEntityTypes.NESTED_SPIDER, LootTable.func_216119_b());
            LootPool.Builder natureStone = this.basicPool((IItemProvider)SkiesBlocks.nature_stone, 0, 1);
            LootPool.Builder starlitVines = this.basicPool((IItemProvider)SkiesBlocks.starlit_vine, 0, 1);
            this.func_218582_a(SkiesEntityTypes.STONELET, this.tableOf((List)ImmutableList.of((Object)natureStone, (Object)starlitVines)));
            this.func_218582_a(SkiesEntityTypes.SPEWTER, this.tableOf(slimeBall));
            LootPool.Builder pinhead = this.lootingPool((IItemProvider)SkiesBlocks.snowcap_pinhead, 0, 2, 0, 1);
            this.func_218582_a(SkiesEntityTypes.SHRUMPTY, this.tableOf(pinhead));
            LootPool.Builder leather = this.lootingPool((IItemProvider)Items.field_151116_aA, 0, 1, 0, 1);
            LootPool.Builder prowlerFish = this.lootingPool((IItemProvider)SkiesItems.municipal_monkfish, 0, 1, 0, 1).func_212841_b_((ILootFunction.IBuilder)this.smeltItem(field_218586_a));
            this.func_218582_a(SkiesEntityTypes.DIOPHYDE_PROWLER, this.tableOf((List)ImmutableList.of((Object)leather, (Object)prowlerFish)));
            this.func_218582_a(SkiesEntityTypes.WHISTLESHELL_CRAB, LootTable.func_216119_b());
            this.func_218582_a(SkiesEntityTypes.SUPPORTER_PET, LootTable.func_216119_b());
            LootPool.Builder crogreBugGuts = this.lootingPool((IItemProvider)SkiesItems.bug_guts, 0, 1, 0, 1);
            this.func_218582_a(SkiesEntityTypes.CROGRE, this.tableOf(crogreBugGuts));
            LootPool.Builder fishBoneMeal = this.basicPool((IItemProvider)Items.field_196106_bc).func_212840_b_(RandomChance.func_216004_a((float)0.05f));
            LootPool.Builder monkfish = this.lootingPool((IItemProvider)SkiesItems.municipal_monkfish, 1, 1, 0, 0).func_212841_b_((ILootFunction.IBuilder)this.smeltItem(field_218586_a));
            this.func_218582_a(SkiesEntityTypes.MUNICIPAL_MONKFISH, this.tableOf((List)ImmutableList.of((Object)monkfish, (Object)fishBoneMeal)));
            LootPool.Builder flatfish = this.lootingPool((IItemProvider)SkiesItems.grittle_flatfish, 1, 1, 0, 0).func_212841_b_((ILootFunction.IBuilder)this.smeltItem(field_218586_a));
            this.func_218582_a(SkiesEntityTypes.GRITTLE_FLATFISH, this.tableOf((List)ImmutableList.of((Object)flatfish, (Object)fishBoneMeal)));
            LootPool.Builder moki = this.lootingPool((IItemProvider)SkiesItems.charscale_moki, 1, 1, 0, 0).func_212841_b_((ILootFunction.IBuilder)this.smeltItem(field_218586_a));
            this.func_218582_a(SkiesEntityTypes.CHARSCALE_MOKI, this.tableOf((List)ImmutableList.of((Object)moki, (Object)fishBoneMeal)));
            this.func_218582_a(SkiesEntityTypes.INFESTED_SWARMER, this.tableOf(bugGuts));
            LootPool.Builder tunid = this.lootingPool((IItemProvider)SkiesItems.horizofin_tunid, 1, 1, 0, 0).func_212841_b_((ILootFunction.IBuilder)this.smeltItem(field_218586_a));
            this.func_218582_a(SkiesEntityTypes.HORIZOFIN_TUNID, this.tableOf((List)ImmutableList.of((Object)tunid, (Object)fishBoneMeal)));
            this.func_218582_a(SkiesEntityTypes.SECLAM, LootTable.func_216119_b());
        }

        private LootTable.Builder ramLootTable(IItemProvider wool) {
            return LootTable.func_216119_b().func_216040_a(LootPool.func_216096_a().func_216046_a((IRandomRange)ConstantRange.func_215835_a((int)1)).func_216045_a((LootEntry.Builder)ItemLootEntry.func_216168_a((IItemProvider)wool))).func_216040_a(LootPool.func_216096_a().func_216046_a((IRandomRange)ConstantRange.func_215835_a((int)1)).func_216045_a((LootEntry.Builder)TableLootEntry.func_216171_a((ResourceLocation)SkiesEntityTypes.STARDUST_RAM.func_220348_g())));
        }

        private LootPool.Builder lootingPool(IItemProvider item, int min, int max, int minLooting, int maxLooting) {
            return this.basicPool(item, min, max).func_212841_b_((ILootFunction.IBuilder)LootingEnchantBonus.func_215915_a((RandomValueRange)RandomValueRange.func_215837_a((float)minLooting, (float)maxLooting)));
        }

        private String entityName(EntityType<?> entity) {
            return entity.getRegistryName().func_110623_a();
        }

        protected Iterable<EntityType<?>> getKnownEntities() {
            return ForgeRegistries.ENTITIES.getValues().stream().filter(e -> e.getRegistryName().func_110624_b().contains("blue_skies"))::iterator;
        }
    }

    private class ChestLoot
    implements Consumer<BiConsumer<ResourceLocation, LootTable.Builder>>,
    LootPoolUtil {
        private ChestLoot() {
        }

        @Override
        public void accept(BiConsumer<ResourceLocation, LootTable.Builder> consumer) {
            this.village(consumer);
            this.bunker(consumer);
            this.caveSpawner(consumer);
            this.blindingDungeon(consumer);
            this.natureDungeon(consumer);
            this.poisonDungeon(consumer);
        }

        private void village(BiConsumer<ResourceLocation, LootTable.Builder> consumer) {
            consumer.accept(VILLAGE_BIOME_CHESTS.get((Object)SkiesVillageBiomes.CALMING_SKIES), this.tableOf((List<LootPool.Builder>)ImmutableList.of((Object)this.poolOf((List<LootEntry.Builder<?>>)ImmutableList.of((Object)this.basicEntry((IItemProvider)Items.field_151166_bC, 1, 4).func_216086_a(1), (Object)this.basicEntry((IItemProvider)Items.field_151122_aG).func_216086_a(1), (Object)this.basicEntry((IItemProvider)SkiesItems.pyrope_gem, 1, 2).func_216086_a(2), (Object)this.basicEntry((IItemProvider)SkiesItems.brewberry, 1, 7).func_216086_a(5), (Object)this.basicEntry((IItemProvider)SkiesBlocks.polar_posy, 1, 2).func_216086_a(5), (Object)this.basicEntry((IItemProvider)SkiesBlocks.bluebright_sapling, 1, 2).func_216086_a(5))).func_216046_a((IRandomRange)RandomValueRange.func_215837_a((float)3.0f, (float)8.0f)))));
            consumer.accept(VILLAGE_BIOME_CHESTS.get((Object)SkiesVillageBiomes.BRIGHTLANDS), this.tableOf((List<LootPool.Builder>)ImmutableList.of((Object)this.poolOf((List<LootEntry.Builder<?>>)ImmutableList.of((Object)this.basicEntry((IItemProvider)Items.field_151166_bC, 1, 4).func_216086_a(1), (Object)this.basicEntry((IItemProvider)Items.field_151122_aG).func_216086_a(1), (Object)this.basicEntry((IItemProvider)SkiesItems.pyrope_gem, 1, 2).func_216086_a(2), (Object)this.basicEntry((IItemProvider)SkiesItems.pine_fruit, 1, 7).func_216086_a(5), (Object)this.basicEntry((IItemProvider)Items.field_151126_ay, 1, 2).func_216086_a(3), (Object)this.basicEntry((IItemProvider)SkiesBlocks.starlit_sapling, 1, 2).func_216086_a(5))).func_216046_a((IRandomRange)RandomValueRange.func_215837_a((float)3.0f, (float)8.0f)))));
            consumer.accept(VILLAGE_BIOME_CHESTS.get((Object)SkiesVillageBiomes.SLUSHLANDS), this.tableOf((List<LootPool.Builder>)ImmutableList.of((Object)this.poolOf((List<LootEntry.Builder<?>>)ImmutableList.of((Object)this.basicEntry((IItemProvider)Items.field_151166_bC, 1, 4).func_216086_a(1), (Object)this.basicEntry((IItemProvider)Items.field_151009_A).func_216086_a(1), (Object)this.basicEntry((IItemProvider)SkiesItems.pyrope_gem, 1, 2).func_216086_a(2), (Object)this.basicEntry((IItemProvider)SkiesItems.cooked_carabeef, 1, 6).func_216086_a(4), (Object)this.basicEntry((IItemProvider)SkiesBlocks.snowcap_pinhead, 1, 2).func_216086_a(5), (Object)this.basicEntry((IItemProvider)SkiesBlocks.snowcap_mushroom_block, 1, 2).func_216086_a(3))).func_216046_a((IRandomRange)RandomValueRange.func_215837_a((float)3.0f, (float)8.0f)))));
            consumer.accept(VILLAGE_BIOME_CHESTS.get((Object)SkiesVillageBiomes.SHADED_WOODLANDS), this.tableOf((List<LootPool.Builder>)ImmutableList.of((Object)this.poolOf((List<LootEntry.Builder<?>>)ImmutableList.of((Object)this.basicEntry((IItemProvider)Items.field_151166_bC, 1, 4).func_216086_a(1), (Object)this.basicEntry((IItemProvider)Items.field_151122_aG).func_216086_a(1), (Object)this.basicEntry((IItemProvider)SkiesItems.pyrope_gem, 1, 2).func_216086_a(2), (Object)this.basicEntry((IItemProvider)SkiesItems.crescent_fruit, 1, 7).func_216086_a(5), (Object)this.basicEntry((IItemProvider)SkiesBlocks.baneful_mushroom, 1, 2).func_216086_a(5), (Object)this.basicEntry((IItemProvider)SkiesBlocks.dusk_sapling, 1, 2).func_216086_a(5))).func_216046_a((IRandomRange)RandomValueRange.func_215837_a((float)3.0f, (float)8.0f)))));
            consumer.accept(VILLAGE_BIOME_CHESTS.get((Object)SkiesVillageBiomes.SUNSET_MAPLE_FOREST), this.tableOf((List<LootPool.Builder>)ImmutableList.of((Object)this.poolOf((List<LootEntry.Builder<?>>)ImmutableList.of((Object)this.basicEntry((IItemProvider)Items.field_151166_bC, 1, 4).func_216086_a(1), (Object)this.basicEntry((IItemProvider)Items.field_151122_aG).func_216086_a(1), (Object)this.basicEntry((IItemProvider)SkiesItems.pyrope_gem, 1, 2).func_216086_a(2), (Object)this.basicEntry((IItemProvider)SkiesItems.cooked_monitor_tail, 1, 7).func_216086_a(5), (Object)this.basicEntry((IItemProvider)SkiesBlocks.blaze_bud, 1, 2).func_216086_a(5), (Object)this.basicEntry((IItemProvider)SkiesBlocks.maple_sapling, 1, 2).func_216086_a(5))).func_216046_a((IRandomRange)RandomValueRange.func_215837_a((float)3.0f, (float)8.0f)))));
            consumer.accept(VILLAGE_BIOME_CHESTS.get((Object)SkiesVillageBiomes.CRYSTAL_DUNES), this.tableOf((List<LootPool.Builder>)ImmutableList.of((Object)this.poolOf((List<LootEntry.Builder<?>>)ImmutableList.of((Object)this.basicEntry((IItemProvider)Items.field_151166_bC, 1, 4).func_216086_a(1), (Object)this.basicEntry((IItemProvider)Items.field_151122_aG).func_216086_a(1), (Object)this.basicEntry((IItemProvider)SkiesItems.pyrope_gem, 1, 2).func_216086_a(2), (Object)this.basicEntry((IItemProvider)SkiesItems.scalefruit, 1, 6).func_216086_a(4), (Object)this.basicEntry((IItemProvider)SkiesBlocks.crystal_flower, 1, 2).func_216086_a(5), (Object)this.basicEntry((IItemProvider)SkiesBlocks.crystallized_planks, 1, 2).func_216086_a(3))).func_216046_a((IRandomRange)RandomValueRange.func_215837_a((float)3.0f, (float)8.0f)))));
            for (Pair pair : Arrays.asList(Pair.of((Object)true, VILLAGE_EVERBRIGHT_PROFESSIONS), Pair.of((Object)false, VILLAGE_EVERDAWN_PROFESSIONS))) {
                boolean everbright = (Boolean)pair.getFirst();
                EnumMap map = (EnumMap)pair.getSecond();
                consumer.accept((ResourceLocation)map.get((Object)SkiesVillageProfessions.LIBRARY), this.tableOf((List<LootPool.Builder>)ImmutableList.of((Object)this.poolOf((List<LootEntry.Builder<?>>)ImmutableList.of((Object)this.basicEntry((IItemProvider)Items.field_151166_bC, 1, 4).func_216086_a(1), (Object)this.basicEntry((IItemProvider)Items.field_151122_aG).func_216086_a(4), (Object)this.basicEntry((IItemProvider)Items.field_151121_aF, 1, 4).func_216086_a(5), (Object)this.basicEntry((IItemProvider)Items.field_151008_G).func_216086_a(2), (Object)this.basicEntry((IItemProvider)Items.field_222086_lz).func_216086_a(2))).func_216046_a((IRandomRange)RandomValueRange.func_215837_a((float)3.0f, (float)8.0f)))));
                consumer.accept((ResourceLocation)map.get((Object)SkiesVillageProfessions.TANNERY), LootTable.func_216119_b().func_216040_a(LootPool.func_216096_a().func_216046_a((IRandomRange)RandomValueRange.func_215837_a((float)1.0f, (float)5.0f)).func_216045_a((LootEntry.Builder)ItemLootEntry.func_216168_a((IItemProvider)Items.field_151116_aA).func_216086_a(1).func_212841_b_((ILootFunction.IBuilder)SetCount.func_215932_a((IRandomRange)RandomValueRange.func_215837_a((float)1.0f, (float)3.0f)))).func_216045_a((LootEntry.Builder)ItemLootEntry.func_216168_a((IItemProvider)Items.field_151027_R).func_216086_a(2)).func_216045_a((LootEntry.Builder)ItemLootEntry.func_216168_a((IItemProvider)Items.field_151021_T).func_216086_a(2)).func_216045_a((LootEntry.Builder)ItemLootEntry.func_216168_a((IItemProvider)Items.field_151024_Q).func_216086_a(2)).func_216045_a((LootEntry.Builder)ItemLootEntry.func_216168_a((IItemProvider)(everbright ? SkiesItems.pine_fruit : SkiesItems.scalefruit)).func_216086_a(5).func_212841_b_((ILootFunction.IBuilder)SetCount.func_215932_a((IRandomRange)RandomValueRange.func_215837_a((float)1.0f, (float)4.0f)))).func_216045_a((LootEntry.Builder)ItemLootEntry.func_216168_a((IItemProvider)Items.field_151026_S).func_216086_a(2)).func_216045_a((LootEntry.Builder)ItemLootEntry.func_216168_a((IItemProvider)Items.field_151141_av).func_216086_a(1)).func_216045_a((LootEntry.Builder)ItemLootEntry.func_216168_a((IItemProvider)Items.field_151166_bC).func_216086_a(1).func_212841_b_((ILootFunction.IBuilder)SetCount.func_215932_a((IRandomRange)RandomValueRange.func_215837_a((float)1.0f, (float)4.0f))))));
                consumer.accept((ResourceLocation)map.get((Object)SkiesVillageProfessions.FARM), this.tableOf((List<LootPool.Builder>)ImmutableList.of((Object)this.poolOf((List<LootEntry.Builder<?>>)ImmutableList.of((Object)this.basicEntry((IItemProvider)Items.field_151166_bC, 1, 3).func_216086_a(1), (Object)this.basicEntry((IItemProvider)(everbright ? SkiesItems.winter_leaf_seeds : SkiesItems.fiery_bean_seeds)).func_216086_a(6), (Object)this.basicEntry((IItemProvider)Items.field_196106_bc, 1, 4).func_216086_a(4), (Object)this.basicEntry((IItemProvider)(everbright ? SkiesItems.bluebright_hoe : SkiesItems.lunar_hoe)).func_212841_b_(this.setStick(everbright ? SkiesItems.starlit_stick : SkiesItems.dusk_stick)).func_216086_a(1))).func_216046_a((IRandomRange)RandomValueRange.func_215837_a((float)3.0f, (float)8.0f)))));
                consumer.accept((ResourceLocation)map.get((Object)SkiesVillageProfessions.SHEPHERD), LootTable.func_216119_b().func_216040_a(LootPool.func_216096_a().func_216046_a((IRandomRange)RandomValueRange.func_215837_a((float)1.0f, (float)5.0f)).func_216045_a((LootEntry.Builder)ItemLootEntry.func_216168_a((IItemProvider)Blocks.field_196556_aL).func_216086_a(6).func_212841_b_((ILootFunction.IBuilder)SetCount.func_215932_a((IRandomRange)RandomValueRange.func_215837_a((float)1.0f, (float)8.0f)))).func_216045_a((LootEntry.Builder)ItemLootEntry.func_216168_a((IItemProvider)Blocks.field_196602_ba).func_216086_a(3).func_212841_b_((ILootFunction.IBuilder)SetCount.func_215932_a((IRandomRange)RandomValueRange.func_215837_a((float)1.0f, (float)3.0f)))).func_216045_a((LootEntry.Builder)ItemLootEntry.func_216168_a((IItemProvider)Blocks.field_196563_aS).func_216086_a(2).func_212841_b_((ILootFunction.IBuilder)SetCount.func_215932_a((IRandomRange)RandomValueRange.func_215837_a((float)1.0f, (float)3.0f)))).func_216045_a((LootEntry.Builder)ItemLootEntry.func_216168_a((IItemProvider)Blocks.field_196568_aX).func_216086_a(2).func_212841_b_((ILootFunction.IBuilder)SetCount.func_215932_a((IRandomRange)RandomValueRange.func_215837_a((float)1.0f, (float)3.0f)))).func_216045_a((LootEntry.Builder)ItemLootEntry.func_216168_a((IItemProvider)Blocks.field_196564_aT).func_216086_a(2).func_212841_b_((ILootFunction.IBuilder)SetCount.func_215932_a((IRandomRange)RandomValueRange.func_215837_a((float)1.0f, (float)3.0f)))).func_216045_a((LootEntry.Builder)ItemLootEntry.func_216168_a((IItemProvider)Items.field_151166_bC).func_216086_a(1)).func_216045_a((LootEntry.Builder)ItemLootEntry.func_216168_a((IItemProvider)SkiesItems.ventium_shears).func_216086_a(1)).func_216045_a((LootEntry.Builder)ItemLootEntry.func_216168_a((IItemProvider)(everbright ? SkiesItems.pine_fruit : Items.field_151015_O)).func_216086_a(6).func_212841_b_((ILootFunction.IBuilder)SetCount.func_215932_a((IRandomRange)RandomValueRange.func_215837_a((float)1.0f, (float)6.0f))))));
                consumer.accept((ResourceLocation)map.get((Object)SkiesVillageProfessions.FISHER), LootTable.func_216119_b().func_216040_a(LootPool.func_216096_a().func_216046_a((IRandomRange)RandomValueRange.func_215837_a((float)1.0f, (float)5.0f)).func_216045_a((LootEntry.Builder)ItemLootEntry.func_216168_a((IItemProvider)Items.field_151166_bC).func_216086_a(1)).func_216045_a((LootEntry.Builder)ItemLootEntry.func_216168_a((IItemProvider)(everbright ? SkiesItems.municipal_monkfish : SkiesItems.horizofin_tunid)).func_216086_a(2).func_212841_b_((ILootFunction.IBuilder)SetCount.func_215932_a((IRandomRange)RandomValueRange.func_215837_a((float)1.0f, (float)3.0f)))).func_216045_a((LootEntry.Builder)ItemLootEntry.func_216168_a((IItemProvider)(everbright ? SkiesItems.grittle_flatfish : SkiesItems.charscale_moki)).func_216086_a(1).func_212841_b_((ILootFunction.IBuilder)SetCount.func_215932_a((IRandomRange)RandomValueRange.func_215837_a((float)1.0f, (float)3.0f)))).func_216045_a((LootEntry.Builder)ItemLootEntry.func_216168_a((IItemProvider)SkiesItems.ventium_water_bucket).func_216086_a(1).func_212841_b_((ILootFunction.IBuilder)SetCount.func_215932_a((IRandomRange)RandomValueRange.func_215837_a((float)1.0f, (float)3.0f)))).func_216045_a((LootEntry.Builder)ItemLootEntry.func_216168_a((IItemProvider)Items.field_222100_pG).func_216086_a(1).func_212841_b_((ILootFunction.IBuilder)SetCount.func_215932_a((IRandomRange)RandomValueRange.func_215837_a((float)1.0f, (float)3.0f)))).func_216045_a((LootEntry.Builder)ItemLootEntry.func_216168_a((IItemProvider)(everbright ? SkiesItems.winter_leaf_seeds : SkiesItems.fiery_bean_seeds)).func_216086_a(3).func_212841_b_((ILootFunction.IBuilder)SetCount.func_215932_a((IRandomRange)RandomValueRange.func_215837_a((float)1.0f, (float)3.0f)))).func_216045_a((LootEntry.Builder)ItemLootEntry.func_216168_a((IItemProvider)Items.field_196155_l).func_216086_a(2).func_212841_b_((ILootFunction.IBuilder)SetCount.func_215932_a((IRandomRange)RandomValueRange.func_215837_a((float)1.0f, (float)3.0f))))));
                consumer.accept((ResourceLocation)map.get((Object)SkiesVillageProfessions.BUTCHER), LootTable.func_216119_b().func_216040_a(LootPool.func_216096_a().func_216046_a((IRandomRange)RandomValueRange.func_215837_a((float)1.0f, (float)5.0f)).func_216045_a((LootEntry.Builder)ItemLootEntry.func_216168_a((IItemProvider)Items.field_151166_bC).func_216086_a(1)).func_216045_a((LootEntry.Builder)ItemLootEntry.func_216168_a((IItemProvider)(everbright ? SkiesItems.carabeef : SkiesItems.monitor_tail)).func_216086_a(6).func_212841_b_((ILootFunction.IBuilder)SetCount.func_215932_a((IRandomRange)RandomValueRange.func_215837_a((float)1.0f, (float)3.0f)))).func_216045_a((LootEntry.Builder)ItemLootEntry.func_216168_a((IItemProvider)(everbright ? SkiesItems.pine_fruit : SkiesItems.scalefruit)).func_216086_a(6).func_212841_b_((ILootFunction.IBuilder)SetCount.func_215932_a((IRandomRange)RandomValueRange.func_215837_a((float)1.0f, (float)3.0f)))).func_216045_a((LootEntry.Builder)ItemLootEntry.func_216168_a((IItemProvider)(everbright ? SkiesItems.brewberry : SkiesItems.crescent_fruit)).func_216086_a(6).func_212841_b_((ILootFunction.IBuilder)SetCount.func_215932_a((IRandomRange)RandomValueRange.func_215837_a((float)1.0f, (float)3.0f)))).func_216045_a((LootEntry.Builder)ItemLootEntry.func_216168_a((IItemProvider)(everbright ? SkiesItems.venison : Items.field_196087_aX)).func_216086_a(6).func_212841_b_((ILootFunction.IBuilder)SetCount.func_215932_a((IRandomRange)RandomValueRange.func_215837_a((float)1.0f, (float)3.0f)))).func_216045_a((LootEntry.Builder)ItemLootEntry.func_216168_a((IItemProvider)Items.field_196155_l).func_216086_a(3).func_212841_b_((ILootFunction.IBuilder)SetCount.func_215932_a((IRandomRange)RandomValueRange.func_215837_a((float)1.0f, (float)3.0f))))));
                consumer.accept((ResourceLocation)map.get((Object)SkiesVillageProfessions.ARMORER), LootTable.func_216119_b().func_216040_a(LootPool.func_216096_a().func_216046_a((IRandomRange)RandomValueRange.func_215837_a((float)1.0f, (float)5.0f)).func_216045_a((LootEntry.Builder)ItemLootEntry.func_216168_a((IItemProvider)SkiesItems.aquite_gem).func_216086_a(2).func_212841_b_((ILootFunction.IBuilder)SetCount.func_215932_a((IRandomRange)RandomValueRange.func_215837_a((float)1.0f, (float)3.0f)))).func_216045_a((LootEntry.Builder)ItemLootEntry.func_216168_a((IItemProvider)(everbright ? SkiesItems.brewberry : SkiesItems.crescent_fruit)).func_216086_a(4).func_212841_b_((ILootFunction.IBuilder)SetCount.func_215932_a((IRandomRange)RandomValueRange.func_215837_a((float)1.0f, (float)4.0f)))).func_216045_a((LootEntry.Builder)ItemLootEntry.func_216168_a((IItemProvider)SkiesItems.aquite_helmet).func_216086_a(1)).func_216045_a((LootEntry.Builder)ItemLootEntry.func_216168_a((IItemProvider)Items.field_151166_bC).func_216086_a(1))));
                consumer.accept((ResourceLocation)map.get((Object)SkiesVillageProfessions.CARTOGRAPHER), LootTable.func_216119_b().func_216040_a(LootPool.func_216096_a().func_216046_a((IRandomRange)RandomValueRange.func_215837_a((float)1.0f, (float)5.0f)).func_216045_a((LootEntry.Builder)ItemLootEntry.func_216168_a((IItemProvider)Items.field_151148_bJ).func_216086_a(10).func_212841_b_((ILootFunction.IBuilder)SetCount.func_215932_a((IRandomRange)RandomValueRange.func_215837_a((float)1.0f, (float)3.0f)))).func_216045_a((LootEntry.Builder)ItemLootEntry.func_216168_a((IItemProvider)Items.field_151121_aF).func_216086_a(15).func_212841_b_((ILootFunction.IBuilder)SetCount.func_215932_a((IRandomRange)RandomValueRange.func_215837_a((float)1.0f, (float)5.0f)))).func_216045_a((LootEntry.Builder)ItemLootEntry.func_216168_a((IItemProvider)Items.field_151111_aL).func_216086_a(5)).func_216045_a((LootEntry.Builder)ItemLootEntry.func_216168_a((IItemProvider)(everbright ? SkiesItems.pine_fruit : SkiesItems.scalefruit)).func_216086_a(15).func_212841_b_((ILootFunction.IBuilder)SetCount.func_215932_a((IRandomRange)RandomValueRange.func_215837_a((float)1.0f, (float)4.0f)))).func_216045_a((LootEntry.Builder)ItemLootEntry.func_216168_a((IItemProvider)(everbright ? SkiesItems.bluebright_stick : SkiesItems.lunar_stick)).func_216086_a(5).func_212841_b_((ILootFunction.IBuilder)SetCount.func_215932_a((IRandomRange)RandomValueRange.func_215837_a((float)1.0f, (float)2.0f))))));
                consumer.accept((ResourceLocation)map.get((Object)SkiesVillageProfessions.FLETCHER), LootTable.func_216119_b().func_216040_a(LootPool.func_216096_a().func_216046_a((IRandomRange)RandomValueRange.func_215837_a((float)1.0f, (float)5.0f)).func_216045_a((LootEntry.Builder)ItemLootEntry.func_216168_a((IItemProvider)Items.field_151166_bC).func_216086_a(1)).func_216045_a((LootEntry.Builder)ItemLootEntry.func_216168_a((IItemProvider)Items.field_151032_g).func_216086_a(3).func_212841_b_((ILootFunction.IBuilder)SetCount.func_215932_a((IRandomRange)RandomValueRange.func_215837_a((float)1.0f, (float)3.0f)))).func_216045_a((LootEntry.Builder)ItemLootEntry.func_216168_a((IItemProvider)Items.field_151008_G).func_216086_a(8).func_212841_b_((ILootFunction.IBuilder)SetCount.func_215932_a((IRandomRange)RandomValueRange.func_215837_a((float)1.0f, (float)3.0f)))).func_216045_a((LootEntry.Builder)ItemLootEntry.func_216168_a((IItemProvider)Items.field_151145_ak).func_216086_a(8).func_212841_b_((ILootFunction.IBuilder)SetCount.func_215932_a((IRandomRange)RandomValueRange.func_215837_a((float)1.0f, (float)3.0f)))).func_216045_a((LootEntry.Builder)ItemLootEntry.func_216168_a((IItemProvider)(everbright ? SkiesItems.bluebright_stick : SkiesItems.lunar_stick)).func_216086_a(7).func_212841_b_((ILootFunction.IBuilder)SetCount.func_215932_a((IRandomRange)RandomValueRange.func_215837_a((float)1.0f, (float)3.0f))))));
                consumer.accept((ResourceLocation)map.get((Object)SkiesVillageProfessions.WEAPONSMITH), LootTable.func_216119_b().func_216040_a(LootPool.func_216096_a().func_216046_a((IRandomRange)RandomValueRange.func_215837_a((float)3.0f, (float)8.0f)).func_216045_a((LootEntry.Builder)ItemLootEntry.func_216168_a((IItemProvider)SkiesItems.diopside_gem).func_216086_a(3).func_212841_b_((ILootFunction.IBuilder)SetCount.func_215932_a((IRandomRange)RandomValueRange.func_215837_a((float)1.0f, (float)3.0f)))).func_216045_a((LootEntry.Builder)ItemLootEntry.func_216168_a((IItemProvider)SkiesItems.aquite_gem).func_216086_a(10).func_212841_b_((ILootFunction.IBuilder)SetCount.func_215932_a((IRandomRange)RandomValueRange.func_215837_a((float)1.0f, (float)5.0f)))).func_216045_a((LootEntry.Builder)ItemLootEntry.func_216168_a((IItemProvider)(everbright ? SkiesItems.falsite_ingot : SkiesItems.horizonite_ingot)).func_216086_a(5).func_212841_b_((ILootFunction.IBuilder)SetCount.func_215932_a((IRandomRange)RandomValueRange.func_215837_a((float)1.0f, (float)3.0f)))).func_216045_a((LootEntry.Builder)ItemLootEntry.func_216168_a((IItemProvider)(everbright ? SkiesItems.pine_fruit : SkiesItems.scalefruit)).func_216086_a(15).func_212841_b_((ILootFunction.IBuilder)SetCount.func_215932_a((IRandomRange)RandomValueRange.func_215837_a((float)1.0f, (float)3.0f)))).func_216045_a((LootEntry.Builder)ItemLootEntry.func_216168_a((IItemProvider)(everbright ? SkiesItems.brewberry : SkiesItems.crescent_fruit)).func_216086_a(15).func_212841_b_((ILootFunction.IBuilder)SetCount.func_215932_a((IRandomRange)RandomValueRange.func_215837_a((float)1.0f, (float)3.0f)))).func_216045_a((LootEntry.Builder)ItemLootEntry.func_216168_a((IItemProvider)SkiesItems.aquite_axe).func_212841_b_(this.setStick(everbright ? SkiesItems.starlit_stick : SkiesItems.dusk_stick)).func_216086_a(5)).func_216045_a((LootEntry.Builder)ItemLootEntry.func_216168_a((IItemProvider)SkiesItems.aquite_sword).func_212841_b_(this.setStick(everbright ? SkiesItems.starlit_stick : SkiesItems.dusk_stick)).func_216086_a(5)).func_216045_a((LootEntry.Builder)ItemLootEntry.func_216168_a((IItemProvider)SkiesItems.aquite_chestplate).func_216086_a(5)).func_216045_a((LootEntry.Builder)ItemLootEntry.func_216168_a((IItemProvider)SkiesItems.aquite_helmet).func_216086_a(5)).func_216045_a((LootEntry.Builder)ItemLootEntry.func_216168_a((IItemProvider)SkiesItems.aquite_leggings).func_216086_a(5)).func_216045_a((LootEntry.Builder)ItemLootEntry.func_216168_a((IItemProvider)SkiesItems.aquite_boots).func_216086_a(5)).func_216045_a((LootEntry.Builder)ItemLootEntry.func_216168_a((IItemProvider)Blocks.field_150343_Z).func_216086_a(5).func_212841_b_((ILootFunction.IBuilder)SetCount.func_215932_a((IRandomRange)RandomValueRange.func_215837_a((float)3.0f, (float)7.0f)))).func_216045_a((LootEntry.Builder)ItemLootEntry.func_216168_a((IItemProvider)(everbright ? SkiesBlocks.starlit_sapling : SkiesBlocks.dusk_sapling)).func_216086_a(5).func_212841_b_((ILootFunction.IBuilder)SetCount.func_215932_a((IRandomRange)RandomValueRange.func_215837_a((float)3.0f, (float)7.0f)))).func_216045_a((LootEntry.Builder)ItemLootEntry.func_216168_a((IItemProvider)(everbright ? Items.field_151141_av : SkiesItems.camel_saddle)).func_216086_a(3))));
                consumer.accept((ResourceLocation)map.get((Object)SkiesVillageProfessions.TOOLSMITH), LootTable.func_216119_b().func_216040_a(LootPool.func_216096_a().func_216046_a((IRandomRange)RandomValueRange.func_215837_a((float)3.0f, (float)8.0f)).func_216045_a((LootEntry.Builder)ItemLootEntry.func_216168_a((IItemProvider)SkiesItems.diopside_gem).func_216086_a(1).func_212841_b_((ILootFunction.IBuilder)SetCount.func_215932_a((IRandomRange)RandomValueRange.func_215837_a((float)1.0f, (float)3.0f)))).func_216045_a((LootEntry.Builder)ItemLootEntry.func_216168_a((IItemProvider)SkiesItems.aquite_gem).func_216086_a(5).func_212841_b_((ILootFunction.IBuilder)SetCount.func_215932_a((IRandomRange)RandomValueRange.func_215837_a((float)1.0f, (float)5.0f)))).func_216045_a((LootEntry.Builder)ItemLootEntry.func_216168_a((IItemProvider)(everbright ? SkiesItems.falsite_ingot : SkiesItems.horizonite_ingot)).func_216086_a(1).func_212841_b_((ILootFunction.IBuilder)SetCount.func_215932_a((IRandomRange)RandomValueRange.func_215837_a((float)1.0f, (float)3.0f)))).func_216045_a((LootEntry.Builder)ItemLootEntry.func_216168_a((IItemProvider)(everbright ? SkiesItems.pine_fruit : SkiesItems.scalefruit)).func_216086_a(15).func_212841_b_((ILootFunction.IBuilder)SetCount.func_215932_a((IRandomRange)RandomValueRange.func_215837_a((float)1.0f, (float)3.0f)))).func_216045_a((LootEntry.Builder)ItemLootEntry.func_216168_a((IItemProvider)SkiesItems.aquite_pickaxe).func_212841_b_(this.setStick(everbright ? SkiesItems.frostbright_stick : SkiesItems.maple_stick)).func_216086_a(5)).func_216045_a((LootEntry.Builder)ItemLootEntry.func_216168_a((IItemProvider)Items.field_196155_l).func_216086_a(1).func_212841_b_((ILootFunction.IBuilder)SetCount.func_215932_a((IRandomRange)RandomValueRange.func_215837_a((float)1.0f, (float)3.0f)))).func_216045_a((LootEntry.Builder)ItemLootEntry.func_216168_a((IItemProvider)(everbright ? SkiesItems.frostbright_stick : SkiesItems.maple_stick)).func_216086_a(20).func_212841_b_((ILootFunction.IBuilder)SetCount.func_215932_a((IRandomRange)RandomValueRange.func_215837_a((float)1.0f, (float)3.0f)))).func_216045_a((LootEntry.Builder)ItemLootEntry.func_216168_a((IItemProvider)SkiesItems.aquite_shovel).func_212841_b_(this.setStick(everbright ? SkiesItems.frostbright_stick : SkiesItems.maple_stick)).func_216086_a(5))));
                consumer.accept((ResourceLocation)map.get((Object)SkiesVillageProfessions.MASON), LootTable.func_216119_b().func_216040_a(LootPool.func_216096_a().func_216046_a((IRandomRange)RandomValueRange.func_215837_a((float)1.0f, (float)5.0f)).func_216045_a((LootEntry.Builder)ItemLootEntry.func_216168_a((IItemProvider)Items.field_151119_aD).func_216086_a(1).func_212841_b_((ILootFunction.IBuilder)SetCount.func_215932_a((IRandomRange)RandomValueRange.func_215837_a((float)1.0f, (float)3.0f)))).func_216045_a((LootEntry.Builder)ItemLootEntry.func_216168_a((IItemProvider)Items.field_222087_nH).func_216086_a(1)).func_216045_a((LootEntry.Builder)ItemLootEntry.func_216168_a((IItemProvider)(everbright ? SkiesBlocks.turquoise_stone : SkiesBlocks.lunar_stone)).func_216086_a(2)).func_216045_a((LootEntry.Builder)ItemLootEntry.func_216168_a((IItemProvider)(everbright ? SkiesBlocks.turquoise_stonebrick : SkiesBlocks.lunar_stonebrick)).func_216086_a(2)).func_216045_a((LootEntry.Builder)ItemLootEntry.func_216168_a((IItemProvider)(everbright ? SkiesItems.pine_fruit : SkiesItems.scalefruit)).func_216086_a(4).func_212841_b_((ILootFunction.IBuilder)SetCount.func_215932_a((IRandomRange)RandomValueRange.func_215837_a((float)1.0f, (float)4.0f)))).func_216045_a((LootEntry.Builder)ItemLootEntry.func_216168_a((IItemProvider)(everbright ? Items.field_222069_lA : Items.field_222078_li)).func_216086_a(1)).func_216045_a((LootEntry.Builder)ItemLootEntry.func_216168_a((IItemProvider)(everbright ? SkiesBlocks.taratite : SkiesBlocks.umber)).func_216086_a(1)).func_216045_a((LootEntry.Builder)ItemLootEntry.func_216168_a((IItemProvider)Items.field_151166_bC).func_216086_a(1))));
                consumer.accept((ResourceLocation)map.get((Object)SkiesVillageProfessions.TEMPLE), LootTable.func_216119_b().func_216040_a(LootPool.func_216096_a().func_216046_a((IRandomRange)RandomValueRange.func_215837_a((float)3.0f, (float)8.0f)).func_216045_a((LootEntry.Builder)ItemLootEntry.func_216168_a((IItemProvider)Items.field_151137_ax).func_216086_a(2).func_212841_b_((ILootFunction.IBuilder)SetCount.func_215932_a((IRandomRange)RandomValueRange.func_215837_a((float)1.0f, (float)4.0f)))).func_216045_a((LootEntry.Builder)ItemLootEntry.func_216168_a((IItemProvider)(everbright ? SkiesItems.pine_fruit : SkiesItems.scalefruit)).func_216086_a(7).func_212841_b_((ILootFunction.IBuilder)SetCount.func_215932_a((IRandomRange)RandomValueRange.func_215837_a((float)1.0f, (float)4.0f)))).func_216045_a((LootEntry.Builder)ItemLootEntry.func_216168_a((IItemProvider)SkiesItems.soul_fragment).func_216086_a(7).func_212841_b_((ILootFunction.IBuilder)SetCount.func_215932_a((IRandomRange)RandomValueRange.func_215837_a((float)1.0f, (float)4.0f)))).func_216045_a((LootEntry.Builder)ItemLootEntry.func_216168_a((IItemProvider)SkiesItems.ventium_ingot).func_216086_a(1).func_212841_b_((ILootFunction.IBuilder)SetCount.func_215932_a((IRandomRange)RandomValueRange.func_215837_a((float)1.0f, (float)4.0f)))).func_216045_a((LootEntry.Builder)ItemLootEntry.func_216168_a((IItemProvider)SkiesItems.falsite_ingot).func_216086_a(1).func_212841_b_((ILootFunction.IBuilder)SetCount.func_215932_a((IRandomRange)RandomValueRange.func_215837_a((float)1.0f, (float)4.0f)))).func_216045_a((LootEntry.Builder)ItemLootEntry.func_216168_a((IItemProvider)Items.field_151166_bC).func_216086_a(1).func_212841_b_((ILootFunction.IBuilder)SetCount.func_215932_a((IRandomRange)RandomValueRange.func_215837_a((float)1.0f, (float)4.0f))))));
                consumer.accept((ResourceLocation)map.get((Object)SkiesVillageProfessions.STARGAZER), this.tableOf((List<LootPool.Builder>)ImmutableList.of((Object)this.poolOf((List<LootEntry.Builder<?>>)ImmutableList.of((Object)this.basicEntry((IItemProvider)Items.field_151166_bC, 1, 4).func_216086_a(1), (Object)this.basicEntry((IItemProvider)SkiesBlocks.star_flare, 1, 2).func_216086_a(2), (Object)this.basicEntry((IItemProvider)Items.field_151122_aG).func_216086_a(4), (Object)this.basicEntry((IItemProvider)Items.field_151121_aF, 1, 4).func_216086_a(6), (Object)this.basicEntry((IItemProvider)Blocks.field_150359_w, 1, 2).func_216086_a(4), (Object)this.basicEntry((IItemProvider)SkiesItems.falsite_ingot).func_216086_a(1))).func_216046_a((IRandomRange)RandomValueRange.func_215837_a((float)3.0f, (float)8.0f)))));
                consumer.accept((ResourceLocation)map.get((Object)SkiesVillageProfessions.WRANGLER), this.tableOf((List<LootPool.Builder>)ImmutableList.of((Object)this.poolOf((List<LootEntry.Builder<?>>)ImmutableList.of((Object)this.basicEntry((IItemProvider)Items.field_151166_bC, 1, 4).func_216086_a(1), (Object)this.basicEntry((IItemProvider)Items.field_151058_ca).func_216086_a(3), (Object)this.basicEntry((IItemProvider)(everbright ? SkiesItems.azulfo_horn : SkiesItems.fox_pelt)).func_216086_a(4), (Object)this.basicEntry((IItemProvider)(everbright ? SkiesItems.pine_fruit : SkiesItems.scalefruit), 1, 2).func_216086_a(6), (Object)this.basicEntry((IItemProvider)Items.field_196155_l).func_216086_a(3))).func_216046_a((IRandomRange)RandomValueRange.func_215837_a((float)3.0f, (float)8.0f)))));
                consumer.accept((ResourceLocation)map.get((Object)SkiesVillageProfessions.SHOVELER), this.tableOf((List<LootPool.Builder>)ImmutableList.of((Object)this.poolOf((List<LootEntry.Builder<?>>)ImmutableList.of((Object)this.basicEntry((IItemProvider)Items.field_151166_bC, 1, 4).func_216086_a(1), (Object)this.basicEntry((IItemProvider)SkiesItems.aquite_shovel).func_212841_b_(this.setStick(everbright ? SkiesItems.frostbright_stick : SkiesItems.maple_stick)).func_216086_a(2), (Object)this.basicEntry((IItemProvider)SkiesItems.falsite_ingot).func_216086_a(1), (Object)this.basicEntry((IItemProvider)(everbright ? SkiesItems.frostbright_stick : SkiesItems.maple_stick), 1, 2).func_216086_a(4), (Object)this.basicEntry((IItemProvider)Items.field_151126_ay, 1, 2).func_216086_a(6))).func_216046_a((IRandomRange)RandomValueRange.func_215837_a((float)3.0f, (float)8.0f)))));
                consumer.accept((ResourceLocation)map.get((Object)SkiesVillageProfessions.NIGHTWATCHER), this.tableOf((List<LootPool.Builder>)ImmutableList.of((Object)this.poolOf((List<LootEntry.Builder<?>>)ImmutableList.of((Object)this.basicEntry((IItemProvider)Items.field_151166_bC, 2, 5).func_216086_a(1), (Object)this.basicEntry((IItemProvider)(everbright ? SkiesItems.azulfo_horn : SkiesItems.fox_pelt)).func_216086_a(3), (Object)this.basicEntry((IItemProvider)SkiesItems.fox_pelt).func_216086_a(2), (Object)this.basicEntry((IItemProvider)Items.field_151007_F, 1, 3).func_216086_a(4), (Object)this.basicEntry((IItemProvider)Items.field_196155_l, 1, 2).func_216086_a(3))).func_216046_a((IRandomRange)RandomValueRange.func_215837_a((float)3.0f, (float)8.0f)))));
            }
        }

        private void bunker(BiConsumer<ResourceLocation, LootTable.Builder> consumer) {
            StandaloneLootEntry.Builder<?> cabbageSeeds = this.basicEntry((IItemProvider)SkiesItems.winter_leaf_seeds);
            StandaloneLootEntry.Builder<?> cryoRoot = this.basicEntry((IItemProvider)SkiesItems.cryo_root, 1, 2);
            StandaloneLootEntry.Builder enchantedBook = this.basicEntry((IItemProvider)Items.field_151122_aG).func_212841_b_((ILootFunction.IBuilder)EnchantWithLevels.func_215895_a((IRandomRange)RandomValueRange.func_215837_a((float)7.0f, (float)12.0f)));
            StandaloneLootEntry.Builder<?> string = this.basicEntry((IItemProvider)Items.field_151007_F, 3, 5);
            consumer.accept(BUNKER, this.tableOf(this.poolOf((List<LootEntry.Builder<?>>)ImmutableList.of(cabbageSeeds, cryoRoot, (Object)enchantedBook, string)).func_216046_a((IRandomRange)RandomValueRange.func_215837_a((float)4.0f, (float)9.0f))));
            StandaloneLootEntry.Builder<?> falsite = this.basicEntry((IItemProvider)SkiesItems.falsite_ingot);
            StandaloneLootEntry.Builder<?> turquoiseGem = this.basicEntry((IItemProvider)SkiesItems.aquite_gem, 1, 3);
            StandaloneLootEntry.Builder<?> pyropeChestplate = this.basicEntry((IItemProvider)SkiesItems.pyrope_chestplate);
            StandaloneLootEntry.Builder<?> packedIce = this.basicEntry((IItemProvider)Items.field_221898_fg, 1, 4);
            StandaloneLootEntry.Builder enchantedBookRare = this.basicEntry((IItemProvider)Items.field_151122_aG).func_212841_b_((ILootFunction.IBuilder)EnchantWithLevels.func_215895_a((IRandomRange)RandomValueRange.func_215837_a((float)10.0f, (float)15.0f)));
            consumer.accept(BUNKER_RARE, this.tableOf(this.poolOf((List<LootEntry.Builder<?>>)ImmutableList.of(falsite, turquoiseGem, pyropeChestplate, packedIce, (Object)enchantedBookRare)).func_216046_a((IRandomRange)RandomValueRange.func_215837_a((float)4.0f, (float)9.0f))));
        }

        private void caveSpawner(BiConsumer<ResourceLocation, LootTable.Builder> consumer) {
            StandaloneLootEntry.Builder<?> aquite = this.basicEntry((IItemProvider)SkiesItems.aquite_gem, 1, 2);
            StandaloneLootEntry.Builder enchantedBook = this.basicEntry((IItemProvider)Items.field_151122_aG).func_212841_b_((ILootFunction.IBuilder)EnchantWithLevels.func_215895_a((IRandomRange)RandomValueRange.func_215837_a((float)3.0f, (float)6.0f)));
            StandaloneLootEntry.Builder<?> string = this.basicEntry((IItemProvider)Items.field_151007_F, 3, 5);
            StandaloneLootEntry.Builder<?> nameTag = this.basicEntry((IItemProvider)Items.field_151057_cb);
            StandaloneLootEntry.Builder<?> saddle = this.basicEntry((IItemProvider)Items.field_151141_av, 0, 1);
            StandaloneLootEntry.Builder<?> ventium = this.basicEntry((IItemProvider)SkiesItems.ventium_ingot);
            StandaloneLootEntry.Builder pyropePickaxeFrostbright = this.basicEntry((IItemProvider)SkiesItems.pyrope_pickaxe).func_212841_b_(this.setStick(SkiesItems.frostbright_stick)).func_212841_b_(this.setDamage(45, 90));
            StandaloneLootEntry.Builder<?> ice = this.basicEntry((IItemProvider)Blocks.field_150403_cj, 2, 3);
            StandaloneLootEntry.Builder<?> pinhead = this.basicEntry((IItemProvider)SkiesBlocks.snowcap_pinhead, 3, 5);
            StandaloneLootEntry.Builder<?> cryoRoot = this.basicEntry((IItemProvider)SkiesItems.cryo_root, 2, 3);
            consumer.accept(EVERBRIGHT_CAVE_SPAWNER, this.tableOf(this.poolOf((List<LootEntry.Builder<?>>)ImmutableList.of(ventium, aquite, (Object)pyropePickaxeFrostbright, string, ice, pinhead, cryoRoot, (Object)enchantedBook, nameTag, saddle)).func_216046_a((IRandomRange)RandomValueRange.func_215837_a((float)4.0f, (float)9.0f))));
            StandaloneLootEntry.Builder<?> horizonite = this.basicEntry((IItemProvider)SkiesItems.horizonite_ingot);
            StandaloneLootEntry.Builder pyropePickaxeMaple = this.basicEntry((IItemProvider)SkiesItems.pyrope_pickaxe).func_212841_b_(this.setStick(SkiesItems.maple_stick)).func_212841_b_(this.setDamage(45, 90));
            StandaloneLootEntry.Builder<?> webbing = this.basicEntry((IItemProvider)SkiesBlocks.spider_webbing, 2, 3);
            StandaloneLootEntry.Builder<?> scalefruitSeeds = this.basicEntry((IItemProvider)SkiesItems.scalefruit_seeds, 3, 5);
            consumer.accept(EVERDAWN_CAVE_SPAWNER, this.tableOf(this.poolOf((List<LootEntry.Builder<?>>)ImmutableList.of(horizonite, aquite, (Object)pyropePickaxeMaple, string, webbing, scalefruitSeeds, (Object)enchantedBook, nameTag, saddle)).func_216046_a((IRandomRange)RandomValueRange.func_215837_a((float)4.0f, (float)9.0f))));
        }

        private void blindingDungeon(BiConsumer<ResourceLocation, LootTable.Builder> consumer) {
            LootPool.Builder blindingKey = this.basicPool((IItemProvider)SkiesItems.blinding_key);
            LootPool.Builder gems = this.poolOf((List<LootEntry.Builder<?>>)ImmutableList.of((Object)this.basicEntry((IItemProvider)SkiesItems.pyrope_gem, 1, 3).func_216086_a(7), (Object)this.basicEntry((IItemProvider)SkiesItems.aquite_gem, 1, 3).func_216086_a(5), this.basicEntry((IItemProvider)SkiesItems.diopside_gem, 1, 3)));
            consumer.accept(BLINDING_STUDY, this.tableOf((List<LootPool.Builder>)ImmutableList.of((Object)blindingKey, (Object)gems)));
            LootPool.Builder paper = this.poolOf((List<LootEntry.Builder<?>>)ImmutableList.of((Object)this.basicEntry((IItemProvider)Items.field_151121_aF, 1, 3).func_216086_a(2), (Object)this.basicEntry((IItemProvider)Items.field_151122_aG).func_216086_a(3))).func_216046_a((IRandomRange)RandomValueRange.func_215837_a((float)5.0f, (float)11.0f));
            LootPool.Builder book = this.basicPool((IItemProvider)Items.field_151122_aG).func_212841_b_((ILootFunction.IBuilder)EnchantWithLevels.func_215895_a((IRandomRange)RandomValueRange.func_215837_a((float)10.0f, (float)16.0f))).func_216046_a((IRandomRange)RandomValueRange.func_215837_a((float)0.0f, (float)2.0f));
            consumer.accept(BLINDING_LIBRARY, this.tableOf((List<LootPool.Builder>)ImmutableList.of((Object)paper, (Object)book)));
            LootPool.Builder libraryChest = LootPool.func_216096_a().func_216045_a((LootEntry.Builder)TableLootEntry.func_216171_a((ResourceLocation)BLINDING_LIBRARY));
            consumer.accept(BLINDING_LIBRARY_KEY, this.tableOf((List<LootPool.Builder>)ImmutableList.of((Object)blindingKey, (Object)libraryChest)));
            LootPool.Builder brightBreadAndAxe = this.poolOf((List<LootEntry.Builder<?>>)ImmutableList.of((Object)this.basicEntry((IItemProvider)Items.field_151025_P, 1, 2).func_216086_a(3), (Object)this.basicEntry((IItemProvider)SkiesItems.aquite_axe).func_212841_b_(this.setStick(SkiesItems.bluebright_stick)).func_212841_b_(this.setDamage(83, 92))));
            consumer.accept(BLINDING_PRISON_EVERBRIGHT, this.tableOf((List<LootPool.Builder>)ImmutableList.of((Object)blindingKey, (Object)brightBreadAndAxe)));
            LootPool.Builder dawnBreadAndAxe = this.poolOf((List<LootEntry.Builder<?>>)ImmutableList.of((Object)this.basicEntry((IItemProvider)Items.field_151025_P, 1, 2).func_216086_a(3), (Object)this.basicEntry((IItemProvider)SkiesItems.aquite_axe).func_212841_b_(this.setStick(SkiesItems.lunar_stick)).func_212841_b_(this.setDamage(84, 91))));
            consumer.accept(BLINDING_PRISON_EVERDAWN, this.tableOf((List<LootPool.Builder>)ImmutableList.of((Object)blindingKey, (Object)dawnBreadAndAxe)));
        }

        private void natureDungeon(BiConsumer<ResourceLocation, LootTable.Builder> consumer) {
            consumer.accept(NATURE_CHEST, this.tableOf((List<LootPool.Builder>)ImmutableList.of((Object)this.poolOf((List<LootEntry.Builder<?>>)ImmutableList.of(this.basicEntry((IItemProvider)SkiesBlocks.starlit_sapling, 2, 4), this.basicEntry((IItemProvider)SkiesBlocks.blush_blossom, 1, 2), this.basicEntry((IItemProvider)SkiesBlocks.nature_stone, 2, 4), this.basicEntry((IItemProvider)SkiesBlocks.glowing_nature_stone, 1, 2), this.basicEntry((IItemProvider)SkiesItems.brewberry, 1, 2))).func_216046_a((IRandomRange)RandomValueRange.func_215837_a((float)5.0f, (float)7.0f)).func_212840_b_(RandomChance.func_216004_a((float)1.0f)), (Object)this.poolOf((List<LootEntry.Builder<?>>)ImmutableList.of(this.basicEntry((IItemProvider)SkiesItems.black_brewberry, 1, 2), this.basicEntry((IItemProvider)SkiesItems.pink_brewberry, 0, 1), this.basicEntry((IItemProvider)SkiesItems.pyrope_gem, 1, 2), this.basicEntry((IItemProvider)SkiesItems.aquite_gem, 1, 2))).func_216046_a((IRandomRange)RandomValueRange.func_215837_a((float)2.0f, (float)4.0f)).func_212840_b_(RandomChance.func_216004_a((float)0.4f)), (Object)this.poolOf((List<LootEntry.Builder<?>>)ImmutableList.of(this.basicEntry((IItemProvider)SkiesItems.diopside_gem), (Object)this.basicEntry((IItemProvider)SkiesItems.aquite_axe, 1, 1).func_212841_b_(this.setStick(SkiesItems.starlit_stick)).func_212841_b_(this.setDamage(85, 90)), (Object)this.basicEntry((IItemProvider)SkiesItems.starlit_spear, 1, 1).func_212841_b_(this.setDamage(80, 85)), (Object)this.basicEntry((IItemProvider)Items.field_151122_aG, 0, 2).func_212841_b_(this.enchant(15, 20)))).func_216046_a((IRandomRange)RandomValueRange.func_215837_a((float)1.0f, (float)2.0f)).func_212840_b_(RandomChance.func_216004_a((float)0.1f)), (Object)this.poolOf((List<LootEntry.Builder<?>>)ImmutableList.of((Object)this.basicEntry((IItemProvider)SkiesItems.starlit_spear).func_212841_b_(this.enchant(15, 20)).func_212841_b_(this.setDamage(80, 85)), this.basicEntry((IItemProvider)Items.field_151141_av), this.basicEntry((IItemProvider)SkiesItems.charoite))).func_216046_a((IRandomRange)ConstantRange.func_215835_a((int)1)).func_212840_b_(RandomChance.func_216004_a((float)0.05f)))));
            consumer.accept(NATURE_CHEST_KEY, this.tableOf((List<LootPool.Builder>)ImmutableList.of((Object)this.basicPool((IItemProvider)SkiesItems.nature_key), (Object)this.poolOf((List<LootEntry.Builder<?>>)ImmutableList.of(this.basicEntry((IItemProvider)SkiesItems.black_brewberry, 1, 2), this.basicEntry((IItemProvider)SkiesItems.pink_brewberry, 0, 1), this.basicEntry((IItemProvider)SkiesItems.pyrope_gem, 1, 2), this.basicEntry((IItemProvider)SkiesItems.aquite_gem, 1, 2))).func_216046_a((IRandomRange)RandomValueRange.func_215837_a((float)2.0f, (float)4.0f)))));
        }

        private void poisonDungeon(BiConsumer<ResourceLocation, LootTable.Builder> consumer) {
            consumer.accept(POISON_CHEST, this.tableOf((List<LootPool.Builder>)ImmutableList.of((Object)this.poolOf((List<LootEntry.Builder<?>>)ImmutableList.of(this.basicEntry((IItemProvider)Items.field_151007_F, 2, 3), this.basicEntry((IItemProvider)SkiesBlocks.moonstone, 2, 5), this.basicEntry((IItemProvider)SkiesBlocks.poison_stone, 2, 4), this.basicEntry((IItemProvider)SkiesBlocks.glowing_poison_stone, 1, 2), this.basicEntry((IItemProvider)SkiesItems.crescent_fruit, 1, 2))).func_216046_a((IRandomRange)RandomValueRange.func_215837_a((float)5.0f, (float)7.0f)).func_212840_b_(RandomChance.func_216004_a((float)1.0f)), (Object)this.poolOf((List<LootEntry.Builder<?>>)ImmutableList.of(this.basicEntry((IItemProvider)Items.field_151070_bp, 1, 2), this.basicEntry((IItemProvider)SkiesBlocks.spider_webbing, 1, 2), this.basicEntry((IItemProvider)SkiesItems.pyrope_gem, 1, 2), this.basicEntry((IItemProvider)SkiesItems.aquite_gem, 1, 2))).func_216046_a((IRandomRange)RandomValueRange.func_215837_a((float)2.0f, (float)4.0f)).func_212840_b_(RandomChance.func_216004_a((float)0.4f)), (Object)this.poolOf((List<LootEntry.Builder<?>>)ImmutableList.of(this.basicEntry((IItemProvider)SkiesItems.diopside_gem), this.basicEntry((IItemProvider)SkiesItems.horizonite_ingot, 1, 1), (Object)this.basicEntry((IItemProvider)SkiesItems.moonstone_shield, 1, 1).func_212841_b_(this.setDamage(65, 80)), (Object)this.basicEntry((IItemProvider)Items.field_151122_aG, 0, 2).func_212841_b_(this.enchant(15, 20)))).func_216046_a((IRandomRange)RandomValueRange.func_215837_a((float)1.0f, (float)2.0f)).func_212840_b_(RandomChance.func_216004_a((float)0.1f)), (Object)this.poolOf((List<LootEntry.Builder<?>>)ImmutableList.of((Object)this.basicEntry((IItemProvider)SkiesItems.aquite_sword).func_212841_b_(this.setStick(SkiesItems.maple_stick)).func_212841_b_(this.enchant(Enchantments.field_180312_n)).func_212841_b_(this.setDamage(25, 55)), this.basicEntry((IItemProvider)SkiesItems.camel_saddle), this.basicEntry((IItemProvider)SkiesItems.charoite))).func_216046_a((IRandomRange)ConstantRange.func_215835_a((int)1)).func_212840_b_(RandomChance.func_216004_a((float)0.05f)))));
            consumer.accept(POISON_CHEST_KEY, this.tableOf((List<LootPool.Builder>)ImmutableList.of((Object)this.basicPool((IItemProvider)SkiesItems.poison_key), (Object)this.poolOf((List<LootEntry.Builder<?>>)ImmutableList.of(this.basicEntry((IItemProvider)Items.field_151070_bp, 1, 2), this.basicEntry((IItemProvider)SkiesBlocks.spider_webbing, 1, 2), this.basicEntry((IItemProvider)SkiesItems.pyrope_gem, 1, 2), this.basicEntry((IItemProvider)SkiesItems.aquite_gem, 1, 2))).func_216046_a((IRandomRange)RandomValueRange.func_215837_a((float)2.0f, (float)4.0f)))));
        }
    }
}

