/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.blue_skies.data.providers;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.legacy.blue_skies.BlueSkies;
import com.legacy.blue_skies.data.objects.IToJson;
import java.io.IOException;
import java.nio.file.Path;
import java.util.Map;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DirectoryCache;
import net.minecraft.data.IDataProvider;
import net.minecraft.util.ResourceLocation;
import org.apache.logging.log4j.Logger;

public abstract class SkiesDataProvider<D extends IToJson<D>>
implements IDataProvider {
    protected static final Logger LOGGER = BlueSkies.makeLogger(SkiesDataProvider.class);
    protected static final Gson GSON = new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().create();
    protected Map<ResourceLocation, D> data;
    protected final DataGenerator generator;
    protected final String name;

    public SkiesDataProvider(DataGenerator generator, String name) {
        this.generator = generator;
        this.name = "blue_skies/" + name;
    }

    public void func_200398_a(DirectoryCache cache) throws IOException {
        this.data = this.gatherData();
        Path outputFolder = this.generator.func_200391_b();
        for (Map.Entry<ResourceLocation, D> dataEntry : this.data.entrySet()) {
            Path outputFile = this.createPath(outputFolder, dataEntry.getKey());
            try {
                JsonObject json = ((IToJson)dataEntry.getValue()).toJson();
                IDataProvider.func_218426_a((Gson)GSON, (DirectoryCache)cache, (JsonElement)json, (Path)outputFile);
            }
            catch (IOException e) {
                LOGGER.error("Couldn't save {} {}", (Object)this.name, (Object)outputFile, (Object)e);
            }
        }
    }

    protected abstract Map<ResourceLocation, D> gatherData();

    protected Path createPath(Path outputFolder, ResourceLocation dataEntryName) {
        return outputFolder.resolve("data/" + dataEntryName.func_110624_b() + "/" + this.name + "/" + dataEntryName.func_110623_a() + ".json");
    }

    public String func_200397_b() {
        return this.name;
    }
}

