/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.blue_skies.data.objects.alchemy;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.legacy.blue_skies.BlueSkies;
import com.legacy.blue_skies.data.managers.SkiesDataManager;
import com.legacy.blue_skies.data.objects.alchemy.AlchemyRecipe;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.nbt.StringNBT;
import net.minecraft.tags.ITag;
import net.minecraft.tags.TagCollectionManager;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.registries.ForgeRegistries;
import org.apache.commons.lang3.tuple.ImmutableTriple;

public class TransmuteRecipe
extends AlchemyRecipe {
    private final Set<Item> items;
    @Nullable
    private final List<ITag<Item>> itemTags;
    private static final String ITEMS_KEY = "items";
    private static final String TAGS_KEY = "tags";

    public TransmuteRecipe(Set<Item> items, List<ITag<Item>> itemTags, boolean shouldOverride) {
        super(shouldOverride, BlueSkies.locate("transmute"));
        this.items = items;
        this.itemTags = itemTags;
    }

    public TransmuteRecipe(Set<Item> items, boolean shouldOverride) {
        this(items, null, shouldOverride);
    }

    public TransmuteRecipe(List<ITag<Item>> itemTags, boolean shouldOverride) {
        this(new HashSet<Item>(), itemTags, shouldOverride);
    }

    @Override
    public void addResults(Set<Item> items) {
        this.items.addAll(items);
    }

    @Override
    public Set<Item> getResults(ItemStack inputA, ItemStack inputB) {
        Set<Item> results = this.getResults();
        results.remove(inputA.func_77973_b());
        results.remove(inputB.func_77973_b());
        return results;
    }

    @Override
    public Set<Item> getResults() {
        HashSet<Item> results = new HashSet<Item>(this.items);
        if (this.itemTags != null) {
            this.itemTags.forEach(tag -> results.addAll(tag.func_230236_b_()));
        }
        return results;
    }

    @Override
    public List<ImmutableTriple<ItemStack, ItemStack, ItemStack>> getAllCombinations() {
        ArrayList<ImmutableTriple<ItemStack, ItemStack, ItemStack>> data = new ArrayList<ImmutableTriple<ItemStack, ItemStack, ItemStack>>();
        for (Item input : this.getResults()) {
            for (Item output : this.getResults(new ItemStack((IItemProvider)input), ItemStack.field_190927_a)) {
                data.add((ImmutableTriple<ItemStack, ItemStack, ItemStack>)ImmutableTriple.of((Object)new ItemStack((IItemProvider)input), (Object)ItemStack.field_190927_a, (Object)new ItemStack((IItemProvider)output)));
            }
        }
        return data;
    }

    @Override
    public boolean matches(ItemStack itemA, ItemStack itemB) {
        return itemB.func_190926_b() && this.getResults().contains(itemA.func_77973_b());
    }

    @Override
    public TransmuteRecipe fromJson(JsonObject json) {
        boolean shouldOverride = JSONUtils.func_151209_a((JsonObject)json, (String)"override", (boolean)false);
        HashSet<Item> items = new HashSet<Item>();
        JSONUtils.func_151214_t((JsonObject)json, (String)ITEMS_KEY).forEach(j -> {
            ResourceLocation name = new ResourceLocation(j.getAsString());
            if (ForgeRegistries.ITEMS.containsKey(name)) {
                items.add((Item)ForgeRegistries.ITEMS.getValue(name));
            }
        });
        ArrayList<ITag<Item>> tags = new ArrayList<ITag<Item>>();
        JSONUtils.func_151213_a((JsonObject)json, (String)TAGS_KEY, (JsonArray)new JsonArray()).forEach(j -> {
            ResourceLocation name = new ResourceLocation(j.getAsString());
            ITag tag = TagCollectionManager.func_242178_a().func_241836_b().func_199910_a(name);
            if (tag != null) {
                tags.add(tag);
            } else {
                SkiesDataManager.LOGGER.warn("The tag {} was not found.", (Object)name.toString());
            }
        });
        return new TransmuteRecipe(items, tags, shouldOverride);
    }

    @Override
    public JsonObject toJson() {
        JsonObject json = new JsonObject();
        json.addProperty("type", this.type.toString());
        json.addProperty("override", Boolean.valueOf(this.shouldOverride));
        JsonArray itemNames = new JsonArray();
        this.items.stream().sorted((a, b) -> a.getRegistryName().compareTo(b.getRegistryName())).forEach(i -> itemNames.add(i.getRegistryName().toString()));
        json.add(ITEMS_KEY, (JsonElement)itemNames);
        if (this.itemTags != null) {
            JsonArray tagNames = new JsonArray();
            Function<ITag, String> getName = t -> TagCollectionManager.func_242178_a().func_241836_b().func_232975_b_(t).toString();
            this.itemTags.stream().sorted((a, b) -> ((String)getName.apply((ITag)a)).compareTo((String)getName.apply((ITag)b))).forEach(t -> tagNames.add((String)getName.apply((ITag)t)));
            json.add(TAGS_KEY, (JsonElement)tagNames);
        }
        return json;
    }

    @Override
    public TransmuteRecipe fromNbt(CompoundNBT nbt) {
        boolean shouldOverride = nbt.func_74767_n("override");
        HashSet<Item> items = new HashSet<Item>();
        nbt.func_150295_c(ITEMS_KEY, 8).forEach(inbt -> items.add((Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation(inbt.func_150285_a_()))));
        ArrayList<ITag<Item>> tags = new ArrayList<ITag<Item>>();
        if (nbt.func_74764_b(TAGS_KEY)) {
            nbt.func_150295_c(TAGS_KEY, 8).forEach(inbt -> {
                ITag tag = TagCollectionManager.func_242178_a().func_241836_b().func_199910_a(new ResourceLocation(inbt.func_150285_a_()));
                if (tag != null) {
                    tags.add(tag);
                }
            });
        }
        return new TransmuteRecipe(items, tags, shouldOverride);
    }

    @Override
    public CompoundNBT toNbt(AlchemyRecipe recipe) {
        if (recipe instanceof TransmuteRecipe) {
            TransmuteRecipe transmuteRecipe = (TransmuteRecipe)recipe;
            CompoundNBT nbt = new CompoundNBT();
            nbt.func_74778_a("type", recipe.type.toString());
            nbt.func_74757_a("override", recipe.shouldOverride);
            ListNBT items = new ListNBT();
            transmuteRecipe.items.forEach(i -> items.add((Object)StringNBT.func_229705_a_((String)i.getRegistryName().toString())));
            nbt.func_218657_a(ITEMS_KEY, (INBT)items);
            if (transmuteRecipe.itemTags != null) {
                ListNBT tags = new ListNBT();
                transmuteRecipe.itemTags.forEach(t -> tags.add((Object)StringNBT.func_229705_a_((String)TagCollectionManager.func_242178_a().func_241836_b().func_232975_b_(t).toString())));
                nbt.func_218657_a(TAGS_KEY, (INBT)tags);
            }
            return nbt;
        }
        throw new IllegalArgumentException("The recipe passed was not an instanceof " + this.getClass().toString());
    }
}

