/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.blue_skies.data.managers.journal;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.legacy.blue_skies.client.gui.screen.journal.JournalEntryRenderers;
import com.legacy.blue_skies.data.managers.SkiesDataManager;
import com.legacy.blue_skies.data.managers.SkiesSyncedDataManager;
import com.legacy.blue_skies.data.objects.journal.JournalEntry;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import java.util.ArrayList;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.NBTDynamicOps;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.ResourceLocation;

public class JournalEntryManager
extends SkiesSyncedDataManager<ResourceLocation, JournalEntry, JournalEntryManager> {
    public JournalEntryManager() {
        super(JournalEntry.getDirectory());
    }

    @Override
    public JournalEntryManager newInstance() {
        return new JournalEntryManager();
    }

    @Override
    public Pair<CompoundNBT, CompoundNBT> entryToNbt(ResourceLocation key, JournalEntry value) {
        CompoundNBT keyNbt = new CompoundNBT();
        keyNbt.func_74778_a("0", key.toString());
        CompoundNBT valueNbt = (CompoundNBT)JsonOps.INSTANCE.convertTo((DynamicOps)NBTDynamicOps.field_210820_a, (JsonElement)value.toJson());
        return Pair.of((Object)keyNbt, (Object)valueNbt);
    }

    @Override
    public Pair<ResourceLocation, JournalEntry> entryFromNbt(CompoundNBT keyNbt, CompoundNBT valueNbt) {
        ResourceLocation key = new ResourceLocation(keyNbt.func_74779_i("0"));
        JsonObject json = ((JsonElement)NBTDynamicOps.field_210820_a.convertTo((DynamicOps)JsonOps.INSTANCE, (INBT)valueNbt)).getAsJsonObject();
        try {
            return Pair.of((Object)key, (Object)this.parseJson(json, key).getSecond());
        }
        catch (SkiesDataManager.RegistryObjectNotFoundException e) {
            throw new IllegalArgumentException("Failed to get registry object");
        }
    }

    @Override
    protected Pair<ResourceLocation, JournalEntry> parseJson(JsonObject json, ResourceLocation name) throws SkiesDataManager.RegistryObjectNotFoundException {
        String title = JSONUtils.func_151200_h((JsonObject)json, (String)"title");
        ArrayList<JournalEntry.Lore> lores = new ArrayList<JournalEntry.Lore>();
        JsonArray loreArray = JSONUtils.func_151214_t((JsonObject)json, (String)"lores");
        for (JsonElement e : loreArray) {
            JsonObject loreJson = e.getAsJsonObject();
            String text = JSONUtils.func_151200_h((JsonObject)loreJson, (String)"text");
            ResourceLocation requirement = loreJson.has("requirement") ? new ResourceLocation(JSONUtils.func_151200_h((JsonObject)loreJson, (String)"requirement")) : null;
            JournalEntryRenderers.IRenderable display = null;
            if (loreJson.has("display")) {
                JsonObject displayJson = JSONUtils.func_152754_s((JsonObject)loreJson, (String)"display");
                String displayType = JSONUtils.func_151200_h((JsonObject)displayJson, (String)"type");
                JsonObject displayData = JSONUtils.func_152754_s((JsonObject)displayJson, (String)"display");
                if (displayType.equals("entity")) {
                    int scale = JSONUtils.func_151203_m((JsonObject)displayData, (String)"scale");
                    int yOffset = JSONUtils.func_151203_m((JsonObject)displayData, (String)"y_offset");
                    display = new JournalEntryRenderers.EntityDisplay(JournalEntryManager.parseEntity(displayData, "entity"), scale, yOffset);
                } else if (displayType.equals("image")) {
                    display = new JournalEntryRenderers.ImageDisplay(new ResourceLocation(JSONUtils.func_151200_h((JsonObject)displayData, (String)"image")));
                } else {
                    throw new IllegalArgumentException("display type invalid");
                }
            }
            lores.add(new JournalEntry.Lore(text, requirement, display));
        }
        JournalEntryRenderers.IRenderable icon = null;
        JsonObject iconJson = JSONUtils.func_152754_s((JsonObject)json, (String)"icon");
        String iconType = JSONUtils.func_151200_h((JsonObject)iconJson, (String)"type");
        JsonObject iconData = JSONUtils.func_152754_s((JsonObject)iconJson, (String)"icon");
        if (iconType.equals("item")) {
            icon = new JournalEntryRenderers.ItemIcon((IItemProvider)JournalEntryManager.parseItem(iconData, "item"));
        } else if (iconType.equals("texture")) {
            icon = new JournalEntryRenderers.TextureIcon(new ResourceLocation(JSONUtils.func_151200_h((JsonObject)iconData, (String)"texture")));
        } else {
            throw new IllegalArgumentException("icon type invalid");
        }
        ResourceLocation section = new ResourceLocation(JSONUtils.func_151200_h((JsonObject)json, (String)"section"));
        ResourceLocation requirement = json.has("requirement") ? new ResourceLocation(JSONUtils.func_151200_h((JsonObject)json, (String)"requirement")) : null;
        int priority = JSONUtils.func_151208_a((JsonObject)json, (String)"priority", (int)0);
        return Pair.of((Object)name, (Object)new JournalEntry(title, lores, icon, section, requirement, priority));
    }
}

