/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.blue_skies.data.managers;

import com.google.gson.JsonObject;
import com.legacy.blue_skies.data.managers.SkiesDataManager;
import com.legacy.blue_skies.data.managers.SkiesSyncedDataManager;
import com.legacy.blue_skies.data.objects.ToolHandleType;
import com.mojang.datafixers.util.Pair;
import net.minecraft.item.Item;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.registries.ForgeRegistries;

public class ToolHandleTypeManager
extends SkiesSyncedDataManager<Item, ToolHandleType, ToolHandleTypeManager> {
    public ToolHandleTypeManager() {
        super(ToolHandleType.getDirectory());
    }

    @Override
    protected Pair<Item, ToolHandleType> parseJson(JsonObject json, ResourceLocation name) throws SkiesDataManager.RegistryObjectNotFoundException {
        Item stick = ToolHandleTypeManager.parseItem(json, "stick");
        float attackSpeed = JSONUtils.func_151221_a((JsonObject)json, (String)"attack_speed", (float)ToolHandleType.DEFAULT.getAttackSpeedModifier());
        float projectileDamage = JSONUtils.func_151221_a((JsonObject)json, (String)"projectile_damage", (float)ToolHandleType.DEFAULT.getProjectileDamageModifier());
        float durability = JSONUtils.func_151221_a((JsonObject)json, (String)"durability", (float)ToolHandleType.DEFAULT.getDurabilityModifier());
        int color = JSONUtils.func_151208_a((JsonObject)json, (String)"color", (int)ToolHandleType.DEFAULT.getColor());
        return Pair.of((Object)stick, (Object)new ToolHandleType(durability, attackSpeed, projectileDamage, stick, color));
    }

    public ToolHandleType getHandle(ResourceLocation itemName) {
        if (ForgeRegistries.ITEMS.containsKey(itemName)) {
            return this.getHandle((Item)ForgeRegistries.ITEMS.getValue(itemName));
        }
        return ToolHandleType.DEFAULT;
    }

    public ToolHandleType getHandle(Item item) {
        if (this.hasHandle(item)) {
            return (ToolHandleType)this.getValue(item);
        }
        return ToolHandleType.DEFAULT;
    }

    public boolean hasHandle(Item item) {
        return this.getData().containsKey(item);
    }

    public boolean hasHandle(ResourceLocation itemName) {
        if (ForgeRegistries.ITEMS.containsKey(itemName)) {
            return this.hasHandle((Item)ForgeRegistries.ITEMS.getValue(itemName));
        }
        return false;
    }

    @Override
    public ToolHandleTypeManager newInstance() {
        return new ToolHandleTypeManager();
    }

    @Override
    public Pair<CompoundNBT, CompoundNBT> entryToNbt(Item key, ToolHandleType value) {
        CompoundNBT keyNbt = new CompoundNBT();
        this.putItem(keyNbt, "0", key);
        CompoundNBT valueNbt = new CompoundNBT();
        this.putItem(valueNbt, "0", value.getStick());
        valueNbt.func_74776_a("1", value.getAttackSpeedModifier());
        valueNbt.func_74776_a("2", value.getDurabilityModifier());
        valueNbt.func_74776_a("3", value.getProjectileDamageModifier());
        valueNbt.func_74768_a("4", value.getColor());
        return Pair.of((Object)keyNbt, (Object)valueNbt);
    }

    @Override
    public Pair<Item, ToolHandleType> entryFromNbt(CompoundNBT keyNbt, CompoundNBT valueNbt) {
        Item key = this.getItem(keyNbt, "0");
        Item stick = this.getItem(valueNbt, "0");
        float attackSpeed = valueNbt.func_74760_g("1");
        float durability = valueNbt.func_74760_g("2");
        float projectileDamage = valueNbt.func_74760_g("3");
        int color = valueNbt.func_74762_e("4");
        return Pair.of((Object)key, (Object)new ToolHandleType(durability, attackSpeed, projectileDamage, stick, color));
    }
}

