/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.blue_skies.client.renders.tile_entities;

import com.legacy.blue_skies.BlueSkies;
import com.legacy.blue_skies.BlueSkiesConfig;
import com.legacy.blue_skies.registries.SkiesBlocks;
import com.legacy.blue_skies.registries.SkiesTileEntityTypes;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import it.unimi.dsi.fastutil.floats.Float2FloatFunction;
import it.unimi.dsi.fastutil.ints.Int2IntFunction;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.block.AbstractChestBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.ChestBlock;
import net.minecraft.client.renderer.Atlases;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.model.ModelRenderer;
import net.minecraft.client.renderer.tileentity.DualBrightnessCallback;
import net.minecraft.client.renderer.tileentity.TileEntityRenderer;
import net.minecraft.client.renderer.tileentity.TileEntityRendererDispatcher;
import net.minecraft.state.Property;
import net.minecraft.state.properties.ChestType;
import net.minecraft.tileentity.IChestLid;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityMerger;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.vector.Vector3f;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class SkyChestRenderer<T extends TileEntity>
extends TileEntityRenderer<T> {
    private static final Map<TileEntityType<?>, String> CHEST_TEXTURES = new HashMap<TileEntityType<?>, String>(){
        private static final long serialVersionUID = -5505549653590035348L;
        {
            this.put(SkiesTileEntityTypes.BLUEBRIGHT_CHEST, "bluebright");
            this.put(SkiesTileEntityTypes.STARLIT_CHEST, "starlit");
            this.put(SkiesTileEntityTypes.FROSTBRIGHT_CHEST, "frostbright");
            this.put(SkiesTileEntityTypes.LUNAR_CHEST, "lunar");
            this.put(SkiesTileEntityTypes.DUSK_CHEST, "dusk");
            this.put(SkiesTileEntityTypes.MAPLE_CHEST, "maple");
            this.put(SkiesTileEntityTypes.CHERRY_CHEST, "cherry");
        }
    };
    private static final ResourceLocation PUMPKIN = BlueSkies.locate("textures/tile_entity/chest/pumpkin.png");
    private final ModelRenderer singleLid;
    private final ModelRenderer singleBottom = new ModelRenderer(64, 64, 0, 19);
    private final ModelRenderer singleLatch;
    private final ModelRenderer rightLid;
    private final ModelRenderer rightBottom;
    private final ModelRenderer rightLatch;
    private final ModelRenderer leftLid;
    private final ModelRenderer leftBottom;
    private final ModelRenderer leftLatch;

    public SkyChestRenderer(TileEntityRendererDispatcher dispatcherIn) {
        super(dispatcherIn);
        this.singleBottom.func_228301_a_(1.0f, 0.0f, 1.0f, 14.0f, 10.0f, 14.0f, 0.0f);
        this.singleLid = new ModelRenderer(64, 64, 0, 0);
        this.singleLid.func_228301_a_(1.0f, 0.0f, 0.0f, 14.0f, 5.0f, 14.0f, 0.0f);
        this.singleLid.field_78797_d = 9.0f;
        this.singleLid.field_78798_e = 1.0f;
        this.singleLatch = new ModelRenderer(64, 64, 0, 0);
        this.singleLatch.func_228301_a_(7.0f, -1.0f, 15.0f, 2.0f, 4.0f, 1.0f, 0.0f);
        this.singleLatch.field_78797_d = 8.0f;
        this.rightBottom = new ModelRenderer(64, 64, 0, 19);
        this.rightBottom.func_228301_a_(1.0f, 0.0f, 1.0f, 15.0f, 10.0f, 14.0f, 0.0f);
        this.rightLid = new ModelRenderer(64, 64, 0, 0);
        this.rightLid.func_228301_a_(1.0f, 0.0f, 0.0f, 15.0f, 5.0f, 14.0f, 0.0f);
        this.rightLid.field_78797_d = 9.0f;
        this.rightLid.field_78798_e = 1.0f;
        this.rightLatch = new ModelRenderer(64, 64, 0, 0);
        this.rightLatch.func_228301_a_(15.0f, -1.0f, 15.0f, 1.0f, 4.0f, 1.0f, 0.0f);
        this.rightLatch.field_78797_d = 8.0f;
        this.leftBottom = new ModelRenderer(64, 64, 0, 19);
        this.leftBottom.func_228301_a_(0.0f, 0.0f, 1.0f, 15.0f, 10.0f, 14.0f, 0.0f);
        this.leftLid = new ModelRenderer(64, 64, 0, 0);
        this.leftLid.func_228301_a_(0.0f, 0.0f, 0.0f, 15.0f, 5.0f, 14.0f, 0.0f);
        this.leftLid.field_78797_d = 9.0f;
        this.leftLid.field_78798_e = 1.0f;
        this.leftLatch = new ModelRenderer(64, 64, 0, 0);
        this.leftLatch.func_228301_a_(0.0f, -1.0f, 15.0f, 1.0f, 4.0f, 1.0f, 0.0f);
        this.leftLatch.field_78797_d = 8.0f;
    }

    public void func_225616_a_(T tileEntity, float partialTicks, MatrixStack matrix, IRenderTypeBuffer renderBuffer, int combinedLightIn, int combinedOverlayIn) {
        World world = tileEntity.func_145831_w();
        boolean worldNotNull = world != null;
        BlockState blockstate = worldNotNull ? tileEntity.func_195044_w() : (BlockState)SkiesBlocks.bluebright_chest.func_176223_P().func_206870_a((Property)ChestBlock.field_176459_a, (Comparable)Direction.SOUTH);
        ChestType chesttype = blockstate.func_235901_b_((Property)ChestBlock.field_196314_b) ? (ChestType)blockstate.func_177229_b((Property)ChestBlock.field_196314_b) : ChestType.SINGLE;
        Block block = blockstate.func_177230_c();
        if (block instanceof AbstractChestBlock) {
            AbstractChestBlock abstractchestblock = (AbstractChestBlock)block;
            boolean isDouble = chesttype != ChestType.SINGLE;
            matrix.func_227860_a_();
            float f = ((Direction)blockstate.func_177229_b((Property)ChestBlock.field_176459_a)).func_185119_l();
            matrix.func_227861_a_(0.5, 0.5, 0.5);
            matrix.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(-f));
            matrix.func_227861_a_(-0.5, -0.5, -0.5);
            TileEntityMerger.ICallbackWrapper icallbackwrapper = worldNotNull ? abstractchestblock.func_225536_a_(blockstate, world, tileEntity.func_174877_v(), true) : TileEntityMerger.ICallback::func_225537_b_;
            float f1 = ((Float2FloatFunction)icallbackwrapper.apply(ChestBlock.func_226917_a_((IChestLid)((IChestLid)tileEntity)))).get(partialTicks);
            f1 = 1.0f - f1;
            f1 = 1.0f - f1 * f1 * f1;
            int i = ((Int2IntFunction)icallbackwrapper.apply((TileEntityMerger.ICallback)new DualBrightnessCallback())).applyAsInt(combinedLightIn);
            IVertexBuilder ivertexbuilder = renderBuffer.getBuffer(RenderType.func_228638_b_((ResourceLocation)this.getChestTextures(tileEntity, chesttype == ChestType.LEFT, isDouble)));
            if (isDouble) {
                if (chesttype == ChestType.LEFT) {
                    this.renderModels(matrix, ivertexbuilder, this.leftLid, this.leftLatch, this.leftBottom, f1, i, combinedOverlayIn);
                } else {
                    this.renderModels(matrix, ivertexbuilder, this.rightLid, this.rightLatch, this.rightBottom, f1, i, combinedOverlayIn);
                }
            } else {
                this.renderModels(matrix, ivertexbuilder, this.singleLid, this.singleLatch, this.singleBottom, f1, i, combinedOverlayIn);
            }
            matrix.func_227865_b_();
        }
    }

    private void renderModels(MatrixStack matrixStackIn, IVertexBuilder bufferIn, ModelRenderer chestLid, ModelRenderer chestLatch, ModelRenderer chestBottom, float lidAngle, int combinedLightIn, int combinedOverlayIn) {
        chestLatch.field_78795_f = chestLid.field_78795_f = -(lidAngle * 1.5707964f);
        chestLid.func_228308_a_(matrixStackIn, bufferIn, combinedLightIn, combinedOverlayIn);
        chestLatch.func_228308_a_(matrixStackIn, bufferIn, combinedLightIn, combinedOverlayIn);
        chestBottom.func_228308_a_(matrixStackIn, bufferIn, combinedLightIn, combinedOverlayIn);
    }

    private ResourceLocation getChestTextures(T tileEntityIn, boolean isLeft, boolean doubleChest) {
        ResourceLocation resourceLocation;
        String chestLocation = "textures/tile_entity/chest/" + CHEST_TEXTURES.get(tileEntityIn.func_200662_C());
        if (BlueSkies.IS_CHRISTMAS && BlueSkiesConfig.CLIENT.hasFestivities()) {
            ResourceLocation christmasTexture = (doubleChest ? (isLeft ? Atlases.field_228756_o_ : Atlases.field_228757_p_) : Atlases.field_228755_n_).func_229310_a_();
            resourceLocation = new ResourceLocation(christmasTexture.func_110624_b(), "textures/" + christmasTexture.func_110623_a() + ".png");
        } else {
            resourceLocation = BlueSkies.IS_HALLOWEEN && !doubleChest && BlueSkiesConfig.CLIENT.hasFestivities() ? PUMPKIN : (doubleChest ? (isLeft ? BlueSkies.locate(chestLocation + "_left.png") : BlueSkies.locate(chestLocation + "_right.png")) : BlueSkies.locate(chestLocation + ".png"));
        }
        return resourceLocation;
    }
}

