/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.blue_skies.client.models.entities.hostile.boss;

import com.google.common.collect.ImmutableList;
import com.legacy.blue_skies.entities.hostile.boss.StarlitCrusherEntity;
import net.minecraft.client.renderer.entity.model.SegmentedModel;
import net.minecraft.client.renderer.model.Model;
import net.minecraft.client.renderer.model.ModelRenderer;
import net.minecraft.util.math.MathHelper;

public class StarlitCrusherModel<T extends StarlitCrusherEntity>
extends SegmentedModel<T> {
    private final ModelRenderer backLeftLeg;
    private final ModelRenderer backRightLeg;
    private final ModelRenderer frontRightLeg;
    private final ModelRenderer frontLeftLeg;
    private final ModelRenderer dummyPoint;
    private final ModelRenderer body;
    private final ModelRenderer leftBranch;
    private final ModelRenderer rightBranch;
    private final ModelRenderer backBranch;
    private final ModelRenderer leaves;
    private final ModelRenderer leafCross1;
    private final ModelRenderer leafCross2;
    private final ModelRenderer rightArm;
    private final ModelRenderer rightArmLayer;
    private final ModelRenderer hammer;
    private final ModelRenderer hammerLayer;
    private final ModelRenderer head;
    private final ModelRenderer headLayer;
    private float smashWave = 0.0f;

    public StarlitCrusherModel() {
        this.field_78090_t = 160;
        this.field_78089_u = 128;
        this.dummyPoint = new ModelRenderer((Model)this);
        this.dummyPoint.func_78793_a(0.0f, -2.0f, 0.0f);
        this.dummyPoint.func_78784_a(0, 0).func_228303_a_(-1.0f, -5.0f, 0.0f, 1.0f, 1.0f, 1.0f, 0.0f, false);
        this.body = new ModelRenderer((Model)this);
        this.body.func_78793_a(0.0f, 17.0f, 0.0f);
        this.dummyPoint.func_78792_a(this.body);
        this.body.func_78784_a(0, 53).func_228303_a_(-9.0f, -28.0f, -9.0f, 18.0f, 29.0f, 18.0f, 0.0f, false);
        this.rightBranch = new ModelRenderer((Model)this);
        this.rightBranch.func_78793_a(8.5f, -20.0f, 0.0f);
        this.body.func_78792_a(this.rightBranch);
        this.setRotationAngle(this.rightBranch, 0.0f, 0.0f, 0.6981f);
        this.rightBranch.func_78784_a(74, 53).func_228303_a_(-2.5f, -12.0f, -3.0f, 4.0f, 14.0f, 6.0f, 0.0f, false);
        this.backBranch = new ModelRenderer((Model)this);
        this.backBranch.func_78793_a(-0.5f, -20.0f, 9.0f);
        this.body.func_78792_a(this.backBranch);
        this.setRotationAngle(this.backBranch, -0.6981f, 0.0f, 0.0f);
        this.backBranch.func_78784_a(54, 53).func_228303_a_(-2.5f, -12.0f, -3.0f, 6.0f, 14.0f, 4.0f, 0.0f, false);
        this.leftBranch = new ModelRenderer((Model)this);
        this.leftBranch.func_78793_a(-8.5f, -20.0f, 0.0f);
        this.body.func_78792_a(this.leftBranch);
        this.setRotationAngle(this.leftBranch, 0.0f, 0.0f, -0.6981f);
        this.leftBranch.func_78784_a(74, 53).func_228303_a_(-1.5f, -12.0f, -3.0f, 4.0f, 14.0f, 6.0f, 0.0f, true);
        this.leaves = new ModelRenderer((Model)this);
        this.leaves.func_78793_a(0.0f, -25.0f, 0.0f);
        this.body.func_78792_a(this.leaves);
        this.leaves.func_78784_a(0, 0).func_228303_a_(-19.0f, -17.0f, -19.0f, 38.0f, 16.0f, 37.0f, 0.0f, false);
        this.leafCross2 = new ModelRenderer((Model)this);
        this.leafCross2.func_78793_a(0.0f, -3.0f, 0.0f);
        this.leaves.func_78792_a(this.leafCross2);
        this.setRotationAngle(this.leafCross2, 0.0f, 0.7854f, 0.0f);
        this.leafCross2.func_78784_a(72, 73).func_228303_a_(-22.0f, -11.0f, 0.0f, 44.0f, 11.0f, 0.0f, 0.0f, false);
        this.leafCross1 = new ModelRenderer((Model)this);
        this.leafCross1.func_78793_a(0.0f, -3.0f, 0.0f);
        this.leaves.func_78792_a(this.leafCross1);
        this.setRotationAngle(this.leafCross1, 0.0f, -0.7854f, 0.0f);
        this.leafCross1.func_78784_a(72, 73).func_228303_a_(-22.0f, -11.0f, 0.0f, 44.0f, 11.0f, 0.0f, 0.0f, false);
        this.rightArm = new ModelRenderer((Model)this);
        this.rightArm.func_78793_a(-9.0f, -11.0f, 0.25f);
        this.body.func_78792_a(this.rightArm);
        this.rightArm.func_78784_a(110, 118).func_228303_a_(-16.0f, -2.0f, -2.75f, 18.0f, 5.0f, 5.0f, 0.0f, false);
        this.hammer = new ModelRenderer((Model)this);
        this.hammer.func_78793_a(-16.0f, 0.5f, 0.0f);
        this.rightArm.func_78792_a(this.hammer);
        this.hammer.func_78784_a(0, 100).func_228303_a_(-10.0f, -4.5f, -9.0f, 10.0f, 9.0f, 17.0f, 0.0f, false);
        this.hammerLayer = new ModelRenderer((Model)this);
        this.hammerLayer.func_78793_a(0.0f, 0.0f, 0.0f);
        this.hammer.func_78792_a(this.hammerLayer);
        this.hammerLayer.func_78784_a(55, 100).func_228303_a_(-10.0f, -4.5f, -9.0f, 10.0f, 9.0f, 17.0f, 0.5f, false);
        this.rightArmLayer = new ModelRenderer((Model)this);
        this.rightArmLayer.func_78793_a(0.0f, 0.0f, 0.0f);
        this.rightArm.func_78792_a(this.rightArmLayer);
        this.rightArmLayer.func_78784_a(109, 108).func_228303_a_(-16.0f, -2.0f, -2.75f, 18.0f, 5.0f, 5.0f, 0.5f, false);
        this.head = new ModelRenderer((Model)this);
        this.head.func_78793_a(0.0f, -16.0f, -9.0f);
        this.body.func_78792_a(this.head);
        this.head.func_78784_a(0, 0).func_228303_a_(-4.0f, -5.0f, -7.0f, 8.0f, 10.0f, 8.0f, 0.0f, false);
        this.headLayer = new ModelRenderer((Model)this);
        this.headLayer.func_78793_a(0.0f, 0.0f, 0.0f);
        this.head.func_78792_a(this.headLayer);
        this.headLayer.func_78784_a(0, 18).func_228303_a_(-4.0f, -5.0f, -7.0f, 8.0f, 10.0f, 8.0f, 0.5f, false);
        this.backLeftLeg = new ModelRenderer((Model)this);
        this.backLeftLeg.func_78793_a(9.0f, 14.0f, 9.0f);
        this.dummyPoint.func_78792_a(this.backLeftLeg);
        this.backLeftLeg.func_78784_a(136, 87).func_228303_a_(-3.0f, -1.0f, -3.0f, 6.0f, 13.0f, 6.0f, 0.0f, false);
        this.frontLeftLeg = new ModelRenderer((Model)this);
        this.frontLeftLeg.func_78793_a(9.0f, 14.0f, -9.0f);
        this.dummyPoint.func_78792_a(this.frontLeftLeg);
        this.frontLeftLeg.func_78784_a(136, 87).func_228303_a_(-3.0f, -1.0f, -3.0f, 6.0f, 13.0f, 6.0f, 0.0f, false);
        this.frontRightLeg = new ModelRenderer((Model)this);
        this.frontRightLeg.func_78793_a(-9.0f, 14.0f, -9.0f);
        this.dummyPoint.func_78792_a(this.frontRightLeg);
        this.frontRightLeg.func_78784_a(136, 87).func_228303_a_(-3.0f, -1.0f, -3.0f, 6.0f, 13.0f, 6.0f, 0.0f, true);
        this.backRightLeg = new ModelRenderer((Model)this);
        this.backRightLeg.func_78793_a(-9.0f, 14.0f, 9.0f);
        this.dummyPoint.func_78792_a(this.backRightLeg);
        this.backRightLeg.func_78784_a(136, 87).func_228303_a_(-3.0f, -1.0f, -3.0f, 6.0f, 13.0f, 6.0f, 0.0f, true);
    }

    public Iterable<ModelRenderer> func_225601_a_() {
        return ImmutableList.of((Object)this.dummyPoint);
    }

    public void setupAnim(T entityIn, float limbSwing, float limbSwingAmount, float partialTicks, float netHeadYaw, float headPitch) {
        EntAnimations anims = EntAnimations.INSTANCE;
        boolean dying = ((StarlitCrusherEntity)entityIn).getDeathTicks() > 0;
        boolean rooted = ((StarlitCrusherEntity)entityIn).isRooted();
        boolean stunned = ((StarlitCrusherEntity)entityIn).isStunned();
        StarlitCrusherEntity.EntLegPosition legAnim = StarlitCrusherEntity.EntLegPosition.getEntPosition(entityIn);
        switch (legAnim) {
            case NONE: {
                anims.defaultLegAnimations(this, limbSwing, limbSwingAmount);
                this.backLeftLeg.field_78796_g = 0.0f;
                this.backRightLeg.field_78796_g = 0.0f;
                this.frontRightLeg.field_78796_g = 0.0f;
                this.frontLeftLeg.field_78796_g = 0.0f;
                this.backLeftLeg.field_78808_h = 0.0f;
                this.backRightLeg.field_78808_h = 0.0f;
                this.frontRightLeg.field_78808_h = 0.0f;
                this.frontLeftLeg.field_78808_h = 0.0f;
                break;
            }
            case DYING: {
                float x = -0.5f;
                float z = -0.5f;
                if (this.backLeftLeg.field_78795_f > x) {
                    this.backLeftLeg.field_78795_f -= 0.01f;
                }
                if (this.backRightLeg.field_78795_f > x) {
                    this.backRightLeg.field_78795_f -= 0.01f;
                }
                if (this.frontRightLeg.field_78795_f < -x) {
                    this.frontRightLeg.field_78795_f += 0.01f;
                }
                if (this.frontLeftLeg.field_78795_f < -x) {
                    this.frontLeftLeg.field_78795_f += 0.01f;
                }
                this.backLeftLeg.field_78796_g = 0.0f;
                this.backRightLeg.field_78796_g = 0.0f;
                this.frontRightLeg.field_78796_g = 0.0f;
                this.frontLeftLeg.field_78796_g = 0.0f;
                if (this.backLeftLeg.field_78808_h < -z) {
                    this.backLeftLeg.field_78808_h += 0.01f;
                }
                if (this.backRightLeg.field_78808_h > z) {
                    this.backRightLeg.field_78808_h -= 0.01f;
                }
                if (this.frontRightLeg.field_78808_h > z) {
                    this.frontRightLeg.field_78808_h -= 0.01f;
                }
                if (!(this.frontLeftLeg.field_78808_h < -z)) break;
                this.frontLeftLeg.field_78808_h += 0.01f;
                break;
            }
            case SPINNING: {
                float x = -0.5f;
                float y = 0.0f;
                float z = -0.5f;
                this.backLeftLeg.field_78795_f = x;
                this.backRightLeg.field_78795_f = x;
                this.frontRightLeg.field_78795_f = -x;
                this.frontLeftLeg.field_78795_f = -x;
                this.backLeftLeg.field_78796_g = -y;
                this.backRightLeg.field_78796_g = y;
                this.frontRightLeg.field_78796_g = -y;
                this.frontLeftLeg.field_78796_g = y;
                this.backLeftLeg.field_78808_h = -z;
                this.backRightLeg.field_78808_h = z;
                this.frontRightLeg.field_78808_h = z;
                this.frontLeftLeg.field_78808_h = -z;
                break;
            }
            case ROOTED: {
                this.backLeftLeg.field_78795_f = 1.0f;
                this.backRightLeg.field_78795_f = 1.0f;
                this.frontRightLeg.field_78795_f = -1.0f;
                this.frontLeftLeg.field_78795_f = -1.0f;
                this.backLeftLeg.field_78796_g = -0.7f;
                this.backRightLeg.field_78796_g = 0.7f;
                this.frontRightLeg.field_78796_g = -0.7f;
                this.frontLeftLeg.field_78796_g = 0.7f;
                this.backLeftLeg.field_78808_h = -1.2f;
                this.backRightLeg.field_78808_h = 1.2f;
                this.frontRightLeg.field_78808_h = 1.2f;
                this.frontLeftLeg.field_78808_h = -1.2f;
                break;
            }
            case STUNNED: {
                this.backLeftLeg.field_78795_f = 1.0f;
                this.backRightLeg.field_78795_f = 1.0f;
                this.frontRightLeg.field_78795_f = -1.0f;
                this.frontLeftLeg.field_78795_f = -1.0f;
                this.backLeftLeg.field_78796_g = -0.1f;
                this.backRightLeg.field_78796_g = 0.1f;
                this.frontRightLeg.field_78796_g = -0.1f;
                this.frontLeftLeg.field_78796_g = 0.1f;
                this.backLeftLeg.field_78808_h = -1.5f;
                this.backRightLeg.field_78808_h = 1.5f;
                this.frontRightLeg.field_78808_h = 1.5f;
                this.frontLeftLeg.field_78808_h = -1.5f;
            }
        }
        if (dying) {
            this.leaves.field_78796_g = MathHelper.func_76134_b((float)(partialTicks * 3.0f)) * 0.1f;
            this.leaves.field_78795_f = -0.12f + MathHelper.func_76134_b((float)(partialTicks * 1.5f)) * 0.1f;
            if (this.head.field_78795_f > -1.0f) {
                this.head.field_78795_f -= 0.005f;
            }
            this.head.field_78795_f = this.head.field_78795_f > -1.0f ? 0.0f - (float)((StarlitCrusherEntity)entityIn).getDeathTicks() * 0.01f : -1.0f;
            this.head.field_78796_g = MathHelper.func_76134_b((float)(partialTicks * 1.0f)) * 0.1f;
            this.rightArm.field_78795_f = 0.0f;
            this.rightArm.field_78796_g = 0.0f;
            this.rightArm.field_78808_h = this.rightArm.field_78808_h < 1.0f ? -0.65f + (float)((StarlitCrusherEntity)entityIn).getDeathTicks() * 0.023f : 1.0f;
            return;
        }
        if (rooted) {
            anims.defaultHeadAnimations(this, headPitch, netHeadYaw, (StarlitCrusherEntity)entityIn, partialTicks);
            this.dummyPoint.field_78797_d = 6.0f;
            this.body.field_78795_f = 0.0f;
            anims.hammerAnimations(this, (StarlitCrusherEntity)entityIn, limbSwingAmount, partialTicks);
            this.rightArm.field_78808_h = -0.3f;
            if (((StarlitCrusherEntity)entityIn).canShake) {
                this.leaves.field_78796_g = MathHelper.func_76134_b((float)(partialTicks * 2.0f)) * 0.1f;
            }
        } else if (stunned) {
            this.head.field_78795_f = 0.5f + MathHelper.func_76134_b((float)(partialTicks * 0.1f)) * 0.2f + limbSwingAmount * 0.5f;
            this.head.field_78796_g = 0.0f;
            this.headLayer.field_78795_f = MathHelper.func_76126_a((float)(partialTicks * 0.1f)) * 3.0f * ((float)Math.PI / 180);
            this.headLayer.field_78796_g = 0.0f;
            this.headLayer.field_78808_h = MathHelper.func_76134_b((float)(partialTicks * 0.1f)) * 2.5f * ((float)Math.PI / 180);
            this.dummyPoint.field_78797_d = 6.0f;
            this.body.field_78795_f = 0.0f;
            this.rightArm.field_78795_f = 0.0f;
            this.rightArm.field_78796_g = 0.0f;
            this.rightArm.field_78808_h = -0.3f;
        } else {
            if (((StarlitCrusherEntity)entityIn).isSpinning()) {
                this.body.field_78795_f = 0.0f;
            }
            this.dummyPoint.field_78797_d = ((StarlitCrusherEntity)entityIn).isSpinning() ? -1.5f : -2.0f;
            this.rightArm.field_78806_j = true;
            anims.hammerAnimations(this, (StarlitCrusherEntity)entityIn, limbSwingAmount, partialTicks);
            anims.defaultHeadAnimations(this, headPitch, netHeadYaw, (StarlitCrusherEntity)entityIn, partialTicks);
        }
        if (!((StarlitCrusherEntity)entityIn).canShake) {
            this.leaves.field_78796_g = 0.0f;
        }
        this.leaves.field_78795_f = -0.12f + MathHelper.func_76134_b((float)(partialTicks * 0.2f)) * 0.1f;
        this.backBranch.field_78795_f = -0.6981f + MathHelper.func_76134_b((float)(partialTicks * 0.2f)) * 0.1f;
        this.leftBranch.field_78795_f = MathHelper.func_76134_b((float)(partialTicks * 0.2f)) * 0.1f;
        this.rightBranch.field_78795_f = MathHelper.func_76134_b((float)(partialTicks * 0.2f)) * 0.1f;
    }

    public void prepareMobModel(T entityIn, float limbSwing, float limbSwingAmount, float partialTick) {
        if (((StarlitCrusherEntity)entityIn).attackTimer > 0) {
            this.smashWave = 0.0f;
            float h = -0.5f + 1.5f * this.triangleWave((float)((StarlitCrusherEntity)entityIn).attackTimer - partialTick, 10.0f);
            this.rightArm.field_78796_g = Math.min(0.0f, h);
            return;
        }
        if (((StarlitCrusherEntity)entityIn).smashTimer > 0) {
            float f = this.triangleWave((float)((StarlitCrusherEntity)entityIn).smashTimer - partialTick, 20.0f);
            float h = -0.5f + 1.5f * f;
            float finalX = Math.min(0.1f, f * 0.4f);
            this.rightArm.field_78796_g = -1.0f + Math.min(0.0f, h);
            this.body.field_78795_f = 0.0f;
            this.body.field_78795_f += finalX;
            this.smashWave = -finalX;
            return;
        }
        this.body.field_78795_f = 0.0f;
        this.smashWave = 0.0f;
    }

    private float triangleWave(float min, float max) {
        return (Math.abs(min % max - max * 0.5f) - max * 0.25f) / (max * 0.25f);
    }

    public void setRotationAngle(ModelRenderer modelRenderer, float x, float y, float z) {
        modelRenderer.field_78795_f = x;
        modelRenderer.field_78796_g = y;
        modelRenderer.field_78808_h = z;
    }

    static class EntAnimations {
        public static final EntAnimations INSTANCE = new EntAnimations();

        EntAnimations() {
        }

        public void defaultHeadAnimations(StarlitCrusherModel<?> model, float headPitch, float netHeadYaw, StarlitCrusherEntity entityIn, float partialTicks) {
            ((StarlitCrusherModel)model).head.field_78808_h = 0.0f;
            ((StarlitCrusherModel)model).head.field_78795_f = headPitch * ((float)Math.PI / 180) + ((StarlitCrusherModel)model).smashWave;
            ((StarlitCrusherModel)model).head.field_78796_g = netHeadYaw / 90.0f;
            if (((StarlitCrusherModel)model).head.field_78796_g == 4.0f) {
                ((StarlitCrusherModel)model).head.field_78796_g = 0.0f;
            }
            ((StarlitCrusherModel)model).headLayer.field_78795_f = MathHelper.func_76126_a((float)(partialTicks * 0.1f)) * 3.0f * ((float)Math.PI / 180);
            ((StarlitCrusherModel)model).headLayer.field_78796_g = 0.0f;
            ((StarlitCrusherModel)model).headLayer.field_78808_h = MathHelper.func_76134_b((float)(partialTicks * 0.1f)) * 2.5f * ((float)Math.PI / 180);
        }

        public void defaultLegAnimations(StarlitCrusherModel<?> model, float limbSwing, float limbSwingAmount) {
            ((StarlitCrusherModel)model).backRightLeg.field_78795_f = MathHelper.func_76134_b((float)(limbSwing * 0.6662f)) * 1.4f * limbSwingAmount;
            ((StarlitCrusherModel)model).backLeftLeg.field_78795_f = MathHelper.func_76134_b((float)(limbSwing * 0.6662f + (float)Math.PI)) * 1.4f * limbSwingAmount;
            ((StarlitCrusherModel)model).frontRightLeg.field_78795_f = MathHelper.func_76134_b((float)(limbSwing * 0.6662f + (float)Math.PI)) * 1.4f * limbSwingAmount;
            ((StarlitCrusherModel)model).frontLeftLeg.field_78795_f = MathHelper.func_76134_b((float)(limbSwing * 0.6662f)) * 1.4f * limbSwingAmount;
        }

        public void hammerAnimations(StarlitCrusherModel<?> model, StarlitCrusherEntity entityIn, float limbSwingAmount, float ageInTicks) {
            boolean smashing;
            if (entityIn.isSpinning()) {
                ((StarlitCrusherModel)model).rightArm.field_78796_g = 0.0f;
                ((StarlitCrusherModel)model).rightArm.field_78795_f = 0.0f;
                ((StarlitCrusherModel)model).rightArm.field_78808_h = 0.0f;
                return;
            }
            float moveResist = limbSwingAmount * 1.0f;
            boolean attacking = (float)entityIn.attackTimer > 0.0f;
            boolean bl = smashing = (float)entityIn.smashTimer > 0.0f;
            if (attacking) {
                ((StarlitCrusherModel)model).rightArm.field_78795_f = 0.0f;
                ((StarlitCrusherModel)model).rightArm.field_78808_h = -0.65f;
                return;
            }
            if (smashing) {
                ((StarlitCrusherModel)model).rightArm.field_78795_f = 0.0f;
                ((StarlitCrusherModel)model).rightArm.field_78808_h = -1.6f;
                return;
            }
            ((StarlitCrusherModel)model).rightArm.field_78795_f = -MathHelper.func_76134_b((float)(ageInTicks * 0.1f)) * 0.1f - moveResist;
            ((StarlitCrusherModel)model).rightArm.field_78796_g = MathHelper.func_76134_b((float)(ageInTicks * 0.1f)) * 0.1f + moveResist;
            ((StarlitCrusherModel)model).rightArm.field_78808_h = -0.65f;
        }
    }
}

