/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.blue_skies.client.gui.screen.journal;

import com.legacy.blue_skies.capability.SkiesPlayer;
import com.legacy.blue_skies.client.gui.screen.journal.BlueJournalEntryScreen;
import com.legacy.blue_skies.client.gui.screen.journal.BlueJournalScreen;
import com.legacy.blue_skies.client.gui.screen.journal.widgets.JournalEntryButton;
import com.legacy.blue_skies.client.gui.screen.journal.widgets.JournalSectionButton;
import com.legacy.blue_skies.data.BlueSkiesData;
import com.legacy.blue_skies.data.objects.journal.JournalEntry;
import com.legacy.blue_skies.data.objects.journal.JournalRequirement;
import com.legacy.blue_skies.data.objects.journal.JournalSection;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.advancements.Advancement;
import net.minecraft.advancements.AdvancementProgress;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.multiplayer.ClientAdvancementManager;

public class BlueJournalSectionScreen
extends BlueJournalScreen {
    protected final List<List<JournalEntryButton>> entryButtons = new ArrayList<List<JournalEntryButton>>();
    public final JournalSection section;
    public final JournalSectionButton sectionButton;

    public BlueJournalSectionScreen(@Nullable BlueJournalScreen previousScreen, JournalSection section, JournalSectionButton sectionButton) {
        super(previousScreen);
        this.section = section;
        this.sectionButton = sectionButton;
    }

    @Override
    protected void loadData() {
        this.injectEntryButtons(this.getEntryButtons());
        JournalSectionButton currentSectionButton = new JournalSectionButton(this.field_230708_k_ / 2 + 145, this.field_230709_l_ / 2 - 100, this.sectionButton.section, button -> this.goBack());
        currentSectionButton.forced = true;
        this.func_230480_a_((Widget)currentSectionButton);
    }

    protected boolean isCorrectSection(JournalEntry entry) {
        return entry.section.equals((Object)this.section.name);
    }

    protected boolean testEntry(JournalEntry entry) {
        if (entry.requirement != null) {
            ClientPlayerEntity player = this.field_230706_i_.field_71439_g;
            JournalRequirement requirement = (JournalRequirement)BlueSkiesData.JOURNAL_REQUIREMENTS.getValue(entry.requirement);
            if (requirement != null) {
                ClientAdvancementManager advancements;
                Advancement advancement;
                boolean advancementDone = false;
                if (requirement.advancement != null && (advancement = (advancements = player.field_71174_a.func_191982_f()).func_194229_a().func_192084_a(requirement.advancement)) != null) {
                    advancementDone = ((AdvancementProgress)advancements.field_192803_d.get(advancement)).func_192105_a();
                }
                int everbrightProg = SkiesPlayer.getIfPresent(player, s -> s.getBrightProgression(), () -> -1);
                int everdawnProg = SkiesPlayer.getIfPresent(player, s -> s.getDawnProgression(), () -> -1);
                return !(!advancementDone && requirement.advancement != null || everbrightProg < requirement.everbrightProgression && requirement.everbrightProgression >= 0 || everdawnProg < requirement.everdawnProgression && requirement.everdawnProgression >= 0);
            }
        }
        return true;
    }

    protected List<JournalEntryButton> getEntryButtons() {
        ArrayList<JournalEntryButton> buttons = new ArrayList<JournalEntryButton>();
        BlueSkiesData.JOURNAL_ENTRIES.getData().forEach((name, entry) -> {
            if (this.isCorrectSection((JournalEntry)entry) && this.testEntry((JournalEntry)entry)) {
                buttons.add(new JournalEntryButton(0, 0, (JournalEntry)entry, button -> this.field_230706_i_.func_147108_a((Screen)new BlueJournalEntryScreen(this, (JournalEntry)entry, this.sectionButton))));
            }
        });
        buttons.sort(JournalEntryButton::compareTo);
        return buttons;
    }

    protected void injectEntryButtons(List<JournalEntryButton> buttons) {
        int i;
        this.entryButtons.clear();
        this.field_230710_m_.removeIf(b -> b instanceof JournalEntryButton);
        this.field_230705_e_.removeIf(b -> b instanceof JournalEntryButton);
        int buttonsPerPage = 9;
        this.totalPages = buttons.size() / buttonsPerPage + (buttons.size() % buttonsPerPage == 0 ? 0 : 1);
        for (i = 0; i < this.totalPages; ++i) {
            this.entryButtons.add(buttons.subList(i * buttonsPerPage, Math.min(buttonsPerPage * (i + 1), buttons.size())));
        }
        for (i = 0; i < this.entryButtons.size(); ++i) {
            int x = this.field_230708_k_ / 2 + (i % 2 == 0 ? -145 : 4);
            int y = this.field_230709_l_ / 2 - 115;
            for (JournalEntryButton b2 : this.entryButtons.get(i)) {
                y += 20;
                if (b2 == null) continue;
                b2.field_230690_l_ = x;
                b2.field_230691_m_ = y;
                this.func_230480_a_((Widget)b2);
            }
        }
    }

    @Override
    protected void onPageChange() {
        super.onPageChange();
        for (int i = 0; i < this.entryButtons.size(); ++i) {
            boolean visible = i == this.page || i == this.page + 1;
            this.entryButtons.get(i).forEach(b -> {
                if (b != null) {
                    b.field_230694_p_ = visible;
                }
            });
        }
    }
}

