/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.blue_skies.client.gui.screen;

import com.legacy.blue_skies.BlueSkies;
import com.legacy.blue_skies.client.gui.container.AlchemyTableContainer;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.audio.ISound;
import net.minecraft.client.audio.SimpleSound;
import net.minecraft.client.gui.screen.inventory.ContainerScreen;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.ITextComponent;

public class AlchemyTableScreen
extends ContainerScreen<AlchemyTableContainer> {
    private static final ResourceLocation BACKGROUND_TEXTURE = BlueSkies.locate("textures/gui/alchemy_table.png");
    private float sliderProgress;
    private boolean clickedOnSroll;
    private int recipeIndexOffset;
    private boolean hasItemsInInputSlot;

    public AlchemyTableScreen(AlchemyTableContainer screenContainer, PlayerInventory inv, ITextComponent title) {
        super((Container)screenContainer, inv, title);
        screenContainer.setInventoryUpdateListener(this::onInventoryUpdate);
        --this.field_238743_q_;
    }

    public void func_230430_a_(MatrixStack matrixStack, int mouseX, int mouseY, float partialTicks) {
        super.func_230430_a_(matrixStack, mouseX, mouseY, partialTicks);
        this.func_230459_a_(matrixStack, mouseX, mouseY);
    }

    protected void func_230450_a_(MatrixStack matrixStack, float partialTicks, int x, int y) {
        this.func_230446_a_(matrixStack);
        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.field_230706_i_.func_110434_K().func_110577_a(BACKGROUND_TEXTURE);
        int left = this.field_147003_i;
        int top = this.field_147009_r;
        this.func_238474_b_(matrixStack, left, top, 0, 0, this.field_146999_f, this.field_147000_g);
        int sliderProgress = (int)(41.0f * this.sliderProgress);
        this.func_238474_b_(matrixStack, left + 119, top + 15 + sliderProgress, 176 + (this.canScroll() ? 0 : 12), 0, 12, 15);
        int leftOffset = this.field_147003_i + 52;
        int topOffset = this.field_147009_r + 14;
        int recipeIndexOffset = this.recipeIndexOffset + 12;
        this.renderRecipeBackground(matrixStack, x, y, leftOffset, topOffset, recipeIndexOffset);
        this.drawRecipesItems(leftOffset, topOffset, recipeIndexOffset);
    }

    protected void func_230459_a_(MatrixStack matrixStack, int hoverX, int hoverY) {
        super.func_230459_a_(matrixStack, hoverX, hoverY);
        if (this.hasItemsInInputSlot) {
            int guiLeft = this.field_147003_i + 52;
            int guiTop = this.field_147009_r + 14;
            int recipeIndexOffset = this.recipeIndexOffset + 12;
            List<Item> outputs = ((AlchemyTableContainer)this.field_147002_h).getOutputItems();
            for (int i = this.recipeIndexOffset; i < recipeIndexOffset && i < ((AlchemyTableContainer)this.field_147002_h).getOutputCount(); ++i) {
                int index = i - this.recipeIndexOffset;
                int x = guiLeft + index % 4 * 16;
                int y = guiTop + index / 4 * 18 + 2;
                if (hoverX < x || hoverX >= x + 16 || hoverY < y || hoverY >= y + 18) continue;
                this.func_230457_a_(matrixStack, new ItemStack((IItemProvider)outputs.get(i)), hoverX, hoverY);
            }
        }
    }

    private void renderRecipeBackground(MatrixStack matrixStack, int x, int y, int leftOffset, int topOffset, int recipeIndexOffset) {
        for (int i = this.recipeIndexOffset; i < recipeIndexOffset && i < ((AlchemyTableContainer)this.field_147002_h).getOutputCount(); ++i) {
            int recipeIndex = i - this.recipeIndexOffset;
            int xPos = leftOffset + recipeIndex % 4 * 16;
            int dividedIndex = recipeIndex / 4;
            int yPos = topOffset + dividedIndex * 18 + 2;
            int vOffset = this.field_147000_g;
            if (i == ((AlchemyTableContainer)this.field_147002_h).getSelectedItem()) {
                vOffset += 18;
            } else if (x >= xPos && y >= yPos && x < xPos + 16 && y < yPos + 18) {
                vOffset += 36;
            }
            this.func_238474_b_(matrixStack, xPos, yPos - 1, 0, vOffset, 16, 18);
        }
    }

    private void drawRecipesItems(int left, int top, int recipeIndexOffsetMax) {
        List<Item> outputs = ((AlchemyTableContainer)this.field_147002_h).getOutputItems();
        for (int i = this.recipeIndexOffset; i < recipeIndexOffsetMax && i < ((AlchemyTableContainer)this.field_147002_h).getOutputCount(); ++i) {
            int recipeIndex = i - this.recipeIndexOffset;
            int xPos = left + recipeIndex % 4 * 16;
            int recipe = recipeIndex / 4;
            int yPos = top + recipe * 18 + 2;
            this.field_230706_i_.func_175599_af().func_180450_b(new ItemStack((IItemProvider)outputs.get(i)), xPos, yPos);
        }
    }

    public boolean func_231044_a_(double mouseX, double mouseY, int button) {
        this.clickedOnSroll = false;
        if (this.hasItemsInInputSlot) {
            int leftOffset = this.field_147003_i + 52;
            int topOffset = this.field_147009_r + 14;
            int recipeIndexOffset = this.recipeIndexOffset + 12;
            for (int l = this.recipeIndexOffset; l < recipeIndexOffset; ++l) {
                int i1 = l - this.recipeIndexOffset;
                double xPos = mouseX - (double)(leftOffset + i1 % 4 * 16);
                double yPos = mouseY - (double)(topOffset + i1 / 4 * 18);
                if (!(xPos >= 0.0) || !(yPos >= 0.0) || !(xPos < 16.0) || !(yPos < 18.0) || !((AlchemyTableContainer)this.field_147002_h).func_75140_a((PlayerEntity)this.field_230706_i_.field_71439_g, l)) continue;
                Minecraft.func_71410_x().func_147118_V().func_147682_a((ISound)SimpleSound.func_184371_a((SoundEvent)SoundEvents.field_219720_mm, (float)1.0f));
                this.field_230706_i_.field_71442_b.func_78756_a(((AlchemyTableContainer)this.field_147002_h).field_75152_c, l);
                return true;
            }
            leftOffset = this.field_147003_i + 119;
            topOffset = this.field_147009_r + 9;
            if (mouseX >= (double)leftOffset && mouseX < (double)(leftOffset + 12) && mouseY >= (double)topOffset && mouseY < (double)(topOffset + 54)) {
                this.clickedOnSroll = true;
            }
        }
        return super.func_231044_a_(mouseX, mouseY, button);
    }

    public boolean func_231045_a_(double mouseX, double mouseY, int button, double dragX, double dragY) {
        if (this.clickedOnSroll && this.canScroll()) {
            int topOffset = this.field_147009_r + 14;
            int lowerBounds = topOffset + 54;
            this.sliderProgress = ((float)mouseY - (float)topOffset - 7.5f) / ((float)(lowerBounds - topOffset) - 15.0f);
            this.sliderProgress = MathHelper.func_76131_a((float)this.sliderProgress, (float)0.0f, (float)1.0f);
            this.recipeIndexOffset = (int)((double)(this.sliderProgress * (float)this.getHiddenRows()) + 0.5) * 4;
            return true;
        }
        return super.func_231045_a_(mouseX, mouseY, button, dragX, dragY);
    }

    public boolean func_231043_a_(double mouseX, double mouseY, double delta) {
        if (this.canScroll()) {
            int hiddenRows = this.getHiddenRows();
            this.sliderProgress = (float)((double)this.sliderProgress - delta / (double)hiddenRows);
            this.sliderProgress = MathHelper.func_76131_a((float)this.sliderProgress, (float)0.0f, (float)1.0f);
            this.recipeIndexOffset = (int)((double)(this.sliderProgress * (float)hiddenRows) + 0.5) * 4;
        }
        return true;
    }

    private boolean canScroll() {
        return this.hasItemsInInputSlot && ((AlchemyTableContainer)this.field_147002_h).getOutputCount() > 12;
    }

    protected int getHiddenRows() {
        return (((AlchemyTableContainer)this.field_147002_h).getOutputCount() + 4 - 1) / 4 - 3;
    }

    private void onInventoryUpdate() {
        this.hasItemsInInputSlot = ((AlchemyTableContainer)this.field_147002_h).hasItemsinInputSlot();
        if (!this.hasItemsInInputSlot) {
            this.sliderProgress = 0.0f;
            this.recipeIndexOffset = 0;
        }
    }
}

