/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.blue_skies.client.gui.container;

import com.legacy.blue_skies.items.util.FoodPrepUtils;
import com.legacy.blue_skies.registries.SkiesBlocks;
import com.legacy.blue_skies.registries.SkiesContainers;
import com.legacy.blue_skies.registries.SkiesSounds;
import com.legacy.blue_skies.registries.SkiesTriggers;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.Inventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.Slot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.item.SoupItem;
import net.minecraft.item.SuspiciousStewItem;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.IWorldPosCallable;
import net.minecraft.util.SoundCategory;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class FoodPrepContainer
extends Container {
    private final IInventory inputInventory = new Inventory(5){

        public void func_70296_d() {
            super.func_70296_d();
            FoodPrepContainer.this.func_75130_a((IInventory)this);
            FoodPrepContainer.this.inventoryUpdateListener.run();
        }
    };
    private final IInventory outputInventory = new Inventory(1);
    private final IWorldPosCallable worldPosCallable;
    private final List<Slot> inputSlots = new ArrayList<Slot>();
    private final Slot outputSlot;
    private Runnable inventoryUpdateListener = () -> {};
    private long lastOnTake;

    public FoodPrepContainer(int id, PlayerInventory playerInv) {
        this(id, playerInv, IWorldPosCallable.field_221489_a);
    }

    public FoodPrepContainer(int id, PlayerInventory playerInv, final IWorldPosCallable worldPos) {
        super(SkiesContainers.FOOD_PREP_TABLE, id);
        int i;
        this.worldPosCallable = worldPos;
        for (i = 0; i < 5; ++i) {
            this.inputSlots.add(this.func_75146_a(new Slot(this.inputInventory, i, 44 + 18 * i, 18)));
        }
        this.outputSlot = this.func_75146_a(new Slot(this.outputInventory, 0, 80, 53){

            public boolean func_75214_a(ItemStack stack) {
                return false;
            }

            public ItemStack func_190901_a(PlayerEntity player, ItemStack stack) {
                if (player instanceof ServerPlayerEntity) {
                    SkiesTriggers.USED_FOOD_PREP.trigger((ServerPlayerEntity)player);
                }
                stack.func_77980_a(player.field_70170_p, player, stack.func_190916_E());
                for (int i = 0; i < FoodPrepContainer.this.inputSlots.size(); ++i) {
                    this.reduceStack((Slot)FoodPrepContainer.this.inputSlots.get(i));
                }
                FoodPrepContainer.this.updateOutputSlot();
                worldPos.func_221486_a((world, pos) -> {
                    long time = world.func_82737_E();
                    if (FoodPrepContainer.this.lastOnTake != time) {
                        world.func_184133_a((PlayerEntity)null, pos, SkiesSounds.BLOCK_FOOD_PREP_TABLE_USE, SoundCategory.BLOCKS, 1.0f, 1.0f);
                        FoodPrepContainer.this.lastOnTake = time;
                    }
                });
                return super.func_190901_a(player, stack);
            }

            private ItemStack reduceStack(Slot slot) {
                if (slot.func_75216_d()) {
                    ItemStack stack = slot.func_75211_c();
                    ItemStack containerItem = null;
                    if (stack.func_77973_b() == Items.field_151068_bn) {
                        containerItem = new ItemStack((IItemProvider)Items.field_151069_bo);
                    } else if (stack.func_77973_b() instanceof SoupItem || stack.func_77973_b() instanceof SuspiciousStewItem) {
                        containerItem = new ItemStack((IItemProvider)Items.field_151054_z);
                    } else if (stack.hasContainerItem()) {
                        containerItem = stack.getContainerItem();
                    }
                    if (containerItem != null) {
                        if (stack.func_190916_E() == 1) {
                            slot.func_75215_d(containerItem);
                            return containerItem;
                        }
                        FoodPrepContainer.this.func_75135_a(stack.getContainerItem(), 6, 42, false);
                    }
                    return slot.func_75209_a(1);
                }
                return ItemStack.field_190927_a;
            }
        });
        for (int y = 0; y < 3; ++y) {
            for (int x = 0; x < 9; ++x) {
                this.func_75146_a(new Slot((IInventory)playerInv, x + y * 9 + 9, 8 + x * 18, 84 + y * 18));
            }
        }
        for (i = 0; i < 9; ++i) {
            this.func_75146_a(new Slot((IInventory)playerInv, i, 8 + i * 18, 142));
        }
    }

    public void func_75134_a(PlayerEntity player) {
        super.func_75134_a(player);
        this.worldPosCallable.func_221486_a((world, pos) -> this.func_193327_a(player, (World)world, this.inputInventory));
    }

    public boolean func_75145_c(PlayerEntity player) {
        return FoodPrepContainer.func_216963_a((IWorldPosCallable)this.worldPosCallable, (PlayerEntity)player, (Block)SkiesBlocks.food_prep_table);
    }

    public ItemStack func_82846_b(PlayerEntity player, int index) {
        ItemStack slotStack = ItemStack.field_190927_a;
        Slot slot = (Slot)this.field_75151_b.get(index);
        if (slot != null && slot.func_75216_d()) {
            int containerSize = 6;
            ItemStack stackInSlot = slot.func_75211_c();
            Item itemInSlot = stackInSlot.func_77973_b();
            slotStack = stackInSlot.func_77946_l();
            if (index == containerSize - 1) {
                itemInSlot.func_77622_d(stackInSlot, player.field_70170_p, player);
                if (!this.func_75135_a(stackInSlot, containerSize, containerSize + 36, true)) {
                    return ItemStack.field_190927_a;
                }
                slot.func_75220_a(stackInSlot, slotStack);
            } else if (index >= 0 && index <= containerSize - 2) {
                if (!this.func_75135_a(stackInSlot, containerSize, containerSize + 36, false)) {
                    return ItemStack.field_190927_a;
                }
            } else {
                if (!this.func_75135_a(stackInSlot, 0, containerSize - 1, false)) {
                    return ItemStack.field_190927_a;
                }
                if (index >= containerSize && index < containerSize + 27 ? !this.func_75135_a(stackInSlot, containerSize + 27, containerSize + 36, false) : index >= containerSize + 27 && index < containerSize + 36 && !this.func_75135_a(stackInSlot, containerSize, containerSize + 27, false)) {
                    return ItemStack.field_190927_a;
                }
            }
            if (stackInSlot.func_190926_b()) {
                slot.func_75215_d(ItemStack.field_190927_a);
            }
            slot.func_75218_e();
            if (stackInSlot.func_190916_E() == slotStack.func_190916_E()) {
                return ItemStack.field_190927_a;
            }
            slot.func_190901_a(player, stackInSlot);
            this.func_75142_b();
        }
        return slotStack;
    }

    public boolean func_94530_a(ItemStack stack, Slot slotIn) {
        return slotIn != this.outputSlot && super.func_94530_a(stack, slotIn);
    }

    public void func_75130_a(IInventory inventory) {
        this.updateOutputSlot();
    }

    public boolean func_75140_a(PlayerEntity playerIn, int id) {
        this.updateOutputSlot();
        return true;
    }

    private void updateOutputSlot() {
        this.outputSlot.func_75215_d(FoodPrepUtils.createFood(this.inputInventory));
        this.func_75142_b();
    }

    @OnlyIn(value=Dist.CLIENT)
    public void setInventoryUpdateListener(Runnable listener) {
        this.inventoryUpdateListener = listener;
    }
}

