/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.blue_skies.blocks.natural;

import com.legacy.blue_skies.blocks.natural.SkiesTrees;
import com.legacy.blue_skies.data.BlueSkiesData;
import com.legacy.blue_skies.registries.SkiesFeatures;
import java.util.Random;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.DoublePlantBlock;
import net.minecraft.block.IGrowable;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.state.Property;
import net.minecraft.state.properties.DoubleBlockHalf;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.ITag;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.ISeedReader;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;

public class SnowcapMushroomBlock
extends DoublePlantBlock
implements IGrowable {
    private static final VoxelShape STEM_BOUNDS = Block.func_208617_a((double)6.0, (double)0.0, (double)6.0, (double)10.0, (double)16.0, (double)10.0);
    private static final VoxelShape CAP_COLLISION = Block.func_208617_a((double)0.0, (double)12.0, (double)0.0, (double)16.0, (double)13.0, (double)16.0);
    private static final VoxelShape CAP_BOUNDS = VoxelShapes.func_197872_a((VoxelShape)CAP_COLLISION, (VoxelShape)Block.func_208617_a((double)6.0, (double)0.0, (double)6.0, (double)10.0, (double)12.0, (double)10.0));

    public SnowcapMushroomBlock(AbstractBlock.Properties properties) {
        super(properties);
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader world, BlockPos pos, ISelectionContext context) {
        VoxelShape voxelShape = state.func_177229_b((Property)field_176492_b) == DoubleBlockHalf.UPPER ? CAP_BOUNDS : STEM_BOUNDS;
        Vector3d vec3d = state.func_177229_b((Property)field_176492_b) == DoubleBlockHalf.LOWER ? world.func_180495_p(pos.func_177984_a()).func_191059_e(world, pos.func_177984_a()) : state.func_191059_e(world, pos);
        return voxelShape.func_197751_a(vec3d.field_72450_a, vec3d.field_72448_b, vec3d.field_72449_c);
    }

    public VoxelShape func_220071_b(BlockState state, IBlockReader world, BlockPos pos, ISelectionContext context) {
        VoxelShape voxelShape = state.func_177229_b((Property)field_176492_b) == DoubleBlockHalf.UPPER ? CAP_COLLISION : VoxelShapes.func_197880_a();
        Vector3d vec3d = state.func_177229_b((Property)field_176492_b) == DoubleBlockHalf.LOWER ? world.func_180495_p(pos.func_177984_a()).func_191059_e(world, pos.func_177984_a()) : state.func_191059_e(world, pos);
        return voxelShape.func_197751_a(vec3d.field_72450_a, vec3d.field_72448_b, vec3d.field_72449_c);
    }

    public boolean func_196260_a(BlockState state, IWorldReader world, BlockPos pos) {
        if (state.func_177229_b((Property)field_176492_b) == DoubleBlockHalf.LOWER) {
            return super.func_196260_a(state, world, pos) || world.func_180495_p(pos.func_177977_b()).func_235714_a_((ITag)BlockTags.field_242171_aD);
        }
        BlockState lowerState = world.func_180495_p(pos.func_177977_b());
        if (state.func_177230_c() != this) {
            return super.func_196260_a(state, world, pos);
        }
        return lowerState.func_177230_c() == this && lowerState.func_177229_b((Property)field_176492_b) == DoubleBlockHalf.LOWER;
    }

    public boolean func_149653_t(BlockState state) {
        return state.func_177229_b((Property)field_176492_b) == DoubleBlockHalf.LOWER;
    }

    public AbstractBlock.OffsetType func_176218_Q() {
        return AbstractBlock.OffsetType.XYZ;
    }

    public void func_225542_b_(BlockState state, ServerWorld world, BlockPos pos, Random random) {
        if (!world.field_72995_K) {
            SnowcapMushroomBlock.freezeBlocks((World)world, pos, random);
        }
    }

    public static void freezeBlocks(World world, BlockPos pos, Random rand) {
        BlockState frozenState;
        BlockPos randPos = new BlockPos(pos.func_177958_n() + rand.nextInt(3) - 1, pos.func_177956_o() - rand.nextInt(2), pos.func_177952_p() + rand.nextInt(3) - 1);
        BlockState stateAtPos = world.func_180495_p(randPos);
        if (BlueSkiesData.SNOWCAP_MUSHROOM_FREEZING.getData().containsKey(stateAtPos.func_177230_c()) && (frozenState = BlueSkiesData.SNOWCAP_MUSHROOM_FREEZING.getState(stateAtPos, rand)) != null) {
            world.func_175656_a(randPos, frozenState);
            if (world instanceof ServerWorld) {
                ((ServerWorld)world).func_195598_a((IParticleData)ParticleTypes.field_197613_f, (double)randPos.func_177958_n() + 0.5, (double)randPos.func_177956_o() + 0.5, (double)randPos.func_177952_p() + 0.5, 8, 0.3, 0.3, 0.3, 0.03);
            }
        }
    }

    public boolean func_196253_a(BlockState state, BlockItemUseContext useContext) {
        return false;
    }

    public boolean func_176473_a(IBlockReader world, BlockPos pos, BlockState state, boolean isClient) {
        return true;
    }

    public boolean func_180670_a(World world, Random rand, BlockPos pos, BlockState state) {
        return true;
    }

    public void func_225535_a_(ServerWorld world, Random rand, BlockPos pos, BlockState state) {
        if (rand.nextFloat() < 0.75f) {
            SkiesFeatures.SNOWCAP_MUSHROOM.func_241855_a((ISeedReader)world, world.func_72863_F().func_201711_g(), rand, state.func_177229_b((Property)field_176492_b) == DoubleBlockHalf.LOWER ? pos : pos.func_177977_b(), SkiesTrees.DUMMY_CONFIG);
        }
    }
}

