/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.blue_skies.blocks.natural;

import javax.annotation.Nullable;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.BushBlock;
import net.minecraft.block.material.Material;
import net.minecraft.block.material.PushReaction;
import net.minecraft.entity.LivingEntity;
import net.minecraft.fluid.Fluids;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.ItemStack;
import net.minecraft.state.DirectionProperty;
import net.minecraft.state.EnumProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.util.Direction;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.Mirror;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;

public class LargeLilyPadBlock
extends BushBlock {
    public static final EnumProperty<Corner> CORNER = EnumProperty.func_177709_a((String)"corner", Corner.class);
    public static final DirectionProperty FACING = BlockStateProperties.field_208157_J;
    private static final VoxelShape SHAPE = Block.func_208617_a((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)2.0, (double)16.0);

    public LargeLilyPadBlock(AbstractBlock.Properties builder) {
        super(builder);
        this.func_180632_j((BlockState)((BlockState)this.func_176223_P().func_206870_a((Property)FACING, (Comparable)Direction.NORTH)).func_206870_a(CORNER, (Comparable)((Object)Corner.BOTTOM_L)));
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader world, BlockPos pos, ISelectionContext context) {
        return SHAPE;
    }

    protected boolean func_200014_a_(BlockState groundState, IBlockReader world, BlockPos groundPos) {
        return (groundState.func_204520_s().func_206886_c() == Fluids.field_204546_a || groundState.func_185904_a() == Material.field_151588_w) && world.func_204610_c(groundPos.func_177984_a()).func_206886_c() == Fluids.field_204541_a;
    }

    public boolean func_196260_a(BlockState state, IWorldReader world, BlockPos pos) {
        if (state.func_203425_a((Block)this) && super.func_196260_a(state, world, pos)) {
            BlockPos offsetPos;
            Corner corner = (Corner)((Object)state.func_177229_b(CORNER));
            Direction facing = (Direction)state.func_177229_b((Property)FACING);
            switch (corner) {
                case BOTTOM_L: {
                    for (Corner c : new Corner[]{Corner.TOP_L, Corner.TOP_R, Corner.BOTTOM_R}) {
                        BlockPos offsetPos2 = c.getOffset(pos, facing);
                        BlockState offsetState = world.func_180495_p(offsetPos2);
                        if (offsetState.func_177230_c() == this && super.func_196260_a(offsetState, world, offsetPos2)) continue;
                        return false;
                    }
                    return true;
                }
            }
            switch (corner) {
                case BOTTOM_R: {
                    offsetPos = pos.func_177972_a(facing.func_176746_e().func_176746_e().func_176746_e());
                    break;
                }
                case TOP_R: {
                    offsetPos = pos.func_177972_a(facing.func_176734_d()).func_177972_a(facing.func_176734_d().func_176746_e());
                    break;
                }
                case TOP_L: {
                    offsetPos = pos.func_177972_a(facing.func_176734_d());
                    break;
                }
                default: {
                    offsetPos = pos;
                }
            }
            return this.func_196260_a(world.func_180495_p(offsetPos), world, offsetPos);
        }
        return false;
    }

    @Nullable
    public BlockState func_196258_a(BlockItemUseContext context) {
        Direction facing = context.func_195992_f();
        for (Corner corner : new Corner[]{Corner.TOP_L, Corner.TOP_R, Corner.BOTTOM_R}) {
            BlockPos offsetPos;
            World world = context.func_195991_k();
            if (world.func_180495_p(offsetPos = corner.getOffset(context.func_195995_a(), facing)).func_196953_a(context) && this.func_200014_a_(world.func_180495_p(offsetPos.func_177977_b()), (IBlockReader)world, offsetPos.func_177977_b())) continue;
            return null;
        }
        return (BlockState)this.func_176223_P().func_206870_a((Property)FACING, (Comparable)facing);
    }

    public void func_180633_a(World world, BlockPos pos, BlockState state, LivingEntity placer, ItemStack stack) {
        Direction facing = (Direction)state.func_177229_b((Property)FACING);
        for (Corner corner : new Corner[]{Corner.TOP_L, Corner.TOP_R, Corner.BOTTOM_R}) {
            world.func_180501_a(corner.getOffset(pos, facing), (BlockState)state.func_206870_a(CORNER, (Comparable)((Object)corner)), 27);
        }
    }

    public BlockState rotate(BlockState state, IWorld world, BlockPos pos, Rotation rotation) {
        return this.func_185499_a(state, rotation);
    }

    public BlockState func_185499_a(BlockState state, Rotation rotation) {
        return (BlockState)((BlockState)state.func_206870_a((Property)FACING, (Comparable)rotation.func_185831_a((Direction)state.func_177229_b((Property)FACING)))).func_206870_a(CORNER, (Comparable)((Object)((Corner)((Object)state.func_177229_b(CORNER))).rotate(rotation)));
    }

    public BlockState func_185471_a(BlockState state, Mirror mirror) {
        return this.func_185499_a(state, mirror.func_185800_a((Direction)state.func_177229_b((Property)FACING)));
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new Property[]{FACING, CORNER});
    }

    public PushReaction func_149656_h(BlockState state) {
        return PushReaction.DESTROY;
    }

    public static enum Corner implements IStringSerializable
    {
        BOTTOM_L("bottom_left"),
        BOTTOM_R("bottom_right"),
        TOP_L("top_left"),
        TOP_R("top_right");

        private final String name;

        private Corner(String name) {
            this.name = name;
        }

        public BlockPos getOffset(BlockPos pos, Direction facing) {
            switch (this) {
                case BOTTOM_R: {
                    return pos.func_177972_a(facing.func_176746_e());
                }
                case TOP_L: {
                    return pos.func_177972_a(facing);
                }
                case TOP_R: {
                    return pos.func_177972_a(facing).func_177972_a(facing.func_176746_e());
                }
            }
            return pos;
        }

        public Corner rotate(Rotation rotation) {
            Corner corner = this;
            for (int i = 0; i < rotation.ordinal(); ++i) {
                corner = corner.rotate90();
            }
            return corner;
        }

        public Corner rotate90() {
            switch (this) {
                case BOTTOM_L: {
                    return BOTTOM_R;
                }
                case BOTTOM_R: {
                    return TOP_R;
                }
                case TOP_L: {
                    return BOTTOM_L;
                }
            }
            return TOP_L;
        }

        public Corner mirror(Mirror mirror, Direction stateFacing) {
            switch (this) {
                case BOTTOM_L: {
                    return BOTTOM_R;
                }
                case BOTTOM_R: {
                    return BOTTOM_L;
                }
                case TOP_L: {
                    return TOP_R;
                }
            }
            return TOP_L;
        }

        public String func_176610_l() {
            return this.name;
        }
    }
}

