/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.blue_skies.blocks.misc;

import com.legacy.blue_skies.blocks.SkyPortalBlock;
import com.legacy.blue_skies.entities.util.interfaces.ISkyBossMob;
import com.legacy.blue_skies.events.SkiesPlayerEvents;
import com.legacy.structure_gel.blocks.GelPortalBlock;
import java.util.Random;
import java.util.function.Supplier;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.FireBlock;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.potion.EffectInstance;
import net.minecraft.state.Property;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.GameRules;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;

public class SkyFireBlock
extends FireBlock {
    private final Supplier<EffectInstance> effect;
    public final Supplier<GelPortalBlock> portalBlock;

    public SkyFireBlock(Supplier<EffectInstance> effect, Supplier<GelPortalBlock> portalBlock) {
        super(AbstractBlock.Properties.func_200945_a((Material)Material.field_151581_o).func_200942_a().func_200944_c().func_200943_b(0.0f).func_235838_a_(value -> 15).func_200947_a(SoundType.field_185854_g).func_222380_e());
        this.effect = effect;
        this.portalBlock = portalBlock;
    }

    public void func_196262_a(BlockState state, World world, BlockPos pos, Entity entityIn) {
        if ((entityIn instanceof LivingEntity || entityIn instanceof PlayerEntity) && !(entityIn instanceof ISkyBossMob)) {
            ((LivingEntity)entityIn).func_195064_c(this.effect.get());
        }
    }

    public BlockState func_196271_a(BlockState fireState, Direction facing, BlockState facingState, IWorld world, BlockPos currentPos, BlockPos facingPos) {
        return this.func_196260_a(fireState, (IWorldReader)world, currentPos) ? this.getFireWithAge(world, currentPos, (Integer)fireState.func_177229_b((Property)field_176543_a)) : Blocks.field_150350_a.func_176223_P();
    }

    public void func_220082_b(BlockState state, World world, BlockPos pos, BlockState oldState, boolean isMoving) {
        if (oldState.func_177230_c() != state.func_177230_c() && !GelPortalBlock.fillPortal((World)world, (BlockPos)pos, (GelPortalBlock)this.portalBlock.get(), SkyPortalBlock.ALLOWED_INSIDE_BLOCKS)) {
            if (!state.func_196955_c((IWorldReader)world, pos)) {
                world.func_217377_a(pos, false);
            } else {
                world.func_205220_G_().func_205360_a(pos, (Object)this, SkyFireBlock.getTickCooldown(world.field_73012_v));
            }
        }
    }

    public void func_225534_a_(BlockState state, ServerWorld world, BlockPos pos, Random rand) {
        world.func_205220_G_().func_205360_a(pos, (Object)this, SkyFireBlock.getTickCooldown(world.field_73012_v));
        if (world.func_82736_K().func_223586_b(GameRules.field_223598_a)) {
            if (!state.func_196955_c((IWorldReader)world, pos)) {
                world.func_217377_a(pos, false);
            }
            BlockState blockstate = world.func_180495_p(pos.func_177977_b());
            boolean flag = blockstate.isFireSource((IWorldReader)world, pos, Direction.UP);
            int i = (Integer)state.func_177229_b((Property)field_176543_a);
            if (!flag && world.func_72896_J() && this.func_176537_d((World)world, pos) && rand.nextFloat() < 0.2f + (float)i * 0.03f) {
                world.func_217377_a(pos, false);
            } else {
                int j = Math.min(15, i + rand.nextInt(3) / 2);
                if (i != j) {
                    state = (BlockState)state.func_206870_a((Property)field_176543_a, (Comparable)Integer.valueOf(j));
                    world.func_180501_a(pos, state, 4);
                }
                if (!flag) {
                    if (!this.areNeighborsFlammable((IBlockReader)world, pos)) {
                        BlockPos blockpos = pos.func_177977_b();
                        if (!world.func_180495_p(blockpos).func_224755_d((IBlockReader)world, blockpos, Direction.UP) || i > 3) {
                            world.func_217377_a(pos, false);
                        }
                        return;
                    }
                    if (i == 15 && rand.nextInt(4) == 0 && !this.canCatchFire((IBlockReader)world, pos.func_177977_b(), Direction.UP)) {
                        world.func_217377_a(pos, false);
                        return;
                    }
                }
                if (!SkiesPlayerEvents.DungeonBalancingChecks.isPlacementInBossRoom((World)world, pos)) {
                    boolean flag1 = world.func_180502_D(pos);
                    int k = flag1 ? -50 : 0;
                    this.tryCatchFire((World)world, pos.func_177974_f(), 300 + k, rand, i, Direction.WEST);
                    this.tryCatchFire((World)world, pos.func_177976_e(), 300 + k, rand, i, Direction.EAST);
                    this.tryCatchFire((World)world, pos.func_177977_b(), 250 + k, rand, i, Direction.UP);
                    this.tryCatchFire((World)world, pos.func_177984_a(), 250 + k, rand, i, Direction.DOWN);
                    this.tryCatchFire((World)world, pos.func_177978_c(), 300 + k, rand, i, Direction.SOUTH);
                    this.tryCatchFire((World)world, pos.func_177968_d(), 300 + k, rand, i, Direction.NORTH);
                    BlockPos.Mutable blockpos$mutable = new BlockPos.Mutable();
                    for (int l = -1; l <= 1; ++l) {
                        for (int i1 = -1; i1 <= 1; ++i1) {
                            for (int j1 = -1; j1 <= 4; ++j1) {
                                if (l == 0 && j1 == 0 && i1 == 0) continue;
                                int k1 = 100;
                                if (j1 > 1) {
                                    k1 += (j1 - 1) * 100;
                                }
                                blockpos$mutable.func_239621_a_((Vector3i)pos, l, j1, i1);
                                int l1 = this.getNeighborEncouragement((IWorldReader)world, (BlockPos)blockpos$mutable);
                                if (l1 <= 0) continue;
                                int i2 = (l1 + 40 + world.func_175659_aa().func_151525_a() * 7) / (i + 30);
                                if (flag1) {
                                    i2 /= 2;
                                }
                                if (i2 <= 0 || rand.nextInt(k1) > i2 || world.func_72896_J() && this.func_176537_d((World)world, (BlockPos)blockpos$mutable)) continue;
                                int j2 = Math.min(15, i + rand.nextInt(5) / 4);
                                world.func_180501_a((BlockPos)blockpos$mutable, this.getFireWithAge((IWorld)world, (BlockPos)blockpos$mutable, j2), 3);
                            }
                        }
                    }
                }
            }
        }
    }

    private void tryCatchFire(World world, BlockPos pos, int chance, Random rand, int age, Direction face) {
        if (rand.nextInt(chance) < world.func_180495_p(pos).getFlammability((IBlockReader)world, pos, face)) {
            BlockState blockstate = world.func_180495_p(pos);
            if (rand.nextInt(age + 10) < 5 && !world.func_175727_C(pos)) {
                world.func_180501_a(pos, this.getFireWithAge((IWorld)world, pos, Math.min(age + rand.nextInt(5) / 4, 15)), 3);
            } else {
                world.func_217377_a(pos, false);
            }
            blockstate.catchFire(world, pos, face, null);
        }
    }

    private BlockState getFireWithAge(IWorld world, BlockPos pos, int age) {
        BlockState state = this.func_196448_a((IBlockReader)world, pos);
        return state.func_203425_a((Block)this) ? (BlockState)state.func_206870_a((Property)field_176543_a, (Comparable)Integer.valueOf(age)) : state;
    }

    private boolean areNeighborsFlammable(IBlockReader world, BlockPos pos) {
        for (Direction direction : Direction.values()) {
            if (!this.canCatchFire(world, pos.func_177972_a(direction), direction.func_176734_d())) continue;
            return true;
        }
        return false;
    }

    private int getNeighborEncouragement(IWorldReader world, BlockPos pos) {
        if (!world.func_175623_d(pos)) {
            return 0;
        }
        int i = 0;
        for (Direction direction : Direction.values()) {
            i = Math.max(world.func_180495_p(pos.func_177972_a(direction)).getFireSpreadSpeed((IBlockReader)world, pos.func_177972_a(direction), direction.func_176734_d()), i);
        }
        return i;
    }

    private static int getTickCooldown(Random rand) {
        return 30 + rand.nextInt(10);
    }
}

