/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.blue_skies.blocks;

import com.google.common.collect.ImmutableList;
import com.legacy.blue_skies.BlueSkies;
import com.legacy.blue_skies.registries.SkiesBlocks;
import com.legacy.blue_skies.registries.SkiesDimensions;
import com.legacy.blue_skies.registries.SkiesParticles;
import com.legacy.blue_skies.registries.SkiesSounds;
import com.legacy.blue_skies.registries.SkiesStructures;
import com.legacy.blue_skies.util.LogicUtil;
import com.legacy.structure_gel.blocks.GelPortalBlock;
import com.legacy.structure_gel.util.GelTeleporter;
import java.util.List;
import java.util.Optional;
import java.util.Random;
import java.util.function.Supplier;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.client.audio.ISound;
import net.minecraft.client.audio.SimpleSound;
import net.minecraft.entity.LivingEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.particles.IParticleData;
import net.minecraft.state.Property;
import net.minecraft.util.Direction;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.TeleportationRepositioner;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.SectionPos;
import net.minecraft.village.PointOfInterestType;
import net.minecraft.world.World;
import net.minecraft.world.gen.feature.structure.Structure;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class SkyPortalBlock
extends GelPortalBlock {
    public static final List<Block> ALLOWED_INSIDE_BLOCKS = ImmutableList.of((Object)Blocks.field_150480_ab, (Object)SkiesBlocks.blue_fire, (Object)SkiesBlocks.black_fire, (Object)SkiesBlocks.upsidedown_blue_fire, (Object)SkiesBlocks.upsidedown_black_fire);
    private final boolean isEverbright;

    public SkyPortalBlock(Supplier<RegistryKey<World>> startingDimensionIn, Supplier<RegistryKey<World>> endpointDimensionIn, Supplier<PointOfInterestType> portalPOI, Supplier<GelPortalBlock> portalBlockIn, Supplier<BlockState> frameBlockIn, boolean isEverbright) {
        super(AbstractBlock.Properties.func_200950_a((AbstractBlock)Blocks.field_150427_aO).func_222380_e(), world -> new Teleporter((ServerWorld)world, startingDimensionIn, endpointDimensionIn, portalPOI, portalBlockIn, frameBlockIn));
        this.isEverbright = isEverbright;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_180655_c(BlockState stateIn, World worldIn, BlockPos pos, Random rand) {
        if (rand.nextInt(190) == 0) {
            if (this == SkiesBlocks.everdawn_portal) {
                worldIn.func_184134_a((double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5, SkiesSounds.BLOCK_EVERDAWN_PORTAL, SoundCategory.BLOCKS, 0.3f, 1.0f, false);
            } else {
                worldIn.func_184134_a((double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5, SkiesSounds.BLOCK_EVERBRIGHT_PORTAL, SoundCategory.BLOCKS, 0.4f, rand.nextFloat() * 0.4f + 0.8f, false);
            }
        }
        for (int i = 0; i < 2; ++i) {
            double x = LogicUtil.plusOrMinus((double)pos.func_177958_n() + 0.5, 0.45, rand);
            double y = LogicUtil.plusOrMinus((double)pos.func_177956_o() + 0.5, 0.45, rand);
            double z = LogicUtil.plusOrMinus((double)pos.func_177952_p() + 0.5, 0.45, rand);
            double dx = LogicUtil.plusOrMinus(0.06, rand);
            double dy = this.isEverbright ? -1.0E-4 : 1.0E-4;
            double dz = LogicUtil.plusOrMinus(0.001, rand);
            if (stateIn.func_177229_b((Property)field_176550_a) == Direction.Axis.X) {
                dx = LogicUtil.plusOrMinus(0.001, rand);
                dz = LogicUtil.plusOrMinus(0.06, rand);
                z = (double)pos.func_177952_p() + 0.5;
            } else {
                x = (double)pos.func_177958_n() + 0.5;
            }
            worldIn.func_195594_a((IParticleData)(this.isEverbright ? SkiesParticles.EVERBRIGHT_PORTAL : SkiesParticles.EVERDAWN_PORTAL), x, y, z, dx, dy, dz);
        }
    }

    public void func_180633_a(World worldIn, BlockPos pos, BlockState state, LivingEntity placer, ItemStack stack) {
        int z;
        int x;
        int y;
        BlockState frameBlock = (BlockState)this.getTeleporter(null).getFrameBlock().get();
        for (y = -1; y <= 3; ++y) {
            if (placer.func_174811_aO() == Direction.NORTH || placer.func_174811_aO() == Direction.SOUTH) {
                for (x = -1; x <= 2; ++x) {
                    worldIn.func_180501_a(pos.func_177982_a(x, y, 0), frameBlock, 18);
                }
                continue;
            }
            for (z = -1; z <= 2; ++z) {
                worldIn.func_180501_a(pos.func_177982_a(0, y, z), frameBlock, 18);
            }
        }
        for (y = 0; y <= 2; ++y) {
            if (placer.func_174811_aO() == Direction.NORTH || placer.func_174811_aO() == Direction.SOUTH) {
                for (x = 0; x <= 1; ++x) {
                    worldIn.func_180501_a(pos.func_177982_a(x, y, 0), (BlockState)this.func_176223_P().func_206870_a((Property)field_176550_a, (Comparable)Direction.Axis.X), 18);
                }
                continue;
            }
            for (z = 0; z <= 1; ++z) {
                worldIn.func_180501_a(pos.func_177982_a(0, y, z), (BlockState)this.func_176223_P().func_206870_a((Property)field_176550_a, (Comparable)Direction.Axis.Z), 18);
            }
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public ISound getTriggerSound() {
        if (this.isEverbright) {
            return SimpleSound.func_239532_b_((SoundEvent)SkiesSounds.BLOCK_EVERBRIGHT_PORTAL_TRIGGER, (float)(new Random().nextFloat() * 0.2f + 0.9f), (float)0.4f);
        }
        return SimpleSound.func_239532_b_((SoundEvent)SkiesSounds.BLOCK_EVERDAWN_PORTAL_TRIGGER, (float)(new Random().nextFloat() * 0.2f + 0.9f), (float)0.35f);
    }

    @OnlyIn(value=Dist.CLIENT)
    public ISound getTravelSound() {
        if (this.isEverbright) {
            return SimpleSound.func_239532_b_((SoundEvent)SkiesSounds.BLOCK_EVERBRIGHT_PORTAL_TRAVEL, (float)(new Random().nextFloat() * 0.4f + 0.8f), (float)1.0f);
        }
        return SimpleSound.func_239532_b_((SoundEvent)SkiesSounds.BLOCK_EVERDAWN_PORTAL_TRAVEL, (float)(new Random().nextFloat() * 0.2f + 0.9f), (float)1.0f);
    }

    private static final class Teleporter
    extends GelTeleporter {
        public Teleporter(ServerWorld world, Supplier<RegistryKey<World>> dimension1, Supplier<RegistryKey<World>> dimension2, Supplier<PointOfInterestType> portalPOI, Supplier<GelPortalBlock> portalBlock, Supplier<BlockState> frameBlock) {
            super(world, dimension1, dimension2, portalPOI, portalBlock, frameBlock, Teleporter::makeNew);
        }

        public Optional<TeleportationRepositioner.Result> func_242957_a(BlockPos startPos, boolean toNether) {
            Optional result = super.func_242957_a(startPos, toNether);
            if (result.isPresent()) {
                return result;
            }
            return super.func_242957_a(Teleporter.shiftPosition(this, startPos), toNether);
        }

        public static Optional<TeleportationRepositioner.Result> makeNew(GelTeleporter teleporter, BlockPos startPos, Direction.Axis enterAxis) {
            return GelTeleporter.createAndFindPortalSurface((GelTeleporter)teleporter, (BlockPos)Teleporter.shiftPosition(teleporter, startPos), (Direction.Axis)enterAxis);
        }

        private static BlockPos shiftPosition(GelTeleporter teleporter, BlockPos startPos) {
            BlockPos newPos = startPos;
            RegistryKey destWorldKey = teleporter.getWorld().func_234923_W_();
            ResourceLocation destWorldLocation = destWorldKey.func_240901_a_();
            if (destWorldLocation.equals((Object)SkiesDimensions.EVERBRIGHT_ID) || destWorldLocation.equals((Object)SkiesDimensions.EVERDAWN_ID)) {
                boolean shiftPortal;
                ServerWorld destWorld = teleporter.getWorld().func_73046_m().func_71218_a(destWorldKey);
                int moves = 0;
                do {
                    shiftPortal = false;
                    for (Structure<?> dungeon : SkiesStructures.dungeons) {
                        if (!destWorld.func_241827_a(SectionPos.func_218167_a((BlockPos)newPos), dungeon).findAny().isPresent()) continue;
                        shiftPortal = true;
                        newPos = newPos.func_177964_d(64);
                        ++moves;
                        break;
                    }
                    if (moves <= 10) continue;
                    BlueSkies.LOGGER.info("Hit the portal position distance shifting limit.");
                    break;
                } while (shiftPortal);
            }
            return newPos;
        }
    }
}

