/*
 * Decompiled with CFR 0.152.
 */
package com.endertech.minecraft.forge.units;

import com.endertech.minecraft.forge.core.ForgeMod;
import com.endertech.minecraft.forge.units.UnitsInit;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;

public class RegistryEntriesInit<E extends IForgeRegistryEntry<E>>
extends UnitsInit<E> {
    public RegistryEntriesInit(ForgeMod mod, Class<? super E> entryClass) {
        super(mod);
        mod.getModEventBus().addGenericListener(entryClass, this::registerEntries);
    }

    public <U extends E> U addNew(String name, U unit) {
        ResourceLocation registryName = new ResourceLocation(this.getMod().getId(), name);
        unit.setRegistryName(registryName);
        return (U)((IForgeRegistryEntry)this.addNew(unit));
    }

    protected void registerEntries(RegistryEvent.Register<E> event) {
        this.getAll().forEach(entry -> this.registerEntry(event.getRegistry(), entry));
    }

    protected void registerEntry(IForgeRegistry<E> registry, E entry) {
        if (entry.getRegistryName() == null) {
            throw new NullPointerException("No registry name for " + entry.getClass().getSimpleName());
        }
        registry.register(entry);
    }
}

