/*
 * Decompiled with CFR 0.152.
 */
package com.endertech.minecraft.forge.units;

import com.endertech.minecraft.forge.configs.IForgeEnum;
import com.endertech.minecraft.forge.configs.IHaveConfig;
import com.endertech.minecraft.forge.configs.UnitConfig;
import com.endertech.minecraft.forge.core.ForgeMod;
import com.endertech.minecraft.forge.units.UnitId;
import com.endertech.minecraft.forge.units.UnitVariant;
import com.endertech.minecraft.forge.world.GameWorld;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.world.IWorldReader;
import net.minecraftforge.registries.IForgeRegistryEntry;

public interface IForgeUnit<U>
extends IHaveConfig,
IForgeRegistryEntry<U> {
    public static UnitConfig createConfig(ForgeMod mod, String folder, Class<?> clazz) {
        Path baseDir = mod.getConfigsDir().resolve(folder);
        String configName = IForgeUnit.getClassRegName(clazz);
        return UnitConfig.in(baseDir, configName);
    }

    default public <E extends Enum<E>> Map<Object, UnitVariant> createUnitVariants(Class<E> clazz) {
        HashMap<Object, UnitVariant> map = new HashMap<Object, UnitVariant>();
        for (Enum en : (Enum[])clazz.getEnumConstants()) {
            UnitVariant variant = UnitVariant.from(this.getRegistryName(), en);
            map.put(en, variant);
        }
        return map;
    }

    public static String getClassRegName(Class<?> clazz) {
        return UnitId.dictToRegName(clazz.getSimpleName());
    }

    default public String getClassRegName() {
        return IForgeUnit.getClassRegName(this.getClass());
    }

    default public String getUnitCategory() {
        return this.getRegistryName().func_110623_a();
    }

    default public boolean isServerSide(IWorldReader world) {
        return GameWorld.isServerSide(world);
    }

    default public boolean isClientSide(IWorldReader world) {
        return GameWorld.isClientSide(world);
    }

    public boolean isEnabled();

    public Map<Object, UnitVariant> getUnitVariants();

    public UnitVariant getDefaultVariant();

    default public UnitVariant getVariant(Object key) {
        return this.getUnitVariants().getOrDefault(key, this.getDefaultVariant());
    }

    public <E extends Enum<E>> void setUnitVariants(Class<E> var1);

    public static enum Variants implements IForgeEnum
    {
        NORMAL,
        INVENTORY;

    }
}

