/*
 * Decompiled with CFR 0.152.
 */
package com.endertech.minecraft.forge.data;

import com.endertech.common.IntBounds;
import com.endertech.minecraft.forge.configs.UnitConfig;
import com.endertech.minecraft.forge.data.INBTSerializable;
import com.endertech.minecraft.forge.data.Names;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraftforge.energy.IEnergyStorage;

public class ForgeEnergy {
    public static final String NAME = "ForgeEnergy";

    public static class Storage
    implements IEnergyStorage,
    INBTSerializable<Storage> {
        protected boolean enabled;
        protected int capacity;
        protected int consumption;
        protected int energy;

        protected Storage(StorageProps props) {
            this(props, 0);
        }

        public Storage(StorageProps props, int energy) {
            this.enabled = props.enabled;
            this.capacity = props.capacity;
            this.consumption = props.consumption;
            this.energy = energy;
        }

        public static Storage empty() {
            return new Storage(StorageProps.EMPTY);
        }

        public static Storage with(StorageProps props) {
            return new Storage(props);
        }

        public Storage set(StorageProps props) {
            this.enabled = props.enabled;
            this.capacity = props.capacity;
            this.consumption = props.consumption;
            this.energy = this.correctedEnergy(this.energy);
            return this;
        }

        public boolean hasEnoughEnergy() {
            return this.extractEnergy(this.getConsumption(), true) == this.getConsumption();
        }

        public boolean isEnabled() {
            return this.enabled;
        }

        public int getConsumption() {
            return this.consumption;
        }

        public int receiveEnergy(int maxReceive, boolean simulate) {
            if (!this.canReceive()) {
                return 0;
            }
            int canReceive = Math.min(this.getMaxEnergyStored() - this.getEnergyStored(), this.getConsumption());
            int energyReceived = Math.min(canReceive, maxReceive);
            if (!simulate) {
                this.energy += energyReceived;
            }
            return energyReceived;
        }

        public int extractEnergy(int maxExtract, boolean simulate) {
            if (!this.canExtract()) {
                return 0;
            }
            int canExtract = Math.min(this.getEnergyStored(), this.getConsumption());
            int energyExtracted = Math.min(canExtract, maxExtract);
            if (!simulate) {
                this.energy -= energyExtracted;
            }
            return energyExtracted;
        }

        public int consumeEnergy() {
            return this.isEnabled() ? this.extractEnergy(this.getConsumption(), false) : 0;
        }

        public int getEnergyStored() {
            return this.energy;
        }

        public int getMaxEnergyStored() {
            return this.capacity;
        }

        public boolean canExtract() {
            return this.getEnergyStored() > 0;
        }

        public boolean canReceive() {
            return this.getEnergyStored() < this.getMaxEnergyStored();
        }

        protected int correctedEnergy(int energy) {
            return IntBounds.from(0, this.getMaxEnergyStored()).enclose(energy);
        }

        @Override
        public Storage readFrom(CompoundNBT compound) {
            if (compound.func_74764_b(ForgeEnergy.NAME)) {
                CompoundNBT tag = compound.func_74775_l(ForgeEnergy.NAME);
                this.enabled = tag.func_74767_n("enabled");
                this.capacity = tag.func_74762_e("capacity");
                this.consumption = tag.func_74762_e("consumption");
                this.energy = this.correctedEnergy(tag.func_74762_e("energy"));
            }
            return this;
        }

        @Override
        public CompoundNBT writeTo(CompoundNBT compound) {
            CompoundNBT tag = new CompoundNBT();
            tag.func_74757_a("enabled", this.isEnabled());
            tag.func_74768_a("capacity", this.getMaxEnergyStored());
            tag.func_74768_a("consumption", this.getConsumption());
            tag.func_74768_a("energy", this.getEnergyStored());
            compound.func_218657_a(ForgeEnergy.NAME, (INBT)tag);
            return compound;
        }
    }

    public static class StorageProps {
        public static final StorageProps EMPTY = new StorageProps(null, "", false, 0, 0);
        public final boolean enabled;
        public final int capacity;
        public final int consumption;

        protected StorageProps(UnitConfig config, String headCategory, boolean enabled, int capacity, int consumption) {
            String category = Names.dotted().join(headCategory, ForgeEnergy.NAME);
            this.enabled = UnitConfig.getBool(config, category, "enabled", enabled, "Whether Forge Energy is required or not");
            this.capacity = UnitConfig.getInt(config, category, "capacity", capacity, IntBounds.from(0, 100000), "Maximum amount of energy that can be held");
            this.consumption = UnitConfig.getInt(config, category, "consumption", consumption, IntBounds.from(0, 1000), "Amount of energy consumed per operation or second");
        }

        public static StorageProps create(UnitConfig config, String headCategory, boolean enabled, int capacity, int consumption) {
            return new StorageProps(config, headCategory, enabled, capacity, consumption);
        }
    }
}

