/*
 * Decompiled with CFR 0.152.
 */
package com.endertech.minecraft.forge.coremod.signatures;

import com.endertech.minecraft.forge.coremod.descriptors.Classes;
import com.endertech.minecraft.forge.coremod.descriptors.Descriptor;
import com.endertech.minecraft.forge.coremod.descriptors.MethodDescriptor;
import com.endertech.minecraft.forge.coremod.descriptors.Types;
import com.endertech.minecraft.forge.coremod.names.ClassName;
import com.endertech.minecraft.forge.coremod.names.MethodName;
import com.endertech.minecraft.forge.coremod.names.Name;
import com.endertech.minecraft.forge.coremod.signatures.Signature;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.MethodNode;

public class MethodSignature
extends Signature {
    public static final MethodSignature ENTITY_ON_ENTITY_UPDATE = MethodSignature.of(Classes.ENTITY.name, "onEntityUpdate", "func_70030_z", MethodDescriptor.VOID);
    public static final MethodSignature ENTITY_ON_UPDATE = MethodSignature.of(Classes.ENTITY.name, "onUpdate", "func_70071_h_", MethodDescriptor.VOID);
    public static final MethodSignature FLUID_TANK_GET_FLUID = MethodSignature.of(Classes.FLUID_TANK.name, "getFluid", MethodDescriptor.of(Classes.FLUID_STACK));
    public static final MethodSignature FLUID_TANK_DRAIN = MethodSignature.of(Classes.FLUID_TANK.name, "drain", MethodDescriptor.of(Classes.FLUID_STACK).withParameters(Types.INT, Types.BOOLEAN));
    public static final MethodSignature ITEM_STACK_GET_COUNT = MethodSignature.of(Classes.ITEM_STACK.name, "getCount", "func_190916_E", MethodDescriptor.of(Types.INT));
    public static final MethodSignature ITEM_STACK_SET_COUNT = MethodSignature.of(Classes.ITEM_STACK.name, "setCount", "func_190920_e", MethodDescriptor.VOID.withParameters(Types.INT));
    public static final MethodSignature ITEM_STACK_SHRINK = MethodSignature.of(Classes.ITEM_STACK.name, "shrink", "func_190918_g", MethodDescriptor.VOID.withParameters(Types.INT));
    public static final MethodSignature ITEM_STACK_SPLIT_STACK = MethodSignature.of(Classes.ITEM_STACK.name, "splitStack", "func_77979_a", MethodDescriptor.of(Classes.ITEM_STACK).withParameters(Types.INT));
    public static final MethodSignature I_TICKABLE_UPDATE = MethodSignature.of(ClassName.from("net.minecraft.util.ITickable"), "update", "func_73660_a", MethodDescriptor.VOID);
    public static final MethodSignature I_INVENTORY_DECR_STACK_SIZE = MethodSignature.of(Classes.IINVENTORY.name, "decrStackSize", "func_70298_a", MethodDescriptor.of(Classes.ITEM_STACK).withParameters(Types.INT, Types.INT));
    public static final MethodSignature I_INVENTORY_GET_STACK_IN_SLOT = MethodSignature.of(Classes.IINVENTORY.name, "getStackInSlot", "func_70301_a", MethodDescriptor.of(Classes.ITEM_STACK).withParameters(Types.INT));
    public static final MethodSignature NON_NULL_LIST_GET = MethodSignature.of(Classes.NON_NULL_LIST.name, "get", MethodDescriptor.of(Classes.OBJECT).withParameters(Types.INT));
    public static final MethodSignature TEXTURE_MANAGER_BIND_TEXTURE = MethodSignature.of(Classes.TEXTURE_MANAGER.name, "bindTexture", "func_110577_a", MethodDescriptor.VOID.withParameters(Classes.RESOURCE_LOCATION));
    public static final MethodSignature WORLD_GET_BLOCK_STATE = MethodSignature.of(Classes.WORLD.name, "getBlockState", MethodDescriptor.of(Classes.BLOCK_STATE).withParameters(Classes.BLOCK_POS));

    protected MethodSignature(ClassName className, MethodName methodName, Descriptor descriptor) {
        super(className, methodName, descriptor);
    }

    private MethodSignature(ClassName className, Name methodName, Descriptor descriptor) {
        super(className, methodName, descriptor);
    }

    public static MethodSignature of(ClassName className, MethodName methodName, MethodDescriptor descriptor) {
        return new MethodSignature(className, methodName, (Descriptor)descriptor);
    }

    public static MethodSignature of(ClassName className, String methodNormalName, String methodSrgName, MethodDescriptor descriptor) {
        return new MethodSignature(className, MethodName.of(className, methodNormalName, methodSrgName), (Descriptor)descriptor);
    }

    public static MethodSignature of(ClassName className, String methodName, MethodDescriptor descriptor) {
        return new MethodSignature(className, MethodName.of(className, methodName), (Descriptor)descriptor);
    }

    public static MethodSignature of(String className, String methodName, MethodDescriptor descriptor) {
        return MethodSignature.of(ClassName.from(className), methodName, descriptor);
    }

    public boolean complyWith(MethodNode method) {
        return this.name.complyWith(method.name) && this.descriptor.complyWith(method.desc);
    }

    public boolean complyWith(MethodInsnNode instruct) {
        return this.className.complyWith(instruct.owner) && this.name.complyWith(instruct.name) && this.descriptor.complyWith(instruct.desc);
    }

    public MethodSignature with(String className) {
        return new MethodSignature(ClassName.from(className), this.name, this.descriptor);
    }
}

