/*
 * Decompiled with CFR 0.152.
 */
package top.theillusivec4.curios.common.capability;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.ai.attributes.Attribute;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.nbt.StringNBT;
import net.minecraft.util.Direction;
import net.minecraft.util.NonNullList;
import net.minecraft.util.Tuple;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.capabilities.ICapabilitySerializable;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.ItemHandlerHelper;
import net.minecraftforge.items.ItemStackHandler;
import top.theillusivec4.curios.api.CuriosApi;
import top.theillusivec4.curios.api.CuriosCapability;
import top.theillusivec4.curios.api.SlotContext;
import top.theillusivec4.curios.api.type.ISlotType;
import top.theillusivec4.curios.api.type.capability.ICuriosItemHandler;
import top.theillusivec4.curios.api.type.inventory.ICurioStacksHandler;
import top.theillusivec4.curios.api.type.inventory.IDynamicStackHandler;
import top.theillusivec4.curios.api.type.util.ICuriosHelper;
import top.theillusivec4.curios.api.type.util.ISlotHelper;
import top.theillusivec4.curios.common.CuriosHelper;
import top.theillusivec4.curios.common.inventory.CurioStacksHandler;

public class CurioInventoryCapability {
    public static void register() {
        CapabilityManager.INSTANCE.register(ICuriosItemHandler.class, (Capability.IStorage)new Capability.IStorage<ICuriosItemHandler>(){

            public INBT writeNBT(Capability<ICuriosItemHandler> capability, ICuriosItemHandler instance, Direction side) {
                return instance.writeNBT();
            }

            public void readNBT(Capability<ICuriosItemHandler> capability, ICuriosItemHandler instance, Direction side, INBT nbt) {
                instance.readNBT((CompoundNBT)nbt);
            }
        }, CurioInventoryWrapper::new);
    }

    public static ICapabilityProvider createProvider(PlayerEntity playerEntity) {
        return new Provider(playerEntity);
    }

    public static class Provider
    implements ICapabilitySerializable<INBT> {
        final LazyOptional<ICuriosItemHandler> optional;
        final ICuriosItemHandler handler;

        Provider(PlayerEntity playerEntity) {
            this.handler = new CurioInventoryWrapper(playerEntity);
            this.optional = LazyOptional.of(() -> this.handler);
        }

        @Nonnull
        public <T> LazyOptional<T> getCapability(@Nullable Capability<T> capability, Direction facing) {
            return CuriosCapability.INVENTORY.orEmpty(capability, this.optional);
        }

        public INBT serializeNBT() {
            return CuriosCapability.INVENTORY.writeNBT((Object)this.handler, null);
        }

        public void deserializeNBT(INBT nbt) {
            CuriosCapability.INVENTORY.readNBT((Object)this.handler, null, nbt);
        }
    }

    public static class CurioInventoryWrapper
    implements ICuriosItemHandler {
        Map<String, ICurioStacksHandler> curios = new LinkedHashMap<String, ICurioStacksHandler>();
        Set<String> locked = new HashSet<String>();
        NonNullList<ItemStack> invalidStacks = NonNullList.func_191196_a();
        PlayerEntity wearer;
        Set<String> toLock = new HashSet<String>();
        List<UnlockState> toUnlock = new ArrayList<UnlockState>();
        Tuple<Integer, Integer> fortuneAndLooting = new Tuple((Object)0, (Object)0);
        Set<ICurioStacksHandler> updates = new HashSet<ICurioStacksHandler>();

        CurioInventoryWrapper() {
            this(null);
        }

        CurioInventoryWrapper(PlayerEntity playerEntity) {
            this.wearer = playerEntity;
            this.reset();
        }

        @Override
        public void reset() {
            ISlotHelper slotHelper = CuriosApi.getSlotHelper();
            if (slotHelper != null && this.wearer != null && !this.wearer.func_130014_f_().func_201670_d()) {
                this.locked.clear();
                this.curios.clear();
                this.invalidStacks.clear();
                TreeSet<ISlotType> sorted = new TreeSet<ISlotType>(slotHelper.getSlotTypes((LivingEntity)this.wearer));
                for (ISlotType slotType : sorted) {
                    this.curios.put(slotType.getIdentifier(), new CurioStacksHandler(this, slotType.getIdentifier(), slotType.getSize(), 0, slotType.isVisible(), slotType.hasCosmetic()));
                }
            }
        }

        @Override
        public int getSlots() {
            int totalSlots = 0;
            for (ICurioStacksHandler stacks : this.curios.values()) {
                totalSlots += stacks.getSlots();
            }
            return totalSlots;
        }

        @Override
        public int getVisibleSlots() {
            int totalSlots = 0;
            for (ICurioStacksHandler stacks : this.curios.values()) {
                if (!stacks.isVisible()) continue;
                totalSlots += stacks.getSlots();
            }
            return totalSlots;
        }

        @Override
        public Set<String> getLockedSlots() {
            return Collections.unmodifiableSet(this.locked);
        }

        @Override
        public Optional<ICurioStacksHandler> getStacksHandler(String identifier) {
            return Optional.ofNullable(this.curios.get(identifier));
        }

        @Override
        public Map<String, ICurioStacksHandler> getCurios() {
            return Collections.unmodifiableMap(this.curios);
        }

        @Override
        public void setCurios(Map<String, ICurioStacksHandler> curios) {
            this.curios = curios;
        }

        @Override
        public void unlockSlotType(String identifier, int amount, boolean visible, boolean cosmetic) {
            this.toUnlock.add(new UnlockState(identifier, amount, visible, cosmetic));
        }

        @Override
        public void lockSlotType(String identifier) {
            this.toLock.add(identifier);
        }

        @Override
        public void processSlots() {
            this.toLock.forEach(id -> this.getStacksHandler((String)id).ifPresent(stackHandler -> {
                this.curios.remove(id);
                this.locked.add((String)id);
                this.loseStacks(stackHandler.getStacks(), (String)id, stackHandler.getSlots());
            }));
            this.toUnlock.forEach(state -> {
                this.curios.putIfAbsent(state.identifier, new CurioStacksHandler(this, state.identifier, state.amount, 0, state.visible, state.cosmetic));
                this.locked.remove(state.identifier);
            });
            this.toLock.clear();
            this.toUnlock.clear();
        }

        @Override
        public void growSlotType(String identifier, int amount) {
            if (amount > 0) {
                this.getStacksHandler(identifier).ifPresent(stackHandler -> stackHandler.grow(amount));
            }
        }

        @Override
        public void shrinkSlotType(String identifier, int amount) {
            if (amount > 0) {
                this.getStacksHandler(identifier).ifPresent(stackHandler -> stackHandler.shrink(amount));
            }
        }

        @Override
        @Nullable
        public LivingEntity getWearer() {
            return this.wearer;
        }

        @Override
        public void loseInvalidStack(ItemStack stack) {
            this.invalidStacks.add((Object)stack);
        }

        @Override
        public void handleInvalidStacks() {
            if (this.wearer != null && !this.invalidStacks.isEmpty()) {
                this.invalidStacks.forEach(drop -> ItemHandlerHelper.giveItemToPlayer((PlayerEntity)this.wearer, (ItemStack)drop));
                this.invalidStacks = NonNullList.func_191196_a();
            }
        }

        private void loseStacks(IDynamicStackHandler stackHandler, String identifier, int amount) {
            if (this.wearer != null && !this.wearer.func_130014_f_().func_201670_d()) {
                ArrayList<ItemStack> drops = new ArrayList<ItemStack>();
                for (int i = Math.max(0, stackHandler.getSlots() - amount); i >= 0 && i < stackHandler.getSlots(); ++i) {
                    ItemStack stack = stackHandler.getStackInSlot(i);
                    drops.add(stackHandler.getStackInSlot(i));
                    SlotContext slotContext = new SlotContext(identifier, (LivingEntity)this.wearer, i);
                    if (!stack.func_190926_b()) {
                        UUID uuid = UUID.nameUUIDFromBytes((identifier + i).getBytes());
                        this.wearer.func_233645_dx_().func_233785_a_(CuriosApi.getCuriosHelper().getAttributeModifiers(slotContext, uuid, stack));
                        CuriosApi.getCuriosHelper().getCurio(stack).ifPresent(curio -> curio.onUnequip(slotContext, ItemStack.field_190927_a));
                    }
                    stackHandler.setStackInSlot(i, ItemStack.field_190927_a);
                }
                drops.forEach(drop -> ItemHandlerHelper.giveItemToPlayer((PlayerEntity)this.wearer, (ItemStack)drop));
            }
        }

        @Override
        public int getFortuneBonus() {
            return (Integer)this.fortuneAndLooting.func_76341_a();
        }

        @Override
        public int getLootingBonus() {
            return (Integer)this.fortuneAndLooting.func_76340_b();
        }

        @Override
        public ListNBT saveInventory(boolean clear) {
            ListNBT taglist = new ListNBT();
            for (Map.Entry<String, ICurioStacksHandler> entry : this.curios.entrySet()) {
                int i;
                CompoundNBT tag = new CompoundNBT();
                ICurioStacksHandler stacksHandler = entry.getValue();
                IDynamicStackHandler stacks = stacksHandler.getStacks();
                IDynamicStackHandler cosmetics = stacksHandler.getCosmeticStacks();
                tag.func_218657_a("Stacks", (INBT)stacks.serializeNBT());
                tag.func_218657_a("Cosmetics", (INBT)cosmetics.serializeNBT());
                tag.func_74778_a("Identifier", entry.getKey());
                taglist.add((Object)tag);
                if (!clear) continue;
                for (i = 0; i < stacks.getSlots(); ++i) {
                    stacks.setStackInSlot(i, ItemStack.field_190927_a);
                }
                for (i = 0; i < cosmetics.getSlots(); ++i) {
                    cosmetics.setStackInSlot(i, ItemStack.field_190927_a);
                }
            }
            return taglist;
        }

        @Override
        public void loadInventory(ListNBT data) {
            if (data != null) {
                for (int i = 0; i < data.size(); ++i) {
                    CompoundNBT tag = data.func_150305_b(i);
                    String identifier = tag.func_74779_i("Identifier");
                    ICurioStacksHandler stacksHandler = this.curios.get(identifier);
                    if (stacksHandler == null) continue;
                    CompoundNBT stacksData = tag.func_74775_l("Stacks");
                    ItemStackHandler loaded = new ItemStackHandler();
                    IDynamicStackHandler stacks = stacksHandler.getStacks();
                    if (!stacksData.isEmpty()) {
                        loaded.deserializeNBT(stacksData);
                        this.loadStacks(stacksHandler, loaded, stacks);
                    }
                    if ((stacksData = tag.func_74775_l("Cosmetics")).isEmpty()) continue;
                    loaded.deserializeNBT(stacksData);
                    stacks = stacksHandler.getCosmeticStacks();
                    this.loadStacks(stacksHandler, loaded, stacks);
                }
            }
        }

        private void loadStacks(ICurioStacksHandler stacksHandler, ItemStackHandler loaded, IDynamicStackHandler stacks) {
            for (int j = 0; j < stacksHandler.getSlots() && j < loaded.getSlots(); ++j) {
                ItemStack stack = stacks.getStackInSlot(j);
                ItemStack loadedStack = loaded.getStackInSlot(j);
                if (stack.func_190926_b()) {
                    stacks.setStackInSlot(j, loadedStack);
                    continue;
                }
                this.loseInvalidStack(stack);
            }
        }

        @Override
        public void setEnchantmentBonuses(Tuple<Integer, Integer> fortuneAndLootingIn) {
            this.fortuneAndLooting = fortuneAndLootingIn;
        }

        @Override
        public Set<ICurioStacksHandler> getUpdatingInventories() {
            return this.updates;
        }

        @Override
        public void addTransientSlotModifiers(Multimap<String, AttributeModifier> modifiers) {
            for (Map.Entry entry : modifiers.asMap().entrySet()) {
                String id = (String)entry.getKey();
                for (AttributeModifier attributeModifier : (Collection)entry.getValue()) {
                    ICurioStacksHandler stacksHandler = this.curios.get(id);
                    if (stacksHandler == null) continue;
                    stacksHandler.addTransientModifier(attributeModifier);
                }
            }
        }

        @Override
        public void addPermanentSlotModifiers(Multimap<String, AttributeModifier> modifiers) {
            for (Map.Entry entry : modifiers.asMap().entrySet()) {
                String id = (String)entry.getKey();
                for (AttributeModifier attributeModifier : (Collection)entry.getValue()) {
                    ICurioStacksHandler stacksHandler = this.curios.get(id);
                    if (stacksHandler == null) continue;
                    stacksHandler.addPermanentModifier(attributeModifier);
                }
            }
        }

        @Override
        public void removeSlotModifiers(Multimap<String, AttributeModifier> modifiers) {
            for (Map.Entry entry : modifiers.asMap().entrySet()) {
                String id = (String)entry.getKey();
                for (AttributeModifier attributeModifier : (Collection)entry.getValue()) {
                    ICurioStacksHandler stacksHandler = this.curios.get(id);
                    if (stacksHandler == null) continue;
                    stacksHandler.removeModifier(attributeModifier.func_111167_a());
                }
            }
        }

        @Override
        public void clearSlotModifiers() {
            for (Map.Entry<String, ICurioStacksHandler> entry : this.curios.entrySet()) {
                entry.getValue().clearModifiers();
            }
        }

        @Override
        public void clearCachedSlotModifiers() {
            HashMultimap slots = HashMultimap.create();
            for (Map.Entry<String, ICurioStacksHandler> entry : this.curios.entrySet()) {
                ICurioStacksHandler stacksHandler = entry.getValue();
                Set<AttributeModifier> modifiers = stacksHandler.getCachedModifiers();
                if (modifiers.isEmpty()) continue;
                IDynamicStackHandler stacks = stacksHandler.getStacks();
                String id = entry.getKey();
                for (int i = 0; i < stacks.getSlots(); ++i) {
                    ItemStack stack = stacks.getStackInSlot(i);
                    if (stack.func_190926_b()) continue;
                    SlotContext slotContext = new SlotContext(id, this.getWearer(), i);
                    UUID uuid = UUID.nameUUIDFromBytes((id + i).getBytes());
                    Multimap<Attribute, AttributeModifier> map = CuriosApi.getCuriosHelper().getAttributeModifiers(slotContext, uuid, stack);
                    for (Attribute attribute : map.keySet()) {
                        if (!(attribute instanceof CuriosHelper.SlotAttributeWrapper)) continue;
                        slots.putAll((Object)((CuriosHelper.SlotAttributeWrapper)attribute).identifier, (Iterable)map.get((Object)attribute));
                    }
                }
            }
            for (Map.Entry<String, ICurioStacksHandler> entry : slots.asMap().entrySet()) {
                String id = entry.getKey();
                ICurioStacksHandler stacksHandler = this.curios.get(id);
                if (stacksHandler == null) continue;
                for (AttributeModifier attributeModifier : (Collection)((Object)entry.getValue())) {
                    stacksHandler.getCachedModifiers().remove(attributeModifier);
                }
                stacksHandler.clearCachedModifiers();
            }
            for (Map.Entry<String, ICurioStacksHandler> entry : this.curios.entrySet()) {
                if (slots.asMap().containsKey(entry.getKey())) continue;
                entry.getValue().clearCachedModifiers();
            }
        }

        @Override
        public Multimap<String, AttributeModifier> getModifiers() {
            HashMultimap result = HashMultimap.create();
            for (Map.Entry<String, ICurioStacksHandler> entry : this.curios.entrySet()) {
                result.putAll((Object)entry.getKey(), entry.getValue().getModifiers().values());
            }
            return result;
        }

        @Override
        public CompoundNBT writeNBT() {
            CompoundNBT compound = new CompoundNBT();
            ListNBT taglist = new ListNBT();
            this.getCurios().forEach((key, stacksHandler) -> {
                CompoundNBT tag = new CompoundNBT();
                tag.func_218657_a("StacksHandler", (INBT)stacksHandler.serializeNBT());
                tag.func_74778_a("Identifier", key);
                taglist.add((Object)tag);
            });
            compound.func_218657_a("Curios", (INBT)taglist);
            ListNBT taglist1 = new ListNBT();
            for (String identifier : this.getLockedSlots()) {
                taglist1.add((Object)StringNBT.func_229705_a_((String)identifier));
            }
            compound.func_218657_a("Locked", (INBT)taglist1);
            return compound;
        }

        @Override
        public void readNBT(CompoundNBT compoundNBT) {
            ListNBT tagList = compoundNBT.func_150295_c("Curios", 10);
            ListNBT lockedList = compoundNBT.func_150295_c("Locked", 8);
            ISlotHelper slotHelper = CuriosApi.getSlotHelper();
            ICuriosHelper curiosHelper = CuriosApi.getCuriosHelper();
            LivingEntity livingEntity = this.getWearer();
            if (!tagList.isEmpty() && slotHelper != null) {
                LinkedHashMap<String, ICurioStacksHandler> curios = new LinkedHashMap<String, ICurioStacksHandler>();
                TreeMap<ISlotType, ICurioStacksHandler> sortedCurios = new TreeMap<ISlotType, ICurioStacksHandler>();
                TreeSet<ISlotType> sorted = new TreeSet<ISlotType>(CuriosApi.getSlotHelper().getSlotTypes((LivingEntity)this.wearer));
                for (ISlotType slotType2 : sorted) {
                    sortedCurios.put(slotType2, new CurioStacksHandler(this, slotType2.getIdentifier(), slotType2.getSize(), 0, slotType2.isVisible(), slotType2.hasCosmetic()));
                }
                for (int i = 0; i < tagList.size(); ++i) {
                    CompoundNBT tag = tagList.func_150305_b(i);
                    String identifier = tag.func_74779_i("Identifier");
                    CurioStacksHandler prevStacksHandler = new CurioStacksHandler(this, identifier);
                    prevStacksHandler.deserializeNBT(tag.func_74775_l("StacksHandler"));
                    Optional<ISlotType> optionalType = CuriosApi.getSlotHelper().getSlotType(identifier);
                    optionalType.ifPresent(type -> {
                        int index;
                        CurioStacksHandler newStacksHandler = new CurioStacksHandler(this, type.getIdentifier(), type.getSize(), prevStacksHandler.getSizeShift(), type.isVisible(), type.hasCosmetic());
                        newStacksHandler.copyModifiers(prevStacksHandler);
                        for (index = 0; index < newStacksHandler.getSlots() && index < prevStacksHandler.getSlots(); ++index) {
                            ItemStack prevCosmetic;
                            ItemStack prevStack = prevStacksHandler.getStacks().getStackInSlot(index);
                            SlotContext slotContext = new SlotContext(identifier, livingEntity, index);
                            if (!prevStack.func_190926_b()) {
                                if (curiosHelper.isStackValid(slotContext, prevStack)) {
                                    newStacksHandler.getStacks().setStackInSlot(index, prevStack);
                                } else {
                                    this.loseInvalidStack(prevStack);
                                }
                            }
                            if ((prevCosmetic = prevStacksHandler.getCosmeticStacks().getStackInSlot(index)).func_190926_b()) continue;
                            if (curiosHelper.isStackValid(slotContext, prevCosmetic)) {
                                newStacksHandler.getCosmeticStacks().setStackInSlot(index, prevStacksHandler.getCosmeticStacks().getStackInSlot(index));
                                continue;
                            }
                            this.loseInvalidStack(prevCosmetic);
                        }
                        while (index < prevStacksHandler.getSlots()) {
                            this.loseInvalidStack(prevStacksHandler.getStacks().getStackInSlot(index));
                            this.loseInvalidStack(prevStacksHandler.getCosmeticStacks().getStackInSlot(index));
                            ++index;
                        }
                        sortedCurios.put((ISlotType)type, newStacksHandler);
                        for (int j = 0; j < newStacksHandler.getRenders().size() && j < prevStacksHandler.getRenders().size(); ++j) {
                            newStacksHandler.getRenders().set(j, (Object)((Boolean)prevStacksHandler.getRenders().get(j)));
                        }
                    });
                    if (optionalType.isPresent()) continue;
                    IDynamicStackHandler stackHandler = prevStacksHandler.getStacks();
                    IDynamicStackHandler cosmeticStackHandler = prevStacksHandler.getCosmeticStacks();
                    for (int j = 0; j < stackHandler.getSlots(); ++j) {
                        ItemStack cosmeticStack;
                        ItemStack stack = stackHandler.getStackInSlot(j);
                        if (!stack.func_190926_b()) {
                            this.loseInvalidStack(stack);
                        }
                        if ((cosmeticStack = cosmeticStackHandler.getStackInSlot(j)).func_190926_b()) continue;
                        this.loseInvalidStack(cosmeticStack);
                    }
                }
                sortedCurios.forEach((slotType, stacksHandler) -> curios.put(slotType.getIdentifier(), (ICurioStacksHandler)stacksHandler));
                this.setCurios(curios);
                for (int k = 0; k < lockedList.size(); ++k) {
                    this.lockSlotType(lockedList.func_150307_f(k));
                }
            }
        }

        public static class UnlockState {
            final String identifier;
            final int amount;
            final boolean visible;
            final boolean cosmetic;

            UnlockState(String identifier, int amount, boolean visible, boolean cosmetic) {
                this.identifier = identifier;
                this.amount = amount;
                this.visible = visible;
                this.cosmetic = cosmetic;
            }
        }
    }
}

