/*
 * Decompiled with CFR 0.152.
 */
package com.grimbo.chipped.integration.jei;

import com.grimbo.chipped.block.ChippedBlocks;
import com.grimbo.chipped.integration.jei.ChippedRecipeCategory;
import com.grimbo.chipped.recipe.ChippedRecipe;
import com.grimbo.chipped.recipe.ChippedSerializer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.JeiPlugin;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.recipe.category.IRecipeCategory;
import mezz.jei.api.registration.IRecipeCatalystRegistration;
import mezz.jei.api.registration.IRecipeCategoryRegistration;
import mezz.jei.api.registration.IRecipeRegistration;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.RecipeManager;
import net.minecraft.tags.ITag;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import org.jetbrains.annotations.NotNull;

@JeiPlugin
public class JEIPlugin
implements IModPlugin {
    private static final ResourceLocation UID = new ResourceLocation("chipped", "chipped");

    @NotNull
    public ResourceLocation getPluginUid() {
        return UID;
    }

    public void registerCategories(IRecipeCategoryRegistration registry) {
        IGuiHelper helper = registry.getJeiHelpers().getGuiHelper();
        registry.addRecipeCategories(new IRecipeCategory[]{new ChippedRecipeCategory(((Block)ChippedBlocks.BOTANIST_WORKBENCH.get()).func_199767_j(), helper), new ChippedRecipeCategory(((Block)ChippedBlocks.GLASSBLOWER.get()).func_199767_j(), helper), new ChippedRecipeCategory(((Block)ChippedBlocks.CARPENTERS_TABLE.get()).func_199767_j(), helper), new ChippedRecipeCategory(((Block)ChippedBlocks.LOOM_TABLE.get()).func_199767_j(), helper), new ChippedRecipeCategory(((Block)ChippedBlocks.MASON_TABLE.get()).func_199767_j(), helper), new ChippedRecipeCategory(((Block)ChippedBlocks.ALCHEMY_BENCH.get()).func_199767_j(), helper), new ChippedRecipeCategory(((Block)ChippedBlocks.MECHANIST_WORKBENCH.get()).func_199767_j(), helper)});
    }

    public void registerRecipes(IRecipeRegistration registration) {
        RecipeManager recipeManager = Minecraft.func_71410_x().field_71441_e.func_199532_z();
        registration.addRecipes(JEIPlugin.flatten(recipeManager.func_241447_a_(ChippedSerializer.BOTANIST_WORKBENCH_TYPE)), JEIPlugin.getUidFromId("botanist_workbench"));
        registration.addRecipes(JEIPlugin.flatten(recipeManager.func_241447_a_(ChippedSerializer.GLASSBLOWER_TYPE)), JEIPlugin.getUidFromId("glassblower"));
        registration.addRecipes(JEIPlugin.flatten(recipeManager.func_241447_a_(ChippedSerializer.CARPENTERS_TABLE_TYPE)), JEIPlugin.getUidFromId("carpenters_table"));
        registration.addRecipes(JEIPlugin.flatten(recipeManager.func_241447_a_(ChippedSerializer.LOOM_TABLE_TYPE)), JEIPlugin.getUidFromId("loom_table"));
        registration.addRecipes(JEIPlugin.flatten(recipeManager.func_241447_a_(ChippedSerializer.MASON_TABLE_TYPE)), JEIPlugin.getUidFromId("mason_table"));
        registration.addRecipes(JEIPlugin.flatten(recipeManager.func_241447_a_(ChippedSerializer.ALCHEMY_BENCH_TYPE)), JEIPlugin.getUidFromId("alchemy_bench"));
        registration.addRecipes(JEIPlugin.flatten(recipeManager.func_241447_a_(ChippedSerializer.MECHANIST_WORKBENCH_TYPE)), JEIPlugin.getUidFromId("mechanist_workbench"));
    }

    public void registerRecipeCatalysts(IRecipeCatalystRegistration registration) {
        registration.addRecipeCatalyst((Object)new ItemStack((IItemProvider)ChippedBlocks.BOTANIST_WORKBENCH.get()), new ResourceLocation[]{JEIPlugin.getUidFromId("botanist_workbench")});
        registration.addRecipeCatalyst((Object)new ItemStack((IItemProvider)ChippedBlocks.GLASSBLOWER.get()), new ResourceLocation[]{JEIPlugin.getUidFromId("glassblower")});
        registration.addRecipeCatalyst((Object)new ItemStack((IItemProvider)ChippedBlocks.CARPENTERS_TABLE.get()), new ResourceLocation[]{JEIPlugin.getUidFromId("carpenters_table")});
        registration.addRecipeCatalyst((Object)new ItemStack((IItemProvider)ChippedBlocks.LOOM_TABLE.get()), new ResourceLocation[]{JEIPlugin.getUidFromId("loom_table")});
        registration.addRecipeCatalyst((Object)new ItemStack((IItemProvider)ChippedBlocks.MASON_TABLE.get()), new ResourceLocation[]{JEIPlugin.getUidFromId("mason_table")});
        registration.addRecipeCatalyst((Object)new ItemStack((IItemProvider)ChippedBlocks.ALCHEMY_BENCH.get()), new ResourceLocation[]{JEIPlugin.getUidFromId("alchemy_bench")});
        registration.addRecipeCatalyst((Object)new ItemStack((IItemProvider)ChippedBlocks.MECHANIST_WORKBENCH.get()), new ResourceLocation[]{JEIPlugin.getUidFromId("mechanist_workbench")});
    }

    private static List<ChippedRecipeCategory.FlattenedRecipe> flatten(Collection<ChippedRecipe> recipes) {
        ArrayList<ChippedRecipeCategory.FlattenedRecipe> flattenedRecipes = new ArrayList<ChippedRecipeCategory.FlattenedRecipe>();
        for (ChippedRecipe recipe : recipes) {
            for (ITag<Item> tag : recipe.getTags()) {
                for (Item item : tag.func_230236_b_()) {
                    flattenedRecipes.add(new ChippedRecipeCategory.FlattenedRecipe(tag, new ItemStack((IItemProvider)item)));
                }
            }
        }
        return flattenedRecipes;
    }

    private static ResourceLocation getUidFromId(String id) {
        return new ResourceLocation("chipped", id);
    }
}

