/*
 * Decompiled with CFR 0.152.
 */
package com.grimbo.chipped.integration.jei;

import java.util.Collections;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.IRecipeLayout;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.ingredient.IGuiItemStackGroup;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredients;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.client.resources.I18n;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.tags.ITag;
import net.minecraft.util.ResourceLocation;
import org.jetbrains.annotations.NotNull;

public class ChippedRecipeCategory
implements IRecipeCategory<FlattenedRecipe> {
    private static final ResourceLocation TEXTURE = new ResourceLocation("jei", "textures/gui/gui_vanilla.png");
    private final ResourceLocation UID;
    private final String localizedName;
    private final IDrawable background;
    private final IDrawable icon;

    public ChippedRecipeCategory(Item item, IGuiHelper guiHelper) {
        this.UID = item.getRegistryName();
        this.localizedName = I18n.func_135052_a((String)("container.chipped." + this.UID.func_110623_a()), (Object[])new Object[0]);
        this.background = guiHelper.createDrawable(TEXTURE, 0, 220, 82, 34);
        this.icon = guiHelper.createDrawableIngredient((Object)item.func_190903_i());
    }

    @NotNull
    public ResourceLocation getUid() {
        return this.UID;
    }

    @NotNull
    public Class<? extends FlattenedRecipe> getRecipeClass() {
        return FlattenedRecipe.class;
    }

    @NotNull
    public String getTitle() {
        return this.localizedName;
    }

    @NotNull
    public IDrawable getBackground() {
        return this.background;
    }

    @NotNull
    public IDrawable getIcon() {
        return this.icon;
    }

    public void setIngredients(FlattenedRecipe recipe, IIngredients ingredients) {
        ingredients.setInputIngredients(Collections.singletonList(Ingredient.func_199805_a((ITag)recipe.tag)));
        ingredients.setOutput(VanillaTypes.ITEM, (Object)recipe.result);
    }

    public void setRecipe(IRecipeLayout recipeLayout, @NotNull FlattenedRecipe recipe, @NotNull IIngredients ingredients) {
        IGuiItemStackGroup guiItemStacks = recipeLayout.getItemStacks();
        guiItemStacks.init(0, true, 0, 8);
        guiItemStacks.init(1, false, 60, 8);
        guiItemStacks.set(ingredients);
    }

    public static class FlattenedRecipe {
        private final ITag<Item> tag;
        private final ItemStack result;

        public FlattenedRecipe(ITag<Item> tag, ItemStack result) {
            this.tag = tag;
            this.result = result;
        }
    }
}

