/*
 * Decompiled with CFR 0.152.
 */
package raccpackeidolon.raccpackeidolon;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import net.minecraftforge.fml.loading.FMLPaths;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import raccpackeidolon.raccpackeidolon.JsonFormats.CrucibleRecipeJson;
import raccpackeidolon.raccpackeidolon.JsonFormats.WorktableRecipeJson;

public class RecipesLoader {
    File recipesDirectory;
    private static final Logger LOGGER = LogManager.getLogger();
    GsonBuilder gsonBuilder = new GsonBuilder();
    Gson gson = this.gsonBuilder.create();

    public RecipesLoader() {
        this.recipesDirectory = new File(FMLPaths.CONFIGDIR.get().toFile(), "eidolon-raccpack");
        if (!this.recipesDirectory.exists()) {
            this.recipesDirectory.mkdirs();
        }
    }

    public void loadRecipes() {
        File[] worktableRecipes;
        File[] crucibleRecipes;
        File crucibleDirectory = new File(this.recipesDirectory, "crucible");
        if (!crucibleDirectory.exists()) {
            crucibleDirectory.mkdirs();
        }
        for (File recipeFile : crucibleRecipes = crucibleDirectory.listFiles(filename -> filename.getName().endsWith(".json"))) {
            this.loadCrucibleRecipe(recipeFile);
        }
        File worktableDirectory = new File(this.recipesDirectory, "worktable");
        if (!worktableDirectory.exists()) {
            worktableDirectory.mkdirs();
        }
        for (File recipeFile : worktableRecipes = worktableDirectory.listFiles(filename -> filename.getName().endsWith(".json"))) {
            this.loadWorktableRecipe(recipeFile);
        }
    }

    public void loadCrucibleRecipe(File file) {
        LOGGER.info(String.format("Importing crucible recipe file %s", file.getAbsolutePath()));
        try {
            String jsonString = new String(Files.readAllBytes(file.toPath()));
            CrucibleRecipeJson recipe = (CrucibleRecipeJson)this.gson.fromJson(jsonString, CrucibleRecipeJson.class);
            recipe.register();
        }
        catch (IOException e) {
            LOGGER.error("Couldn't load crucible recipe", (Throwable)e);
        }
    }

    public void loadWorktableRecipe(File file) {
        LOGGER.info(String.format("Importing worktable recipe file %s", file.getAbsolutePath()));
        try {
            String jsonString = new String(Files.readAllBytes(file.toPath()));
            WorktableRecipeJson recipe = (WorktableRecipeJson)this.gson.fromJson(jsonString, WorktableRecipeJson.class);
            recipe.register();
        }
        catch (IOException e) {
            LOGGER.error("Couldn't load worktable recipe", (Throwable)e);
        }
    }
}

