/*
 * Decompiled with CFR 0.152.
 */
package mekanism.tools.common.item;

import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import java.util.List;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mekanism.common.config.value.CachedIntValue;
import mekanism.common.config.value.CachedValue;
import mekanism.common.lib.attribute.AttributeCache;
import mekanism.common.lib.attribute.IAttributeRefresher;
import mekanism.tools.client.render.GlowArmor;
import mekanism.tools.common.IHasRepairType;
import mekanism.tools.common.material.MaterialCreator;
import mekanism.tools.common.registries.ToolsItems;
import mekanism.tools.common.util.ToolsUtils;
import net.minecraft.client.renderer.entity.model.BipedModel;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.ai.attributes.Attribute;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.ArmorItem;
import net.minecraft.item.IArmorMaterial;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class ItemMekanismArmor
extends ArmorItem
implements IHasRepairType,
IAttributeRefresher {
    private final MaterialCreator material;
    private final AttributeCache attributeCache;
    private final boolean makesPiglinsNeutral;

    public ItemMekanismArmor(MaterialCreator material, EquipmentSlotType slot, Item.Properties properties, boolean makesPiglinsNeutral) {
        super((IArmorMaterial)material, slot, properties);
        CachedIntValue armorConfig;
        this.material = material;
        this.makesPiglinsNeutral = makesPiglinsNeutral;
        if (slot == EquipmentSlotType.FEET) {
            armorConfig = material.bootArmor;
        } else if (slot == EquipmentSlotType.LEGS) {
            armorConfig = material.leggingArmor;
        } else if (slot == EquipmentSlotType.CHEST) {
            armorConfig = material.chestplateArmor;
        } else if (slot == EquipmentSlotType.HEAD) {
            armorConfig = material.helmetArmor;
        } else {
            throw new IllegalArgumentException("Invalid slot type for armor");
        }
        this.attributeCache = new AttributeCache((IAttributeRefresher)this, new CachedValue[]{material.toughness, material.knockbackResistance, armorConfig});
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_77624_a(@Nonnull ItemStack stack, @Nullable World world, @Nonnull List<ITextComponent> tooltip, @Nonnull ITooltipFlag flag) {
        super.func_77624_a(stack, world, tooltip, flag);
        ToolsUtils.addDurability(tooltip, stack);
    }

    @OnlyIn(value=Dist.CLIENT)
    public BipedModel getArmorModel(LivingEntity entityLiving, ItemStack itemStack, EquipmentSlotType armorSlot, BipedModel defaultModel) {
        if (itemStack.func_77973_b() == ToolsItems.REFINED_GLOWSTONE_HELMET.getItem() || itemStack.func_77973_b() == ToolsItems.REFINED_GLOWSTONE_CHESTPLATE.getItem() || itemStack.func_77973_b() == ToolsItems.REFINED_GLOWSTONE_LEGGINGS.getItem() || itemStack.func_77973_b() == ToolsItems.REFINED_GLOWSTONE_BOOTS.getItem()) {
            return GlowArmor.getGlow(armorSlot);
        }
        return super.getArmorModel(entityLiving, itemStack, armorSlot, defaultModel);
    }

    public boolean makesPiglinsNeutral(@Nonnull ItemStack stack, @Nonnull LivingEntity wearer) {
        return this.makesPiglinsNeutral;
    }

    @Override
    @Nonnull
    public Ingredient getRepairMaterial() {
        return this.func_200880_d().func_200898_c();
    }

    public int func_200881_e() {
        return this.func_200880_d().func_200902_b(this.func_185083_B_());
    }

    public float func_234657_f_() {
        return this.func_200880_d().func_200901_e();
    }

    public float getKnockbackResistance() {
        return this.func_200880_d().func_230304_f_();
    }

    public int getMaxDamage(ItemStack stack) {
        return this.material.func_200896_a(this.func_185083_B_());
    }

    public boolean func_77645_m() {
        return this.material.func_200896_a(this.func_185083_B_()) > 0;
    }

    @Nonnull
    public Multimap<Attribute, AttributeModifier> getAttributeModifiers(@Nonnull EquipmentSlotType slot, @Nonnull ItemStack stack) {
        return slot == this.func_185083_B_() ? this.attributeCache.getAttributes() : ImmutableMultimap.of();
    }

    public void addToBuilder(ImmutableMultimap.Builder<Attribute, AttributeModifier> builder) {
        UUID modifier = field_185084_n[this.func_185083_B_().func_188454_b()];
        builder.put((Object)Attributes.field_233826_i_, (Object)new AttributeModifier(modifier, "Armor modifier", (double)this.func_200881_e(), AttributeModifier.Operation.ADDITION));
        builder.put((Object)Attributes.field_233827_j_, (Object)new AttributeModifier(modifier, "Armor toughness", (double)this.func_234657_f_(), AttributeModifier.Operation.ADDITION));
        builder.put((Object)Attributes.field_233820_c_, (Object)new AttributeModifier(modifier, "Armor knockback resistance", (double)this.getKnockbackResistance(), AttributeModifier.Operation.ADDITION));
    }
}

