/*
 * Decompiled with CFR 0.152.
 */
package team.chisel.ctm.client.model;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Multimap;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import com.mojang.datafixers.util.Either;
import com.mojang.datafixers.util.Pair;
import it.unimi.dsi.fastutil.ints.Int2ObjectArrayMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.model.BlockModel;
import net.minecraft.client.renderer.model.BlockPartFace;
import net.minecraft.client.renderer.model.IBakedModel;
import net.minecraft.client.renderer.model.IModelTransform;
import net.minecraft.client.renderer.model.IUnbakedModel;
import net.minecraft.client.renderer.model.ItemModelGenerator;
import net.minecraft.client.renderer.model.ItemOverrideList;
import net.minecraft.client.renderer.model.ModelBakery;
import net.minecraft.client.renderer.model.RenderMaterial;
import net.minecraft.client.renderer.texture.AtlasTexture;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.model.IModelConfiguration;
import team.chisel.ctm.api.model.IModelCTM;
import team.chisel.ctm.api.texture.ICTMTexture;
import team.chisel.ctm.api.util.TextureInfo;
import team.chisel.ctm.client.model.ModelBakedCTM;
import team.chisel.ctm.client.texture.IMetadataSectionCTM;
import team.chisel.ctm.client.texture.render.TextureNormal;
import team.chisel.ctm.client.texture.type.TextureTypeNormal;
import team.chisel.ctm.client.util.BlockRenderLayer;
import team.chisel.ctm.client.util.CTMPackReloadListener;
import team.chisel.ctm.client.util.ResourceUtil;

public class ModelCTM
implements IModelCTM {
    private final IUnbakedModel vanillamodel;
    @Nullable
    private final BlockModel modelinfo;
    private final Int2ObjectMap<JsonElement> overrides;
    protected final Int2ObjectMap<IMetadataSectionCTM> metaOverrides = new Int2ObjectArrayMap();
    protected Int2ObjectMap<TextureAtlasSprite> spriteOverrides;
    protected Map<Pair<Integer, ResourceLocation>, ICTMTexture<?>> textureOverrides;
    private final Collection<ResourceLocation> textureDependencies;
    private transient byte layers;
    private Map<ResourceLocation, ICTMTexture<?>> textures = new HashMap();
    private static final ItemModelGenerator ITEM_MODEL_GENERATOR = new ItemModelGenerator();

    public ModelCTM(IUnbakedModel modelinfo) {
        this.vanillamodel = modelinfo;
        this.modelinfo = null;
        this.overrides = new Int2ObjectOpenHashMap();
        this.textureDependencies = new HashSet<ResourceLocation>();
    }

    public ModelCTM(BlockModel modelinfo, Int2ObjectMap<JsonElement> overrides) throws IOException {
        this.vanillamodel = modelinfo;
        this.modelinfo = modelinfo;
        this.overrides = overrides;
        this.textureDependencies = new HashSet<ResourceLocation>();
        for (Int2ObjectMap.Entry e : this.overrides.int2ObjectEntrySet()) {
            IMetadataSectionCTM meta = null;
            if (((JsonElement)e.getValue()).isJsonPrimitive() && ((JsonElement)e.getValue()).getAsJsonPrimitive().isString()) {
                ResourceLocation rl2 = new ResourceLocation(((JsonElement)e.getValue()).getAsString());
                meta = ResourceUtil.getMetadata(ResourceUtil.spriteToAbsolute(rl2));
                this.textureDependencies.add(rl2);
            } else if (((JsonElement)e.getValue()).isJsonObject()) {
                JsonObject obj = ((JsonElement)e.getValue()).getAsJsonObject();
                if (!obj.has("ctm_version")) {
                    obj.add("ctm_version", (JsonElement)new JsonPrimitive((Number)1));
                }
                meta = new IMetadataSectionCTM.Serializer().deserialize(obj);
            }
            if (meta == null) continue;
            this.metaOverrides.put(e.getIntKey(), meta);
            this.textureDependencies.addAll(Arrays.asList(meta.getAdditionalTextures()));
        }
        this.textureDependencies.removeIf(rl -> rl.func_110623_a().startsWith("#"));
    }

    public Collection<RenderMaterial> getTextures(IModelConfiguration owner, Function<ResourceLocation, IUnbakedModel> modelGetter, Set<Pair<String, String>> missingTextureErrors) {
        List<RenderMaterial> ret = this.textureDependencies.stream().map(rl -> new RenderMaterial(AtlasTexture.field_110575_b, rl)).collect(Collectors.toList());
        ret.addAll(this.vanillamodel.func_225614_a_(modelGetter, missingTextureErrors));
        for (RenderMaterial tex : ret) {
            IMetadataSectionCTM meta;
            try {
                meta = ResourceUtil.getMetadata(ResourceUtil.spriteToAbsolute(tex.func_229313_b_()));
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            if (meta == null || meta.getType().requiredTextures() == meta.getAdditionalTextures().length + 1) continue;
            throw new IllegalArgumentException(String.format("Texture type %s requires exactly %d textures. %d were provided.", meta.getType(), meta.getType().requiredTextures(), meta.getAdditionalTextures().length + 1));
        }
        return ret;
    }

    public IBakedModel bake(IModelConfiguration owner, ModelBakery bakery, Function<RenderMaterial, TextureAtlasSprite> spriteGetter, IModelTransform modelTransform, ItemOverrideList itemOverrides, ResourceLocation modelLocation) {
        return this.bake(bakery, spriteGetter, modelTransform, modelLocation);
    }

    public IBakedModel bake(ModelBakery bakery, Function<RenderMaterial, TextureAtlasSprite> spriteGetter, IModelTransform modelTransform, ResourceLocation modelLocation) {
        if (this.modelinfo != null && this.modelinfo.func_178310_f() == ModelBakery.field_177606_o) {
            return ITEM_MODEL_GENERATOR.func_209579_a(spriteGetter, this.modelinfo).func_228813_a_(bakery, this.modelinfo, spriteGetter, modelTransform, modelLocation, false);
        }
        IBakedModel parent = this.vanillamodel.func_225613_a_(bakery, spriteGetter, modelTransform, modelLocation);
        this.initializeTextures(bakery, spriteGetter);
        return new ModelBakedCTM(this, parent);
    }

    public void initializeTextures(ModelBakery bakery, Function<RenderMaterial, TextureAtlasSprite> spriteGetter) {
        TextureAtlasSprite sprite;
        for (RenderMaterial m : this.getTextures(null, arg_0 -> ((ModelBakery)bakery).func_209597_a(arg_0), new HashSet<Pair<String, String>>())) {
            sprite = spriteGetter.apply(m);
            IMetadataSectionCTM chiselmeta = null;
            try {
                chiselmeta = ResourceUtil.getMetadata(sprite);
            }
            catch (IOException iOException) {
                // empty catch block
            }
            IMetadataSectionCTM meta = chiselmeta;
            this.textures.computeIfAbsent(sprite.func_195668_m(), s -> {
                TextureNormal tex = meta == null ? new TextureNormal(TextureTypeNormal.INSTANCE, new TextureInfo(new TextureAtlasSprite[]{sprite}, Optional.empty(), null)) : meta.makeTexture(sprite, spriteGetter);
                this.layers = (byte)(this.layers | 1 << (tex.getLayer() == null ? 7 : tex.getLayer().ordinal()));
                return tex;
            });
        }
        if (this.spriteOverrides == null) {
            this.spriteOverrides = new Int2ObjectArrayMap();
            for (Int2ObjectMap.Entry e : this.overrides.int2ObjectEntrySet()) {
                if (!((JsonElement)e.getValue()).isJsonPrimitive() || !((JsonElement)e.getValue()).getAsJsonPrimitive().isString()) continue;
                sprite = spriteGetter.apply(new RenderMaterial(AtlasTexture.field_110575_b, new ResourceLocation(((JsonElement)e.getValue()).getAsString())));
                this.spriteOverrides.put(e.getIntKey(), (Object)sprite);
            }
        }
        if (this.textureOverrides == null) {
            this.textureOverrides = new HashMap();
            for (Int2ObjectMap.Entry e : this.metaOverrides.int2ObjectEntrySet()) {
                List<BlockPartFace> matches = this.modelinfo.func_178298_a().stream().flatMap(b -> b.field_178240_c.values().stream()).filter(b -> b.field_178245_c == e.getIntKey()).collect(Collectors.toList());
                HashMultimap bySprite = HashMultimap.create();
                matches.forEach(arg_0 -> this.lambda$initializeTextures$5((Multimap)bySprite, arg_0));
                for (Map.Entry e2 : bySprite.asMap().entrySet()) {
                    ICTMTexture<?> tex;
                    ResourceLocation texLoc = ((RenderMaterial)e2.getKey()).func_229313_b_();
                    TextureAtlasSprite sprite2 = this.getOverrideSprite(e.getIntKey());
                    if (sprite2 == null) {
                        sprite2 = spriteGetter.apply(new RenderMaterial(AtlasTexture.field_110575_b, texLoc));
                    }
                    this.layers = (byte)(this.layers | 1 << ((tex = ((IMetadataSectionCTM)e.getValue()).makeTexture(sprite2, spriteGetter)).getLayer() == null ? 7 : tex.getLayer().ordinal()));
                    this.textureOverrides.put((Pair<Integer, ResourceLocation>)Pair.of((Object)e.getIntKey(), (Object)texLoc), tex);
                }
            }
        }
    }

    @Override
    public void load() {
    }

    @Override
    public Collection<ICTMTexture<?>> getCTMTextures() {
        return ImmutableList.builder().addAll(this.textures.values()).addAll(this.textureOverrides.values()).build();
    }

    @Override
    public ICTMTexture<?> getTexture(ResourceLocation iconName) {
        return this.textures.get(iconName);
    }

    @Override
    public boolean canRenderInLayer(BlockState state, RenderType layer) {
        return this.layers < 0 && CTMPackReloadListener.canRenderInLayerFallback(state, layer) || (this.layers >> BlockRenderLayer.fromType(layer).ordinal() & 1) == 1;
    }

    @Override
    @Nullable
    public TextureAtlasSprite getOverrideSprite(int tintIndex) {
        return (TextureAtlasSprite)this.spriteOverrides.get(tintIndex);
    }

    @Override
    @Nullable
    public ICTMTexture<?> getOverrideTexture(int tintIndex, ResourceLocation sprite) {
        return this.textureOverrides.get(Pair.of((Object)tintIndex, (Object)sprite));
    }

    private /* synthetic */ void lambda$initializeTextures$5(Multimap bySprite, BlockPartFace part) {
        bySprite.put(this.modelinfo.field_178318_c.getOrDefault(part.field_178242_d.substring(1), Either.right((Object)part.field_178242_d)).left().get(), (Object)part);
    }
}

