/*
 * Decompiled with CFR 0.152.
 */
package team.chisel.ctm.client.model;

import com.google.common.collect.ObjectArrays;
import com.mojang.blaze3d.matrix.MatrixStack;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Random;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.block.BlockState;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.model.BakedQuad;
import net.minecraft.client.renderer.model.IBakedModel;
import net.minecraft.client.renderer.model.ItemCameraTransforms;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.util.Direction;
import team.chisel.ctm.api.model.IModelCTM;
import team.chisel.ctm.api.texture.ICTMTexture;
import team.chisel.ctm.api.texture.ITextureContext;
import team.chisel.ctm.api.util.RenderContextList;
import team.chisel.ctm.client.model.AbstractCTMBakedModel;
import team.chisel.ctm.client.util.BakedQuadRetextured;
import team.chisel.ctm.client.util.CTMPackReloadListener;

@ParametersAreNonnullByDefault
public class ModelBakedCTM
extends AbstractCTMBakedModel {
    private static final Direction[] FACINGS = (Direction[])ObjectArrays.concat((Object[])Direction.values(), (Object)null);

    public ModelBakedCTM(IModelCTM model, IBakedModel parent) {
        super(model, parent);
    }

    @Override
    protected AbstractCTMBakedModel createModel(@Nullable BlockState state, IModelCTM model, IBakedModel parent, @Nullable RenderContextList ctx, Random rand) {
        while (parent instanceof ModelBakedCTM) {
            parent = ((AbstractCTMBakedModel)parent).getParent(rand);
        }
        ModelBakedCTM ret = new ModelBakedCTM(model, parent);
        for (RenderType layer : LAYERS) {
            for (Direction facing : FACINGS) {
                ArrayList<BakedQuad> quads;
                List parentQuads = parent.func_200117_a(state, facing, rand);
                if (facing != null) {
                    quads = new ArrayList<BakedQuad>();
                    ret.faceQuads.put((Object)layer, (Object)facing, quads);
                } else {
                    quads = ret.genQuads.get((Object)layer);
                }
                LinkedHashMap texturemap = new LinkedHashMap();
                for (BakedQuad q : parentQuads) {
                    ICTMTexture<?> tex2 = this.getOverrideTexture(rand, q.func_178211_c(), q.func_187508_a().func_195668_m());
                    if (tex2 == null) {
                        tex2 = this.getTexture(rand, q.func_187508_a().func_195668_m());
                    }
                    if (tex2 == null) continue;
                    TextureAtlasSprite spriteReplacement = this.getOverrideSprite(rand, q.func_178211_c());
                    if (spriteReplacement != null) {
                        q = new BakedQuadRetextured(q, spriteReplacement);
                    }
                    texturemap.put(q, tex2);
                }
                int quadGoal = ctx == null ? 1 : texturemap.values().stream().mapToInt(tex -> tex.getType().getQuadsPerSide()).max().orElse(1);
                for (Map.Entry e : texturemap.entrySet()) {
                    if ((((ICTMTexture)e.getValue()).getLayer() == null || ((ICTMTexture)e.getValue()).getLayer().getRenderType() != layer) && (((ICTMTexture)e.getValue()).getLayer() != null || state != null && !CTMPackReloadListener.canRenderInLayerFallback(state, layer))) continue;
                    ITextureContext tcx = ctx == null ? null : ctx.getRenderContext((ICTMTexture)e.getValue());
                    quads.addAll(((ICTMTexture)e.getValue()).transformQuad((BakedQuad)e.getKey(), tcx, quadGoal));
                }
            }
        }
        return ret;
    }

    @Override
    @Nonnull
    public TextureAtlasSprite func_177554_e() {
        return Optional.ofNullable(this.getModel().getTexture(this.getParent().func_177554_e().func_195668_m())).map(ICTMTexture::getParticle).orElse(this.getParent().func_177554_e());
    }

    @Override
    public IBakedModel handlePerspective(ItemCameraTransforms.TransformType cameraTransformType, MatrixStack ms) {
        this.getParent().handlePerspective(cameraTransformType, ms);
        return this;
    }
}

