/*
 * Decompiled with CFR 0.152.
 */
package mekanism.generators.common.tile;

import java.util.List;
import javax.annotation.Nonnull;
import mekanism.api.Action;
import mekanism.api.IContentsListener;
import mekanism.api.RelativeSide;
import mekanism.api.energy.IEnergyContainer;
import mekanism.api.inventory.AutomationType;
import mekanism.api.inventory.IInventorySlot;
import mekanism.api.math.FloatingLong;
import mekanism.api.providers.IBlockProvider;
import mekanism.common.capabilities.holder.slot.IInventorySlotHolder;
import mekanism.common.capabilities.holder.slot.InventorySlotHelper;
import mekanism.common.integration.computer.SpecialComputerMethodWrapper;
import mekanism.common.integration.computer.annotation.ComputerMethod;
import mekanism.common.integration.computer.annotation.WrappingComputerMethod;
import mekanism.common.inventory.container.MekanismContainer;
import mekanism.common.inventory.container.sync.ISyncableData;
import mekanism.common.inventory.container.sync.SyncableBoolean;
import mekanism.common.inventory.container.sync.SyncableFloatingLong;
import mekanism.common.inventory.slot.EnergyInventorySlot;
import mekanism.common.tile.base.TileEntityMekanism;
import mekanism.common.tile.interfaces.IBoundingBlock;
import mekanism.common.util.MekanismUtils;
import mekanism.common.util.WorldUtils;
import mekanism.generators.common.config.MekanismGeneratorsConfig;
import mekanism.generators.common.registries.GeneratorsBlocks;
import mekanism.generators.common.tile.TileEntityGenerator;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IWorld;

public class TileEntityWindGenerator
extends TileEntityGenerator
implements IBoundingBlock {
    public static final float SPEED = 32.0f;
    public static final float SPEED_SCALED = 8.0f;
    private double angle;
    private FloatingLong currentMultiplier = FloatingLong.ZERO;
    private boolean isBlacklistDimension;
    @WrappingComputerMethod(wrapper=SpecialComputerMethodWrapper.ComputerIInventorySlotWrapper.class, methodNames={"getEnergyItem"})
    private EnergyInventorySlot energySlot;

    public TileEntityWindGenerator() {
        super((IBlockProvider)GeneratorsBlocks.WIND_GENERATOR, ((FloatingLong)MekanismGeneratorsConfig.generators.windGenerationMax.get()).multiply(2L));
    }

    @Nonnull
    protected IInventorySlotHolder getInitialInventory() {
        InventorySlotHelper builder = InventorySlotHelper.forSide(() -> ((TileEntityWindGenerator)this).getDirection());
        this.energySlot = EnergyInventorySlot.drain((IEnergyContainer)this.getEnergyContainer(), (IContentsListener)this, (int)143, (int)35);
        builder.addSlot((IInventorySlot)this.energySlot);
        return builder.build();
    }

    @Override
    protected RelativeSide[] getEnergySides() {
        return new RelativeSide[]{RelativeSide.FRONT, RelativeSide.BOTTOM};
    }

    public void onLoad() {
        super.onLoad();
        if (this.field_145850_b != null) {
            this.isBlacklistDimension = ((List)MekanismGeneratorsConfig.generators.windGenerationDimBlacklist.get()).contains(this.field_145850_b.func_234923_W_().func_240901_a_());
            if (this.isBlacklistDimension) {
                this.setActive(false);
            }
        }
    }

    @Override
    protected void onUpdateServer() {
        super.onUpdateServer();
        this.energySlot.drainContainer();
        if (this.isBlacklistDimension) {
            return;
        }
        if (this.ticker % 20 == 0) {
            this.currentMultiplier = this.getMultiplier();
            this.setActive(MekanismUtils.canFunction((TileEntityMekanism)this) && !this.currentMultiplier.isZero());
        }
        if (!this.currentMultiplier.isZero() && MekanismUtils.canFunction((TileEntityMekanism)this) && !this.getEnergyContainer().getNeeded().isZero()) {
            this.getEnergyContainer().insert(((FloatingLong)MekanismGeneratorsConfig.generators.windGenerationMin.get()).multiply(this.currentMultiplier), Action.EXECUTE, AutomationType.INTERNAL);
        }
    }

    protected void onUpdateClient() {
        super.onUpdateClient();
        if (this.getActive()) {
            this.angle = (this.angle + (double)(((float)this.func_174877_v().func_177956_o() + 4.0f) / 8.0f)) % 360.0;
        }
    }

    private FloatingLong getMultiplier() {
        BlockPos top;
        if (this.field_145850_b != null && this.field_145850_b.func_204610_c(top = this.func_174877_v().func_177981_b(4)).func_206888_e() && this.field_145850_b.func_226660_f_(top)) {
            int minY = MekanismGeneratorsConfig.generators.windGenerationMinY.get();
            int maxY = MekanismGeneratorsConfig.generators.windGenerationMaxY.get();
            float clampedY = Math.min(maxY, Math.max(minY, top.func_177956_o()));
            FloatingLong minG = (FloatingLong)MekanismGeneratorsConfig.generators.windGenerationMin.get();
            FloatingLong maxG = (FloatingLong)MekanismGeneratorsConfig.generators.windGenerationMax.get();
            FloatingLong slope = maxG.subtract(minG).divide((long)(maxY - minY));
            FloatingLong toGen = minG.add(slope.multiply((double)(clampedY - (float)minY)));
            return toGen.divide(minG);
        }
        return FloatingLong.ZERO;
    }

    public void onPlace() {
        super.onPlace();
        if (this.field_145850_b != null) {
            BlockPos pos = this.func_174877_v();
            WorldUtils.makeBoundingBlock((IWorld)this.field_145850_b, (BlockPos)pos.func_177984_a(), (BlockPos)pos);
            WorldUtils.makeBoundingBlock((IWorld)this.field_145850_b, (BlockPos)pos.func_177981_b(2), (BlockPos)pos);
            WorldUtils.makeBoundingBlock((IWorld)this.field_145850_b, (BlockPos)pos.func_177981_b(3), (BlockPos)pos);
            WorldUtils.makeBoundingBlock((IWorld)this.field_145850_b, (BlockPos)pos.func_177981_b(4), (BlockPos)pos);
            this.isBlacklistDimension = ((List)MekanismGeneratorsConfig.generators.windGenerationDimBlacklist.get()).contains(this.field_145850_b.func_234923_W_().func_240901_a_());
        }
    }

    public void func_145843_s() {
        super.func_145843_s();
        if (this.field_145850_b != null) {
            this.field_145850_b.func_217377_a(this.func_174877_v().func_177984_a(), false);
            this.field_145850_b.func_217377_a(this.func_174877_v().func_177981_b(2), false);
            this.field_145850_b.func_217377_a(this.func_174877_v().func_177981_b(3), false);
            this.field_145850_b.func_217377_a(this.func_174877_v().func_177981_b(4), false);
        }
    }

    public FloatingLong getCurrentMultiplier() {
        return this.currentMultiplier;
    }

    public double getAngle() {
        return this.angle;
    }

    @ComputerMethod(nameOverride="isBlacklistedDimension")
    public boolean isBlacklistDimension() {
        return this.isBlacklistDimension;
    }

    public SoundCategory getSoundCategory() {
        return SoundCategory.WEATHER;
    }

    public BlockPos getSoundPos() {
        return super.getSoundPos().func_177981_b(4);
    }

    public void addContainerTrackers(MekanismContainer container) {
        super.addContainerTrackers(container);
        container.track((ISyncableData)SyncableFloatingLong.create(this::getCurrentMultiplier, value -> {
            this.currentMultiplier = value;
        }));
        container.track((ISyncableData)SyncableBoolean.create(this::isBlacklistDimension, value -> {
            this.isBlacklistDimension = value;
        }));
    }

    @Nonnull
    public AxisAlignedBB getRenderBoundingBox() {
        return new AxisAlignedBB(this.field_174879_c.func_177982_a(-2, 0, -2), this.field_174879_c.func_177982_a(3, 7, 3));
    }

    @ComputerMethod
    private FloatingLong getProductionRate() {
        return this.getActive() ? ((FloatingLong)MekanismGeneratorsConfig.generators.windGenerationMin.get()).multiply(this.getCurrentMultiplier()) : FloatingLong.ZERO;
    }
}

