/*
 * Decompiled with CFR 0.152.
 */
package mekanism.generators.client.render;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import javax.annotation.ParametersAreNonnullByDefault;
import mekanism.api.chemical.gas.GasStack;
import mekanism.client.render.MekanismRenderer;
import mekanism.client.render.ModelRenderer;
import mekanism.client.render.RenderResizableCuboid;
import mekanism.client.render.data.ChemicalRenderData;
import mekanism.client.render.data.RenderData;
import mekanism.client.render.tileentity.MekanismTileEntityRenderer;
import mekanism.common.util.WorldUtils;
import mekanism.generators.client.render.RenderTurbineRotor;
import mekanism.generators.common.content.turbine.TurbineMultiblockData;
import mekanism.generators.common.tile.turbine.TileEntityTurbineCasing;
import mekanism.generators.common.tile.turbine.TileEntityTurbineRotor;
import net.minecraft.client.renderer.Atlases;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.tileentity.TileEntityRendererDispatcher;
import net.minecraft.profiler.IProfiler;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockReader;

@ParametersAreNonnullByDefault
public class RenderIndustrialTurbine
extends MekanismTileEntityRenderer<TileEntityTurbineCasing> {
    public RenderIndustrialTurbine(TileEntityRendererDispatcher renderer) {
        super(renderer);
    }

    protected void render(TileEntityTurbineCasing tile, float partialTick, MatrixStack matrix, IRenderTypeBuffer renderer, int light, int overlayLight, IProfiler profiler) {
        TurbineMultiblockData multiblock;
        if (tile.isMaster() && (multiblock = (TurbineMultiblockData)tile.getMultiblock()).isFormed() && multiblock.complex != null && multiblock.renderLocation != null) {
            int height;
            BlockPos pos = tile.func_174877_v();
            BlockPos complexPos = multiblock.complex;
            IVertexBuilder buffer = RenderTurbineRotor.INSTANCE.model.getBuffer(renderer);
            profiler.func_76320_a("turbineRotor");
            while (true) {
                complexPos = complexPos.func_177977_b();
                TileEntityTurbineRotor rotor = (TileEntityTurbineRotor)WorldUtils.getTileEntity(TileEntityTurbineRotor.class, (IBlockReader)tile.func_145831_w(), (BlockPos)complexPos);
                if (rotor == null) break;
                matrix.func_227860_a_();
                matrix.func_227861_a_((double)(complexPos.func_177958_n() - pos.func_177958_n()), (double)(complexPos.func_177956_o() - pos.func_177956_o()), (double)(complexPos.func_177952_p() - pos.func_177952_p()));
                RenderTurbineRotor.INSTANCE.render(rotor, matrix, buffer, MekanismRenderer.FULL_SKY_LIGHT, overlayLight);
                matrix.func_227865_b_();
            }
            profiler.func_76319_b();
            if (!multiblock.gasTank.isEmpty() && multiblock.length() > 0 && (height = multiblock.lowerVolume / (multiblock.length() * multiblock.width())) >= 1) {
                ChemicalRenderData.GasRenderData data = new ChemicalRenderData.GasRenderData((GasStack)multiblock.gasTank.getStack());
                data.location = multiblock.renderLocation;
                data.height = height;
                data.length = multiblock.length();
                data.width = multiblock.width();
                int glow = data.calculateGlowLight(MekanismRenderer.FULL_SKY_LIGHT);
                matrix.func_227860_a_();
                matrix.func_227861_a_((double)(data.location.func_177958_n() - pos.func_177958_n()), (double)(data.location.func_177956_o() - pos.func_177956_o()), (double)(data.location.func_177952_p() - pos.func_177952_p()));
                MekanismRenderer.Model3D gasModel = ModelRenderer.getModel((RenderData)data, (double)1.0);
                MekanismRenderer.renderObject((MekanismRenderer.Model3D)gasModel, (MatrixStack)matrix, (IVertexBuilder)renderer.getBuffer(Atlases.func_228785_j_()), (int)data.getColorARGB(multiblock.prevSteamScale), (int)glow, (int)overlayLight, (RenderResizableCuboid.FaceDisplay)this.getFaceDisplay((RenderData)data, gasModel));
                matrix.func_227865_b_();
            }
        }
    }

    protected String getProfilerSection() {
        return "industrialTurbine";
    }

    public boolean shouldRenderOffScreen(TileEntityTurbineCasing tile) {
        if (tile.isMaster()) {
            TurbineMultiblockData multiblock = (TurbineMultiblockData)tile.getMultiblock();
            return multiblock.isFormed() && multiblock.complex != null && multiblock.renderLocation != null;
        }
        return false;
    }
}

