/*
 * Decompiled with CFR 0.152.
 */
package com.minecraftabnormals.upgrade_aquatic.common.blocks.coralstone;

import com.minecraftabnormals.abnormals_core.core.util.BlockUtil;
import com.minecraftabnormals.upgrade_aquatic.core.registry.UABlocks;
import java.util.Map;
import java.util.Random;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.CoralWallFanBlock;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.fluid.FluidState;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.ITag;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;

public class CoralstoneBlock
extends Block {
    public static final BooleanProperty POWERED = BooleanProperty.func_177716_a((String)"powered");
    @Nullable
    private final Block[] growableCoralBlocks;
    private final boolean chiseled;

    public CoralstoneBlock(AbstractBlock.Properties properties, boolean chiseled) {
        this(properties, chiseled, null);
    }

    public CoralstoneBlock(AbstractBlock.Properties properties, boolean chiseled, @Nullable Block[] growableCoralBlocks) {
        super(properties);
        this.chiseled = chiseled;
        this.growableCoralBlocks = growableCoralBlocks;
        this.func_180632_j((BlockState)((BlockState)this.field_176227_L.func_177621_b()).func_206870_a((Property)POWERED, (Comparable)Boolean.valueOf(false)));
    }

    public ActionResultType func_225533_a_(BlockState state, World world, BlockPos pos, PlayerEntity player, Hand hand, BlockRayTraceResult hit) {
        ItemStack stack = player.func_184586_b(hand);
        if (stack.func_77973_b() == Items.field_151097_aZ && state.func_177230_c() != UABlocks.CHISELED_CORALSTONE.get() && state.func_177230_c() != UABlocks.CORALSTONE.get()) {
            BlockState newState = this.chiseled ? ((Block)UABlocks.CHISELED_CORALSTONE.get()).func_176223_P() : ((Block)UABlocks.CORALSTONE.get()).func_176223_P();
            world.func_184133_a(null, pos, SoundEvents.field_187784_dt, SoundCategory.PLAYERS, 1.0f, 0.8f);
            stack.func_222118_a(1, (LivingEntity)player, entity -> entity.func_213334_d(hand));
            world.func_180501_a(pos, newState, 2);
            return ActionResultType.SUCCESS;
        }
        return super.func_225533_a_(state, world, pos, player, hand, hit);
    }

    public void func_225534_a_(BlockState state, ServerWorld worldIn, BlockPos pos, Random random) {
        if (!worldIn.isAreaLoaded(pos, 3)) {
            return;
        }
        Block block = state.func_177230_c();
        if (this.growableCoralBlocks == null && block != UABlocks.DEAD_CORALSTONE.get() && block != UABlocks.DEAD_CHISELED_CORALSTONE.get()) {
            CoralstoneBlock.tickConversion(this.chiseled ? UABlocks.CHISELED_CORALSTONE_CONVERSION_MAP : UABlocks.CORALSTONE_CONVERSION_MAP, state, worldIn, pos, random);
        }
        if (this.growableCoralBlocks != null && random.nextFloat() < 0.12f) {
            boolean isValidPosToGrow;
            Direction randDirection = this.growableCoralBlocks.length > 3 ? Direction.func_239631_a_((Random)random) : Direction.func_82600_a((int)(random.nextInt(5) + 1));
            BlockPos growPos = pos.func_177972_a(randDirection);
            FluidState fluidState = worldIn.func_180495_p(growPos).func_204520_s();
            boolean bl = isValidPosToGrow = worldIn.func_180495_p(growPos).func_185904_a().func_76222_j() && fluidState.func_206882_g() >= 8 && fluidState.func_206884_a((ITag)FluidTags.field_206959_a);
            if (isValidPosToGrow && ((Boolean)state.func_177229_b((Property)POWERED)).booleanValue()) {
                if (randDirection.func_176745_a() > 1) {
                    worldIn.func_180501_a(growPos, (BlockState)this.growableCoralBlocks[2].func_176223_P().func_206870_a((Property)CoralWallFanBlock.field_211884_b, (Comparable)randDirection), 2);
                } else if (randDirection.func_176745_a() == 1) {
                    if (random.nextBoolean()) {
                        worldIn.func_180501_a(growPos, this.growableCoralBlocks[1].func_176223_P(), 2);
                    } else {
                        worldIn.func_180501_a(growPos, this.growableCoralBlocks[0].func_176223_P(), 2);
                    }
                } else {
                    worldIn.func_180501_a(growPos, this.growableCoralBlocks[3].func_176223_P(), 2);
                }
            }
        }
    }

    public void func_220069_a(BlockState state, World worldIn, BlockPos pos, Block blockIn, BlockPos fromPos, boolean isMoving) {
        boolean flag;
        if (!worldIn.field_72995_K && (flag = ((Boolean)state.func_177229_b((Property)POWERED)).booleanValue()) != worldIn.func_175640_z(pos)) {
            worldIn.func_180501_a(pos, (BlockState)state.func_235896_a_((Property)POWERED), 2);
        }
    }

    public BlockState func_196258_a(BlockItemUseContext context) {
        return (BlockState)this.func_176223_P().func_206870_a((Property)POWERED, (Comparable)Boolean.valueOf(context.func_195991_k().func_175640_z(context.func_195995_a())));
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new Property[]{POWERED});
    }

    public static void tickConversion(Map<Supplier<Block>, Supplier<Block>> conversionMap, BlockState state, ServerWorld world, BlockPos pos, Random random) {
        for (int i = 0; i < 4; ++i) {
            Block randomBlock = world.func_180495_p(pos.func_177982_a(random.nextInt(3) - 1, random.nextInt(5) - 3, random.nextInt(3) - 1)).func_177230_c();
            conversionMap.forEach((input, output) -> {
                if (input.get() == randomBlock) {
                    world.func_180501_a(pos, BlockUtil.transferAllBlockStates((BlockState)state, (BlockState)((Block)output.get()).func_176223_P()), 2);
                }
            });
        }
    }
}

