/*
 * Decompiled with CFR 0.152.
 */
package com.minecraftabnormals.environmental.integration.jei;

import com.minecraftabnormals.environmental.client.gui.screen.inventory.KilnScreen;
import com.minecraftabnormals.environmental.common.inventory.container.KilnContainer;
import com.minecraftabnormals.environmental.common.item.crafting.BakingRecipe;
import com.minecraftabnormals.environmental.common.item.crafting.SawingRecipe;
import com.minecraftabnormals.environmental.core.registry.EnvironmentalBlocks;
import com.minecraftabnormals.environmental.core.registry.EnvironmentalItems;
import com.minecraftabnormals.environmental.core.registry.EnvironmentalRecipes;
import com.minecraftabnormals.environmental.integration.jei.BakingCategory;
import com.minecraftabnormals.environmental.integration.jei.SawingCategory;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.JeiPlugin;
import mezz.jei.api.constants.VanillaRecipeCategoryUid;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.helpers.IJeiHelpers;
import mezz.jei.api.recipe.category.IRecipeCategory;
import mezz.jei.api.registration.IGuiHandlerRegistration;
import mezz.jei.api.registration.IRecipeCatalystRegistration;
import mezz.jei.api.registration.IRecipeCategoryRegistration;
import mezz.jei.api.registration.IRecipeRegistration;
import mezz.jei.api.registration.IRecipeTransferRegistration;
import mezz.jei.api.registration.ISubtypeRegistration;
import net.minecraft.client.Minecraft;
import net.minecraft.client.world.ClientWorld;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.IRecipeType;
import net.minecraft.item.crafting.RecipeManager;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;

@JeiPlugin
public class EnvironmentalPlugin
implements IModPlugin {
    public static final ResourceLocation RECIPE_GUI_ENVIRONMENTAL = new ResourceLocation("environmental", "textures/gui/jei.png");

    public ResourceLocation getPluginUid() {
        return new ResourceLocation("environmental", "environmental");
    }

    public void registerItemSubtypes(ISubtypeRegistration registration) {
        registration.registerSubtypeInterpreter((Item)EnvironmentalItems.SLABFISH_BUCKET.get(), stack -> stack.func_77978_p() != null && stack.func_77978_p().func_150297_b("SlabfishType", 8) ? stack.func_77978_p().func_74779_i("SlabfishType") : "");
    }

    public void registerCategories(IRecipeCategoryRegistration registration) {
        IJeiHelpers jeiHelpers = registration.getJeiHelpers();
        IGuiHelper guiHelper = jeiHelpers.getGuiHelper();
        registration.addRecipeCategories(new IRecipeCategory[]{new BakingCategory(guiHelper)});
        registration.addRecipeCategories(new IRecipeCategory[]{new SawingCategory(guiHelper)});
    }

    public void registerRecipes(IRecipeRegistration registration) {
        Results recipes = EnvironmentalPlugin.getAllRecipes();
        registration.addRecipes(recipes.getBakingRecipes(), BakingCategory.BAKING);
        registration.addRecipes(recipes.getSawingRecipes(), SawingCategory.SAWING);
    }

    public void registerGuiHandlers(IGuiHandlerRegistration registration) {
        registration.addRecipeClickArea(KilnScreen.class, 78, 32, 28, 23, new ResourceLocation[]{BakingCategory.BAKING, VanillaRecipeCategoryUid.FUEL});
    }

    public void registerRecipeTransferHandlers(IRecipeTransferRegistration registration) {
        registration.addRecipeTransferHandler(KilnContainer.class, BakingCategory.BAKING, 0, 1, 3, 36);
    }

    public void registerRecipeCatalysts(IRecipeCatalystRegistration registration) {
        registration.addRecipeCatalyst((Object)new ItemStack((IItemProvider)EnvironmentalBlocks.KILN.get()), new ResourceLocation[]{BakingCategory.BAKING, VanillaRecipeCategoryUid.FUEL});
        registration.addRecipeCatalyst((Object)new ItemStack((IItemProvider)EnvironmentalBlocks.SAWMILL.get()), new ResourceLocation[]{SawingCategory.SAWING});
    }

    public static Results getAllRecipes() {
        Results results = new Results();
        ClientWorld world = Minecraft.func_71410_x().field_71441_e;
        RecipeManager recipeManager = world.func_199532_z();
        results.bakingRecipes.addAll(EnvironmentalPlugin.getRecipes(recipeManager, EnvironmentalRecipes.RecipeTypes.BAKING));
        results.sawingRecipes.addAll(EnvironmentalPlugin.getRecipes(recipeManager, EnvironmentalRecipes.RecipeTypes.SAWING));
        return results;
    }

    private static <C extends IInventory, T extends IRecipe<C>> Collection<T> getRecipes(RecipeManager recipeManager, IRecipeType<T> recipeType) {
        Map recipesMap = recipeManager.func_215366_a(recipeType);
        return recipesMap.values();
    }

    public static class Results {
        private final List<BakingRecipe> bakingRecipes = new ArrayList<BakingRecipe>();
        private final List<SawingRecipe> sawingRecipes = new ArrayList<SawingRecipe>();

        public List<BakingRecipe> getBakingRecipes() {
            return this.bakingRecipes;
        }

        public List<SawingRecipe> getSawingRecipes() {
            return this.sawingRecipes;
        }
    }
}

