/*
 * Decompiled with CFR 0.152.
 */
package com.minecraftabnormals.environmental.common.world.gen.util;

import com.minecraftabnormals.environmental.core.registry.EnvironmentalBlocks;
import java.util.Random;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.ITag;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.IWorldWriter;
import net.minecraft.world.gen.IWorldGenerationBaseReader;
import net.minecraft.world.gen.IWorldGenerationReader;
import net.minecraftforge.common.IPlantable;

public class WisteriaTreeUtils {
    public static int getLengthByNeighbors(IWorldGenerationReader world, Random random, BlockPos pos) {
        int length = random.nextInt(6);
        for (Direction direction : Direction.values()) {
            if (direction == Direction.UP || direction == Direction.DOWN) continue;
            if (WisteriaTreeUtils.isAir((IWorldGenerationBaseReader)world, pos.func_177972_a(direction))) {
                ++length;
                continue;
            }
            if (!WisteriaTreeUtils.isLeaves((IWorldGenerationBaseReader)world, pos.func_177972_a(direction))) continue;
            --length;
        }
        return length;
    }

    public static boolean isAir(IWorldGenerationBaseReader worldIn, BlockPos pos) {
        if (!(worldIn instanceof IBlockReader)) {
            return worldIn.func_217375_a(pos, AbstractBlock.AbstractBlockState::func_196958_f);
        }
        return worldIn.func_217375_a(pos, state -> state.isAir((IBlockReader)worldIn, pos));
    }

    public static boolean isLeaves(IWorldGenerationBaseReader worldIn, BlockPos pos) {
        return worldIn.func_217375_a(pos, p_214579_0_ -> p_214579_0_.func_235714_a_((ITag)BlockTags.field_206952_E));
    }

    public static boolean isAirOrLeavesOrVines(IWorldGenerationBaseReader worldIn, BlockPos pos) {
        if (!(worldIn instanceof IWorldReader)) {
            return worldIn.func_217375_a(pos, state -> state.func_196958_f() || state.func_235714_a_((ITag)BlockTags.field_206952_E));
        }
        return worldIn.func_217375_a(pos, state -> state.canBeReplacedByLeaves((IWorldReader)worldIn, pos));
    }

    public static boolean isLog(IWorldGenerationBaseReader worldIn, BlockPos pos) {
        return worldIn.func_217375_a(pos, p_214579_0_ -> p_214579_0_.func_235714_a_((ITag)BlockTags.field_200031_h));
    }

    public static boolean isAirOrLeaves(IWorldGenerationBaseReader worldIn, BlockPos pos) {
        if (worldIn instanceof IWorldReader) {
            return worldIn.func_217375_a(pos, state -> state.canBeReplacedByLeaves((IWorldReader)worldIn, pos));
        }
        return worldIn.func_217375_a(pos, state -> state.func_196958_f() || state.func_235714_a_((ITag)BlockTags.field_206952_E));
    }

    public static void placeVines(IWorldGenerationReader world, Random random, BlockPos pos, BlockState leaf, BlockState vineLower, BlockState vineUpper) {
        int length = WisteriaTreeUtils.getLengthByNeighbors(world, random, pos);
        if (random.nextInt(6) != 5 && WisteriaTreeUtils.isAir((IWorldGenerationBaseReader)world, pos) && !WisteriaTreeUtils.isLog((IWorldGenerationBaseReader)world, pos)) {
            switch (length) {
                case 0: {
                    break;
                }
                case 1: {
                    break;
                }
                case 2: {
                    break;
                }
                case 3: {
                    if (!WisteriaTreeUtils.isAir((IWorldGenerationBaseReader)world, pos)) break;
                    WisteriaTreeUtils.placeLeafAt(world, pos, leaf);
                    break;
                }
                case 4: {
                    if (WisteriaTreeUtils.isAir((IWorldGenerationBaseReader)world, pos)) {
                        WisteriaTreeUtils.placeLeafAt(world, pos, leaf);
                    }
                    if (!WisteriaTreeUtils.isAir((IWorldGenerationBaseReader)world, pos.func_177977_b())) break;
                    WisteriaTreeUtils.placeLeafAt(world, pos.func_177977_b(), leaf);
                    break;
                }
                case 5: {
                    if (WisteriaTreeUtils.isAir((IWorldGenerationBaseReader)world, pos)) {
                        WisteriaTreeUtils.placeLeafAt(world, pos, leaf);
                    }
                    if (WisteriaTreeUtils.isAir((IWorldGenerationBaseReader)world, pos.func_177977_b())) {
                        WisteriaTreeUtils.placeLeafAt(world, pos.func_177977_b(), leaf);
                    }
                    if (!WisteriaTreeUtils.isAir((IWorldGenerationBaseReader)world, pos.func_177979_c(2))) break;
                    WisteriaTreeUtils.placeLeafAt(world, pos.func_177979_c(2), leaf);
                }
            }
        }
    }

    public static void placeLeafAt(IWorldGenerationReader worldIn, BlockPos pos, BlockState leaf) {
        if (WisteriaTreeUtils.isAirOrLeavesOrVines((IWorldGenerationBaseReader)worldIn, pos)) {
            WisteriaTreeUtils.setForcedState((IWorldWriter)worldIn, pos, leaf);
        }
    }

    public static void setForcedState(IWorldWriter worldIn, BlockPos pos, BlockState state) {
        worldIn.func_180501_a(pos, state, 18);
    }

    public static void setDirtAt(IWorld worldIn, BlockPos pos) {
        Block block = worldIn.func_180495_p(pos).func_177230_c();
        if (block == Blocks.field_196658_i || block == Blocks.field_150458_ak) {
            WisteriaTreeUtils.setForcedState((IWorldWriter)worldIn, pos, Blocks.field_150346_d.func_176223_P());
        }
    }

    public static boolean isValidGround(IWorld world, BlockPos pos) {
        return world.func_180495_p(pos).canSustainPlant((IBlockReader)world, pos, Direction.UP, (IPlantable)EnvironmentalBlocks.BLUE_WISTERIA_SAPLING.get());
    }
}

