/*
 * Decompiled with CFR 0.152.
 */
package com.minecraftabnormals.environmental.common.entity.goals;

import com.google.common.collect.Lists;
import com.minecraftabnormals.abnormals_core.common.world.storage.tracking.IDataManager;
import com.minecraftabnormals.environmental.core.other.EnvironmentalDataProcessors;
import com.minecraftabnormals.environmental.core.other.EnvironmentalTags;
import com.minecraftabnormals.environmental.core.registry.EnvironmentalBlocks;
import java.util.ArrayList;
import java.util.EnumSet;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.dispenser.IPosition;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.passive.PigEntity;
import net.minecraft.tags.ITag;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.World;
import net.minecraftforge.common.Tags;

public class HuntTruffleGoal
extends Goal {
    private final PigEntity pig;
    private final IDataManager data;
    private int runDelay;
    private int lookTimer;
    private Vector3d lookVector;

    public HuntTruffleGoal(PigEntity pigIn) {
        this.pig = pigIn;
        this.data = (IDataManager)this.pig;
        this.func_220684_a(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.JUMP, Goal.Flag.LOOK));
    }

    public boolean func_75250_a() {
        if (this.runDelay > 0) {
            --this.runDelay;
            return false;
        }
        this.runDelay = 20;
        if (((Boolean)this.data.getValue(EnvironmentalDataProcessors.HAS_TRUFFLE_TARGET)).booleanValue()) {
            return true;
        }
        return (Integer)this.data.getValue(EnvironmentalDataProcessors.TRUFFLE_HUNTING_TIME) > 0 && this.findTruffle();
    }

    public boolean func_75253_b() {
        return (Boolean)this.data.getValue(EnvironmentalDataProcessors.HAS_TRUFFLE_TARGET) != false && (Integer)this.data.getValue(EnvironmentalDataProcessors.TRUFFLE_HUNTING_TIME) != 0;
    }

    public void func_75249_e() {
        this.lookVector = new Vector3d(1.0, 0.0, 1.0);
        this.moveToTruffle();
        this.data.setValue(EnvironmentalDataProcessors.LOOKING_FOR_TRUFFLE, (Object)true);
    }

    public void func_75251_c() {
        this.data.setValue(EnvironmentalDataProcessors.LOOKING_FOR_TRUFFLE, (Object)false);
    }

    public void func_75246_d() {
        int trufflehuntingtime = (Integer)this.data.getValue(EnvironmentalDataProcessors.TRUFFLE_HUNTING_TIME);
        BlockPos blockpos = (BlockPos)this.data.getValue(EnvironmentalDataProcessors.TRUFFLE_POS);
        Vector3d pigpos = this.pig.func_213303_ch();
        Vector3d vector3d = new Vector3d((double)blockpos.func_177958_n() + 0.5 - pigpos.func_82615_a(), 0.0, (double)blockpos.func_177952_p() + 0.5 - pigpos.func_82616_c()).func_72432_b();
        this.pig.func_70671_ap().func_75650_a(pigpos.func_82615_a() + vector3d.func_82615_a() * this.lookVector.func_82615_a(), this.pig.func_226278_cu_() - 0.6 + this.lookVector.func_82617_b(), pigpos.func_82616_c() + vector3d.func_82616_c() * this.lookVector.func_82616_c(), (float)(this.pig.func_184649_cE() + 20), (float)this.pig.func_70646_bf());
        if (blockpos.func_218137_a((IPosition)this.pig.func_213303_ch(), 4.0)) {
            if (trufflehuntingtime > 0) {
                this.data.setValue(EnvironmentalDataProcessors.TRUFFLE_HUNTING_TIME, (Object)-800);
            }
        } else {
            if (this.lookTimer-- <= 0) {
                this.lookTimer = 18 + this.pig.func_70681_au().nextInt(9);
                this.lookVector = new Vector3d((double)this.pig.func_70681_au().nextFloat() * 1.2, (double)this.pig.func_70681_au().nextFloat() * 0.4, (double)this.pig.func_70681_au().nextFloat() * 1.2);
            }
            this.moveToTruffle();
        }
    }

    private void moveToTruffle() {
        BlockPos blockpos = (BlockPos)this.data.getValue(EnvironmentalDataProcessors.TRUFFLE_POS);
        this.pig.func_70661_as().func_75492_a((double)blockpos.func_177958_n() + 0.5, (double)(blockpos.func_177956_o() + 1), (double)blockpos.func_177952_p() + 0.5, 1.1);
    }

    private boolean findTruffle() {
        if (!this.pig.field_70170_p.func_230315_m_().func_236043_f_()) {
            return false;
        }
        int range = 80;
        int height = 16;
        BlockPos blockpos = this.pig.func_233580_cy_();
        BlockPos.Mutable blockpos$mutable = new BlockPos.Mutable();
        ArrayList truffleblocks = Lists.newArrayList();
        for (int i = 0; i < range; ++i) {
            boolean flag = false;
            for (int y = -height; y < height; ++y) {
                int x = 0;
                while (x <= i) {
                    int z;
                    int n = z = x < i && x > -i ? i : 0;
                    while (z <= i) {
                        blockpos$mutable.func_239621_a_((Vector3i)blockpos, x, y - 1, z);
                        if (this.pig.func_213389_a((BlockPos)blockpos$mutable)) {
                            if (this.isTruffle(this.pig.field_70170_p, (BlockPos)blockpos$mutable)) {
                                this.data.setValue(EnvironmentalDataProcessors.HAS_TRUFFLE_TARGET, (Object)true);
                                this.data.setValue(EnvironmentalDataProcessors.TRUFFLE_POS, (Object)blockpos$mutable);
                                return true;
                            }
                            if (this.isSuitableForTruffle(this.pig.field_70170_p, (BlockPos)blockpos$mutable)) {
                                if (i <= 48 && !flag) {
                                    flag = true;
                                    truffleblocks.clear();
                                }
                                truffleblocks.add(blockpos$mutable.func_185334_h());
                            }
                        }
                        z = z > 0 ? -z : 1 - z;
                    }
                    x = x > 0 ? -x : 1 - x;
                }
            }
        }
        if (truffleblocks.size() > 0) {
            BlockPos trufflepos = (BlockPos)truffleblocks.get(this.pig.func_70681_au().nextInt(truffleblocks.size()));
            this.pig.field_70170_p.func_180501_a(trufflepos, ((Block)EnvironmentalBlocks.BURIED_TRUFFLE.get()).func_176223_P(), 3);
            this.data.setValue(EnvironmentalDataProcessors.HAS_TRUFFLE_TARGET, (Object)true);
            this.data.setValue(EnvironmentalDataProcessors.TRUFFLE_POS, (Object)trufflepos);
            return true;
        }
        return false;
    }

    private boolean isTruffle(World worldIn, BlockPos pos) {
        return worldIn.func_180495_p(pos).func_177230_c() == EnvironmentalBlocks.BURIED_TRUFFLE.get();
    }

    private boolean isSuitableForTruffle(World worldIn, BlockPos pos) {
        if (worldIn.func_180495_p(pos).func_177230_c() != Blocks.field_150346_d) {
            return false;
        }
        for (Direction direction : Direction.values()) {
            BlockState blockstate = worldIn.func_180495_p(pos.func_177972_a(direction));
            if (!(direction == Direction.UP ? !blockstate.func_235714_a_(EnvironmentalTags.Blocks.GRASS_LIKE) && (!blockstate.func_235714_a_((ITag)Tags.Blocks.DIRT) || !worldIn.func_180495_p(pos.func_177984_a()).func_235714_a_(EnvironmentalTags.Blocks.GRASS_LIKE)) : !blockstate.func_235714_a_((ITag)Tags.Blocks.DIRT))) continue;
            return false;
        }
        return true;
    }
}

