/*
 * Decompiled with CFR 0.152.
 */
package com.minecraftabnormals.environmental.common.block;

import com.minecraftabnormals.abnormals_core.core.util.item.filling.TargetedItemGroupFiller;
import java.util.Random;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.LeavesBlock;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.IntegerProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.Direction;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.IForgeShearable;

public class WisteriaLeavesBlock
extends Block
implements IForgeShearable {
    public static final IntegerProperty DISTANCE = IntegerProperty.func_177719_a((String)"distance", (int)1, (int)8);
    public static final BooleanProperty PERSISTENT = BlockStateProperties.field_208515_s;
    private static final TargetedItemGroupFiller FILLER = new TargetedItemGroupFiller(() -> Items.field_221644_aj);

    public WisteriaLeavesBlock(AbstractBlock.Properties properties) {
        super(properties);
        this.func_180632_j((BlockState)((BlockState)((BlockState)this.field_176227_L.func_177621_b()).func_206870_a((Property)DISTANCE, (Comparable)Integer.valueOf(8))).func_206870_a((Property)PERSISTENT, (Comparable)Boolean.valueOf(false)));
    }

    public boolean func_149653_t(BlockState state) {
        return (Integer)state.func_177229_b((Property)DISTANCE) == 8 && (Boolean)state.func_177229_b((Property)PERSISTENT) == false;
    }

    public void func_225542_b_(BlockState state, ServerWorld worldIn, BlockPos pos, Random random) {
        if (!((Boolean)state.func_177229_b((Property)PERSISTENT)).booleanValue() && (Integer)state.func_177229_b((Property)DISTANCE) == 8) {
            WisteriaLeavesBlock.func_220075_c((BlockState)state, (World)worldIn, (BlockPos)pos);
            worldIn.func_217377_a(pos, false);
        }
    }

    public void func_225534_a_(BlockState state, ServerWorld worldIn, BlockPos pos, Random random) {
        worldIn.func_180501_a(pos, WisteriaLeavesBlock.updateDistance(state, (IWorld)worldIn, pos), 3);
    }

    public int func_200011_d(BlockState state, IBlockReader worldIn, BlockPos pos) {
        return 1;
    }

    public BlockState func_196271_a(BlockState stateIn, Direction facing, BlockState facingState, IWorld worldIn, BlockPos currentPos, BlockPos facingPos) {
        int i = WisteriaLeavesBlock.getDistance(facingState) + 1;
        if (i != 1 || (Integer)stateIn.func_177229_b((Property)DISTANCE) != i) {
            worldIn.func_205220_G_().func_205360_a(currentPos, (Object)this, 1);
        }
        return stateIn;
    }

    private static BlockState updateDistance(BlockState state, IWorld worldIn, BlockPos pos) {
        int i = 8;
        BlockPos.Mutable blockpos$mutable = new BlockPos.Mutable();
        for (Direction direction : Direction.values()) {
            blockpos$mutable.func_239622_a_((Vector3i)pos, direction);
            i = Math.min(i, WisteriaLeavesBlock.getDistance(worldIn.func_180495_p((BlockPos)blockpos$mutable)) + 1);
            if (i == 1) break;
        }
        return (BlockState)state.func_206870_a((Property)DISTANCE, (Comparable)Integer.valueOf(i));
    }

    private static int getDistance(BlockState neighbor) {
        if (BlockTags.field_200031_h.func_230235_a_((Object)neighbor.func_177230_c())) {
            return 0;
        }
        if (neighbor.func_177230_c() instanceof WisteriaLeavesBlock) {
            return (Integer)neighbor.func_177229_b((Property)DISTANCE);
        }
        if (neighbor.func_177230_c() instanceof LeavesBlock) {
            return (Integer)neighbor.func_177229_b((Property)LeavesBlock.field_208494_a);
        }
        return 8;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_180655_c(BlockState stateIn, World worldIn, BlockPos pos, Random rand) {
        BlockPos blockpos;
        BlockState blockstate;
        if (!(!worldIn.func_175727_C(pos.func_177984_a()) || rand.nextInt(15) != 1 || (blockstate = worldIn.func_180495_p(blockpos = pos.func_177977_b())).func_200132_m() && blockstate.func_224755_d((IBlockReader)worldIn, blockpos, Direction.UP))) {
            double d0 = (float)pos.func_177958_n() + rand.nextFloat();
            double d1 = (double)pos.func_177956_o() - 0.05;
            double d2 = (float)pos.func_177952_p() + rand.nextFloat();
            worldIn.func_195594_a((IParticleData)ParticleTypes.field_197618_k, d0, d1, d2, 0.0, 0.0, 0.0);
        }
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new Property[]{DISTANCE, PERSISTENT});
    }

    public BlockState func_196258_a(BlockItemUseContext context) {
        return WisteriaLeavesBlock.updateDistance((BlockState)this.func_176223_P().func_206870_a((Property)PERSISTENT, (Comparable)Boolean.valueOf(true)), (IWorld)context.func_195991_k(), context.func_195995_a());
    }

    public void func_149666_a(ItemGroup group, NonNullList<ItemStack> items) {
        FILLER.fillItem(this.func_199767_j(), group, items);
    }
}

