/*
 * Decompiled with CFR 0.152.
 */
package com.minecraftabnormals.environmental.client.render;

import com.minecraftabnormals.environmental.client.model.SlabfishModel;
import com.minecraftabnormals.environmental.client.render.SlabfishSpriteUploader;
import com.minecraftabnormals.environmental.client.render.layer.BackpackOverlayRenderLayer;
import com.minecraftabnormals.environmental.client.render.layer.BackpackRenderLayer;
import com.minecraftabnormals.environmental.client.render.layer.OverlayRenderLayer;
import com.minecraftabnormals.environmental.client.render.layer.SweaterRenderLayer;
import com.minecraftabnormals.environmental.common.entity.SlabfishEntity;
import com.minecraftabnormals.environmental.common.slabfish.SlabfishManager;
import com.mojang.blaze3d.matrix.MatrixStack;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRendererManager;
import net.minecraft.client.renderer.entity.MobRenderer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3f;
import net.minecraft.world.IWorldReader;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class SlabfishRenderer
extends MobRenderer<SlabfishEntity, SlabfishModel<SlabfishEntity>> {
    public SlabfishRenderer(EntityRendererManager renderManager) {
        super(renderManager, new SlabfishModel(), 0.3f);
        this.func_177094_a(new SweaterRenderLayer(this));
        this.func_177094_a(new BackpackRenderLayer(this));
        this.func_177094_a(new OverlayRenderLayer(this));
        this.func_177094_a(new BackpackOverlayRenderLayer(this));
    }

    public ResourceLocation getTextureLocation(SlabfishEntity slabby) {
        return SlabfishSpriteUploader.ATLAS_LOCATION;
    }

    protected RenderType getRenderType(SlabfishEntity slabby, boolean p_230496_2_, boolean p_230496_3_, boolean p_230496_4_) {
        ResourceLocation texture = this.getTextureLocation(slabby);
        if (p_230496_3_) {
            return RenderType.func_239268_f_((ResourceLocation)texture);
        }
        if (p_230496_2_) {
            return SlabfishManager.get((IWorldReader)slabby.field_70170_p).getSlabfishType(slabby.getSlabfishType()).orElse(SlabfishManager.DEFAULT_SLABFISH).isTranslucent() ? RenderType.func_228644_e_((ResourceLocation)texture) : ((SlabfishModel)this.field_77045_g).func_228282_a_(texture);
        }
        return p_230496_4_ ? RenderType.func_228654_j_((ResourceLocation)texture) : null;
    }

    protected float getBob(SlabfishEntity livingBase, float partialTicks) {
        float f = MathHelper.func_219799_g((float)partialTicks, (float)livingBase.oFlap, (float)livingBase.wingRotation);
        float f1 = MathHelper.func_219799_g((float)partialTicks, (float)livingBase.oFlapSpeed, (float)livingBase.destPos);
        return (MathHelper.func_76126_a((float)f) + 1.0f) * f1;
    }

    protected void scale(SlabfishEntity slabfish, MatrixStack matrixStack, float partialTickTime) {
        ((SlabfishModel)this.field_77045_g).sprite = SlabfishSpriteUploader.instance().func_215282_a(SlabfishManager.get((IWorldReader)slabfish.field_70170_p).getSlabfishType(slabfish.getSlabfishType()).orElse(SlabfishManager.DEFAULT_SLABFISH).getTextureLocation());
        if (slabfish.func_233684_eK_() || slabfish.func_184187_bx() != null) {
            matrixStack.func_227861_a_(0.0, slabfish.func_70631_g_() ? 0.15625 : 0.3125, 0.0);
        }
        if (slabfish.func_70090_H()) {
            matrixStack.func_227861_a_(0.0, slabfish.func_70631_g_() ? (double)-0.8f : (double)-0.4f, 0.5);
            matrixStack.func_227863_a_(Vector3f.field_229179_b_.func_229193_c_(1.5707964f));
        }
    }
}

