/*
 * Decompiled with CFR 0.152.
 */
package superlord.prehistoricfauna.world.worldtype;

import java.util.function.LongFunction;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.registry.Registry;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.gen.IExtendedNoiseRandom;
import net.minecraft.world.gen.LazyAreaLayerContext;
import net.minecraft.world.gen.area.IArea;
import net.minecraft.world.gen.area.IAreaFactory;
import net.minecraft.world.gen.layer.Layer;
import net.minecraft.world.gen.layer.LayerUtil;
import net.minecraft.world.gen.layer.SmoothLayer;
import net.minecraft.world.gen.layer.ZoomLayer;
import net.minecraft.world.gen.layer.traits.IAreaTransformer1;
import superlord.prehistoricfauna.world.worldtype.PFWorldTypeBiomesLayer;
import superlord.prehistoricfauna.world.worldtype.PFWorldTypeRiverLayer;
import superlord.prehistoricfauna.world.worldtype.PFWorldTypeRiverMixLayer;

public class PFWorldTypeLayerUtil {
    private static Registry<Biome> biomeRegistry;

    static int getBiomeId(RegistryKey<Biome> define) {
        Biome biome = (Biome)biomeRegistry.func_230516_a_(define);
        return biomeRegistry.func_148757_b((Object)biome);
    }

    public static <T extends IArea, C extends IExtendedNoiseRandom<T>> IAreaFactory<T> makeLayers(LongFunction<C> contextFactory, Registry<Biome> registry) {
        biomeRegistry = registry;
        IAreaFactory biomes = new PFWorldTypeBiomesLayer().func_202823_a((IExtendedNoiseRandom)contextFactory.apply(1L));
        biomes = ZoomLayer.NORMAL.func_202713_a((IExtendedNoiseRandom)contextFactory.apply(1000L), biomes);
        biomes = ZoomLayer.NORMAL.func_202713_a((IExtendedNoiseRandom)contextFactory.apply(1001L), biomes);
        biomes = ZoomLayer.NORMAL.func_202713_a((IExtendedNoiseRandom)contextFactory.apply(1002L), biomes);
        biomes = ZoomLayer.NORMAL.func_202713_a((IExtendedNoiseRandom)contextFactory.apply(1003L), biomes);
        biomes = ZoomLayer.NORMAL.func_202713_a((IExtendedNoiseRandom)contextFactory.apply(1004L), biomes);
        biomes = ZoomLayer.NORMAL.func_202713_a((IExtendedNoiseRandom)contextFactory.apply(1005L), biomes);
        biomes = LayerUtil.func_202829_a((long)1000L, (IAreaTransformer1)ZoomLayer.NORMAL, (IAreaFactory)biomes, (int)1, contextFactory);
        IAreaFactory riverLayer = PFWorldTypeRiverLayer.INSTANCE.func_202713_a((IExtendedNoiseRandom)contextFactory.apply(1L), biomes);
        riverLayer = SmoothLayer.INSTANCE.func_202713_a((IExtendedNoiseRandom)contextFactory.apply(7000L), riverLayer);
        biomes = PFWorldTypeRiverMixLayer.INSTANCE.func_202707_a((IExtendedNoiseRandom)contextFactory.apply(100L), biomes, riverLayer);
        return biomes;
    }

    public static Layer makeLayers(long seed, Registry<Biome> registry) {
        biomeRegistry = registry;
        IAreaFactory areaFactory = PFWorldTypeLayerUtil.makeLayers(contextSeed -> new LazyAreaLayerContext(25, seed, contextSeed), registry);
        return new Layer(areaFactory);
    }
}

